/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.duowan.mobile.basemedia.api.channel.basechannel.TextChatSvcResult;
import com.duowan.mobile.basemedia.api.event.IChannelLinkClient_onCurrentChatSendMessageFeedbackTips_EventArgs;
import com.duowan.mobile.livebasebiz.api.LiveBizApiManager;
import com.duowan.mobile.livebasebiz.event.IChatEmotionClient_onShowChatInputBroadcast_EventArgs;
import com.duowan.mobile.livebasebiz.privatechat.IChatEmotionCore;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.bizmodel.login.LoginUtilHomeApi;
import com.yy.mobile.livebizwrapper.chatinput.helper.FeedbackTipHelper;
import com.yy.mobile.livebizwrapper.chatscreen.AbstractPublicScreenAdapter;
import com.yy.mobile.livebizwrapper.chatscreen.BasicPublicScreenPresenter$$EventBinder;
import com.yy.mobile.livebizwrapper.chatscreen.IPublicChatDataModel;
import com.yy.mobile.livebizwrapper.chatscreen.IPublicChatScreenToastCore;
import com.yy.mobile.livebizwrapper.chatscreen.IPublicScreenDataObserver;
import com.yy.mobile.livebizwrapper.chatscreen.event.OnLiveAnchorSubscribeMessageClickEvent;
import com.yy.mobile.livebizwrapper.chatscreen.event.ShowQuickPopupEvent;
import com.yy.mobile.livebizwrapper.chatscreen.view.IPublicScreenView;
import com.yy.mobile.mvplifecycle2.RxMvpPresenter;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.mobile.util.valid.BlankUtil;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.businesstranport.IBridgeToMainPluginCore;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.subscribe.ISubscribeCore;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableTransformer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.List;
import org.json.JSONObject;
import tv.athena.util.common.SizeUtils;
import tv.athena.util.toast.ToastUtil;

public abstract class BasicPublicScreenPresenter<V extends IPublicScreenView>
extends RxMvpPresenter<V>
implements IPublicScreenDataObserver {
    private static final String TAG = "BasicPublicScreenPresenter";
    private IPublicChatDataModel dataModel;
    protected BehaviorSubject<IPublicChatDataModel> dataModelSubject;
    private Runnable initDataModelTask = () -> {
        Activity context;
        IPublicScreenView view = (IPublicScreenView)this.getView();
        if (view != null && (context = view.getChatActivity()) != null) {
            this.dataModel = this.onCreateDataModel();
            this.dataModel.onCreate((Context)context, this);
            this.dataModelSubject.onNext((Object)this.dataModel);
            MLog.info((String)TAG, (String)"create PublicChatDataModel in mainThread runnable");
        }
    };
    private PopupComponent component;
    private boolean isLoginSuccess;
    private EventBinder mEventBinder;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MLog.info((String)TAG, (String)("PublicScreenPresenter onCreate: " + this.getClass().getSimpleName()));
        this.onEventBind();
        this.init();
    }

    protected void onResume() {
        super.onResume();
        if (this.isLoginSuccess) {
            MLog.info((String)TAG, (String)"isLoginSuccess");
            RxBus.getDefault().post((Object)new IChatEmotionClient_onShowChatInputBroadcast_EventArgs(true, true));
            this.isLoginSuccess = false;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        MLog.info((String)TAG, (String)("PublicScreenPresenter onDestroy: " + this.getClass().getSimpleName()));
        this.isLoginSuccess = false;
        this.release();
    }

    protected abstract IPublicChatDataModel onCreateDataModel();

    protected abstract AbstractPublicScreenAdapter onCreateMsgAdapter();

    @SuppressLint(value={"CheckResult"})
    private void init() {
        this.dataModelSubject = BehaviorSubject.create();
        this.initDataModelTask.run();
    }

    private void release() {
        if (this.dataModel != null) {
            this.dataModel.onDestroy();
        }
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.initDataModelTask);
    }

    @Override
    public void onNotify(List<? extends ChannelMessage> data) {
        MLog.info((String)TAG, (String)("flushChatData data size = " + (data != null ? Integer.valueOf(data.size()) : "0")));
        IPublicScreenView v = (IPublicScreenView)this.getView();
        if (v != null && data != null) {
            v.appendMsg(data);
        }
    }

    @BusEvent
    public void onShowLiteChatPop(ShowQuickPopupEvent args) {
        if (this.isCanShowLiteChatPopup()) {
            ((IPublicScreenView)this.getView()).showBubbleWindow(args);
        }
    }

    @BusEvent
    public void onLiveAnchorSubscribeMessageClick(OnLiveAnchorSubscribeMessageClickEvent event) {
        if (this.isShowLogin()) {
            return;
        }
        ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).subscribeObservable(event.getUid()).observeOn(AndroidSchedulers.mainThread()).compose((CompletableTransformer)this.bindToLifecycle()).subscribe(new CompletableObserver(){

            public void onSubscribe(@NonNull Disposable d) {
            }

            public void onComplete() {
                ((IPublicScreenView)BasicPublicScreenPresenter.this.getView()).notifyDataChange();
            }

            public void onError(@NonNull Throwable e) {
                MLog.info((String)BasicPublicScreenPresenter.TAG, (String)("onLiveAnchorSubscribeMessageClick error= " + e));
            }
        });
    }

    private boolean isShowLogin() {
        if (this.getView() == null || LoginUtilHomeApi.isLogined()) {
            return false;
        }
        ((IBridgeToMainPluginCore)CoreFactory.getCore(IBridgeToMainPluginCore.class)).showLoginDialog(((IPublicScreenView)this.getView()).getChatActivity());
        return true;
    }

    protected boolean isCanShowLiteChatPopup() {
        return true;
    }

    public void showLiteChatPopup(String inputText) {
        try {
            if (this.component != null && this.component.isVisible()) {
                this.component.dismiss();
            }
            this.component = LiveBizApiManager.INSTANCE.getBizComponentApi().createLiteChatPopupComponent((CharSequence)inputText);
            if (this.getView() != null && ((IPublicScreenView)this.getView()).getHostFragmentManager() != null) {
                this.component.show(((IPublicScreenView)this.getView()).getHostFragmentManager(), "\u7cbe\u7b80\u7248\u8f93\u5165\u6846");
            }
        }
        catch (Throwable ignore) {
            MLog.error((Object)TAG, (String)"show LiteChatPopupComponent fail: ", (Throwable)ignore, (Object[])new Object[0]);
        }
    }

    @BusEvent
    public void onSendMessageResultListener(IChannelLinkClient_onCurrentChatSendMessageFeedbackTips_EventArgs busEventArgs) {
        TextChatSvcResult result = busEventArgs.getEt();
        if (result == null) {
            MLog.info((String)TAG, (String)"send message result is null");
        }
        if (result.reason == 0) {
            MLog.info((String)TAG, (String)"send message success");
        } else {
            MLog.info((String)TAG, (String)("send message failed: reasonCode = " + result.reason));
            if (!BlankUtil.isBlank((Object)result.props) && 12 == result.reason) {
                String rescode = new String((byte[])result.props.get(5));
                String reason = new String((byte[])result.props.get(4));
                String lastSendMsgCache = ((IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class)).getLastSendMsgCache();
                MLog.info((Object)TAG, (String)"send message failed: rescode = %s , reason = %s , lastSendMsgCache = %s", (Object[])new Object[]{rescode, reason, lastSendMsgCache});
                if ("102".equals(rescode)) {
                    if (!TextUtils.isEmpty((CharSequence)reason)) {
                        ToastUtil.showToast((String)reason, (int)80, (int)0, (int)SizeUtils.dp2px((float)60.0f));
                    }
                    return;
                }
                if (!BlankUtil.isBlank((String)lastSendMsgCache)) {
                    ((IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class)).sendOwnMessage(lastSendMsgCache, null, null);
                }
                if (!BlankUtil.isBlank((String)rescode) && !TextUtils.isEmpty((CharSequence)reason)) {
                    ToastUtil.showToast((String)reason, (int)80, (int)0, (int)SizeUtils.dp2px((float)60.0f));
                }
                return;
            }
            String reason = this.handleResult(result);
            if (!TextUtils.isEmpty((CharSequence)reason)) {
                ((IPublicChatScreenToastCore)ICoreManagerBase.getCore(IPublicChatScreenToastCore.class)).showToast(reason, 80, 0, SizeUtils.dp2px((float)60.0f));
            }
        }
    }

    private String handleResult(TextChatSvcResult result) {
        IChatEmotionCore chatEmotionCore = (IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class);
        int reasonCode = result.reason;
        String reasonTip = "";
        switch (reasonCode) {
            case 12: {
                chatEmotionCore.setInputMsgCache(null);
                chatEmotionCore.setMsgSendState(1);
                if (LoginUtil.isLogined() && result.uid == LoginUtil.getUid()) {
                    ToastUtil.showToast((String)"\u62b1\u6b49\uff0c\u5305\u542b\u654f\u611f\u8bcd\u6c47\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\uff01");
                }
                return "";
            }
            case 23: {
                chatEmotionCore.setInputMsgCache(null);
                chatEmotionCore.setMsgSendState(0);
                return reasonTip;
            }
            case 24: {
                String leftTime = "";
                if (result.props != null) {
                    leftTime = new String((byte[])result.props.get(4));
                }
                reasonTip = leftTime;
                chatEmotionCore.setInputMsgCache(null);
                chatEmotionCore.setMsgSendState(0);
                break;
            }
            case 34: {
                String resCode;
                String disableSeconds;
                String response = "";
                if (result.props != null) {
                    response = new String((byte[])result.props.get(4));
                }
                if (StringUtils.isEmpty((String)response).booleanValue()) break;
                try {
                    JSONObject json = new JSONObject(response);
                    disableSeconds = json.optString("disableSeconds");
                    resCode = json.optString("resCode");
                }
                catch (Throwable e) {
                    MLog.error((String)TAG, (String)"parse RENPIN_UNIFY_RES json error: $response");
                    return reasonTip;
                }
                String msg = FeedbackTipHelper.chatResCodeTips((Context)((IPublicScreenView)this.getView()).getChatActivity(), resCode, disableSeconds);
                if (TextUtils.isEmpty((CharSequence)msg)) break;
                if ("0" == resCode) {
                    return reasonTip;
                }
                reasonTip = msg;
                chatEmotionCore.setInputMsgCache(null);
                chatEmotionCore.setMsgSendState(0);
                break;
            }
            default: {
                reasonTip = "";
            }
        }
        if (reasonTip.isEmpty()) {
            reasonTip = FeedbackTipHelper.chatSendMessageFeedbackTips((Context)((IPublicScreenView)this.getView()).getChatActivity(), reasonCode);
        }
        chatEmotionCore.setMsgSendState(0);
        return reasonTip;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new BasicPublicScreenPresenter$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

