/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.template.ViewingRoomApi;
import com.duowan.mobile.basemedia.watchlive.template.BaseViewScene;
import com.duowan.mobile.livebasebiz.api.LiveBizApiManager;
import com.duowan.mobile.livebasebiz.event.PublicScreenHeightChangeEventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatscreen.BasicPublicScreenComponent$$EventBinder;
import com.yy.mobile.livebizwrapper.chatscreen.BasicPublicScreenPresenter;
import com.yy.mobile.livebizwrapper.chatscreen.event.ShowQuickPopupEvent;
import com.yy.mobile.livebizwrapper.chatscreen.view.IPublicScreenView;
import com.yy.mobile.livebizwrapper.chatscreen.view.PublicScreenListView;
import com.yy.mobile.livebizwrapper.events.ChatInputPopStatusChangeEvent;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onSubscribeResult_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onUnSubscribeResult_EventArgs;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.widget.bubblelayout.ArrowDirection;
import com.yy.mobile.ui.widget.bubblelayout.BubbleLayout;
import com.yy.mobile.ui.widget.bubblelayout.BubblePopupWindow;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.LiveAnchorSubscribeMessage;
import java.util.List;

public abstract class BasicPublicScreenComponent<P extends BasicPublicScreenPresenter<V>, V extends IPublicScreenView>
extends Component<P, V>
implements IPublicScreenView {
    private static final String TAG = "BasicPublicScreenComponent";
    private static int LAYOUT_BOTTOM_MARGIN = ScreenUtil.getInstance().dip2px(40);
    protected RelativeLayout rootView;
    protected RelativeLayout listLayout;
    protected PublicScreenListView listView;
    protected ViewGroup revenueLayout;
    private BubblePopupWindow mBubblePopupWindow;
    private EventBinder mEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getChatActivity() != null) {
            this.getChatActivity().getWindow().setSoftInputMode(48);
        }
        MLog.info((String)TAG, (String)("onCreate: " + this.getClass().getSimpleName()));
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        MLog.debug((String)TAG, (String)("onCreateView: " + this.getClass().getSimpleName()));
        long t1 = System.currentTimeMillis();
        this.rootView = (RelativeLayout)inflater.inflate(this.getLayoutResId(), (ViewGroup)new FrameLayout(this.getContext()), false);
        MLog.info((String)TAG, (String)("inflate view time = " + (System.currentTimeMillis() - t1)));
        this.initView((ViewGroup)this.rootView);
        return this.rootView;
    }

    protected abstract void initView(ViewGroup var1);

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initVisibleStatus();
        if (this.listView != null) {
            this.listView.init(((BasicPublicScreenPresenter)this.getPresenter()).onCreateMsgAdapter());
            this.listView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                    BasicPublicScreenComponent.this.dismissBubbleWindow();
                }

                public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                    BasicPublicScreenComponent.this.dismissBubbleWindow();
                }
            });
        }
    }

    protected abstract int getLayoutResId();

    @Override
    @Nullable
    public FragmentManager getHostFragmentManager() {
        return this.getActivity() != null ? this.getActivity().getSupportFragmentManager() : null;
    }

    @Override
    public void appendMsg(List<? extends ChannelMessage> data) {
        if (this.listView != null && data != null) {
            this.listView.appendMsg(data);
        }
    }

    @Override
    public void showBubbleWindow(final ShowQuickPopupEvent event) {
        Context context = this.getContext();
        if (context != null) {
            this.mBubblePopupWindow = new BubblePopupWindow(context);
            BubbleLayout bubbleView = (BubbleLayout)LayoutInflater.from((Context)context).inflate(R.layout.public_screen_bubble_content, null);
            View.OnClickListener onBubbleClick = new View.OnClickListener(){

                public void onClick(View v) {
                    BasicPublicScreenPresenter presenter;
                    int id2 = v.getId();
                    FragmentActivity fragmentActivity = BasicPublicScreenComponent.this.getActivity();
                    if (id2 == R.id.tv_report && fragmentActivity != null) {
                        LiveBizApiManager.INSTANCE.getLiveReportApi().showReport(fragmentActivity, event.uid);
                        BasicPublicScreenComponent.this.reportClick("2");
                    } else if (id2 == R.id.tv_copy && null != (presenter = (BasicPublicScreenPresenter)BasicPublicScreenComponent.this.getPresenter())) {
                        presenter.showLiteChatPopup(event.content);
                        BasicPublicScreenComponent.this.reportClick("1");
                    }
                    BasicPublicScreenComponent.this.dismissBubbleWindow();
                }
            };
            TextView report = (TextView)bubbleView.findViewById(R.id.tv_report);
            TextView copy = (TextView)bubbleView.findViewById(R.id.tv_copy);
            View split = bubbleView.findViewById(R.id.split);
            if (event.uid == LoginUtil.getUid()) {
                split.setVisibility(8);
                report.setVisibility(8);
                this.reportExposure("1");
                bubbleView.setArrowPosition((float)(ScreenUtil.getInstance().dip2px(60) / 2));
            } else {
                this.reportExposure("1");
                this.reportExposure("2");
                split.setVisibility(0);
                report.setVisibility(0);
                bubbleView.setArrowPosition((float)(ScreenUtil.getInstance().dip2px(122) / 2));
            }
            report.setOnClickListener(onBubbleClick);
            copy.setOnClickListener(onBubbleClick);
            bubbleView.setArrowDirection(ArrowDirection.BOTTOM.getValue());
            bubbleView.setArrowSize(20.0f, 20.0f);
            bubbleView.setBubbleColor(Color.parseColor((String)"#FF404040"));
            bubbleView.setCornersRadius((float)ScreenUtil.getInstance().dip2px(6));
            this.mBubblePopupWindow.setBubbleView((View)bubbleView);
            this.mBubblePopupWindow.show(event.parent, 48);
        }
    }

    @Override
    public void notifyDataChange() {
        if (this.listView == null) {
            return;
        }
        if (null != this.listView.getAdapter()) {
            this.listView.getAdapter().notifyDataSetChanged();
        }
    }

    private void reportClick(String entryType) {
        Property pro = new Property();
        pro.putString("entry_type", entryType);
        HiidoSDK.instance().reportTimesEvent(LoginUtil.getUid(), "51038", "0012", pro);
    }

    private void reportExposure(String entryType) {
        Property pro = new Property();
        pro.putString("entry_type", entryType);
        HiidoSDK.instance().reportTimesEvent(LoginUtil.getUid(), "51038", "0011", pro);
    }

    @Override
    public void dismissBubbleWindow() {
        if (null != this.mBubblePopupWindow) {
            this.mBubblePopupWindow.dismiss();
            this.mBubblePopupWindow = null;
        }
    }

    @Override
    public void insertMsg(List<? extends ChannelMessage> data) {
        if (this.listView != null && data != null) {
            this.listView.insertMsg(data);
        }
    }

    @Override
    public void setPublicScreenSize(int w, int h) {
        if (this.listLayout != null && this.listLayout.getLayoutParams() != null) {
            MLog.info((String)TAG, (String)("setPublicScreenSize: w = " + w + "h = " + h));
            ViewGroup.LayoutParams param = this.listLayout.getLayoutParams();
            if (param.width != w || param.height != h) {
                param.width = w;
                if (h > 0) {
                    param.height = this.isNewGeneralHit() ? this.getGeneralHeight() : h;
                }
                this.listLayout.setLayoutParams(param);
            }
            RxBus.getDefault().post((Object)new PublicScreenHeightChangeEventArgs(h));
        }
    }

    private int getGeneralHeight() {
        return (int)((float)ResolutionUtils.getScreenHeight((Context)BasicConfig.getInstance().getAppContext()) - ResolutionUtils.convertDpToPixel((float)395.0f, (Context)BasicConfig.getInstance().getAppContext()));
    }

    private boolean isNewGeneralHit() {
        String templateId = ChannelApi.Factory.get().getTemplateId();
        return templateId != null && templateId.equals("0");
    }

    public void onOrientationChanged(boolean isLandscape) {
        this.initVisibleStatus();
    }

    private void initVisibleStatus() {
        if (!this.isShowWhenLandScape()) {
            this.rootView.setVisibility(this.isLandScape() ? 8 : 0);
            if (!this.isLandScape()) {
                this.setListLayoutPadding(0);
            }
        }
    }

    protected boolean isShowWhenLandScape() {
        return false;
    }

    protected boolean isLandScape() {
        if (this.checkActivityValid()) {
            return this.getResources().getConfiguration().orientation == 2;
        }
        return false;
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mBubblePopupWindow = null;
        MLog.info((String)TAG, (String)("onDestroy: " + this.getClass().getSimpleName()));
    }

    @Override
    public Activity getChatActivity() {
        return this.getActivity();
    }

    @BusEvent
    public void onPublicScreenInputPopChange(ChatInputPopStatusChangeEvent event) {
        MLog.info((String)TAG, (String)("onPublicScreenInputPopChange: " + event.show + " " + event.height));
        this.setListLayoutPadding(event.height);
        if (!event.show && this.listView != null) {
            this.listView.setCanScrollToBottom(true);
        }
    }

    @BusEvent
    public void onUnFollow(ISubscribeClient_onUnSubscribeResult_EventArgs event) {
        if (event.getSuccess()) {
            this.updateSubscribeMessage(event.getAnchorUid());
        }
    }

    @BusEvent
    public void onFollow(ISubscribeClient_onSubscribeResult_EventArgs event) {
        if (event.getSuccess()) {
            this.updateSubscribeMessage(event.getAnchorUid());
        }
    }

    private void updateSubscribeMessage(long anchorUid) {
        if (this.listView == null) {
            MLog.info((String)TAG, (String)"listView == null");
            return;
        }
        if (this.listView.getAdapter() == null) {
            MLog.info((String)TAG, (String)"listView.getAdapter()  == null");
            return;
        }
        RecyclerView.LayoutManager layoutManager = this.listView.getLayoutManager();
        if (layoutManager == null) {
            MLog.info((String)TAG, (String)"layoutManager == null");
            return;
        }
        if (layoutManager instanceof LinearLayoutManager) {
            List<ChannelMessage> messages = this.listView.getMessages();
            int size = messages.size();
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            int first = linearLayoutManager.findFirstVisibleItemPosition();
            int end = linearLayoutManager.findLastVisibleItemPosition();
            MLog.info((String)TAG, (String)("first = " + first + " end = " + end + " size = " + size));
            for (int i = first; i <= end; ++i) {
                if (i < 0 || i >= size) {
                    MLog.error((String)TAG, (String)("index = " + i));
                    return;
                }
                ChannelMessage message = messages.get(i);
                if (!(message instanceof LiveAnchorSubscribeMessage)) continue;
                long messageUid = ((LiveAnchorSubscribeMessage)message).getAnchorUid();
                if (messageUid == anchorUid) {
                    MLog.info((String)TAG, (String)("notifyItemChanged index = " + i));
                    this.listView.getAdapter().notifyItemChanged(i);
                    continue;
                }
                MLog.info((String)TAG, (String)("messageUid = " + messageUid + " anchorUid = " + anchorUid));
            }
        } else {
            MLog.error((String)TAG, (String)"layoutManager is not instanceof LinearLayoutManager");
        }
    }

    private void setListLayoutPadding(int padding) {
        if (this.listLayout != null) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.listLayout.getLayoutParams();
            int bottomMargin = LAYOUT_BOTTOM_MARGIN + padding;
            if (BaseViewScene.PARTY == ViewingRoomApi.Factory.get().getCurrentScene()) {
                bottomMargin -= ScreenUtil.getInstance().dip2px(10);
            }
            layoutParams.setMargins(0, 0, 0, bottomMargin);
            MLog.info((String)TAG, (String)("setListLayoutPadding: " + bottomMargin));
            this.listLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.listLayout.requestLayout();
            if (this.rootView != null) {
                this.rootView.requestLayout();
            }
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new BasicPublicScreenComponent$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

