/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen;

import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.livebizwrapper.chatscreen.AirTicketDelayReport$$EventBinder;
import com.yy.mobile.livebizwrapper.chatscreen.model.PublicChatStatisticUtils;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelInfo;

public class AirTicketDelayReport
extends EmptyEventCompat {
    private static final String TAG = "AirTicketDelayReport";
    private long mClickFromSid = 0L;
    private long mClickToSid = 0L;
    private boolean mReportWaiting = false;
    private EventBinder mEventBinder;

    public static AirTicketDelayReport getInstance() {
        return Holder.INSTANCE;
    }

    public AirTicketDelayReport() {
        this.onEventBind();
    }

    public void clickToChannel(long toSid) {
        MLog.debug((String)TAG, (String)"clickToChannel:");
        this.mClickFromSid = this.getChannelId();
        this.mClickToSid = toSid;
        this.mReportWaiting = true;
    }

    @BusEvent
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        MLog.debug((String)TAG, (String)"onJoinChannelSuccess:");
        long toSid = this.getChannelId();
        long newTopUid = ChannelApi.Factory.get().getCurrentTopMicId();
        if (toSid == this.mClickToSid && this.mReportWaiting && newTopUid > 0L) {
            MLog.info((Object)TAG, (String)"onJoinChannelSuccess: mClickFromSid=%s, mClickToSid=%s, newTopUid=%s", (Object[])new Object[]{this.mClickFromSid, this.mClickToSid, newTopUid});
            PublicChatStatisticUtils.reportChatAirTicketClick(this.mClickFromSid, this.mClickToSid, newTopUid);
            this.mClickFromSid = 0L;
            this.mClickToSid = 0L;
            this.mReportWaiting = false;
        }
    }

    @BusEvent
    public void updateCurrentChannelMicQueue(IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs busEventArgs) {
        long newTopUid = busEventArgs.getNewTopUid();
        MLog.debug((Object)TAG, (String)"updateCurrentChannelMicQueue: newTopUid=%d", (Object[])new Object[]{newTopUid});
        long toSid = this.getChannelId();
        if (toSid == this.mClickToSid && this.mReportWaiting) {
            MLog.info((Object)TAG, (String)"updateCurrentChannelMicQueue: mClickFromSid=%s, mClickToSid=%s, newTopUid=%s", (Object[])new Object[]{this.mClickFromSid, this.mClickToSid, newTopUid});
            PublicChatStatisticUtils.reportChatAirTicketClick(this.mClickFromSid, this.mClickToSid, newTopUid);
            this.mClickFromSid = 0L;
            this.mClickToSid = 0L;
            this.mReportWaiting = false;
        }
    }

    public long getChannelId() {
        if (ChannelApi.Factory.get() != null && ChannelApi.Factory.get().getCurrentChannelInfo() != null) {
            ChannelInfo channelInfo = ChannelApi.Factory.get().getCurrentChannelInfo();
            return channelInfo.topSid;
        }
        return 0L;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new AirTicketDelayReport$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    private static class Holder {
        private static AirTicketDelayReport INSTANCE = new AirTicketDelayReport();

        private Holder() {
        }
    }
}

