/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.text.Spannable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatscreen.AsyncContentViewBinder;
import com.yy.mobile.livebizwrapper.chatscreen.EventSafeLinkMovementMethod;
import com.yy.mobile.livebizwrapper.chatscreen.PublicMessageHelper;
import com.yy.mobile.livebizwrapper.chatscreen.SafeSpannableFactory;
import com.yy.mobile.livebizwrapper.chatscreen.event.OnLiveAnchorSubscribeMessageClickEvent;
import com.yy.mobile.livebizwrapper.chatscreen.event.ShowQuickPopupEvent;
import com.yy.mobile.livebizwrapper.chatscreen.holder.EnterChannelShowViewBinder;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.AsyncContentMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.EnterChannelShowMessage;
import com.yy.mobile.livebizwrapper.chatscreen.view.ExtendTextView;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.LiveAnchorSubscribeMessage;
import com.yymobile.core.channel.PublicChatMessage;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;

public abstract class AbstractPublicScreenAdapter
extends MultiTypeAdapter {
    private static final String TAG = "PublicScreenAdapter";
    protected Context context;
    private boolean mForbiddenLongClick = false;

    public AbstractPublicScreenAdapter(Context context) {
        this.context = context;
        this.register(AsyncContentMessage.class, new AsyncContentViewBinder());
        this.register(ChannelMessage.class, new ChannelMessageViewBinder());
        this.register(EnterChannelShowMessage.class, new EnterChannelShowViewBinder());
    }

    public abstract void setEnlarge(boolean var1);

    protected int getItemLayoutResId() {
        return R.layout.mobile_live_screen_item;
    }

    private void resetView(ViewHolder holder) {
        if (holder.tvMessage == null) {
            return;
        }
        holder.tvMessage.setPadding(0, 0, 0, 0);
        if (Build.VERSION.SDK_INT >= 16) {
            holder.tvMessage.setBackground(null);
        } else {
            holder.tvMessage.setBackgroundDrawable(null);
        }
    }

    public abstract void onBindView(ChannelMessage var1, TextView var2);

    private void setCopyContent(ChannelMessage message, TextView textView) {
        if (textView instanceof ExtendTextView) {
            ExtendTextView copyTextView = (ExtendTextView)textView;
            if (message instanceof PublicChatMessage) {
                copyTextView.setCopyContent(message.pureText);
            } else {
                copyTextView.setCopyContent("");
            }
        }
    }

    private void setSpanFactory(TextView tv) {
        if (tv != null) {
            tv.setSpannableFactory((Spannable.Factory)SafeSpannableFactory.getInstance());
        }
    }

    private void setMovementMethod(TextView tvMessage) {
        try {
            tvMessage.setMovementMethod(EventSafeLinkMovementMethod.getInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void forbiddenLongClick(boolean isForbidden) {
        MLog.info((String)TAG, (String)("isForbidden:" + isForbidden));
        this.mForbiddenLongClick = isForbidden;
    }

    private void bindLiveAnchorSubscribeMessage(final @NonNull ViewHolder holder, @NonNull ChannelMessage message) {
        if (message instanceof LiveAnchorSubscribeMessage) {
            final LiveAnchorSubscribeMessage liveAnchorSubscribeMessage = (LiveAnchorSubscribeMessage)message;
            liveAnchorSubscribeMessage.update(new ClickableSpan(){

                public void onClick(@NonNull View widget) {
                    RxBus.getDefault().post((Object)new OnLiveAnchorSubscribeMessageClickEvent(liveAnchorSubscribeMessage.getAnchorUid(), holder.getAdapterPosition()));
                }
            }, new ClickableSpan(){

                public void onClick(@NonNull View widget) {
                    PublicMessageHelper.onNickNameClick(liveAnchorSubscribeMessage.getAnchorUid(), (String)liveAnchorSubscribeMessage.tailMap.get("hdid"));
                }

                public void updateDrawState(@NonNull TextPaint ds) {
                    ds.setColor(Color.parseColor((String)"#FFDA81"));
                    ds.setUnderlineText(false);
                }
            });
        }
    }

    private class ChannelMessageViewBinder
    extends ItemViewBinder<ChannelMessage, ViewHolder> {
        private ChannelMessageViewBinder() {
        }

        @NonNull
        protected ViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
            return new ViewHolder(inflater.inflate(AbstractPublicScreenAdapter.this.getItemLayoutResId(), parent, false));
        }

        protected void onBindViewHolder(@NonNull ViewHolder holder, final @NonNull ChannelMessage message) {
            AbstractPublicScreenAdapter.this.bindLiveAnchorSubscribeMessage(holder, message);
            AbstractPublicScreenAdapter.this.resetView(holder);
            AbstractPublicScreenAdapter.this.setCopyContent(message, holder.tvMessage);
            AbstractPublicScreenAdapter.this.setSpanFactory(holder.tvMessage);
            AbstractPublicScreenAdapter.this.setMovementMethod(holder.tvMessage);
            AbstractPublicScreenAdapter.this.onBindView(message, holder.tvMessage);
            if (LoginUtil.isLogined() && holder.tvMessage instanceof ExtendTextView) {
                final ExtendTextView etv = (ExtendTextView)holder.tvMessage;
                etv.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        MLog.info((String)AbstractPublicScreenAdapter.TAG, (String)"onLongClick");
                        if (AbstractPublicScreenAdapter.this.mForbiddenLongClick) {
                            return false;
                        }
                        String text = etv.getCopyContent();
                        if (!TextUtils.isEmpty((CharSequence)text)) {
                            RxBus.getDefault().post((Object)new ShowQuickPopupEvent(text, v, message.uid));
                        }
                        return true;
                    }
                });
            }
        }
    }

    private static class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvMessage;

        ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.tvMessage = (TextView)itemView.findViewById(R.id.tv_chat_content);
        }
    }
}

