/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatinput.hotwords;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.channel.hiidoStatistic.IHiddoStatisticChannelCore;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatinput.IChatBridgeToLivePluginCore;
import com.yy.mobile.livebizwrapper.chatinput.SendChatPresenter;
import com.yy.mobile.livebizwrapper.chatinput.hotwords.HotWordsListAdapter;
import com.yy.mobile.livebizwrapper.events.LiteChatSendMessageEvent;
import com.yy.mobile.livebizwrapper.utils.NavigationBarUtils;
import com.yy.mobile.ui.widget.labelView.Label;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.List;

public class HotwordPopupWindow
extends PopupWindow {
    private static final String TAG = "HotwordPopupWindow";
    private Activity activity;
    private View mHotWordsView;
    private TextView mHotWordsLoading;
    private ListView mHotWordsListView;
    private HotWordsListAdapter mHotWordsListAdapter;
    private SendChatPresenter mSendPresenter;
    private int mDataSize = 0;
    private AdapterView.OnItemClickListener mHotWordsOnItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> var1, View var2, int position, long id2) {
            if (LoginUtil.isLogined()) {
                HotwordPopupWindow.this.dealHotWordsItemClick(position);
            } else if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(BaseFragmentApi.class) != null) {
                ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog(HotwordPopupWindow.this.activity);
            }
        }
    };
    private static final int MAX_DATA_SIZE = 6;
    private static final int DEFAULT_TOW_DATA = 2;

    private void dealHotWordsItemClick(int position) {
        this.dismissPopupAmountList();
        String strMessage = this.mHotWordsListAdapter.getItemText(position);
        if (!TextUtils.isEmpty((CharSequence)strMessage)) {
            if (CoreFactory.getCore(IChatBridgeToLivePluginCore.class) != null) {
                ((IChatBridgeToLivePluginCore)CoreFactory.getCore(IChatBridgeToLivePluginCore.class)).isWordTrigger(strMessage);
            }
            this.mSendPresenter.onPreSendMessage(strMessage, null, new boolean[]{true}, "1");
            MLog.info((String)TAG, (String)"dealHotWordsItemClick:send LiteChatSendMessageEvent.");
            RxBus.getDefault().post((Object)new LiteChatSendMessageEvent("send_message"));
            if (this.mHotWordsListAdapter.getItemViewType(position) == 0) {
                Property property = new Property();
                property.putString("key1", String.valueOf(ChannelApi.Factory.get().getCurrentChannelInfo().topSid));
                property.putString("key3", String.valueOf(ChannelApi.Factory.get().getCurrentTopMicId()));
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51012", "0004", (Serializable)property);
            }
            if (strMessage.equals("1") || strMessage.equals("2")) {
                ChannelInfo channelInfo = ChannelApi.Factory.get().getCurrentChannelInfo();
                Property property = new Property();
                property.putString("key1", String.valueOf(channelInfo.topSid));
                ((IHiddoStatisticChannelCore)CoreFactory.getCore(IHiddoStatisticChannelCore.class)).sendEventStatistic_Channel(LoginUtil.getUid(), "51001", "0016", (Serializable)property);
            }
        }
    }

    public HotwordPopupWindow(Activity activity, int dataSize) {
        super((Context)activity);
        this.activity = activity;
        this.mDataSize = dataSize;
        this.mSendPresenter = new SendChatPresenter((Context)activity);
        this.mHotWordsListAdapter = new HotWordsListAdapter((Context)activity);
    }

    private static Rect locateView(View v) {
        int[] locInt = new int[2];
        if (v == null) {
            return null;
        }
        try {
            v.getLocationOnScreen(locInt);
        }
        catch (NullPointerException npe) {
            return null;
        }
        Rect location = new Rect();
        location.left = locInt[0];
        location.top = locInt[1];
        location.right = location.left + v.getWidth();
        location.bottom = location.top + v.getHeight();
        return location;
    }

    public void show(View anchor, boolean isLandscape) {
        double heightPercent;
        Rect rect = HotwordPopupWindow.locateView(anchor);
        if (rect == null) {
            return;
        }
        this.initHotWordsListPopupWindow(isLandscape);
        int x = rect.left - this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_left);
        int y = (anchor.getHeight() + rect.height()) / 2 + this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_bottom);
        double d = heightPercent = this.mDataSize >= 6 ? 1.0 : (double)(this.mDataSize + 2) * 1.0 / 8.0;
        if (isLandscape) {
            DisplayMetrics metrics = new DisplayMetrics();
            this.activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            x = rect.right + this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_left_landscape);
            y = (int)ResolutionUtils.convertDpToPixel((float)metrics.heightPixels, (Context)this.activity) - this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_bottom_landscape);
            this.mHotWordsView.setBackgroundResource(R.drawable.landscape_hot_words_list_bkg);
            this.setHeight((int)((double)this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_height_landscape) * heightPercent));
            this.showAtLocation(anchor, 0, x, y);
        } else {
            this.mHotWordsView.setBackgroundResource(R.drawable.hot_words_list_bkg);
            double h = (double)this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_height) * heightPercent;
            double screenHeight = ResolutionUtils.getScreenHeight((Context)BasicConfig.getInstance().getAppContext());
            if (h + (double)y > screenHeight && h < screenHeight) {
                y = (int)(screenHeight - h);
            }
            this.setHeight((int)h);
            int navigationBarHeight = NavigationBarUtils.getNavigationBarHeight(BasicConfig.getInstance().getAppContext());
            if (NavigationBarUtils.isNavigationBarOpen(this.activity)) {
                y += navigationBarHeight;
            }
            this.showAtLocation(anchor, 83, x, y);
        }
    }

    public void initHotWordsListPopupWindow(boolean isLandscape) {
        if (this.mHotWordsView == null) {
            this.mHotWordsView = this.activity.getLayoutInflater().inflate(R.layout.hot_words_list, null);
            this.mHotWordsLoading = (TextView)this.mHotWordsView.findViewById(R.id.hot_words_list_loading);
            this.mHotWordsListView = (ListView)this.mHotWordsView.findViewById(R.id.lv_hot_words_list);
            this.mHotWordsListView.setAdapter((ListAdapter)this.mHotWordsListAdapter);
            this.mHotWordsListView.setOnItemClickListener(this.mHotWordsOnItemClickListener);
            this.setContentView(this.mHotWordsView);
            this.setBackgroundDrawable((Drawable)new BitmapDrawable());
            this.setOutsideTouchable(true);
            this.setFocusable(true);
            if (isLandscape) {
                this.setAnimationStyle(R.style.left_popup_menu_animation);
            } else {
                this.setAnimationStyle(R.style.left_bottom_popup_scale_menu_animation);
            }
            int width = this.isNewGeneralHit() ? this.getGeneralWidth() : this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_width);
            this.setWidth(width);
        }
    }

    private int getGeneralWidth() {
        return (int)((float)ResolutionUtils.getScreenWidth((Context)BasicConfig.getInstance().getAppContext()) - ResolutionUtils.convertDpToPixel((float)148.0f, (Context)BasicConfig.getInstance().getAppContext()));
    }

    private boolean isNewGeneralHit() {
        String templateId = ChannelApi.Factory.get().getTemplateId();
        return templateId != null && templateId.equals("0");
    }

    private void dismissPopupAmountList() {
        if (this.isShowing()) {
            this.dismiss();
        }
    }

    public void setHotWordsListView(List<Label> list) {
        if (this.mHotWordsListView == null || this.mHotWordsLoading == null) {
            return;
        }
        if (!FP.empty(list) && list.size() > 0) {
            this.mHotWordsLoading.setVisibility(8);
            this.mHotWordsListView.setVisibility(0);
            this.mHotWordsListAdapter.setListData(list);
        } else {
            this.mHotWordsLoading.setVisibility(0);
            this.mHotWordsListView.setVisibility(8);
        }
    }
}

