/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatinput.hotwords;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.ui.widget.labelView.Label;
import com.yy.mobile.util.FP;
import java.util.ArrayList;
import java.util.List;

public class HotWordsListAdapter
extends BaseAdapter {
    public static final int HOT_WORDS_TYPE_TEXT = 0;
    private static final String HOT_WORDS_NULL = "0";
    private static final String HOT_WORDS_1 = "1";
    private static final String HOT_WORDS_2 = "2";
    private static final int HOT_WORDS_TYPE_1 = 1;
    private static final int HOT_WORDS_TYPE_2 = 2;
    private Context mContext;
    private LayoutInflater mInflater;
    private List<HotWordsInfo> mHotWordsList = new ArrayList<HotWordsInfo>();
    private static final int TYPE_COUNT = 3;

    public HotWordsListAdapter(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public void setListData(List<Label> list) {
        this.mHotWordsList.clear();
        if (!FP.empty(list)) {
            int size = list.size() > 6 ? 6 : list.size();
            for (int i = 0; i < size; ++i) {
                HotWordsInfo hotWordsInfo = new HotWordsInfo();
                hotWordsInfo.itemText = list.get((int)i).text;
                hotWordsInfo.itemType = 0;
                this.mHotWordsList.add(hotWordsInfo);
            }
        }
        HotWordsInfo hotWordsInfo2 = new HotWordsInfo();
        hotWordsInfo2.itemType = 2;
        this.mHotWordsList.add(hotWordsInfo2);
        HotWordsInfo hotWordsInfo1 = new HotWordsInfo();
        hotWordsInfo1.itemType = 1;
        this.mHotWordsList.add(hotWordsInfo1);
        this.notifyDataSetChanged();
    }

    public String getItemText(int position) {
        HotWordsInfo info = this.getItem(position);
        if (info.itemType == 0) {
            return info.itemText;
        }
        if (info.itemType == 1) {
            return HOT_WORDS_1;
        }
        if (info.itemType == 2) {
            return HOT_WORDS_2;
        }
        return HOT_WORDS_NULL;
    }

    public int getCount() {
        return this.mHotWordsList.size();
    }

    public long getItemId(int position) {
        return 0L;
    }

    public int getItemViewType(int position) {
        return this.getItem((int)position).itemType;
    }

    public HotWordsInfo getItem(int position) {
        if (position >= 0 && position < this.mHotWordsList.size()) {
            return this.mHotWordsList.get(position);
        }
        return null;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        HotWordsItemViewHolder viewHolder;
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.hot_words_list_item, parent, false);
            viewHolder = new HotWordsItemViewHolder();
            viewHolder.itemTextView = (TextView)convertView.findViewById(R.id.tv_hotwords_description);
            viewHolder.itemImageView = (ImageView)convertView.findViewById(R.id.iv_hotwords_description);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (HotWordsItemViewHolder)convertView.getTag();
        }
        if (this.getItemViewType(position) == 0) {
            HotWordsInfo itemInfo = this.getItem(position);
            if (!TextUtils.isEmpty((CharSequence)itemInfo.itemText)) {
                viewHolder.itemTextView.setText((CharSequence)itemInfo.itemText);
                viewHolder.itemTextView.setVisibility(0);
                viewHolder.itemImageView.setVisibility(8);
            }
        } else if (this.getItemViewType(position) == 1) {
            viewHolder.itemImageView.setBackgroundResource(R.drawable.item_kou1_normal);
            viewHolder.itemImageView.setVisibility(0);
            viewHolder.itemTextView.setVisibility(8);
        } else if (this.getItemViewType(position) == 2) {
            viewHolder.itemImageView.setBackgroundResource(R.drawable.item_kou2_normal);
            viewHolder.itemImageView.setVisibility(0);
            viewHolder.itemTextView.setVisibility(8);
        }
        return convertView;
    }

    private static class HotWordsItemViewHolder {
        TextView itemTextView;
        ImageView itemImageView;

        private HotWordsItemViewHolder() {
        }
    }

    private static class HotWordsInfo {
        int itemType = 0;
        String itemText;

        private HotWordsInfo() {
        }
    }
}

