/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatinput;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import androidx.fragment.app.FragmentActivity;
import com.duowan.mobile.basemedia.watchlive.activity.LiveTemplateActivity;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.livebizwrapper.utils.CommonUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SoftKeyboardStateChangeHelper
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final String TAG = "SoftKeyboardStateHelper";
    private final List<SoftKeyboardStateListener> listeners = new LinkedList<SoftKeyboardStateListener>();
    private final View rootView;
    private boolean isSoftKeyboardOpened;
    private int diff = 100;
    private int windowInitialBottom = 0;
    private Disposable taskDsp;
    private Context context;

    public SoftKeyboardStateChangeHelper(View rootView, FragmentActivity hostActivity) {
        this(rootView, false);
        if (hostActivity instanceof LiveTemplateActivity) {
            this.context = ((LiveTemplateActivity)hostActivity).getContext();
        }
    }

    public SoftKeyboardStateChangeHelper(View rootView, boolean isSoftKeyboardOpened) {
        this.rootView = rootView;
        this.isSoftKeyboardOpened = isSoftKeyboardOpened;
        this.init();
        rootView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private void init() {
        int top = 0;
        if (this.rootView != null && this.rootView.getRootView() != null) {
            Rect r = new Rect();
            try {
                this.rootView.getWindowVisibleDisplayFrame(r);
                this.windowInitialBottom = ScreenUtil.isFullScreen() ? ScreenUtil.getInstance().getWindowWidthPixels() : ScreenUtil.getInstance().getWindowHeightPixels();
                top = r.top;
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (Throwable)throwable);
                this.windowInitialBottom = ScreenUtil.getInstance().getWindowHeightPixels();
            }
        }
        MLog.info((Object)TAG, (String)"diff=%d, top=%d, windowBottom=%d, rootHeight=%d", (Object[])new Object[]{this.diff, top, this.windowInitialBottom, this.rootView.getMeasuredHeight()});
    }

    public void onGlobalLayout() {
        if (!this.listeners.isEmpty()) {
            Rect r = new Rect();
            this.rootView.getWindowVisibleDisplayFrame(r);
            this.startHandleTask();
        }
    }

    private void startHandleTask() {
        RxUtils.dispose((Disposable)this.taskDsp);
        this.taskDsp = Observable.timer((long)150L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                Rect r = new Rect();
                SoftKeyboardStateChangeHelper.this.rootView.getWindowVisibleDisplayFrame(r);
                int heightDiff = SoftKeyboardStateChangeHelper.this.windowInitialBottom + r.top - (r.bottom + (r.bottom - SoftKeyboardStateChangeHelper.this.rootView.getMeasuredHeight()));
                MLog.info((Object)SoftKeyboardStateChangeHelper.TAG, (String)"heightDiff=%d,  windowInitialBottom=%d\uff0cbottom=%d, top=%d, rootHeight=%d\uff0c isOpened=%s\uff0c NavBar=%d", (Object[])new Object[]{heightDiff -= SoftKeyboardStateChangeHelper.this.getNavBarHeight(), SoftKeyboardStateChangeHelper.this.windowInitialBottom, r.bottom, r.top, SoftKeyboardStateChangeHelper.this.rootView.getMeasuredHeight(), SoftKeyboardStateChangeHelper.this.isSoftKeyboardOpened, SoftKeyboardStateChangeHelper.this.getNavBarHeight()});
                if (!SoftKeyboardStateChangeHelper.this.isSoftKeyboardOpened && heightDiff > SoftKeyboardStateChangeHelper.this.diff) {
                    SoftKeyboardStateChangeHelper.this.isSoftKeyboardOpened = true;
                    SoftKeyboardStateChangeHelper.this.notifyOnSoftKeyboardOpened(heightDiff);
                    MLog.info((String)SoftKeyboardStateChangeHelper.TAG, (String)"notifyOnSoftKeyboardOpened");
                } else if (SoftKeyboardStateChangeHelper.this.isSoftKeyboardOpened && heightDiff < SoftKeyboardStateChangeHelper.this.diff) {
                    SoftKeyboardStateChangeHelper.this.isSoftKeyboardOpened = false;
                    SoftKeyboardStateChangeHelper.this.notifyOnSoftKeyboardClosed();
                    MLog.info((String)SoftKeyboardStateChangeHelper.TAG, (String)"notifyOnSoftKeyboardClosed");
                } else if (SoftKeyboardStateChangeHelper.this.isSoftKeyboardOpened && heightDiff > SoftKeyboardStateChangeHelper.this.diff) {
                    SoftKeyboardStateChangeHelper.this.notifySoftKeyboardHeightChange(heightDiff);
                    MLog.info((String)SoftKeyboardStateChangeHelper.TAG, (String)"notifySoftKeyboardHeightChange");
                } else {
                    MLog.info((String)SoftKeyboardStateChangeHelper.TAG, (String)"not handle");
                    if (SoftKeyboardStateChangeHelper.this.isSoftKeyboardOpened) {
                        SoftKeyboardStateChangeHelper.this.notifyOnSoftKeyboardClosed();
                    }
                }
            }
        });
    }

    public void addSoftKeyboardStateListener(SoftKeyboardStateListener listener2) {
        this.listeners.add(listener2);
    }

    public void removeSoftKeyboardStateListener(SoftKeyboardStateListener listener2) {
        this.listeners.remove(listener2);
        RxUtils.dispose((Disposable)this.taskDsp);
    }

    private void notifyOnSoftKeyboardOpened(int keyboardHeightInPx) {
        for (SoftKeyboardStateListener listener2 : this.listeners) {
            if (listener2 == null) continue;
            listener2.onSoftKeyboardOpened(keyboardHeightInPx);
        }
    }

    private void notifyOnSoftKeyboardClosed() {
        for (SoftKeyboardStateListener listener2 : this.listeners) {
            if (listener2 == null) continue;
            listener2.onSoftKeyboardClosed();
        }
    }

    private void notifySoftKeyboardHeightChange(int height) {
        for (SoftKeyboardStateListener listener2 : this.listeners) {
            if (listener2 == null) continue;
            listener2.onSoftKeyboardHeightChange(height);
        }
    }

    private int getNavBarHeight() {
        if (this.isShowNavBar() && !ScreenUtil.isFullScreen()) {
            return CommonUtils.getNavigationBarHeight(BasicConfig.getInstance().getAppContext());
        }
        return 0;
    }

    public boolean isShowNavBar() {
        Rect outRect1 = new Rect();
        try {
            ((Activity)this.context).getWindow().getDecorView().getWindowVisibleDisplayFrame(outRect1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        int activityHeight = outRect1.height();
        int statuBarHeight = ScreenUtil.getStatusBarHeight();
        int remainHeight = SoftKeyboardStateChangeHelper.getRealHeight() - statuBarHeight;
        return activityHeight != remainHeight;
    }

    public static int getRealHeight() {
        WindowManager wm = (WindowManager)BasicConfig.getInstance().getAppContext().getSystemService("window");
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            wm.getDefaultDisplay().getRealSize(point);
        } else {
            wm.getDefaultDisplay().getSize(point);
        }
        return point.y;
    }

    public static interface SoftKeyboardStateListener {
        public void onSoftKeyboardOpened(int var1);

        public void onSoftKeyboardClosed();

        public void onSoftKeyboardHeightChange(int var1);
    }
}

