/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatinput;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.template.ViewingRoomApi;
import com.duowan.mobile.basemedia.watchlive.template.BaseViewScene;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.event.OnLoginSucceedForRequestCode_EventArgs;
import com.yy.mobile.livebizwrapper.chatinput.BaseChatInputPopComponent;
import com.yy.mobile.livebizwrapper.chatinput.ChatInputPopComponent;
import com.yy.mobile.livebizwrapper.chatinput.ShowChatPresenter$$EventBinder;
import com.yy.mobile.livebizwrapper.chatinput.hotwords.HotwordPopupWindow;
import com.yy.mobile.login.LoginEntranceType;
import com.yy.mobile.ui.widget.labelView.Label;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ShowChatPresenter
implements EventCompat {
    private static final String TAG = "ShowChatPresenter";
    private BaseChatInputPopComponent publicScreenInputPop;
    private Disposable sendDelayDsp;
    private EventBinder mEventBinder;

    public void onCreate() {
        this.onEventBind();
    }

    public void showChatInputComponent(Fragment fragment, String defaultContent, boolean isHideWhenSuccess) {
        if (ViewingRoomApi.Factory.get().getCurrentScene() != BaseViewScene.ENTERTAINMENT && ViewingRoomApi.Factory.get().getCurrentScene() != BaseViewScene.PARTY) {
            MLog.info((String)TAG, (String)"\u975e\u6e38\u620f\u6a21\u677f\u548c\u5a31\u4e50\u6a21\u677f");
            this.showChatInputForNormal(fragment, defaultContent, isHideWhenSuccess);
        } else {
            MLog.info((String)TAG, (String)"\u6e38\u620f\u6a21\u677f\u548c\u5a31\u4e50\u6a21\u677f\uff0c\u663e\u793a\u7684\u8f93\u5165\u5f39\u7a97\u5305\u542b\u8425\u6536\u529f\u80fd");
            this.showChatInput(fragment, defaultContent, isHideWhenSuccess);
        }
    }

    private void showChatInput(Fragment fragment, String defaultContent, boolean isHideWhenSuccess) {
        try {
            if (this.publicScreenInputPop instanceof ChatInputPopComponent && TextUtils.isEmpty((CharSequence)defaultContent)) {
                this.publicScreenInputPop.setHideFlag(isHideWhenSuccess);
                if (!this.publicScreenInputPop.isAdded()) {
                    this.publicScreenInputPop.show(fragment.getFragmentManager(), "ChatInputPopComponent");
                } else {
                    MLog.error((String)TAG, (String)"show inputcomponent when already add");
                }
            } else {
                this.publicScreenInputPop = ChatInputPopComponent.Companion.show(fragment.getFragmentManager(), defaultContent, isHideWhenSuccess);
            }
        }
        catch (Exception e) {
            MLog.error((String)TAG, (String)("show chat input component error: " + e.getMessage()));
        }
    }

    @BusEvent
    public void onLoginSucceed(OnLoginSucceedForRequestCode_EventArgs arg) {
        MLog.info((String)TAG, (String)("onLoginSucceed respondCode: " + arg.getmRequestCode()));
        if (!TextUtils.isEmpty((CharSequence)arg.getmRequestCode()) && arg.getmRequestCode().contains("login_request_code_chat_btn_") && this.publicScreenInputPop != null) {
            RxUtils.dispose((Disposable)this.sendDelayDsp);
            this.sendDelayDsp = Observable.timer((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    if (ShowChatPresenter.this.publicScreenInputPop != null) {
                        ShowChatPresenter.this.publicScreenInputPop.triggerSendMsg();
                    }
                }
            });
        }
    }

    private void showChatInputForNormal(Fragment fragment, String defaultContent, boolean isHideWhenSuccess) {
        try {
            if (this.publicScreenInputPop instanceof BaseChatInputPopComponent && TextUtils.isEmpty((CharSequence)defaultContent)) {
                this.publicScreenInputPop.setHideFlag(isHideWhenSuccess);
                if (!this.publicScreenInputPop.isAdded()) {
                    this.publicScreenInputPop.show(fragment.getFragmentManager(), "BaseChatInputPopComponent");
                } else {
                    MLog.error((String)TAG, (String)"show inputcomponent when already add");
                }
            } else {
                this.publicScreenInputPop = BaseChatInputPopComponent.Companion.show(fragment.getFragmentManager(), defaultContent, isHideWhenSuccess);
            }
        }
        catch (Exception e) {
            MLog.error((String)TAG, (String)("show base chat input component error: " + e.getMessage()));
        }
    }

    @Nullable
    public HotwordPopupWindow showHotWordComponentWithLogin(@NotNull Activity activity, @NotNull View anchorView, boolean isLandscape, List<Label> words) {
        if (LoginUtil.isLogined()) {
            return this.createHotWordComponent(activity, anchorView, isLandscape, words);
        }
        if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(BaseFragmentApi.class) != null) {
            ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialogWithEntrance(activity, LoginEntranceType.LIVE_CHAT);
        }
        return null;
    }

    private HotwordPopupWindow createHotWordComponent(@NotNull Activity activity, @NotNull View anchorView, boolean isLandscape, List<Label> words) {
        HotwordPopupWindow window = null;
        window = this.showHotWordComponent(activity, anchorView, isLandscape, FP.size(words));
        window.setHotWordsListView(words);
        Property property = new Property();
        property.putString("key1", String.valueOf(ChannelApi.Factory.get().getCurrentChannelInfo().topSid));
        property.putString("key3", String.valueOf(ChannelApi.Factory.get().getCurrentTopMicId()));
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51012", "0003", (Serializable)property);
        return window;
    }

    private HotwordPopupWindow showHotWordComponent(@NotNull Activity activity, @NotNull View anchorView, boolean isLandscape, int dataSize) {
        HotwordPopupWindow window = new HotwordPopupWindow(activity, dataSize);
        window.show(anchorView, isLandscape);
        return window;
    }

    public void onDestroy() {
        MLog.info((String)TAG, (String)"onDestroy");
        RxUtils.dispose((Disposable)this.sendDelayDsp);
        if (this.publicScreenInputPop != null) {
            this.publicScreenInputPop.hidePop();
            this.publicScreenInputPop = null;
        }
        this.onEventUnBind();
    }

    public void onEventBind() {
        if (this.mEventBinder == null) {
            this.mEventBinder = new ShowChatPresenter$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

