/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatinput;

import android.content.Context;
import android.text.TextUtils;
import android.widget.TextView;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.channel.ChannelLoginPowerApi;
import com.duowan.mobile.livebasebiz.privatechat.ChatMsgInfo;
import com.duowan.mobile.livebasebiz.privatechat.IChatEmotionCore;
import com.duowan.mobile.livebasebiz.utils.MsgValidator;
import com.yy.mobile.RxBus;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.events.SendMessageTriggerShareEvent;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.richtext.YCommonTicketFilter;
import com.yy.mobile.richtext.YGroupTicketFilter;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import javax.annotation.Nullable;

public class SendChatPresenter {
    private static final String TAG = "SendChatPresenter";
    private Context mContext;
    private IChatEmotionCore chatEmotionCore;

    public SendChatPresenter(Context context) {
        this.mContext = context;
    }

    private IChatEmotionCore getChatEmotionCore() {
        if (this.chatEmotionCore == null) {
            this.chatEmotionCore = (IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class);
        }
        return this.chatEmotionCore;
    }

    public void sendMessage(String message, @Nullable TextView editInputContent, boolean[] isSendFromBtn, String isDefault) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            MLog.info((String)TAG, (String)"sendMessage fail: content is empty");
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            SingleToastUtil.showToast((int)R.string.str_net_error_common);
            MLog.info((String)TAG, (String)"sendMessage fail: network is unavailable");
            return;
        }
        if (this.isContainSensitiveWords(message)) {
            MLog.info((String)TAG, (String)"sendMessage fail: contain Sensitive Words");
            return;
        }
        if (this.isForbidUrlAndTicket(message)) {
            MLog.info((String)TAG, (String)"sendMessage fail: Forbid Url And Ticket");
            return;
        }
        ChatMsgInfo chatMsgInfo = this.getChatEmotionCore().createMessageBean(message, isDefault);
        this.getChatEmotionCore().setSendCurrentTime(System.currentTimeMillis());
        chatMsgInfo = this.getChatEmotionCore().checkChatMsg(chatMsgInfo);
        if (!TextUtils.isEmpty((CharSequence)chatMsgInfo.msgToSend) && chatMsgInfo.msgLength > 0 && chatMsgInfo.shouldSend) {
            this.chatEmotionCore.sendMessage(chatMsgInfo);
            MLog.info((String)TAG, (String)"component send to sdk by self");
            if (isSendFromBtn[0]) {
                ((IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class)).setInputMsgCache("");
                if (editInputContent != null) {
                    editInputContent.setText(null);
                }
                isSendFromBtn[0] = false;
            }
            if ((StringUtils.equal((String)chatMsgInfo.originMsg, (String)"1") || StringUtils.equal((String)chatMsgInfo.originMsg, (String)"2")) && !StringUtils.isEmpty((String)message).booleanValue()) {
                this.getChatEmotionCore().setMsgSendState(-1);
            } else {
                this.getChatEmotionCore().setMsgSendState(3);
            }
            RxBus.getDefault().post((Object)new SendMessageTriggerShareEvent(message, ""));
        } else {
            MLog.info((String)TAG, (String)"msg send by other holder");
            if (!chatMsgInfo.shouldKeepMsg && isSendFromBtn[0]) {
                ((IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class)).setInputMsgCache("");
                if (editInputContent != null) {
                    editInputContent.setText(null);
                }
                isSendFromBtn[0] = false;
            }
        }
    }

    private boolean isForbidUrlAndTicket(String message) {
        if (!TextUtils.isEmpty((CharSequence)message) && (MsgValidator.matchUrl((String)message) || ChannelTicketFilter.isChannelTicketMessage((CharSequence)message) || YGroupTicketFilter.isYGroupTicketMessage((CharSequence)message) || YCommonTicketFilter.isCommonTicketMessage((CharSequence)message))) {
            if (ChannelApi.Factory.get().getCurrentChannelInfo().forbidGuestSendUrl && ChannelApi.Factory.get().getCurrentChannelInfo().forbidMemberSendUrl && (this.isChannelGuest() || this.isChannelManagerBelow())) {
                MLog.info((String)TAG, (String)"sendMessage  guest and member -> forbidGuestSendUrl");
                this.postMessageToShow(message);
                SingleToastUtil.showToast((String)"\u7981\u6b62\u9ec4\u9a6c\u53ca\u4ee5\u4e0b\u6210\u5458\u53d1\u9001\u5305\u542bYY\u94fe\u63a5\u7684\u6587\u5b57\u4fe1\u606f");
                return true;
            }
            if (ChannelApi.Factory.get().getCurrentChannelInfo().forbidGuestSendUrl && !ChannelApi.Factory.get().getCurrentChannelInfo().forbidMemberSendUrl && this.isChannelGuest()) {
                MLog.info((String)TAG, (String)"sendMessage  guest -> forbidGuestSendUrl");
                this.postMessageToShow(message);
                SingleToastUtil.showToast((String)"\u672c\u9891\u9053\u7981\u6b62\u6e38\u5ba2\u53d1\u9001url\u548c\u98de\u673a\u7968");
                return true;
            }
        }
        return false;
    }

    private boolean isContainSensitiveWords(String message) {
        if (ChannelLoginPowerApi.Factory.get().isChannelPOLICE()) {
            this.postMessageToShow(message);
            SingleToastUtil.showToast((int)R.string.str_forbid_send_with_userInfo_channelPolice);
            return true;
        }
        return false;
    }

    private boolean isChannelMember() {
        return ChannelLoginPowerApi.Factory.get().getCurrentChannelLoginUserPowerInfo().isChannelMember(ChannelApi.Factory.get().getCurrentChannelInfo().topSid, ChannelApi.Factory.get().getCurrentChannelInfo().subSid);
    }

    private boolean isChannelManagerBelow() {
        ChannelLoginPowerApi api = ChannelLoginPowerApi.Factory.get();
        if (api != null && api.getCurrentChannelLoginUserPowerInfo() != null) {
            return api.getCurrentChannelLoginUserPowerInfo().isChannelMABelow(ChannelApi.Factory.get().getCurrentChannelInfo().topSid, ChannelApi.Factory.get().getCurrentChannelInfo().subSid);
        }
        return false;
    }

    private boolean isChannelGuest() {
        return ChannelLoginPowerApi.Factory.get().getCurrentChannelLoginUserPowerInfo().isChannelGuest(ChannelApi.Factory.get().getCurrentChannelInfo().topSid, ChannelApi.Factory.get().getCurrentChannelInfo().subSid);
    }

    private boolean isMobileChannelManager() {
        ChannelApi linkChannelCore = ChannelApi.Factory.get();
        long topSid = linkChannelCore.getCurrentChannelInfo().topSid;
        long subSid = linkChannelCore.getCurrentChannelInfo().subSid;
        return ChannelLoginPowerApi.Factory.get().getCurrentChannelLoginUserPowerInfo().isChannelMA(topSid, subSid);
    }

    private void postMessageToShow(String msg) {
        if (this.getChatEmotionCore() != null) {
            this.getChatEmotionCore().sendOwnMessage(msg, null, null);
        }
    }

    private void postMessageToShow(String msg, Object extInfo, Object extProps) {
        if (this.getChatEmotionCore() != null) {
            this.getChatEmotionCore().sendOwnMessage(msg, extInfo, extProps);
        }
    }

    public boolean onPreSendMessage(String msg, @Nullable TextView editText, boolean[] isFromButton, String isDefault) {
        String errorMsg = this.getChatEmotionCore().getErrorResultForInvalidChat();
        if (errorMsg == null) {
            long currentTime = System.currentTimeMillis();
            if ((currentTime - this.getChatEmotionCore().getLastSendTime()) / 1000L < 2L) {
                MLog.info((String)TAG, (String)"[sendMessage] send chat msg too fast");
                SingleToastUtil.showToast((int)R.string.str_chat_text_counter_limited_tip);
                return false;
            }
            this.sendMessage(msg, editText, isFromButton, isDefault);
            return true;
        }
        MLog.info((Object)TAG, (String)"[sendMessage] errorMsg: %s", (Object[])new Object[]{errorMsg});
        this.postMessageToShow(msg);
        SingleToastUtil.showToast((String)errorMsg);
        return true;
    }
}

