/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.bulletscreen.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.richtext.RichTextManager;
import com.yy.mobile.ui.basicgunview.IDanmukuView;
import com.yy.mobile.ui.basicgunview.bulletscreen.DanmuOpenStatusType;
import com.yy.mobile.ui.basicgunview.bulletscreen.danmucanvas.bean.BitmapGunPowder;
import com.yy.mobile.ui.basicgunview.bulletscreen.danmucanvas.bean.DanmuData;
import com.yy.mobile.ui.basicgunview.bulletscreen.util.DanMuPosition;
import com.yy.mobile.ui.basicgunview.newgunpower.GunNewPower;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuOpenStatus;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.channel.ChannelMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DanMuUtil {
    private static final String TAG = "DanMuUtil";
    protected List<RichTextManager.Feature> features;
    protected HashSet<String> emotionMap;
    protected BlockingQueue<DanmuData> que;
    private Thread task;
    private AtomicBoolean door = new AtomicBoolean(true);
    private LinkedList<BitmapGunPowder> priorityDanmu;
    private LinkedList<BitmapGunPowder> normalDanmu;
    private LinkedList<BitmapGunPowder> myDanmu;
    private AtomicInteger danmuCount = new AtomicInteger();
    private boolean mSurfaceView = false;
    private WeakReference<IDanmukuView> mDanmuView = null;
    private TextView mDanmuTextView;
    private int mDanmuTextSize = 14;
    private boolean openStatus = false;
    private DanMuPosition mCurrentPosition;
    private boolean mDanmuEnabled;
    private boolean ignoreOrientation = false;

    public int getDanmuTextSize() {
        return this.mDanmuTextSize;
    }

    public void setDanmuTextSize(int danmuTextSize) {
        this.mDanmuTextSize = danmuTextSize;
    }

    protected DanMuUtil() {
        this.features = new ArrayList<RichTextManager.Feature>();
        this.emotionMap = new HashSet(500);
        this.features.add(RichTextManager.Feature.CHANNELAIRTICKET);
        this.features.add(RichTextManager.Feature.EMOTICON);
        this.features.add(RichTextManager.Feature.NOBLEEMOTION);
        this.features.add(RichTextManager.Feature.NOBLEGIFEMOTION);
        this.emotionMap.addAll(Arrays.asList(EmoticonFilter.getAllSmileCodes()));
        this.que = new LinkedBlockingQueue<DanmuData>();
        this.priorityDanmu = new LinkedList();
        this.normalDanmu = new LinkedList();
        this.myDanmu = new LinkedList();
        this.mDanmuEnabled = this.isDanmuEnabledFromPreference();
        MLog.info((String)TAG, (String)("init DanmuEnabled:" + this.mDanmuEnabled));
    }

    public boolean isSurfaceView() {
        return this.mSurfaceView;
    }

    public void setSurfaceView(boolean isSurfaceView) {
        this.mSurfaceView = isSurfaceView;
    }

    public IDanmukuView getDanmuView() {
        if (this.mDanmuView != null && this.mDanmuView.get() != null) {
            return (IDanmukuView)this.mDanmuView.get();
        }
        return null;
    }

    public void setDanmuView(IDanmukuView danmuView) {
        this.mDanmuView = new WeakReference<IDanmukuView>(danmuView);
    }

    public void loadMedal(Context context, SpannableStringBuilder sp, int defalutImgResId, int width, int height, String medalUrl) {
        if (FP.empty((CharSequence)medalUrl)) {
            return;
        }
        ImageLoader.preloadBitmap((String)medalUrl, (ImageConfig)ImageConfig.fullImageConfig(), (int)defalutImgResId);
        BitmapDrawable medalDrawable = ImageLoader.getBitmapFromCache((String)medalUrl, (ImageConfig)ImageConfig.fullImageConfig());
        if (medalDrawable == null) {
            medalDrawable = ImageUtil.getBitmapDrawableFromResource((int)width, (int)height, (int)defalutImgResId);
        }
        int newWidth = (int)ResolutionUtils.convertDpToPixel((float)50.5f, (Context)context);
        int newHeight = (int)ResolutionUtils.convertDpToPixel((float)21.5f, (Context)context);
        medalDrawable.setBounds(0, 0, newWidth, newHeight);
        sp.setSpan((Object)new CustomImageSpan((Drawable)medalDrawable, 2.0f), 0, 1, 33);
    }

    public Drawable getFixedSizedNobleImage(int reSource, int w, int h, Context context) {
        BitmapDrawable baseImage = ImageLoader.getBitmapDrawableFromResource((int)reSource, (ImageConfig)ImageConfig.fullImageConfig());
        BitmapDrawable reSize = null;
        int tw = (int)ResolutionUtils.convertDpToPixel((float)w, (Context)context);
        int th = (int)ResolutionUtils.convertDpToPixel((float)h, (Context)context);
        if (baseImage != null) {
            reSize = ImageLoader.getBitmapFromCache((String)(reSource + "" + tw + th));
            if (reSize == null) {
                Bitmap bitmap = baseImage.getBitmap();
                if (bitmap == null) {
                    return null;
                }
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)tw, (int)th, (boolean)true);
                reSize = new BitmapDrawable(context.getResources(), bitmap);
                ImageLoader.addBitmapToCache((String)(reSource + "" + tw + th), (BitmapDrawable)reSize);
            }
            reSize.setBounds(0, 0, reSize.getIntrinsicWidth(), reSize.getIntrinsicHeight());
        }
        return reSize != null ? reSize : baseImage;
    }

    protected void initDanmuTextView(Context context) {
        if (this.mDanmuTextView == null) {
            try {
                LayoutInflater inflater = (LayoutInflater)BasicConfig.getInstance().getAppContext().getSystemService("layout_inflater");
                View view = inflater.inflate(R.layout.danmu_message_item, null);
                this.mDanmuTextView = (TextView)view.findViewById(R.id.tv_danmu_content);
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (Throwable)throwable);
            }
        }
        if (this.mDanmuTextView != null) {
            this.mDanmuTextView.setTextSize(2, (float)this.getDanmuTextSize());
        }
    }

    public void clear() {
        this.mDanmuTextView = null;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)" clearPublicChatMedal ");
        }
    }

    public void setIgnoreOrientation(boolean ignoreOrientation) {
        this.ignoreOrientation = ignoreOrientation;
    }

    protected void addDanMuData(Spannable spannable, DanmuData danmuData) {
        this.addGunPowder(spannable, danmuData.priority, danmuData.textColor, danmuData.lineNum, danmuData.senderUid, danmuData.backGround, danmuData.contend, danmuData.pureText, danmuData.isReplay, danmuData.isGiftMessage, danmuData.isAir);
    }

    protected boolean checkValid(Context context) {
        this.initDanmuTextView(context);
        if (context.getResources().getConfiguration().orientation == 1 && !this.ignoreOrientation) {
            return false;
        }
        return this.isDanmuEnabled() && this.isOpen();
    }

    public synchronized void checkTask(Context context) {
        if (this.task == null) {
            this.init(context);
        }
    }

    public abstract Spannable addMentel(ChannelMessage var1, Spannable var2, Context var3);

    public abstract void appendDanmu(ChannelMessage var1, Context var2);

    public abstract void appendSpannableDanMu(ChannelMessage var1, Context var2);

    public abstract GunNewPower getInvincibleDanmu();

    public abstract boolean needInvincibleDanmu();

    public Spannable setSpanColor(ChannelMessage message, Spannable spannable, int nicknameColor, int textColor) {
        int idx;
        if (spannable == null) {
            return null;
        }
        spannable.setSpan((Object)new ForegroundColorSpan(textColor), 0, spannable.length(), 33);
        if (!TextUtils.isEmpty((CharSequence)message.nickname) && (idx = spannable.toString().indexOf(message.nickname)) >= 0 && idx < spannable.length()) {
            spannable.setSpan((Object)new ForegroundColorSpan(nicknameColor), idx, idx + message.nickname.length(), 33);
        }
        return spannable;
    }

    public Spannable setSpanColorAndBackground(ChannelMessage message, Spannable spannable, @ColorInt int nickNameColor, @ColorInt int textColor) {
        int idx;
        if (spannable == null) {
            return null;
        }
        ForegroundColorSpan nameSpan = new ForegroundColorSpan(nickNameColor);
        ForegroundColorSpan textSpan = new ForegroundColorSpan(textColor);
        spannable.setSpan((Object)textSpan, 0, spannable.length(), 33);
        if (!TextUtils.isEmpty((CharSequence)message.nickname) && (idx = spannable.toString().indexOf(message.nickname)) >= 0 && idx < spannable.length()) {
            spannable.setSpan((Object)nameSpan, idx, idx + message.nickname.length(), 33);
        }
        return spannable;
    }

    protected void addGunPowder(Spannable span, int priority, int color, int lineNum, long senderUid, int backGround, String contend, String pureText, boolean isReplay, boolean isGift, boolean isAir) {
        if (this.que.size() > 200) {
            this.stopDanmu();
            this.open(true);
        }
        DanmuData data = new DanmuData(span, pureText, priority, color, lineNum, senderUid);
        data.priority = priority;
        data.contend = contend;
        data.backGround = backGround;
        data.isReplay = isReplay;
        data.isGiftMessage = isGift;
        data.isAir = isAir;
        data.pureText = pureText;
        this.que.add(data);
    }

    protected void addGunPowder(Spannable span, int priority, int color, int lineNum, long senderUid, int backGround, String contend, String pureText, boolean isReplay, boolean isGift, boolean isAir, Drawable bgDrawable) {
        if (this.que.size() > 200) {
            this.stopDanmu();
            this.open(true);
        }
        DanmuData data = new DanmuData(span, pureText, priority, color, lineNum, senderUid);
        data.priority = priority;
        data.contend = contend;
        data.backGround = backGround;
        data.isReplay = isReplay;
        data.isGiftMessage = isGift;
        data.isAir = isAir;
        data.pureText = pureText;
        data.bgDrawable = bgDrawable;
        this.que.add(data);
    }

    private void init(Context context) {
        this.task = new Thread("pluginlivebasebiz DanmuTask"){

            @Override
            public void run() {
                try {
                    while (DanMuUtil.this.door.get()) {
                        DanmuData tmp = DanMuUtil.this.que.take();
                        if (tmp != null) {
                            BitmapGunPowder tmpPowder = new BitmapGunPowder(tmp.priority, tmp.backGround, tmp.contend, BasicConfig.getInstance().getAppContext(), DanMuUtil.this.mDanmuTextView);
                            tmpPowder.span = tmp.span;
                            tmpPowder.textColor = tmp.textColor;
                            tmpPowder.mTextSize = tmp.textSize;
                            tmpPowder.senderUid = tmp.senderUid;
                            tmpPowder.isReplay = tmp.isReplay;
                            tmpPowder.isGiftMessage = tmp.isGiftMessage;
                            tmpPowder.isAir = tmp.isAir;
                            tmpPowder.pureText = tmp.pureText;
                            tmpPowder.bgDrawable = tmp.bgDrawable;
                            if (DanMuUtil.this.danmuCount.get() >= 80) {
                                DanMuUtil.this.priorityDanmu.clear();
                                DanMuUtil.this.normalDanmu.clear();
                                DanMuUtil.this.myDanmu.clear();
                                DanMuUtil.this.danmuCount.set(0);
                            }
                            DanMuUtil.this.danmuCount.incrementAndGet();
                            DanMuUtil.this.addDanmu(tmpPowder);
                        }
                        Thread.sleep(300L);
                    }
                }
                catch (InterruptedException e) {
                    MLog.info((String)"wangke", (String)"DanMu thread end normal");
                }
                catch (Throwable t) {
                    MLog.info((String)"wangke", (String)("DanMu thread end error" + t.toString()));
                }
            }
        };
        this.door.set(true);
        this.task.start();
    }

    private void addDanmu(BitmapGunPowder bitmapGunPowder) {
        if (bitmapGunPowder.isme && bitmapGunPowder.p > 10) {
            this.myDanmu.add(bitmapGunPowder);
        } else if (bitmapGunPowder.p > 0) {
            this.priorityDanmu.add(bitmapGunPowder);
        } else {
            this.normalDanmu.add(bitmapGunPowder);
        }
    }

    public IDanmuOpenStatus getDanmuOpenStatus(@DanmuOpenStatusType int type) {
        switch (type) {
            case 0: {
                return new IDanmuOpenStatus(){

                    public void getGunPower(HashMap<Integer, Boolean> hashMap) {
                        if (!DanMuUtil.this.isDanmuEnabled() || !DanMuUtil.this.isOpen() && hashMap == null) {
                            return;
                        }
                        DanMuUtil.this.pushDanmuFromButtomToTop(hashMap);
                    }
                };
            }
            case 2: {
                return new IDanmuOpenStatus(){

                    public void getGunPower(HashMap<Integer, Boolean> hashMap) {
                        if (!DanMuUtil.this.isDanmuEnabled() || !DanMuUtil.this.isOpen() && hashMap == null) {
                            return;
                        }
                        DanMuUtil.this.pushDanmuForGameTemplate(hashMap);
                    }
                };
            }
        }
        return new IDanmuOpenStatus(){

            public void getGunPower(HashMap<Integer, Boolean> hashMap) {
                if (!DanMuUtil.this.isDanmuEnabled() || !DanMuUtil.this.isOpen() && hashMap == null) {
                    return;
                }
                if (DanMuUtil.this.needInvincibleDanmu()) {
                    DanMuUtil.this.pushInvincibleDanmu(hashMap);
                } else {
                    DanMuUtil.this.pushDanmu(hashMap);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDanmu(HashMap<Integer, Boolean> map) {
        DanMuUtil danMuUtil = this;
        synchronized (danMuUtil) {
            if (this.door.get()) {
                for (int i = map.size() - 1; i >= 0; --i) {
                    if (!map.get(i).booleanValue()) continue;
                    BitmapGunPowder tmp = null;
                    tmp = i == map.size() - 1 ? (this.myDanmu.size() != 0 ? this.myDanmu.poll() : (this.priorityDanmu.size() != 0 ? this.priorityDanmu.poll() : this.normalDanmu.poll())) : this.normalDanmu.poll();
                    if (tmp == null) continue;
                    tmp.convert(this.isSurfaceView());
                    if (tmp.bitmap != null && this.mDanmuView != null && this.mDanmuView.get() != null) {
                        ((IDanmukuView)this.mDanmuView.get()).sendGunPower((GunNewPower)tmp, i);
                    }
                    this.danmuCount.decrementAndGet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDanmuFromButtomToTop(HashMap<Integer, Boolean> map) {
        DanMuUtil danMuUtil = this;
        synchronized (danMuUtil) {
            if (this.door.get()) {
                for (int i = map.size() - 1; i >= 0; --i) {
                    if (!map.get(i).booleanValue()) continue;
                    BitmapGunPowder tmp = null;
                    tmp = this.myDanmu.size() != 0 ? this.myDanmu.poll() : (this.priorityDanmu.size() != 0 ? this.priorityDanmu.poll() : this.normalDanmu.poll());
                    if (tmp == null) continue;
                    tmp.convert(this.isSurfaceView());
                    if (tmp.bitmap != null && this.mDanmuView != null && this.mDanmuView.get() != null) {
                        ((IDanmukuView)this.mDanmuView.get()).sendGunPower((GunNewPower)tmp, i);
                    }
                    this.danmuCount.decrementAndGet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDanmuForGameTemplate(HashMap<Integer, Boolean> map) {
        DanMuUtil danMuUtil = this;
        synchronized (danMuUtil) {
            if (this.door.get()) {
                for (int i = map.size() - 1; i >= 0; --i) {
                    if (!map.get(i).booleanValue() || !this.isValidPosition(i)) continue;
                    BitmapGunPowder tmp = null;
                    tmp = this.myDanmu.size() != 0 ? this.myDanmu.poll() : (this.priorityDanmu.size() != 0 ? this.priorityDanmu.poll() : this.normalDanmu.poll());
                    if (tmp == null) continue;
                    tmp.convert(this.isSurfaceView());
                    if (tmp.bitmap != null && this.mDanmuView != null && this.mDanmuView.get() != null) {
                        ((IDanmukuView)this.mDanmuView.get()).sendGunPower((GunNewPower)tmp, i);
                    }
                    this.danmuCount.decrementAndGet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushInvincibleDanmu(HashMap<Integer, Boolean> map) {
        if (this.door.get()) {
            for (int i = map.size() - 1; i >= 0; --i) {
                if (!map.get(i).booleanValue()) continue;
                if (i == map.size() - 1 && i != 0) {
                    DanMuUtil danMuUtil = this;
                    synchronized (danMuUtil) {
                        BitmapGunPowder tmp = null;
                        tmp = this.myDanmu.size() != 0 ? this.myDanmu.poll() : (this.priorityDanmu.size() != 0 ? this.priorityDanmu.poll() : this.normalDanmu.poll());
                        if (tmp != null) {
                            tmp.convert(this.isSurfaceView());
                            if (tmp.bitmap != null && this.mDanmuView != null && this.mDanmuView.get() != null) {
                                ((IDanmukuView)this.mDanmuView.get()).sendGunPower((GunNewPower)tmp, i);
                            }
                            this.danmuCount.decrementAndGet();
                        }
                        continue;
                    }
                }
                GunNewPower gun = this.getInvincibleDanmu();
                if (gun == null) {
                    return;
                }
                if (gun.bitmap == null || this.mDanmuView == null || this.mDanmuView.get() == null) continue;
                ((IDanmukuView)this.mDanmuView.get()).sendGunPower(gun, i);
            }
        }
    }

    public void setCurrentPosition(DanMuPosition mCurrentPosition) {
        this.mCurrentPosition = mCurrentPosition;
    }

    protected boolean isValidPosition(int i) {
        switch (this.mCurrentPosition) {
            case TOP: {
                if (i < 0 || i > 2) break;
                return true;
            }
            case BOTTOM: {
                if (i < 5 || i > 7) break;
                return true;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    protected void updateShaderMatrix(BitmapShader bitmapShader, int bitmapWidth, int bitmapHeight, Rect drawableRect) {
        float scale;
        float dx = 0.0f;
        float dy = 0.0f;
        Matrix mShaderMatrix = new Matrix();
        mShaderMatrix.set(null);
        if (bitmapWidth * drawableRect.height() > drawableRect.width() * bitmapHeight) {
            scale = (float)drawableRect.height() / (float)bitmapHeight;
            dx = ((float)drawableRect.width() - (float)bitmapWidth * scale) * 0.5f;
        } else {
            scale = (float)drawableRect.width() / (float)bitmapWidth;
            dy = ((float)drawableRect.height() - (float)bitmapHeight * scale) * 0.5f;
        }
        mShaderMatrix.setScale(scale, scale);
        mShaderMatrix.postTranslate((float)((int)(dx + 0.5f) + 2), (float)((int)(dy + 0.5f) + 2));
        bitmapShader.setLocalMatrix(mShaderMatrix);
    }

    public void stopDanmu() {
        this.danmuCount = new AtomicInteger();
        this.door.set(false);
        if (this.task != null) {
            this.task.interrupt();
        }
        this.task = null;
        this.que.clear();
        this.priorityDanmu.clear();
        this.normalDanmu.clear();
        this.myDanmu.clear();
        this.openStatus = false;
        MLog.info((String)TAG, (String)"stopDanMu");
    }

    public void open(boolean open) {
        this.openStatus = open;
        MLog.info((String)TAG, (String)("isOpen=" + open));
    }

    public boolean isOpen() {
        return this.openStatus;
    }

    public boolean isDanmuEnabled() {
        return this.mDanmuEnabled;
    }

    public void setDanmuEnabled(boolean enabled) {
        IDanmukuView danmukuView = this.getDanmuView();
        if (danmukuView != null) {
            danmukuView.setVisibility(enabled ? 0 : 4);
        }
        CommonPref.instance().putBoolean(this.getDanmu_enabledString(), enabled);
        this.mDanmuEnabled = enabled;
        MLog.info((String)TAG, (String)("setDanmuEnabled DanmuEnabled:" + this.mDanmuEnabled));
    }

    private boolean isDanmuEnabledFromPreference() {
        return CommonPref.instance().getBoolean(this.getDanmu_enabledString(), true);
    }

    protected String getDanmu_enabledString() {
        return "shareed_pref_name_danmu_enabled";
    }

    public void setDanmuEnabledWithoutStoreState(boolean enable) {
        IDanmukuView danmukuView = this.getDanmuView();
        if (danmukuView != null) {
            danmukuView.setVisibility(enable ? 0 : 4);
        }
        this.mDanmuEnabled = enable;
        MLog.info((String)TAG, (String)("setDanmuEnabledWithoutStoreState DanmuEnabled:" + this.mDanmuEnabled));
    }
}

