/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.audience;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.livebasebiz.event.IChatEmotionClient_onChatInputSwitch_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.livebasebiz.IMicAudienceDiversity;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.audience.DefaultOnlineAudienceBizHolder;
import com.yy.mobile.livebizwrapper.audience.IOnlineAudienceBizHolder;
import com.yy.mobile.livebizwrapper.audience.OnlineAudienceComponent$$EventBinder;
import com.yy.mobile.livebizwrapper.bulletscreen.LiveRoomOnlineViewerLoadSampling;
import com.yy.mobile.livebizwrapper.component.LiveBizComponentLinkProvider;
import com.yy.mobile.livebizwrapper.events.UpdateViewEventArgs;
import com.yy.mobile.livebizwrapper.micaudience.IMicAudienceCore;
import com.yy.mobile.livebizwrapper.micaudience.event.IMicAudienceClient_addAudienceListView_EventArgs;
import com.yy.mobile.livebizwrapper.micaudience.event.IMicAudienceClient_onPreLeaveChannel_EventArgs;
import com.yy.mobile.livebizwrapper.officialchannel.IChannelOfficialInfoCore;
import com.yy.mobile.livebizwrapper.officialchannel.OfficialInfo;
import com.yy.mobile.livebizwrapper.slidefunction.core.IActiveUserCore;
import com.yy.mobile.livebizwrapper.slidefunction.events.IBasicFunctionClient_onSwipeSwitchTipNotify_EventArgs;
import com.yy.mobile.livebizwrapper.statistic.GameTplStatisticModel;
import com.yy.mobile.livebizwrapper.task.INewUserTaskInterceptCore;
import com.yy.mobile.livebizwrapper.utils.NoRepeatClickListener;
import com.yy.mobile.livebizwrapper.widget.TipsPopupWindow;
import com.yy.mobile.perf.PerfSDK;
import com.yy.mobile.plugin.main.event.IMicClient_notifyAnchorImMediateOPlayer_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelInfo_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicStateisColse_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicStateisOpen_EventArgs;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.ActivityCheckUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.HasVideoStreamEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.NoVideoStreamEvent;
import com.yy.mobile.startlive.api.anchor.LiveBizTypeHolder;
import com.yy.mobile.statistic.StatisticService;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelState;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OnlineAudienceComponent
extends Component
implements LiveBizComponentLinkProvider.OnHolderCreatedWithDefaultListener<IOnlineAudienceBizHolder> {
    private static final String TAG = "OnlineAudienceComponent";
    public static final String SHOW_MIC_DOT = "enableShowMicDot";
    private View mRootView = null;
    private ViewGroup mAudienceListView = null;
    private ViewGroup mOtherBizLayout = null;
    private ImageView mMicImg;
    private ImageView mMicDotImg;
    private View mExitViewPortrait = null;
    private boolean enableShowMicDot = true;
    private boolean isFullScreen;
    private DialogLinkManager mDialogLinkManager;
    private Map<String, String> extendInfo = new HashMap<String, String>();
    private IOnlineAudienceBizHolder onlineAudienceBizHolder;
    private NoRepeatClickListener mOnlineMicOnClickListener = new NoRepeatClickListener(){

        @Override
        public void onNoRepeatClick(View v) {
            if (null != OnlineAudienceComponent.this.onlineAudienceBizHolder && ActivityCheckUtils.checkActivityValid((Activity)OnlineAudienceComponent.this.getActivity())) {
                OnlineAudienceComponent.this.onlineAudienceBizHolder.doOnlineMicClick(OnlineAudienceComponent.this.getRoot(), OnlineAudienceComponent.this.getFragmentManager());
            }
        }
    };
    private View.OnClickListener mExitOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            MLog.info((String)OnlineAudienceComponent.TAG, (String)"click exit live room button");
            OnlineAudienceComponent.this.onLeaveChannel(false, true);
        }
    };
    private TipsPopupWindow tipsPopupWindow;
    private Runnable hideTipsPopWindowRunnable = new Runnable(){

        @Override
        public void run() {
            OnlineAudienceComponent.this.hideTipsPopWindow();
        }
    };
    private static final String SHARE_PREF_SLIDE_DOWN_CLOSE_GUIDE = "SHARE_PREF_SLIDE_DOWN_CLOSE_GUIDE";
    private EventBinder mEventBinder;

    public static OnlineAudienceComponent newInstance() {
        Bundle bundle = new Bundle();
        OnlineAudienceComponent component = new OnlineAudienceComponent();
        component.setArguments(bundle);
        return component;
    }

    public void onCreate(Bundle savedInstanceState) {
        Bundle bundle;
        super.onCreate(savedInstanceState);
        LiveBizComponentLinkProvider.INSTANCE.callCreateHolder(this, DefaultOnlineAudienceBizHolder.class);
        if (this.getArguments() != null) {
            this.enableShowMicDot = this.getArguments().getBoolean(SHOW_MIC_DOT, true);
        }
        boolean bl = this.isFullScreen = this.getResources().getConfiguration().orientation == 2;
        if (this.getActivity().getIntent() != null && (bundle = this.getActivity().getIntent().getExtras()) != null) {
            this.extendInfo = (Map)bundle.get("channel_mobile_extend_info");
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ((LiveRoomOnlineViewerLoadSampling)StatisticService.instance().get(LiveRoomOnlineViewerLoadSampling.class)).begin();
        PerfSDK.instance().start(50021, "liveroom_online_viewer_load_timecost");
        long t1 = System.currentTimeMillis();
        this.mRootView = inflater.inflate(R.layout.fragment_live_online_audience, container, false);
        MLog.info((String)TAG, (String)("inflate view time = " + (System.currentTimeMillis() - t1)));
        this.mAudienceListView = (ViewGroup)this.mRootView.findViewById(R.id.audience_list_layout);
        this.mOtherBizLayout = (ViewGroup)this.mRootView.findViewById(R.id.other_biz_layout);
        this.mMicImg = (ImageView)this.mRootView.findViewById(R.id.audience_icon_more);
        this.mMicDotImg = (ImageView)this.mRootView.findViewById(R.id.audience_mic_onlice_dot);
        this.mExitViewPortrait = this.mRootView.findViewById(R.id.btn_exit_portrait);
        this.mExitViewPortrait.setOnClickListener(this.mExitOnClickListener);
        this.mMicImg.setOnClickListener((View.OnClickListener)this.mOnlineMicOnClickListener);
        if (!((IMicAudienceDiversity)ICoreManagerBase.getCore(IMicAudienceDiversity.class)).isMicAudienceEnable()) {
            this.enableShowMicDot = false;
            this.mMicImg.setVisibility(8);
            this.mMicDotImg.setVisibility(8);
        }
        if (this.enableShowMicDot) {
            if (ChannelApi.Factory.get().isOpenMic()) {
                if (LoginUtil.isLogined() && this.mMicDotImg != null) {
                    this.mMicDotImg.setVisibility(0);
                }
            } else if (LoginUtil.isLogined() && this.mMicDotImg != null) {
                this.mMicDotImg.setVisibility(8);
            }
        }
        return this.mRootView;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.showProgramInfoComponent();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.getResources().getConfiguration().orientation == 2) {
            this.isFullScreen = true;
        } else if (this.getResources().getConfiguration().orientation == 1) {
            this.isFullScreen = false;
        }
    }

    private void showProgramInfoComponent() {
        if (ChannelApi.Factory.get() != null && ChannelApi.Factory.get().getChannelState() == ChannelState.In_Channel && ChannelApi.Factory.get().getCurrentChannelInfo() != null && ChannelApi.Factory.get().getCurrentChannelInfo().topSid > 0L) {
            View view;
            OfficialInfo chanelinfo = ((IChannelOfficialInfoCore)CoreFactory.getCore(IChannelOfficialInfoCore.class)).getOfficialProgramInfo(ChannelApi.Factory.get().getCurrentChannelInfo().topSid);
            if (chanelinfo != null && !this.isLianMai()) {
                View view2;
                if (this.mRootView != null && (view2 = (View)this.mRootView.getParent()) != null) {
                    RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, DimenConverter.dip2px((Context)this.getActivity(), (float)38.0f));
                    layoutParams.setMargins(DimenConverter.dip2px((Context)this.getActivity(), (float)0.0f), DimenConverter.dip2px((Context)this.getActivity(), (float)12.0f), 0, 0);
                    layoutParams.addRule(1, R.id.basic_live_program_component);
                    view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
            } else if (this.mRootView != null && (view = (View)this.mRootView.getParent()) != null) {
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, DimenConverter.dip2px((Context)this.getActivity(), (float)38.0f));
                layoutParams.setMargins(0, 0, 0, 0);
                layoutParams.addRule(1, R.id.basic_live_program_component);
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    public boolean isLianMai() {
        return LiveBizTypeHolder.getInstance().isLinkMic();
    }

    @BusEvent(busType=1, busName="Live")
    public void onPreLeaveChannel(IMicAudienceClient_onPreLeaveChannel_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)("onLeaveChannel called with: busEventArgs = [" + busEventArgs + "]"));
        boolean param = busEventArgs.mParam;
        this.onLeaveChannel(param, true);
    }

    protected boolean onLeaveChannel(boolean showOnMicDialog, boolean resetSlipParamsAfterSuccess) {
        if (this.isLiveTaskInterceptExit()) {
            return true;
        }
        if (this.isCanShowSlideChannelGuide() && ((IActiveUserCore)CoreFactory.getCore(IActiveUserCore.class)).allowPopH5()) {
            MLog.info((String)TAG, (String)"cann show slide guide and pop is h5");
            return this.handleNormalExit(showOnMicDialog, resetSlipParamsAfterSuccess);
        }
        if (this.isInterceptExit()) {
            MLog.info((String)TAG, (String)"pop active user recommend");
            BasePopupComponent pop = ((IActiveUserCore)CoreFactory.getCore(IActiveUserCore.class)).createRecommendPopComponent();
            if (pop != null) {
                pop.show(this.getChildFragmentManager(), pop.getClass().getSimpleName());
                ((IActiveUserCore)CoreFactory.getCore(IActiveUserCore.class)).updateIsAlreadyPopInCurChannel(true);
            }
            return true;
        }
        return this.handleNormalExit(showOnMicDialog, resetSlipParamsAfterSuccess);
    }

    private boolean handleNormalExit(boolean showOnMicDialog, boolean resetSlipParamsAfterSuccess) {
        if (((IActiveUserCore)CoreFactory.getCore(IActiveUserCore.class)).isAlreadyPopInCurChannel()) {
            MLog.info((String)TAG, (String)"isAlreadyPopInCurChannel Do not show other guides");
            this.leaveChannelDirect();
            return true;
        }
        if (null != this.onlineAudienceBizHolder && this.onlineAudienceBizHolder.isValid()) {
            return this.onlineAudienceBizHolder.onLeaveChannel(showOnMicDialog, resetSlipParamsAfterSuccess, this.extendInfo);
        }
        this.leaveChannelDirect();
        return true;
    }

    private boolean isCanShowSlideChannelGuide() {
        if (null != this.onlineAudienceBizHolder && this.onlineAudienceBizHolder.isValid()) {
            return this.onlineAudienceBizHolder.isCanShowSlideChannelGuide();
        }
        return false;
    }

    private boolean isLiveTaskInterceptExit() {
        if (CoreFactory.getCore(INewUserTaskInterceptCore.class) != null) {
            return ((INewUserTaskInterceptCore)CoreFactory.getCore(INewUserTaskInterceptCore.class)).canShowNewUserTaskPop();
        }
        return false;
    }

    private boolean isInterceptExit() {
        return ((IActiveUserCore)CoreFactory.getCore(IActiveUserCore.class)).allowPop();
    }

    private void leaveChannelDirect() {
        if (null != this.onlineAudienceBizHolder && this.onlineAudienceBizHolder.isValid()) {
            this.onlineAudienceBizHolder.leaveChannelDirect();
        } else {
            GameTplStatisticModel.instance().componentDestroyReport(this.getContext());
            if (this.checkActivityValid() && this.getActivity() != null) {
                this.getActivity().finish();
            }
            ChannelApi.Factory.get().leaveChannel();
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.mRootView != null) {
            this.onOrientationChanged(this.getActivity().getResources().getConfiguration().orientation == 2);
            if (CoreFactory.getCore(IMicAudienceCore.class) != null) {
                ((IMicAudienceCore)CoreFactory.getCore(IMicAudienceCore.class)).setOnlineAudienceCreateSuccessed(true);
            }
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        this.mExitViewPortrait.setVisibility(0);
    }

    public boolean onBackPressed() {
        boolean isAuditFailed = false;
        if (ChannelApi.Factory.get().getCurrentChannelInfo() != null) {
            isAuditFailed = ChannelApi.Factory.get().getCurrentChannelInfo().closeReasonDuetoAuditFailed();
        }
        if (!(isAuditFailed || this.isFullScreen || CommonPref.instance().getBoolean(SHARE_PREF_SLIDE_DOWN_CLOSE_GUIDE, false) || TextUtils.equals((CharSequence)ChannelApi.Factory.get().getBusinessId(), (CharSequence)"voiceroom"))) {
            RxBus.getDefault().post((Object)new IBasicFunctionClient_onSwipeSwitchTipNotify_EventArgs());
            return true;
        }
        return super.onBackPressed();
    }

    public void onPause() {
        super.onPause();
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        LiveBizComponentLinkProvider.INSTANCE.cancelCreateHolder(this);
        if (null != this.onlineAudienceBizHolder) {
            this.onlineAudienceBizHolder.unBindLifecycle(this.getLifecycle());
        }
        if (this.mAudienceListView != null) {
            this.mAudienceListView.removeAllViews();
            this.mAudienceListView = null;
        }
        if (this.mExitViewPortrait != null) {
            this.mExitViewPortrait.setOnClickListener(null);
        }
        if (this.mOtherBizLayout != null) {
            this.mOtherBizLayout.removeAllViews();
        }
        this.getHandler().removeCallbacks(this.hideTipsPopWindowRunnable);
        this.hideTipsPopWindow();
        this.tipsPopupWindow = null;
        ((IActiveUserCore)CoreFactory.getCore(IActiveUserCore.class)).updateIsAlreadyPopInCurChannel(false);
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    @BusEvent(busType=1, busName="Live")
    public void addAudienceListView(IMicAudienceClient_addAudienceListView_EventArgs busEventArgs) {
        View view = busEventArgs.mView;
        ((LiveRoomOnlineViewerLoadSampling)StatisticService.instance().get(LiveRoomOnlineViewerLoadSampling.class)).end();
        PerfSDK.instance().end(50021, "liveroom_online_viewer_load_timecost");
        if (view != null && this.mAudienceListView != null) {
            if (view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            this.mAudienceListView.removeAllViews();
            this.mAudienceListView.addView(view);
            this.mAudienceListView.setVisibility(0);
            this.mAudienceListView.setClipChildren(false);
            MLog.info((String)"NobleSeatController", (String)"addAudienceListView success !");
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void updateOtherBiz(UpdateViewEventArgs busEventArgs) {
        if (busEventArgs == null || busEventArgs.contentView == null) {
            return;
        }
        View view = busEventArgs.contentView;
        if (busEventArgs.type.equals(UpdateViewEventArgs.ADD_VIEW)) {
            if (view.getParent() == null) {
                MLog.info((String)TAG, (String)("add view from " + busEventArgs.from + "," + view));
                this.mOtherBizLayout.addView(view);
            }
        } else if (busEventArgs.type.equals(UpdateViewEventArgs.DEL_VIEW)) {
            MLog.info((String)TAG, (String)("remove view from " + busEventArgs.from + "," + view));
            this.mOtherBizLayout.removeView(view);
        }
    }

    @BusEvent
    public void channelMicStateisOpen(IChannelMicStateClient_channelMicStateisOpen_EventArgs busEventArgs) {
        ChannelInfo info = busEventArgs.getInfo();
        if (this.enableShowMicDot && LoginUtil.isLogined() && this.mMicDotImg != null && info.channelMode != ChannelInfo.ChannelMode.Free_Mode && info.channelMode != ChannelInfo.ChannelMode.ADMIN_Mode) {
            this.mMicDotImg.setVisibility(0);
        }
    }

    @BusEvent
    public void channelMicStateisColse(IChannelMicStateClient_channelMicStateisColse_EventArgs busEventArgs) {
        ChannelInfo info = busEventArgs.getChannelInfo();
        if (this.enableShowMicDot && LoginUtil.isLogined() && this.mMicDotImg != null && info.channelMode != ChannelInfo.ChannelMode.Free_Mode && info.channelMode != ChannelInfo.ChannelMode.ADMIN_Mode) {
            this.mMicDotImg.setVisibility(8);
        }
    }

    @BusEvent
    public void updateCurrentChannelInfo(IChannelLinkClient_updateCurrentChannelInfo_EventArgs busEventArgs) {
        ChannelInfo info = busEventArgs.getChannelInfo();
        if (this.enableShowMicDot && info != null && (info.channelMode == ChannelInfo.ChannelMode.Free_Mode || info.channelMode == ChannelInfo.ChannelMode.ADMIN_Mode) && this.mMicDotImg != null) {
            this.mMicDotImg.setVisibility(8);
        }
        this.showProgramInfoComponent();
    }

    @BusEvent
    public void onChatInputSwitch(IChatEmotionClient_onChatInputSwitch_EventArgs busEventArgs) {
        boolean chatInputSwitch = busEventArgs.getChatInputSwitch();
        if (chatInputSwitch) {
            this.hideSelf();
        } else {
            this.showSelf();
        }
    }

    @BusEvent
    public void notifyAnchorImMediateOPlayer(IMicClient_notifyAnchorImMediateOPlayer_EventArgs busEventArgs) {
        String msg = busEventArgs.getMsg();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("notifyAnchorImMediateOPlayer msg =" + msg));
        }
        if (!TextUtils.isEmpty((CharSequence)msg) && this.checkActivityValid() && this.isResumed()) {
            this.showTipsPopWindow(msg);
        }
    }

    private void showTipsPopWindow(String tips) {
        if (this.mMicImg == null || !this.checkActivityValid()) {
            return;
        }
        if (this.tipsPopupWindow != null && this.tipsPopupWindow.isShowing()) {
            this.tipsPopupWindow.dismiss();
            this.tipsPopupWindow = null;
        }
        if (this.getActivity() == null) {
            return;
        }
        this.getHandler().removeCallbacks(this.hideTipsPopWindowRunnable);
        this.tipsPopupWindow = new TipsPopupWindow((Context)this.getActivity(), tips);
        this.tipsPopupWindow.setText(tips);
        this.tipsPopupWindow.showAsDropDown((View)this.mMicImg);
        this.getHandler().postDelayed(this.hideTipsPopWindowRunnable, 3000L);
    }

    private void hideTipsPopWindow() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.tipsPopupWindow != null) {
            if (this.tipsPopupWindow.isShowing()) {
                this.tipsPopupWindow.dismiss();
            }
            this.tipsPopupWindow = null;
        }
    }

    public void setExitOnClickListener(View.OnClickListener exitOnClickListener) {
        if (this.mExitViewPortrait != null) {
            this.mExitViewPortrait.setOnClickListener(exitOnClickListener);
        }
    }

    private DialogLinkManager getLinkDialogManager() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(this.getContext());
        }
        return this.mDialogLinkManager;
    }

    @BusEvent
    public void onNoVideoStreamNotify(NoVideoStreamEvent event) {
        MLog.info((String)TAG, (String)"onNoVideoStreamNotify:");
    }

    @BusEvent
    public void hasVideoStreamNotify(HasVideoStreamEvent event) {
        MLog.info((String)TAG, (String)("hasVideoStreamNotify called with: event = [" + event + "]"));
    }

    @Override
    public void onDefaultHolderCreated(@NonNull IOnlineAudienceBizHolder holder) {
        this.onlineAudienceBizHolder = holder;
    }

    @Override
    public void onHolderCreated(@NotNull IOnlineAudienceBizHolder holder) {
        this.onlineAudienceBizHolder = holder;
        holder.bindLifecycle(this.getActivity(), this.getLifecycle());
    }

    @Override
    public Class<IOnlineAudienceBizHolder> getHolderClass() {
        return IOnlineAudienceBizHolder.class;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new OnlineAudienceComponent$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

