/*
 * Decompiled with CFR 0.152.
 */
package com.yy.datacenter;

import android.util.Log;
import androidx.annotation.NonNull;
import com.yy.datacenter.BasicChannelInfo;
import com.yy.datacenter.reduce.LiveRoomDataState_CameraFocusEnableReduce;
import com.yy.datacenter.reduce.LiveRoomDataState_CurrentAnchorUidReduce;
import com.yy.datacenter.reduce.LiveRoomDataState_CurrentBasicChannelInfoReduce;
import com.yy.datacenter.reduce.LiveRoomDataState_CurrentOwUidReduce;
import com.yy.datacenter.reduce.LiveRoomDataState_CurrentRunningPluginIdReduce;
import com.yy.datacenter.reduce.LiveRoomDataState_CurrentSocialOwnerUidReduce;
import com.yy.datacenter.reduce.LiveRoomDataState_CurrentTemplateIdReduce;
import com.yy.datacenter.reduce.LiveRoomDataState_CurrentVoiceRoomOwnerUidReduce;
import com.yy.datacenter.reduce.LiveRoomDataState_NoFaceEnableReduce;
import com.yy.datacenter.reduce.LiveRoomDataState_UnderCoverStartReduce;
import com.yy.datacenter.reduce.LiveRoomDataState_VoiceChangerEnableReduce;
import com.yy.mobile.model.Reducer;
import com.yy.mobile.model.StateAction;
import com.yy.mobile.model.store.State;
import java.util.ArrayList;
import java.util.List;

public final class LiveRoomDataState
extends State {
    private static final String TAG = "LiveRoomDataState";
    private final long mCurrentAnchorUid;
    private final long mCurrentOwUid;
    private final String mCurrentTemplateId;
    private final BasicChannelInfo mCurrentBasicChannelInfo;
    private final long mCurrentVoiceRoomOwnerUid;
    private final long mCurrentSocialOwnerUid;
    private final boolean mNoFaceEnable;
    private final boolean mVoiceChangerEnable;
    private final String mCurrentRunningPluginId;
    private final boolean mCameraFocusEnable;
    private final boolean mUnderCoverStart;

    private LiveRoomDataState(Builder builder) {
        super((State.Builder)builder);
        this.mCurrentAnchorUid = builder.mCurrentAnchorUid;
        this.mCurrentOwUid = builder.mCurrentOwUid;
        this.mCurrentTemplateId = builder.mCurrentTemplateId;
        this.mCurrentBasicChannelInfo = builder.mCurrentBasicChannelInfo;
        this.mCurrentVoiceRoomOwnerUid = builder.mCurrentVoiceRoomOwnerUid;
        this.mCurrentSocialOwnerUid = builder.mCurrentSocialOwnerUid;
        this.mNoFaceEnable = builder.mNoFaceEnable;
        this.mVoiceChangerEnable = builder.mVoiceChangerEnable;
        this.mCurrentRunningPluginId = builder.mCurrentRunningPluginId;
        this.mCameraFocusEnable = builder.mCameraFocusEnable;
        this.mUnderCoverStart = builder.mUnderCoverStart;
    }

    public long getCurrentAnchorUid() {
        return this.mCurrentAnchorUid;
    }

    public long getCurrentOwUid() {
        return this.mCurrentOwUid;
    }

    public String getCurrentTemplateId() {
        if (this.mCurrentTemplateId == null) {
            Log.d((String)TAG, (String)"getCurrentTemplateId will return null.");
        }
        return this.mCurrentTemplateId;
    }

    public BasicChannelInfo getCurrentBasicChannelInfo() {
        if (this.mCurrentBasicChannelInfo == null) {
            Log.d((String)TAG, (String)"getCurrentBasicChannelInfo will return null.");
        }
        return this.mCurrentBasicChannelInfo;
    }

    public long getCurrentVoiceRoomOwnerUid() {
        return this.mCurrentVoiceRoomOwnerUid;
    }

    public long getCurrentSocialOwnerUid() {
        return this.mCurrentSocialOwnerUid;
    }

    public boolean isNoFaceEnable() {
        return this.mNoFaceEnable;
    }

    public boolean isVoiceChangerEnable() {
        return this.mVoiceChangerEnable;
    }

    public String getCurrentRunningPluginId() {
        if (this.mCurrentRunningPluginId == null) {
            Log.d((String)TAG, (String)"getCurrentRunningPluginId will return null.");
        }
        return this.mCurrentRunningPluginId;
    }

    public boolean isCameraFocusEnable() {
        return this.mCameraFocusEnable;
    }

    public boolean isUnderCoverStart() {
        return this.mUnderCoverStart;
    }

    static List<Reducer<LiveRoomDataState, ? extends StateAction>> getReduceList() {
        ArrayList<Reducer<LiveRoomDataState, ? extends StateAction>> reduceList = new ArrayList<Reducer<LiveRoomDataState, ? extends StateAction>>();
        reduceList.add(new LiveRoomDataState_CurrentAnchorUidReduce());
        reduceList.add(new LiveRoomDataState_CurrentOwUidReduce());
        reduceList.add(new LiveRoomDataState_CurrentTemplateIdReduce());
        reduceList.add(new LiveRoomDataState_CurrentBasicChannelInfoReduce());
        reduceList.add(new LiveRoomDataState_CurrentVoiceRoomOwnerUidReduce());
        reduceList.add(new LiveRoomDataState_CurrentSocialOwnerUidReduce());
        reduceList.add(new LiveRoomDataState_NoFaceEnableReduce());
        reduceList.add(new LiveRoomDataState_VoiceChangerEnableReduce());
        reduceList.add(new LiveRoomDataState_CurrentRunningPluginIdReduce());
        reduceList.add(new LiveRoomDataState_CameraFocusEnableReduce());
        reduceList.add(new LiveRoomDataState_UnderCoverStartReduce());
        return reduceList;
    }

    public static final class Builder
    extends State.Builder<LiveRoomDataState> {
        private long mCurrentAnchorUid;
        private long mCurrentOwUid;
        private String mCurrentTemplateId;
        private BasicChannelInfo mCurrentBasicChannelInfo;
        private long mCurrentVoiceRoomOwnerUid;
        private long mCurrentSocialOwnerUid;
        private boolean mNoFaceEnable;
        private boolean mVoiceChangerEnable;
        private String mCurrentRunningPluginId;
        private boolean mCameraFocusEnable;
        private boolean mUnderCoverStart;

        public Builder() {
            this(null);
        }

        public Builder(LiveRoomDataState originalState) {
            if (originalState == null) {
                return;
            }
            this.mCurrentAnchorUid = originalState.mCurrentAnchorUid;
            this.mCurrentOwUid = originalState.mCurrentOwUid;
            this.mCurrentTemplateId = originalState.mCurrentTemplateId;
            this.mCurrentBasicChannelInfo = originalState.mCurrentBasicChannelInfo;
            this.mCurrentVoiceRoomOwnerUid = originalState.mCurrentVoiceRoomOwnerUid;
            this.mCurrentSocialOwnerUid = originalState.mCurrentSocialOwnerUid;
            this.mNoFaceEnable = originalState.mNoFaceEnable;
            this.mVoiceChangerEnable = originalState.mVoiceChangerEnable;
            this.mCurrentRunningPluginId = originalState.mCurrentRunningPluginId;
            this.mCameraFocusEnable = originalState.mCameraFocusEnable;
            this.mUnderCoverStart = originalState.mUnderCoverStart;
        }

        public Builder setCurrentAnchorUid(long mCurrentAnchorUid) {
            this.mCurrentAnchorUid = mCurrentAnchorUid;
            return this;
        }

        public Builder setCurrentOwUid(long mCurrentOwUid) {
            this.mCurrentOwUid = mCurrentOwUid;
            return this;
        }

        public Builder setCurrentTemplateId(String mCurrentTemplateId) {
            this.mCurrentTemplateId = mCurrentTemplateId;
            return this;
        }

        public Builder setCurrentBasicChannelInfo(BasicChannelInfo mCurrentBasicChannelInfo) {
            this.mCurrentBasicChannelInfo = mCurrentBasicChannelInfo;
            return this;
        }

        public Builder setCurrentVoiceRoomOwnerUid(long mCurrentVoiceRoomOwnerUid) {
            this.mCurrentVoiceRoomOwnerUid = mCurrentVoiceRoomOwnerUid;
            return this;
        }

        public Builder setCurrentSocialOwnerUid(long mCurrentSocialOwnerUid) {
            this.mCurrentSocialOwnerUid = mCurrentSocialOwnerUid;
            return this;
        }

        public Builder setNoFaceEnable(boolean mNoFaceEnable) {
            this.mNoFaceEnable = mNoFaceEnable;
            return this;
        }

        public Builder setVoiceChangerEnable(boolean mVoiceChangerEnable) {
            this.mVoiceChangerEnable = mVoiceChangerEnable;
            return this;
        }

        public Builder setCurrentRunningPluginId(String mCurrentRunningPluginId) {
            this.mCurrentRunningPluginId = mCurrentRunningPluginId;
            return this;
        }

        public Builder setCameraFocusEnable(boolean mCameraFocusEnable) {
            this.mCameraFocusEnable = mCameraFocusEnable;
            return this;
        }

        public Builder setUnderCoverStart(boolean mUnderCoverStart) {
            this.mUnderCoverStart = mUnderCoverStart;
            return this;
        }

        @NonNull
        public LiveRoomDataState build() {
            return new LiveRoomDataState(this);
        }
    }
}

