/*
 * Decompiled with CFR 0.152.
 */
package com.yy.datacenter;

import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.datacenter.BasicChannelInfo;
import com.yy.datacenter.LiveRoomDataCenter;
import com.yy.datacenter.LiveRoomDataCenterProcessor$$EventBinder;
import com.yy.datacenter.LiveRoomDataState;
import com.yy.datacenter.action.LiveRoomDataState_CurrentAnchorUidAction;
import com.yy.datacenter.action.LiveRoomDataState_CurrentBasicChannelInfoAction;
import com.yy.datacenter.action.LiveRoomDataState_CurrentOwUidAction;
import com.yy.mobile.baseapi.model.store.YYState;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.baseapi.model.store.action.YYState_LastLiveAnchorUidAction;
import com.yy.mobile.model.Action;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelInfo_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.streamcompat.VideoStreamArriveCompatEvent;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.media.IMediaCoreForAudience;

public enum LiveRoomDataCenterProcessor implements EventCompat
{
    INSTANCE;

    private static final String TAG = "LiveRoomDataCenterProcessor";
    private EventBinder mEventBinder;

    private LiveRoomDataCenterProcessor() {
        this.onEventBind();
    }

    public void onEventBind() {
        if (this.mEventBinder == null) {
            this.mEventBinder = new LiveRoomDataCenterProcessor$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    public void init() {
    }

    @BusEvent
    public void updateCurrentChannelMicQueue(IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs event) {
        long newTopUid = event.getNewTopUid();
        MLog.info((String)TAG, (String)("updateCurrentChannelMicQueue  newTopUid = " + newTopUid));
        if (newTopUid == 0L && this.getUidFromVideoStream() != 0L) {
            return;
        }
        this.setCurrentAnchorUid(newTopUid);
    }

    @BusEvent(busType=1, busName="FlowRxBus")
    public void onMediaVideoArrive(VideoStreamArriveCompatEvent event) {
        if (((YYState)YYStore.INSTANCE.getState()).getChannelState() == ChannelState.No_Channel) {
            MLog.info((String)TAG, (String)"onMediaArrive not in channel return");
            return;
        }
        if (((LiveRoomDataState)LiveRoomDataCenter.INSTANCE.getState()).getCurrentAnchorUid() != 0L) {
            MLog.info((String)TAG, (String)"uid is not 0 return ");
            return;
        }
        long anchorUid = this.getUidFromVideoStream();
        if (anchorUid != 0L) {
            MLog.info((String)TAG, (String)"dispatch anchor uid from arrived video");
            this.setCurrentAnchorUid(anchorUid);
        }
    }

    private long getUidFromVideoStream() {
        IMediaCoreForAudience core = (IMediaCoreForAudience)CoreFactory.getCore(IMediaCoreForAudience.class);
        if (core != null && core.getStreamListSize() > 0) {
            return core.getVideoStreamUid();
        }
        return 0L;
    }

    @BusEvent
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs event) {
        MLog.info((Object)TAG, (String)"onJoinChannelSuccess channelId = %s, ow = %dinfo.topASid = %d, info.topSid = %d, info.subSid = %d", (Object[])new Object[]{event.getInfo().getId(), event.getInfo().sitOwner, event.getInfo().topASid, event.getInfo().topSid, event.getInfo().subSid});
        ChannelInfo info = event.getInfo();
        if (info == null) {
            MLog.error((String)TAG, (String)"onJoinChannelSuccess event channel info is null");
            return;
        }
        LiveRoomDataCenter.INSTANCE.dispatch((Action)new LiveRoomDataState_CurrentBasicChannelInfoAction(new BasicChannelInfo(info.topASid, info.topSid, info.subSid)));
        if (event.getInfo().sitOwner != 0L) {
            LiveRoomDataCenter.INSTANCE.dispatch((Action)new LiveRoomDataState_CurrentOwUidAction(event.getInfo().sitOwner));
        }
    }

    @BusEvent
    public void updateCurrentChannelInfo(IChannelLinkClient_updateCurrentChannelInfo_EventArgs event) {
        ChannelInfo info = event.getChannelInfo();
        if (info == null) {
            MLog.error((String)TAG, (String)"updateCurrentChannelInfo event channel info is null");
            return;
        }
        MLog.info((Object)TAG, (String)"updateCurrentChannelInfo channelId = %s, ow = %d ,info.topASid = %d, info.topSid = %d, info.subSid = %d", (Object[])new Object[]{info.getId(), info.sitOwner, info.topASid, info.topSid, info.subSid});
        LiveRoomDataCenter.INSTANCE.dispatch((Action)new LiveRoomDataState_CurrentBasicChannelInfoAction(new BasicChannelInfo(info.topASid, info.topSid, info.subSid)));
        if (info.sitOwner != 0L) {
            LiveRoomDataCenter.INSTANCE.dispatch((Action)new LiveRoomDataState_CurrentOwUidAction(event.getChannelInfo().sitOwner));
            YYStore.INSTANCE.dispatch((Action)new YYState_LastLiveAnchorUidAction(event.getChannelInfo().sitOwner));
        }
    }

    @BusEvent
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs event) {
        MLog.info((Object)TAG, (String)"onLeaveChannel id = %s", (Object[])new Object[]{event.getInfo().getId()});
        LiveRoomDataCenter.INSTANCE.dispatch((Action)new LiveRoomDataState_CurrentBasicChannelInfoAction(new BasicChannelInfo(0L, 0L, 0L)));
        LiveRoomDataCenter.INSTANCE.dispatch((Action)new LiveRoomDataState_CurrentAnchorUidAction(0L));
        LiveRoomDataCenter.INSTANCE.dispatch((Action)new LiveRoomDataState_CurrentOwUidAction(0L));
    }

    private void setCurrentAnchorUid(long newUid) {
        long lastAnchorUid = ((LiveRoomDataState)LiveRoomDataCenter.INSTANCE.getState()).getCurrentAnchorUid();
        if (lastAnchorUid == newUid) {
            return;
        }
        MLog.info((Object)TAG, (String)"dispatch current anchorUid = %d", (Object[])new Object[]{newUid});
        LiveRoomDataCenter.INSTANCE.dispatch((Action)new LiveRoomDataState_CurrentAnchorUidAction(newUid));
    }
}

