/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.main.kinds;

import com.duowan.mobile.main.kinds.Kind;
import com.duowan.mobile.main.kinds.KindHouse;
import com.duowan.mobile.main.kinds.KindStorage;
import com.duowan.mobile.main.kinds.KindSyringeService;
import com.duowan.mobile.main.kinds.KindsFactory;
import com.duowan.mobile.main.kinds.wrapper.KindWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class KindsImpl {
    private final KindStorage mStorage;
    private final KindsFactory mFactory;
    private final ConcurrentHashMap<Class<? extends Kind>, KindWrapper> mFeatures = new ConcurrentHashMap();
    private KindSyringeService mSyringeService;

    public KindsImpl(KindStorage storage, KindsFactory factory) {
        this.mStorage = storage;
        this.mFactory = factory;
        this.mSyringeService = new KindSyringeService();
        this.mSyringeService.init();
    }

    public <T extends Kind> T of(Class<T> clz) {
        return (T)this.wrapper(clz).instance();
    }

    public <T extends Kind> KindWrapper<T, ?> wrapper(Class<T> clz) {
        KindWrapper<T, ?> kindWrapper = this.mFeatures.get(clz);
        if (kindWrapper == null) {
            kindWrapper = this.create(clz);
            if (kindWrapper == null) {
                throw new RuntimeException("Kind is not used properly, type:" + clz.getSimpleName());
            }
            this.mFeatures.put(clz, kindWrapper);
        }
        return kindWrapper;
    }

    private <T extends Kind> KindWrapper<T, ?> create(Class<T> clz) {
        return this.mFactory.create(clz, this.mStorage);
    }

    public KindWrapper wrapper(String key) {
        return this.wrapper(this.mFactory.map(key));
    }

    private Set<Class<? extends Kind>> featureClasses() {
        return this.mFactory.featureClasses();
    }

    public boolean addFeatureMap(String moudleName) {
        return this.mSyringeService.inject(moudleName, KindHouse.mFeatureClzs, KindHouse.mFeatureWrappers);
    }

    public List<KindWrapper> getFeaturesWrapper() {
        ArrayList<KindWrapper> result = new ArrayList<KindWrapper>();
        Set<Class<? extends Kind>> featureClasses = this.featureClasses();
        if (featureClasses != null && !featureClasses.isEmpty()) {
            for (Class<? extends Kind> featureClass : featureClasses) {
                result.add(this.wrapper(featureClass));
            }
        }
        return result;
    }
}

