/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.main.kinds;

import com.duowan.mobile.main.kinds.IKindInject;
import com.duowan.mobile.main.kinds.LruCache;
import java.util.ArrayList;
import java.util.List;

public class KindInjectUtil
implements IKindInject {
    private static final KindInjectUtil mInstance = new KindInjectUtil();
    private LruCache<String, IKindInject> classCache = new LruCache(66);
    private List<String> blackList = new ArrayList<String>();

    private KindInjectUtil() {
    }

    public static KindInjectUtil getInstance() {
        return mInstance;
    }

    @Override
    public void inject(Object target) {
        this.injectInner(target);
    }

    private void injectInner(Object target) {
        Class<?> clazz = target.getClass();
        do {
            String className = clazz.getName();
            try {
                if (this.blackList.contains(className)) continue;
                IKindInject kindInject = this.classCache.get(className);
                if (null == kindInject) {
                    kindInject = (IKindInject)Class.forName(className + "$$Inject").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                kindInject.inject(target);
                this.classCache.put(className, kindInject);
            }
            catch (Exception e) {
                this.blackList.add(className);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
    }
}

