package com.duowan.mobile.main.kinds.wrapper

import com.duowan.mobile.main.kinds.Kind
import com.duowan.mobile.main.kinds.KindInjectUtil
import com.duowan.mobile.main.kinds.KindStorage
import java.util.HashMap

/**
 * 有不规则值的Feature，如[IntKindValue], [StringKindValue]
 *
 * @param <T>
</T> */
abstract class MixedKindWrapper<T : Kind, TYPE>(
    storage: KindStorage, storageKey: String,
    dfValue: TYPE, clz: Class<T>, private val mValueCount: Int,
    alias: String, group: String
) : AbstractKindWrapper<T, TYPE>(storage, storageKey, dfValue, alias, group) {
    protected val mIndexMap: MutableMap<TYPE, Int>
    private val mInstance: kotlin.Array<Kind?> = arrayOfNulls(mValueCount)
    private val mImplClasses: kotlin.Array<Class<out T>?> = arrayOfNulls(mValueCount)

    private var _allFeaturesInstance: MutableList<Kind>? = null
    override val allFeaturesInstance: List<Kind>
        get() {
            if (_allFeaturesInstance == null) {
                _allFeaturesInstance = mutableListOf()
                for (i in 0 until mValueCount) {
                    if (mInstance[i] != null) {
                        _allFeaturesInstance!!.add(mInstance[i]!!)
                    } else {
                        _allFeaturesInstance!!.add(createInstance(i)!!)
                    }
                }
            }

            return _allFeaturesInstance ?: throw AssertionError("Set to null by another thread")
        }

    init {
        mIndexMap = HashMap()
        initializeIndex()
    }

    override fun instance(): T {
        if (mIndexMap.isEmpty()) {
            throw RuntimeException("if you change param [value] of @KindsItemTest " +
                "or @StringKindValue or @StringKindValue, " + "please clean your app data!")
        }

        val value = storageValue()
        val index: Int?
        index = if (mIndexMap.containsKey(value)) {
            mIndexMap[value]
        } else {
            mIndexMap[mDefaultValue]
        }
        return instanceOfIndex(index!!)
    }

    private fun instanceOfIndex(index: Int): T {
        if (mInstance[index] == null) {
            mInstance[index] = createInstance(index)
            injectParam(mInstance[index]!!) //参数注入
        }

        return mInstance[index] as T
    }

    private fun injectParam(`object`: Any) {
        KindInjectUtil.instance.inject(`object`)
    }

    private fun createInstance(index: Int): T? {
        val clz = mImplClasses[index]
        return try {
            clz?.newInstance()
        } catch (e: Exception) {
            null
        }
    }

    /**
     * map value to index of instance array.
     *
     * @param value
     * @param index
     */
    protected fun mapIndex(value: TYPE, index: Int, implClass: Class<out T>) {
        mIndexMap[value] = index
        mImplClasses[index] = implClass
    }

    override fun store(value: TYPE) {
        val oldValue = storageValue()
        if (value == oldValue) {
            return
        }

        val ketSet = mIndexMap.keys
        if (ketSet.isEmpty()) {
            //key-value feature
            storeValue(value)
        } else {
            //optional feature
            for (v in mIndexMap.keys) {
                if (v == value) {
                    storeValue(value)
                }
            }
        }
    }

    override fun storeInstance(instance: T) {
        var index = 0
        while (index < mValueCount) {
            if (mInstance[index] === instance) {
                break
            }
            index++
        }

        if (index >= mValueCount) {
            return
        }

        for ((key, value) in mIndexMap) {
            if (value == index) {
                store(key)
                break
            }
        }
    }

    protected abstract fun initializeIndex()

    /**
     * Store value persistent.
     *
     * @param value
     */
    protected abstract fun storeValue(value: TYPE)

    override fun getValueByIndex(index: Int): TYPE {
        for ((key, value) in mIndexMap) {
            if (index == value) {
                return key
            }
        }
        throw RuntimeException("if you change param [value] of @KindsItemTest " +
            "or @StringKindValue or @StringKindValue, " + "please clean your app data!")
    }
}