package com.duowan.mobile.main.kinds.wrapper

import com.duowan.mobile.main.kinds.Kind
import com.duowan.mobile.main.kinds.KindStorage

/**
 * @param <T>
</T> */
abstract class LayerKindWrapper<T : Kind>(
    storage: KindStorage, storageKey: String,
    dfValue: Int, clz: Class<T>, valueCount: Int,
    alias: String, group: String, private val mParamId: String
) : MixedKindWrapper<T, Int>(storage, storageKey, dfValue, clz, valueCount, alias, group) {

    override fun storageValue(): Int {
        return mStorage.getInt(storageKey(), mDefaultValue, mParamId)
    }

    override fun storeValue(value: Int) {
        mStorage.putInt(storageKey(), value)
    }

    override fun type(): Class<*> {
        return Integer.TYPE
    }
}