package com.duowan.mobile.main.kinds.wrapper

import com.duowan.mobile.main.kinds.Kind

/**
 * Wrapper class that provide interfaces of a specified feature.
 *
 * @param <T>
 * @param <TYPE>
</TYPE></T> */
interface KindWrapper<T : Kind, TYPE> {

    /**
     * get instance of all features
     *
     * @return
     */
    val allFeaturesInstance: List<Kind>

    /**
     * Get instance of current feature value.
     *
     * @return
     */
    fun instance(): T

    fun storageKey(): String

    /**
     * Read persistent value.
     *
     * @return
     */
    fun storageValue(): TYPE

    /**
     * Store persistent value.
     *
     * @param value
     */
    fun store(value: TYPE)

    /**
     * Store persistent value specified by instance.
     *
     * @param instance
     */
    fun storeInstance(instance: T)

    /**
     * Value type.
     *
     * @return
     */
    fun type(): Class<*>

    /**
     * Alias of feature.
     *
     * @return
     */
    fun alias(): String

    /**
     * Default is true in debug build mode. Only valid for boolean features.
     *
     * @return
     */
    fun enableForDebug(): Boolean

    /**
     * group of features
     *
     * @return
     */
    fun group(): String

    fun getValueByIndex(index: Int): TYPE
}