package com.duowan.mobile.main.kinds.wrapper

import com.duowan.mobile.main.kinds.Kind
import com.duowan.mobile.main.kinds.KindStorage

abstract class BooleanKindWrapper<T : Kind> @JvmOverloads constructor(
    storage: KindStorage, storageKey: String,
    dfValue: Boolean, clz: Class<T>,
    alias: String, group: String, private val mEnableDebug: Boolean = false
) : AbstractKindWrapper<T, Boolean>(storage, storageKey, dfValue, alias, group) {
    private val mInstance: kotlin.Array<Kind?> = arrayOfNulls(2)

    private var _allFeaturesInstance: MutableList<Kind>? = null
    override val allFeaturesInstance: List<Kind>
        get() {
            if (_allFeaturesInstance == null) {
                _allFeaturesInstance = mutableListOf()
                _allFeaturesInstance!!.add(instanceOfValue(true))
                _allFeaturesInstance!!.add(instanceOfValue(false))
            }
            return _allFeaturesInstance ?: throw AssertionError("Set to null by another thread")
        }

    override fun instance(): T {
        val value = storageValue()
        return instanceOfValue(value)
    }

    private fun instanceOfValue(value: Boolean): T {
        val index = if (value) 1 else 0
        if (mInstance[index] == null) {
            mInstance[index] = createInstance(value)
        }

        return mInstance[index] as T
    }

    override fun type(): Class<*> {
        return java.lang.Boolean.TYPE
    }

    override fun storageValue(): Boolean {
        return mEnableDebug && mStorage.isDebug || mStorage.getBoolean(storageKey(), mDefaultValue)
    }

    override fun store(value: Boolean) {
        val old = storageValue()
        if (old != value) {
            mStorage.putBoolean(storageKey(), value!!)
        }
    }

    fun store(value: Int?) {
        store(value != 0)
    }

    override fun storeInstance(instance: T) {
        if (instance === mInstance[0]) {
            store(true)
        } else if (instance === mInstance[1]) {
            store(false)
        }
    }

    override fun enableForDebug(): Boolean {
        return mEnableDebug
    }

    protected abstract fun createInstance(value: Boolean): T

    override fun getValueByIndex(index: Int): Boolean {
        if (index < 0) {
            throw RuntimeException("index must not small 0")
        }
        return index == 0
    }
}
