package com.duowan.mobile.main.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 实验组抽象类的注解
 * demo:
 *
 * @KindsLayer( layerId = "kinds_test1",name = "abTest sdk用例实验1",defaultTest = 0 )
 * abstract class IAbTestUserCaseTest1 : Kind {
 *      abstract fun getText(): String
 * }
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.CLASS)
@Inherited
@ValueSetting(KindsItemTest.class)
public @interface KindsLayer {
    /**
     * 该组实验的LayerId
     */
    String layerId();

    /**
     * 该组实验的名称
     */
    String name() default "";

    /**
     * 该组实验默认的实验方案的id
     */
    int defaultTest();

    /**
     * 实验分组的参数id，实验分发时，根据该参数指定的paramId进行分发，默认值为action
     */
    String paramId() default "action";
}