package com.duowan.mobile.main.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 具体实验类的注解
 * demo：
 *
 * @KindsItemTest(0)
 * class AbTestUserCaseTest1_0 : IAbTestUserCaseTest1() {
 *     override fun getText(): String {
 *         return "默认"
 *     }
 *
 *     override fun getName(): String {
 *         return "对照组"
 *     }
 * }
 *
 * @KindsItemTest(1)
 * class AbTestUserCaseTest1_1 : IAbTestUserCaseTest1() {
 *     override fun getText(): String {
 *         return "早上"
 *     }
 *
 *     override fun getName(): String {
 *         return "实验组"
 *     }
 * }
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.CLASS)
public @interface KindsItemTest {
    /**
     * 该实验所对应的参数值
     */
    int value();

    /**
     * 实验的名称
     */
    String name() default "";
}