/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.kindsActivity.proxy;

import android.content.Context;
import com.duowan.kindsActivity.bean.GroupEntity;
import com.duowan.kindsActivity.bean.LayerEntity;
import com.duowan.kindsActivity.bean.ParamEntity;
import com.duowan.kindsActivity.sqlite.DBManager;
import com.duowan.kindsActivity.util.NewSettingStorageUtil;
import com.duowan.mobile.main.kinds.Logger;
import com.yy.abtest.config.ExptConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.json.JSONObject;

class YYABTestClientProxy
implements InvocationHandler {
    private Object target;
    private Context mContext;
    private static final String TAG = "YYABTestClientProxy";
    private DBManager mDBManager;

    public YYABTestClientProxy(Object object, Context context) {
        this.target = object;
        this.mContext = context;
        this.mDBManager = DBManager.getInstance(this.mContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!"getExperiment".equals(method.getName()) || !NewSettingStorageUtil.INSTANCE.isCustomValueWithKey((String)args[0])) return method.invoke(this.target, args);
        LayerEntity layerEntity = this.mDBManager.queryLayer((String)args[0]);
        if (layerEntity == null) return method.invoke(this.target, args);
        Logger.INSTANCE.i(TAG, "LayerEntity = " + layerEntity.toString());
        int groupIndex = layerEntity.getCurrentGroup();
        if (groupIndex <= 0) return method.invoke(this.target, args);
        GroupEntity entity = this.mDBManager.queryGroup(layerEntity.getCurrentGroup());
        Logger.INSTANCE.i(TAG, "GroupEntity = " + entity.toString());
        if (entity.getTestId() <= 0) return method.invoke(this.target, args);
        List<ParamEntity> paramEntities = entity.getParams();
        JSONObject object = new JSONObject();
        for (ParamEntity param : paramEntities) {
            object.put(param.getCode(), (Object)param.getValue());
        }
        Logger.INSTANCE.i(TAG, "ParamEntity = " + object.toString());
        return new ExptConfig(layerEntity.getLayerId(), String.valueOf(entity.getTestId()), object);
    }
}

