/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.kindsActivity.sqlite;

import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.duowan.mobile.main.kinds.Logger;

public class DatabaseHelper
extends SQLiteOpenHelper {
    private static final int DATABASE_VERSION = 1;
    private static final String DATABASE_NAME = "abtest.db";
    private static final String TAG = "DatabaseHelper";
    public static final String LAYER_TABLE_NAME = "ab_layer";
    public static final String GROUP_TABLE_NAME = "ab_group";
    public static final String PARAM_TABLE_NAME = "ab_param";

    public DatabaseHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, DatabaseErrorHandler errorHandler) {
        super(context, name, factory, version, errorHandler);
    }

    public DatabaseHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    public DatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 1);
    }

    public void onCreate(SQLiteDatabase db) {
        Logger.INSTANCE.i(TAG, "DatabaseHelper onCreate");
        StringBuffer layerTable = new StringBuffer();
        layerTable.append("CREATE TABLE [ab_layer] (");
        layerTable.append("[layer_id] TEXT NOT NULL PRIMARY KEY , ");
        layerTable.append("[layer_name] TEXT , ");
        layerTable.append("[testId] INTEGER)");
        db.execSQL(layerTable.toString());
        StringBuffer groupTable = new StringBuffer();
        groupTable.append("CREATE TABLE [ab_group] (");
        groupTable.append("[testId] INTEGER NOT NULL PRIMARY KEY, ");
        groupTable.append("[name] TEXT,");
        groupTable.append("[layer_id] TEXT,");
        groupTable.append("FOREIGN KEY (layer_id) REFERENCES ab_layer (layer_id))");
        db.execSQL(groupTable.toString());
        StringBuffer paramTable = new StringBuffer();
        paramTable.append("CREATE TABLE [ab_param] (");
        paramTable.append("[_id] INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, ");
        paramTable.append("[expermentId] INTEGER,");
        paramTable.append("[code] TEXT,");
        paramTable.append("[val] TEXT,");
        paramTable.append("[testId] INTEGER,");
        paramTable.append("FOREIGN KEY (testId) REFERENCES ab_group (testId))");
        db.execSQL(paramTable.toString());
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion != newVersion) {
            Logger.INSTANCE.i(TAG, "DatabaseHelper onUpgrade");
            db.execSQL("DROP TABLE IF EXISTS ab_param");
            db.execSQL("DROP TABLE IF EXISTS ab_group");
            db.execSQL("DROP TABLE IF EXISTS ab_layer");
            this.onCreate(db);
        }
    }

    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
        Log.d((String)TAG, (String)"DatabaseHelper onOpen");
        if (!db.isReadOnly()) {
            db.execSQL("PRAGMA foreign_keys=ON;");
        }
    }
}

