/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.kindsActivity.sqlite;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.duowan.kindsActivity.bean.GroupEntity;
import com.duowan.kindsActivity.bean.LayerEntity;
import com.duowan.kindsActivity.bean.ParamEntity;
import com.duowan.kindsActivity.sqlite.DatabaseHelper;
import com.duowan.mobile.main.kinds.Logger;
import java.util.ArrayList;
import java.util.List;

public class DBManager {
    private DatabaseHelper helper;
    private SQLiteDatabase db;
    private static final String TAG = "DatabaseHelper";
    private static DBManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBManager getInstance(Context context) {
        if (instance != null) return instance;
        Class<DBManager> clazz = DBManager.class;
        synchronized (DBManager.class) {
            if (instance != null) return instance;
            instance = new DBManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private DBManager(Context context) {
        Logger.INSTANCE.i(TAG, "DBManager --> Constructor");
        this.helper = new DatabaseHelper(context);
        this.db = this.helper.getWritableDatabase();
    }

    public void insert(List<LayerEntity> layerEntities) {
        Logger.INSTANCE.i(TAG, "DBManager --> add");
        try {
            for (LayerEntity layerEntity : layerEntities) {
                this.db.beginTransaction();
                this.db.execSQL("INSERT INTO ab_layer VALUES( ?, ?,?)", new Object[]{layerEntity.getLayerId(), layerEntity.getLayerName(), layerEntity.getCurrentGroup()});
                this.db.setTransactionSuccessful();
                this.db.endTransaction();
                List<GroupEntity> groupEntities = layerEntity.getGroups();
                for (GroupEntity groupEntity : groupEntities) {
                    this.db.beginTransaction();
                    this.db.execSQL("INSERT INTO ab_group VALUES( ?,?,?)", new Object[]{groupEntity.getTestId(), groupEntity.getName(), layerEntity.getLayerId()});
                    this.db.setTransactionSuccessful();
                    this.db.endTransaction();
                    List<ParamEntity> paramEntities = groupEntity.getParams();
                    for (ParamEntity paramEntity : paramEntities) {
                        this.db.beginTransaction();
                        this.db.execSQL("INSERT INTO ab_param VALUES( null,?,?,?,?)", new Object[]{paramEntity.getExperimentId(), paramEntity.getCode(), paramEntity.getValue(), groupEntity.getTestId()});
                        this.db.setTransactionSuccessful();
                        this.db.endTransaction();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.db.endTransaction();
        }
    }

    public void deleteAllTable() {
        this.db.execSQL("DELETE FROM ab_param");
        this.db.execSQL("DELETE FROM ab_group");
        this.db.execSQL("DELETE FROM ab_layer");
    }

    public List<LayerEntity> queryALL(String sql, String[] selectionArgs) {
        Logger.INSTANCE.i(TAG, "DBManager --> query");
        ArrayList<LayerEntity> entities = new ArrayList<LayerEntity>();
        Cursor layerCursor = this.db.rawQuery(sql, selectionArgs);
        while (layerCursor.moveToNext()) {
            LayerEntity layerEntity = new LayerEntity();
            layerEntity.setLayerId(layerCursor.getString(layerCursor.getColumnIndex("layer_id")));
            layerEntity.setLayerName(layerCursor.getString(layerCursor.getColumnIndex("layer_name")));
            layerEntity.setCurrentGroup(layerCursor.getInt(layerCursor.getColumnIndex("testId")));
            Cursor groupCursor = this.db.rawQuery("SELECT * FROM ab_group where layer_id = ? ORDER BY testId ", new String[]{layerEntity.getLayerId()});
            ArrayList<GroupEntity> groupEntities = new ArrayList<GroupEntity>();
            while (groupCursor.moveToNext()) {
                GroupEntity groupEntity = new GroupEntity();
                groupEntity.setName(groupCursor.getString(groupCursor.getColumnIndex("name")));
                groupEntity.setTestId(groupCursor.getInt(groupCursor.getColumnIndex("testId")));
                Cursor paramCursor = this.db.rawQuery("SELECT * FROM ab_param where testId = ?", new String[]{String.valueOf(groupEntity.getTestId())});
                ArrayList<ParamEntity> paramEntities = new ArrayList<ParamEntity>();
                while (paramCursor.moveToNext()) {
                    ParamEntity paramEntity = new ParamEntity();
                    paramEntity.setCode(paramCursor.getString(paramCursor.getColumnIndex("code")));
                    paramEntity.setExperimentId(paramCursor.getInt(paramCursor.getColumnIndex("expermentId")));
                    paramEntity.setValue(paramCursor.getString(paramCursor.getColumnIndex("val")));
                    paramEntities.add(paramEntity);
                }
                groupEntity.setParams(paramEntities);
                groupEntities.add(groupEntity);
                paramCursor.close();
            }
            layerEntity.setGroups(groupEntities);
            groupCursor.close();
            entities.add(layerEntity);
        }
        layerCursor.close();
        return entities;
    }

    public void closeDB() {
        Logger.INSTANCE.i(TAG, "DBManager --> closeDB");
        this.db.close();
    }

    public List<LayerEntity> search(String key) {
        List<LayerEntity> searchResult = this.queryALL("SELECT * FROM ab_layer where layer_id like ? or layer_name like ? order by layer_name", new String[]{"%" + key + "%", "%" + key + "%"});
        return searchResult;
    }

    public LayerEntity queryLayer(String key) {
        List<LayerEntity> searchResult = this.queryALL("SELECT * FROM ab_layer where layer_id = ? ", new String[]{key});
        if (searchResult.size() == 1) {
            return searchResult.get(0);
        }
        return null;
    }

    public List<LayerEntity> queryLayerList() {
        return this.queryALL("SELECT * FROM ab_layer ORDER BY layer_id ", null);
    }

    public int updateLayer(String key, String name, int testId) {
        ContentValues cv = new ContentValues();
        cv.put("layer_id", key);
        cv.put("layer_name", name);
        cv.put("testId", Integer.valueOf(testId));
        String[] args = new String[]{key};
        return this.db.update("ab_layer", cv, "layer_id=?", args);
    }

    public void updateCustomParam(int testId, List<ParamEntity> paramEntities) {
        for (ParamEntity entity : paramEntities) {
            ContentValues cv = new ContentValues();
            String[] args = new String[]{String.valueOf(testId), entity.getCode()};
            cv.put("code", entity.getCode());
            cv.put("val", entity.getValue());
            this.db.update("ab_param", cv, "testId=? and code=?", args);
        }
    }

    public List<ParamEntity> queryParam(int testId) {
        Cursor paramCursor = this.db.rawQuery("SELECT * FROM ab_param where testId = ?", new String[]{String.valueOf(testId)});
        ArrayList<ParamEntity> paramEntities = new ArrayList<ParamEntity>();
        while (paramCursor.moveToNext()) {
            ParamEntity paramEntity = new ParamEntity();
            paramEntity.setCode(paramCursor.getString(paramCursor.getColumnIndex("code")));
            paramEntity.setExperimentId(paramCursor.getInt(paramCursor.getColumnIndex("expermentId")));
            paramEntity.setValue(paramCursor.getString(paramCursor.getColumnIndex("val")));
            paramEntities.add(paramEntity);
        }
        return paramEntities;
    }

    public GroupEntity queryGroup(int testId) {
        Cursor groupCursor = this.db.rawQuery("SELECT * FROM ab_group where testId = ?", new String[]{String.valueOf(testId)});
        GroupEntity groupEntity = new GroupEntity();
        while (groupCursor.moveToNext()) {
            groupEntity.setName(groupCursor.getString(groupCursor.getColumnIndex("name")));
            groupEntity.setTestId(groupCursor.getInt(groupCursor.getColumnIndex("testId")));
            Cursor paramCursor = this.db.rawQuery("SELECT * FROM ab_param where testId = ?", new String[]{String.valueOf(groupEntity.getTestId())});
            ArrayList<ParamEntity> paramEntities = new ArrayList<ParamEntity>();
            while (paramCursor.moveToNext()) {
                ParamEntity paramEntity = new ParamEntity();
                paramEntity.setCode(paramCursor.getString(paramCursor.getColumnIndex("code")));
                paramEntity.setExperimentId(paramCursor.getInt(paramCursor.getColumnIndex("expermentId")));
                paramEntity.setValue(paramCursor.getString(paramCursor.getColumnIndex("val")));
                paramEntities.add(paramEntity);
            }
            groupEntity.setParams(paramEntities);
            paramCursor.close();
        }
        return groupEntity;
    }
}

