/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.launcher;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.alibaba.android.arouter.core.AutowiredServiceImpl;
import com.alibaba.android.arouter.core.InstrumentationHook;
import com.alibaba.android.arouter.core.LogisticsCenter;
import com.alibaba.android.arouter.exception.HandlerException;
import com.alibaba.android.arouter.exception.InitException;
import com.alibaba.android.arouter.exception.NoRouteFoundException;
import com.alibaba.android.arouter.facade.Postcard;
import com.alibaba.android.arouter.facade.annotation.PluginInitalizer;
import com.alibaba.android.arouter.facade.callback.InterceptorCallback;
import com.alibaba.android.arouter.facade.callback.NavigationCallback;
import com.alibaba.android.arouter.facade.service.AutowiredService;
import com.alibaba.android.arouter.facade.service.DegradeService;
import com.alibaba.android.arouter.facade.service.InterceptorService;
import com.alibaba.android.arouter.facade.service.PathReplaceService;
import com.alibaba.android.arouter.facade.template.ILogger;
import com.alibaba.android.arouter.facade.template.IPluginInitalizer;
import com.alibaba.android.arouter.launcher.ARouter;
import com.alibaba.android.arouter.thread.DefaultPoolExecutor;
import com.alibaba.android.arouter.utils.DefaultLogger;
import com.alibaba.android.arouter.utils.TextUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ThreadPoolExecutor;

final class _ARouter {
    @PluginInitalizer
    public static IPluginInitalizer pluginInitalizer;
    static ILogger logger;
    private static volatile boolean monitorMode;
    private static volatile boolean debuggable;
    private static volatile boolean autoInject;
    private static volatile _ARouter instance;
    private static volatile boolean hasInit;
    private static volatile ThreadPoolExecutor executor;
    private static Context mContext;
    private static InterceptorService interceptorService;
    private static AutowiredService autowiredService;

    private _ARouter() {
    }

    protected static synchronized boolean init(Application application) {
        mContext = application;
        LogisticsCenter.init(mContext, executor);
        logger.info("ARouter::", "ARouter init success!");
        hasInit = true;
        return true;
    }

    protected static synchronized void addPluginRouteMap(IPluginInitalizer initalizer) {
        LogisticsCenter.addPluginRouteMap(initalizer);
        if (interceptorService != null) {
            interceptorService.onNewPluginInject(mContext);
        }
    }

    static synchronized void destroy() {
        if (_ARouter.debuggable()) {
            hasInit = false;
            LogisticsCenter.suspend();
            logger.info("ARouter::", "ARouter destroy success!");
        } else {
            logger.error("ARouter::", "Destroy can be used in debug mode only!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static _ARouter getInstance() {
        if (!hasInit) {
            throw new InitException("ARouterCore::Init::Invoke init(context) first!");
        }
        if (instance != null) return instance;
        Class<_ARouter> clazz = _ARouter.class;
        synchronized (_ARouter.class) {
            if (instance != null) return instance;
            instance = new _ARouter();
            _ARouter.inject(instance);
            _ARouter.addPluginRouteMap(pluginInitalizer);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static synchronized void openDebug() {
        debuggable = true;
        logger.info("ARouter::", "ARouter openDebug");
    }

    static synchronized void openLog() {
        logger.showLog(true);
        logger.info("ARouter::", "ARouter openLog");
    }

    @Deprecated
    static synchronized void enableAutoInject() {
        autoInject = true;
    }

    @Deprecated
    static boolean canAutoInject() {
        return autoInject;
    }

    @Deprecated
    static void attachBaseContext() {
        Log.i((String)"ARouter::", (String)"ARouter start attachBaseContext");
        try {
            Class<?> mMainThreadClass = Class.forName("android.app.ActivityThread");
            Method getMainThread = mMainThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]);
            getMainThread.setAccessible(true);
            Object currentActivityThread = getMainThread.invoke(null, new Object[0]);
            Field mInstrumentationField = mMainThreadClass.getDeclaredField("mInstrumentation");
            mInstrumentationField.setAccessible(true);
            mInstrumentationField.set(currentActivityThread, (Object)new InstrumentationHook());
            Log.i((String)"ARouter::", (String)"ARouter hook instrumentation success!");
        }
        catch (Exception ex) {
            Log.e((String)"ARouter::", (String)("ARouter hook instrumentation failed! [" + ex.getMessage() + "]"));
        }
    }

    static synchronized void printStackTrace() {
        logger.showStackTrace(true);
        logger.info("ARouter::", "ARouter printStackTrace");
    }

    static synchronized void setExecutor(ThreadPoolExecutor tpe) {
        executor = tpe;
    }

    static synchronized void monitorMode() {
        monitorMode = true;
        logger.info("ARouter::", "ARouter monitorMode on");
    }

    static boolean isMonitorMode() {
        return monitorMode;
    }

    static boolean debuggable() {
        return debuggable;
    }

    static void setLogger(ILogger userLogger) {
        if (null != userLogger) {
            logger = userLogger;
        }
    }

    static void inject(Object thiz) {
        if (autowiredService == null) {
            autowiredService = new AutowiredServiceImpl();
            autowiredService.init(mContext);
        }
        if (null != autowiredService) {
            autowiredService.autowire(thiz);
        }
    }

    static void afterInit() {
        interceptorService = (InterceptorService)ARouter.getInstance().build("/arouter/service/interceptor").navigation();
    }

    protected Postcard build(String path) {
        if (TextUtils.isEmpty(path)) {
            logger.error("ARouter::", "Parameter is invalid!");
            return this.build("", "");
        }
        Uri uri = Uri.parse((String)path);
        if (uri.getScheme() != null && !uri.getScheme().isEmpty() || path.contains("?")) {
            return this.build(uri);
        }
        PathReplaceService pService = ARouter.getInstance().navigation(PathReplaceService.class);
        if (null != pService) {
            path = pService.forString(path);
        }
        return this.build(path, this.extractGroup(path));
    }

    protected Postcard build(Uri uri) {
        String path;
        String scheme;
        if (null == uri || TextUtils.isEmpty(uri.toString())) {
            logger.error("ARouter::", "Parameter is invalid!");
            return new Postcard("", "");
        }
        PathReplaceService pService = ARouter.getInstance().navigation(PathReplaceService.class);
        if (null != pService) {
            uri = pService.forUri(uri);
        }
        if ((scheme = uri.getScheme()) != null && !scheme.equals("")) {
            StringBuilder builder = new StringBuilder();
            builder.append("/").append(uri.getHost()).append(uri.getPath());
            path = builder.toString();
        } else {
            path = uri.getPath();
        }
        return new Postcard(path, this.extractGroup(path), uri, null);
    }

    protected Postcard build(String path, String group) {
        if (TextUtils.isEmpty(path) || TextUtils.isEmpty(group)) {
            logger.error("ARouter::", "Parameter is invalid!");
            return new Postcard("", "");
        }
        PathReplaceService pService = ARouter.getInstance().navigation(PathReplaceService.class);
        if (null != pService) {
            path = pService.forString(path);
        }
        return new Postcard(path, group);
    }

    private String extractGroup(String path) {
        if (TextUtils.isEmpty(path) || !path.startsWith("/")) {
            logger.error("ARouter::", "Extract the default group failed, the path must be start with '/' and contain more than 2 '/'!");
            return null;
        }
        try {
            String defaultGroup = path.substring(1, path.indexOf("/", 1));
            if (TextUtils.isEmpty(defaultGroup)) {
                throw new HandlerException("ARouter::Extract the default group failed! There's nothing between 2 '/'!");
            }
            return defaultGroup;
        }
        catch (Exception e) {
            logger.warning("ARouter::", "Failed to extract default group! " + e.getMessage());
            return null;
        }
    }

    protected void tryCompletion(Postcard postcard) {
        this.tryCompletion(postcard, null);
    }

    protected void tryCompletion(Context context, Postcard postcard) {
        this.tryCompletion(context, postcard, null);
    }

    protected void tryCompletion(Postcard postcard, @Nullable NavigationCallback callback) {
        this.tryCompletion(null, postcard, callback);
    }

    protected void tryCompletion(@Nullable Context context, Postcard postcard, @Nullable NavigationCallback callback) {
        block3: {
            try {
                LogisticsCenter.completion(postcard, context);
                if (null != callback) {
                    callback.onFound(postcard);
                }
            }
            catch (NoRouteFoundException ex) {
                logger.error("ARouter::", ex.getMessage());
                if (null == callback) break block3;
                callback.onLost(postcard);
            }
        }
    }

    protected <T> T navigation(Class<? extends T> service) {
        try {
            Postcard postcard = LogisticsCenter.buildProvider(service.getName());
            if (null == postcard) {
                postcard = LogisticsCenter.buildProvider(service.getSimpleName());
            }
            LogisticsCenter.completion(postcard);
            return (T)postcard.getProvider();
        }
        catch (NoRouteFoundException ex) {
            logger.warning("ARouter::", ex.getMessage());
            return null;
        }
    }

    protected Object navigation(final Context context, final Postcard postcard, final int requestCode, final NavigationCallback callback) {
        if ((postcard.getPath() == null || postcard.getPath().isEmpty() || postcard.getGroup() == null || postcard.getGroup().isEmpty()) && callback != null) {
            callback.onLost(postcard);
        }
        try {
            LogisticsCenter.completion(postcard, context);
        }
        catch (NoRouteFoundException ex) {
            logger.warning("ARouter::", ex.getMessage());
            DegradeService degradeService = ARouter.getInstance().navigation(DegradeService.class);
            boolean ret = false;
            if (null != degradeService) {
                ret = degradeService.onLost(context, postcard);
            }
            if (callback != null) {
                if (ret) {
                    callback.onArrival(postcard);
                } else {
                    callback.onLost(postcard);
                }
            }
            return null;
        }
        if (null != callback) {
            callback.onFound(postcard);
        }
        if (postcard.isGreenChannel()) {
            return this._navigation(context, postcard, requestCode, callback);
        }
        interceptorService.doInterceptions(postcard, new InterceptorCallback(){

            @Override
            public void onContinue(Postcard postcard2) {
                _ARouter.this._navigation(context, postcard2, requestCode, callback);
            }

            @Override
            public void onInterrupt(Throwable exception) {
                if (null != callback) {
                    callback.onInterrupt(postcard);
                }
                logger.info("ARouter::", "Navigation failed, termination by interceptor : " + exception.getMessage());
            }
        });
        return null;
    }

    private Object _navigation(Context context, final Postcard postcard, final int requestCode, final NavigationCallback callback) {
        final Context currentContext = null == context ? mContext : context;
        switch (postcard.getType()) {
            case ACTIVITY: {
                final Intent intent = new Intent(currentContext, postcard.getDestination());
                intent.putExtras(postcard.getExtras());
                int flags = postcard.getFlags();
                if (-1 != flags) {
                    intent.setFlags(flags);
                } else if (!(currentContext instanceof Activity)) {
                    intent.setFlags(0x10000000);
                }
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        if (requestCode > 0) {
                            ActivityCompat.startActivityForResult((Activity)((Activity)currentContext), (Intent)intent, (int)requestCode, (Bundle)postcard.getOptionsBundle());
                        } else {
                            ActivityCompat.startActivity((Context)((Activity)currentContext), (Intent)intent, (Bundle)postcard.getOptionsBundle());
                        }
                        if ((0 <= postcard.getEnterAnim() || 0 <= postcard.getExitAnim()) && currentContext instanceof Activity) {
                            ((Activity)currentContext).overridePendingTransition(postcard.getEnterAnim(), postcard.getExitAnim());
                        }
                        if (null != callback) {
                            callback.onArrival(postcard);
                        }
                    }
                });
                break;
            }
            case PROVIDER: {
                return postcard.getProvider();
            }
            case BOARDCAST: 
            case CONTENT_PROVIDER: 
            case FRAGMENT: {
                Class fragmentMeta = postcard.getDestination();
                try {
                    Object instance = fragmentMeta.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (instance instanceof Fragment) {
                        ((Fragment)instance).setArguments(postcard.getExtras());
                    } else if (instance instanceof android.support.v4.app.Fragment) {
                        ((android.support.v4.app.Fragment)instance).setArguments(postcard.getExtras());
                    }
                    return instance;
                }
                catch (Exception ex) {
                    logger.error("ARouter::", "Fetch fragment instance error, " + TextUtils.formatStackTrace(ex.getStackTrace()));
                }
            }
            default: {
                return null;
            }
        }
        return null;
    }

    static {
        logger = new DefaultLogger("ARouter::");
        monitorMode = false;
        debuggable = false;
        autoInject = false;
        instance = null;
        hasInit = false;
        executor = DefaultPoolExecutor.getInstance();
    }
}

