/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.swipeloadingview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.duowan.mobile.basemedia.swipe.SwipeDirection;
import com.duowan.mobile.basemedia.swipe.SwipeViewDelegate;
import com.duowan.mobile.entlive.events.ITouchComponentClient_onScrollStart_EventArgs;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.MEIPAI;
import com.yy.mobile.RxBus;
import com.yy.mobile.ui.activity.GlobalActivityManager;
import com.yy.mobile.ui.widget.swipeloadingview.ISwipe;
import com.yy.mobile.ui.widget.swipeloadingview.SwipeDetector;
import com.yy.mobile.util.log.MLog;

public class SwipeContentView
extends View
implements ISwipe {
    private static final String TAG = "SwipeContentView";
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int CENTER_POS = 1;
    private SwipeDetector swipeDetector;
    private Scroller mScroller;
    private SwipeViewDelegate swipeViewDelegate;
    private GestureDetector.OnDoubleTapListener doubleTapListener;
    private boolean canScroll;
    private boolean isDraging;
    private boolean isFling;
    private boolean isFirstScrollAfterDown;
    private int mTouchDownScreen;
    private int currentHorizontalIndex = 1;
    private int currentVerticalIndex = 1;
    private SwipeDirection from;
    private SwipeDirection to;
    private View toView;
    private int fromEdge;
    private int toEdge;
    private int privateFlag = 255;
    private SwipeDirection originalFrom;
    private boolean mNeedAnimation = true;
    private static final Interpolator sInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };

    public boolean onDoubleTapEvent(MotionEvent e) {
        if (this.doubleTapListener != null) {
            return this.doubleTapListener.onDoubleTapEvent(e);
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (this.doubleTapListener != null) {
            return this.doubleTapListener.onDoubleTap(e);
        }
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        if (this.doubleTapListener != null) {
            return this.doubleTapListener.onSingleTapConfirmed(e);
        }
        return false;
    }

    public void enableDirection(SwipeDirection direction) {
        this.privateFlag |= direction.getEnableBitMask();
    }

    public void disableDirection(SwipeDirection direction) {
        this.privateFlag &= ~direction.getEnableBitMask();
    }

    public boolean isEnable() {
        return this.privateFlag != 0;
    }

    public boolean isEnable(SwipeDirection direction) {
        if (direction != null) {
            return (this.privateFlag & direction.getEnableBitMask()) == direction.getEnableBitMask();
        }
        return false;
    }

    public SwipeContentView(@NonNull Context context) {
        super(context);
        this.swipeDetector = new SwipeDetector(context, this);
        this.mScroller = new Scroller(context, sInterpolator);
    }

    public SwipeContentView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.swipeDetector = new SwipeDetector(context, this);
        this.mScroller = new Scroller(context, sInterpolator);
    }

    public SwipeContentView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.swipeDetector = new SwipeDetector(context, this);
        this.mScroller = new Scroller(context, sInterpolator);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.swipeDetector.onTouchEvent(event);
    }

    @Override
    public void interuptByScrollOrientationChange(boolean isVertical) {
        MLog.debug((Object)TAG, (String)"interuptByScrollOrientationChange", (Object[])new Object[0]);
        this.mScroller.abortAnimation();
        this.computeScroll();
    }

    @Override
    public boolean onDragStart() {
        MLog.debug((Object)TAG, (String)("onDragStart:" + this.from), (Object[])new Object[0]);
        this.originalFrom = this.from;
        this.isDraging = true;
        return true;
    }

    @Override
    public void onDragCancel(int dragDiraction) {
        this.isDraging = false;
        if (!this.isFling) {
            int index = this.swipeDetector.isVerticalScroll() ? this.currentVerticalIndex : this.currentHorizontalIndex;
            this.flingToScreen(index, 0);
            this.isFling = true;
        }
    }

    @Override
    public boolean isFling() {
        return this.isFling;
    }

    public boolean onDown(MotionEvent e) {
        this.isFirstScrollAfterDown = true;
        return true;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public boolean onScroll(MotionEvent currentDownEvent, MotionEvent e2, float distanceX, float distanceY) {
        if (this.isFirstScrollAfterDown) {
            int currentIndex;
            this.isFirstScrollAfterDown = false;
            this.mTouchDownScreen = currentIndex = this.swipeDetector.isVerticalScroll() ? this.currentVerticalIndex : this.currentHorizontalIndex;
            MLog.debug((Object)TAG, (String)("touchDownScreen:" + this.mTouchDownScreen), (Object[])new Object[0]);
            this.from = this.swipeDetector.isVerticalScroll() ? SwipeDirection.Companion.getVerticalDirection(currentIndex) : SwipeDirection.Companion.getHorizontalDirection(currentIndex);
            this.setupEdge();
        }
        this.canScroll = this.tryScroll(currentDownEvent, e2);
        if (this.canScroll) {
            this.isFling = false;
            this.smoothScrollBy((int)distanceX, (int)distanceY);
        }
        return this.canScroll;
    }

    private void setupEdge() {
        this.fromEdge = 0;
        this.toEdge = 0;
        if (this.swipeDetector.isVerticalScroll()) {
            this.fromEdge = this.isEnable(SwipeDirection.TOP) ? -this.getMeasuredHeight() : 0;
            this.toEdge = this.isEnable(SwipeDirection.BOTTOM) ? this.getMeasuredHeight() : 0;
        } else {
            this.fromEdge = this.isEnable(SwipeDirection.LEFT) ? -this.getMeasuredWidth() : 0;
            this.toEdge = this.isEnable(SwipeDirection.RIGHT) ? this.getMeasuredWidth() : 0;
        }
    }

    private boolean tryScroll(MotionEvent currentDownEvent, MotionEvent e2) {
        SwipeDirection newTo;
        int startScrollDownPos = (int)(this.swipeDetector.isVerticalScroll() ? currentDownEvent.getY() : currentDownEvent.getX());
        int newPos = (int)(this.swipeDetector.isVerticalScroll() ? e2.getY() : e2.getX());
        int currentIndex = this.mTouchDownScreen;
        int nextIndex = newPos > startScrollDownPos ? currentIndex - 1 : currentIndex + 1;
        SwipeDirection swipeDirection = newTo = this.swipeDetector.isVerticalScroll() ? SwipeDirection.Companion.getVerticalDirection(nextIndex) : SwipeDirection.Companion.getHorizontalDirection(nextIndex);
        if (!this.isEnable(newTo) && this.originalFrom == SwipeDirection.CENTER) {
            newTo = null;
        }
        if (newTo != null) {
            if (newTo != this.to) {
                View newToView = null;
                if (this.swipeViewDelegate != null) {
                    newToView = this.swipeViewDelegate.getDragView(newTo);
                }
                if (newToView != null) {
                    this.toView = newToView;
                    this.to = newTo;
                    return true;
                }
                return false;
            }
            return this.toView != null;
        }
        return false;
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onFling(MotionEvent currentDownEvent, MotionEvent e2, float velocityX, float velocityY) {
        this.isDraging = false;
        if (this.canScroll) {
            float mFlingVelocity = this.swipeDetector.isVerticalScroll() ? velocityY : velocityX;
            int startScrollDownPos = (int)(this.swipeDetector.isVerticalScroll() ? currentDownEvent.getY() : currentDownEvent.getX());
            int newPos = (int)(this.swipeDetector.isVerticalScroll() ? e2.getY() : e2.getX());
            int velocity = (int)(this.swipeDetector.isVerticalScroll() ? velocityY : velocityX);
            if (mFlingVelocity > 0.0f && startScrollDownPos <= newPos) {
                this.flingToScreen(this.mTouchDownScreen - 1, velocity);
            } else if (mFlingVelocity < 0.0f && startScrollDownPos >= newPos) {
                this.flingToScreen(this.mTouchDownScreen + 1, velocity);
            } else {
                this.flingToScreen(this.mTouchDownScreen, velocity);
            }
            return true;
        }
        return false;
    }

    private int getDirectionPos(View view, SwipeDirection direction) {
        if (view == null) {
            return 0;
        }
        switch (direction) {
            case TOP: {
                return -this.getRealHeight(view);
            }
            case LEFT: {
                return -this.getRealWidth(view);
            }
            case RIGHT: {
                return this.getRealWidth(view);
            }
            case BOTTOM: {
                return this.getRealHeight(view);
            }
        }
        return 0;
    }

    private int getRealWidth(View view) {
        int width = view.getMeasuredWidth() == 0 ? this.getMeasuredWidth() : view.getMeasuredWidth();
        int height = this.getRealHeight(view);
        if (height != GlobalActivityManager.INSTANCE.getForceAcivityHieght() && !(Spdt.currentFlavor() instanceof MEIPAI)) {
            MLog.info((Object)TAG, (String)("#getRealWidth width = " + width + ", forceActivityWidth = " + GlobalActivityManager.INSTANCE.getForceActivityWidth()), (Object[])new Object[0]);
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            lp.width = GlobalActivityManager.INSTANCE.getForceActivityWidth();
            lp.height = GlobalActivityManager.INSTANCE.getForceAcivityHieght();
            view.setLayoutParams(lp);
        }
        return width;
    }

    private int getRealHeight(View view) {
        int height;
        int n = height = view.getMeasuredHeight() == 0 ? this.getMeasuredHeight() : view.getMeasuredHeight();
        if (height != GlobalActivityManager.INSTANCE.getForceAcivityHieght() && !(Spdt.currentFlavor() instanceof MEIPAI)) {
            MLog.info((Object)TAG, (String)("#getRealHeight height = " + height + "forceAcivityHieght = " + GlobalActivityManager.INSTANCE.getForceAcivityHieght()), (Object[])new Object[0]);
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            lp.width = GlobalActivityManager.INSTANCE.getForceActivityWidth();
            lp.height = GlobalActivityManager.INSTANCE.getForceAcivityHieght();
            view.setLayoutParams(lp);
        }
        return height;
    }

    private void flingToScreen(int targetScreen, int velocity) {
        MLog.debug((Object)TAG, (String)("flingToScreen: targetScreen\uff1a " + targetScreen + " velocity\uff1a" + velocity), (Object[])new Object[0]);
        SwipeDirection newTo = this.swipeDetector.isVerticalScroll() ? SwipeDirection.Companion.getVerticalDirection(targetScreen) : SwipeDirection.Companion.getHorizontalDirection(targetScreen);
        this.flingToDirection(newTo, velocity, this.swipeDetector.isVerticalScroll(), true);
    }

    public void flingToDirection(SwipeDirection fromDirection, SwipeDirection toDirection, int velocity, boolean needAnimation) {
        this.from = fromDirection;
        this.originalFrom = fromDirection;
        boolean isVertical = toDirection == SwipeDirection.TOP || toDirection == SwipeDirection.BOTTOM ? true : (toDirection == SwipeDirection.CENTER ? fromDirection != SwipeDirection.LEFT && fromDirection != SwipeDirection.RIGHT : false);
        this.swipeDetector.setVerticalScroll(isVertical);
        this.flingToDirection(toDirection, velocity, isVertical, needAnimation);
    }

    private void flingToDirection(SwipeDirection toDirection, int velocity, boolean isVertical, boolean needAnimation) {
        MLog.debug((Object)TAG, (String)("flingToScreen: originalFrom\uff1a " + this.originalFrom + " toDirection\uff1a" + toDirection + " needAnimation; " + needAnimation), (Object[])new Object[0]);
        if (toDirection != null) {
            RxBus.getDefault().post((Object)new ITouchComponentClient_onScrollStart_EventArgs(toDirection));
            this.mNeedAnimation = needAnimation;
            this.to = toDirection;
            this.isFling = true;
            View view = null;
            if (this.swipeViewDelegate != null) {
                view = this.swipeViewDelegate.getDragView(toDirection);
                this.swipeViewDelegate.onFling(this.originalFrom, toDirection);
            }
            if (view != null) {
                this.toView = view;
            }
            int dstPos = this.getDirectionPos(this.toView, this.to);
            if (isVertical) {
                this.smoothScrollTo(this.getScrollX(), dstPos, velocity);
            } else {
                this.smoothScrollTo(dstPos, this.getScrollY(), velocity);
            }
            if (!needAnimation) {
                this.mScroller.abortAnimation();
                this.doScroll();
                this.from = this.to;
            }
        }
    }

    void smoothScrollTo(int x, int y, int velocity) {
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        int delta = dx != 0 ? dx : dy;
        int width = dx != 0 ? this.getPaddedWidth() : this.getPaddedHeight();
        int halfWidth = width / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(delta) / (float)width);
        float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
        int duration = 0;
        if ((velocity = Math.abs(velocity)) > 0) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
        } else {
            float pageWidth = width;
            float pageDelta = (float)Math.abs(delta) / pageWidth;
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, 600);
        this.mScroller.startScroll(sx, sy, dx, dy, duration);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private int getPaddedWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    private int getPaddedHeight() {
        return this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            this.doScroll();
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else if (this.isFling && !this.isDraging) {
            this.isFling = false;
            this.doScroll();
            this.from = this.to;
            this.swipeDetector.onFlingFinish();
            MLog.info((Object)TAG, (String)("computeScroll end originalFrom: " + this.originalFrom + " to: " + this.to + " mNeedAnimation: " + this.mNeedAnimation), (Object[])new Object[0]);
            if (this.swipeViewDelegate != null) {
                this.swipeViewDelegate.onScrollFinish(this.originalFrom, this.to);
            }
        }
    }

    private int getWidth(View view) {
        return this.getRealWidth(view);
    }

    private int getHeight(View view) {
        return this.getRealHeight(view);
    }

    private void doScroll() {
        int oldX = this.getScrollX();
        int oldY = this.getScrollY();
        int x = this.mScroller.getCurrX();
        int y = this.mScroller.getCurrY();
        if (oldX != x || oldY != y) {
            this.scrollTo(x, y);
            int target2 = this.getDirectionPos(this.toView, this.to);
            int distance = this.swipeDetector.isVerticalScroll() ? this.getHeight(this.toView) : this.getWidth(this.toView);
            int scroll = this.swipeDetector.isVerticalScroll() ? y : x;
            int index = this.computeScreenIndex(scroll, target2, distance);
            if (this.swipeViewDelegate != null) {
                float percent = 0.0f;
                if (distance != 0) {
                    percent = (float)scroll / (float)distance;
                }
                this.swipeViewDelegate.onScroll(this.from, this.to, x, y, Math.abs(percent), this.swipeDetector.isVerticalScroll());
            }
            if (this.swipeDetector.isVerticalScroll()) {
                this.currentVerticalIndex = index;
            } else {
                this.currentHorizontalIndex = index;
            }
        }
    }

    private void smoothScrollTo(int fx, int fy) {
        this.smoothScrollTo(fx, fy, 0);
    }

    private void smoothScrollBy(int dx, int dy) {
        if (this.swipeDetector.isVerticalScroll()) {
            int y = this.mScroller.getFinalY() + dy;
            if (this.fromEdge > y) {
                dy = this.fromEdge - this.mScroller.getFinalY();
            } else if (y > this.toEdge) {
                dy = this.toEdge - this.mScroller.getFinalY();
            }
        } else {
            int x = this.mScroller.getFinalX() + dx;
            if (this.fromEdge > x) {
                dx = this.fromEdge - this.mScroller.getFinalX();
            } else if (x > this.toEdge) {
                dx = this.toEdge - this.mScroller.getFinalX();
            }
        }
        if (dx != 0 || dy != 0) {
            this.mScroller.startScroll(this.mScroller.getFinalX(), this.mScroller.getFinalY(), dx, dy, 600);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setSwipeViewDelegate(SwipeViewDelegate swipeViewDelegate) {
        this.swipeViewDelegate = swipeViewDelegate;
    }

    public void setDoubleTapListener(GestureDetector.OnDoubleTapListener doubleTapListener) {
        this.doubleTapListener = doubleTapListener;
    }

    protected int computeScreenIndex(int scroll, int target2, int distance) {
        int startEdge = target2 - distance / 3 * 2;
        int endEdge = target2 + distance / 3 * 2;
        int index = startEdge < scroll && scroll < endEdge ? this.to.getIndex() : this.from.getIndex();
        return index;
    }
}

