/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.usertask;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.log.MLog;

public class CircularProgressView
extends View {
    private static final String TAG = "CircularProgressView";
    private Paint mBackPaint;
    private Paint mProgPaint;
    private RectF mRectF;
    private int[] mColorArray;
    private float mProgress;
    private ValueAnimator mAnimator;
    private CountDownListener mCountDownListener;
    private boolean mAnimatorCancel = false;

    public CircularProgressView(Context context) {
        this(context, null);
    }

    public CircularProgressView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LiveCircularProgressView);
        this.mBackPaint = new Paint();
        this.mBackPaint.setStyle(Paint.Style.STROKE);
        this.mBackPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mBackPaint.setAntiAlias(true);
        this.mBackPaint.setDither(true);
        this.mBackPaint.setStrokeWidth(typedArray.getDimension(R.styleable.LiveCircularProgressView_live_backWidth, 5.0f));
        this.mBackPaint.setColor(typedArray.getColor(R.styleable.LiveCircularProgressView_live_backColor, -3355444));
        this.mProgPaint = new Paint();
        this.mProgPaint.setStyle(Paint.Style.STROKE);
        this.mProgPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mProgPaint.setAntiAlias(true);
        this.mProgPaint.setDither(true);
        this.mProgPaint.setStrokeWidth(typedArray.getDimension(R.styleable.LiveCircularProgressView_live_progWidth, 10.0f));
        this.mProgPaint.setColor(typedArray.getColor(R.styleable.LiveCircularProgressView_live_progColor, -16776961));
        int startColor = typedArray.getColor(R.styleable.LiveCircularProgressView_live_progStartColor, -1);
        int firstColor = typedArray.getColor(R.styleable.LiveCircularProgressView_live_progFirstColor, -1);
        this.mColorArray = (int[])(startColor != -1 && firstColor != -1 ? new int[]{startColor, firstColor} : null);
        this.mProgress = typedArray.getInteger(R.styleable.LiveCircularProgressView_live_progress, 0);
        typedArray.recycle();
    }

    public void setCountDownListener(CountDownListener l) {
        this.mCountDownListener = l;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int viewWide = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int viewHigh = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int mRectLength = (int)((float)(viewWide > viewHigh ? viewHigh : viewWide) - (this.mBackPaint.getStrokeWidth() > this.mProgPaint.getStrokeWidth() ? this.mBackPaint.getStrokeWidth() : this.mProgPaint.getStrokeWidth()));
        int mRectL = this.getPaddingLeft() + (viewWide - mRectLength) / 2;
        int mRectT = this.getPaddingTop() + (viewHigh - mRectLength) / 2;
        this.mRectF = new RectF((float)mRectL, (float)mRectT, (float)(mRectL + mRectLength), (float)(mRectT + mRectLength));
        if (this.mColorArray != null && this.mColorArray.length > 1) {
            this.mProgPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mColorArray, null, Shader.TileMode.MIRROR));
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawArc(this.mRectF, 0.0f, 360.0f, false, this.mBackPaint);
        canvas.drawArc(this.mRectF, 275.0f, 360.0f * this.mProgress / 100.0f, false, this.mProgPaint);
    }

    public float getProgress() {
        return this.mProgress;
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
        this.invalidate();
    }

    public void setProgress(int progress, long animTime) {
        if (animTime <= 0L) {
            this.setProgress(progress);
        } else {
            this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mProgress, progress});
            this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    CircularProgressView.this.mProgress = ((Float)animation.getAnimatedValue()).floatValue();
                    CircularProgressView.this.invalidate();
                }
            });
            this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animation) {
                    super.onAnimationCancel(animation);
                    CircularProgressView.this.mAnimatorCancel = true;
                }

                public void onAnimationEnd(Animator animation) {
                    if (!CircularProgressView.this.mAnimatorCancel && CircularProgressView.this.mCountDownListener != null) {
                        CircularProgressView.this.mCountDownListener.onComplete();
                    }
                    CircularProgressView.this.mAnimatorCancel = false;
                    CircularProgressView.this.mAnimator.removeAllUpdateListeners();
                    CircularProgressView.this.mAnimator.removeAllListeners();
                }
            });
            this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mAnimator.setDuration(animTime);
            this.mAnimator.start();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelAnimator();
        if (this.mAnimator != null) {
            this.mAnimator.removeAllUpdateListeners();
            this.mAnimator.removeAllListeners();
        }
    }

    public void setBackWidth(int width) {
        this.mBackPaint.setStrokeWidth((float)width);
        this.invalidate();
    }

    public void setBackColor(@ColorRes int color2) {
        this.mBackPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)color2));
        this.invalidate();
    }

    public void setProgWidth(int width) {
        this.mProgPaint.setStrokeWidth((float)width);
        this.invalidate();
    }

    public void setProgColor(@ColorRes int color2) {
        this.mProgPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)color2));
        this.mProgPaint.setShader(null);
        this.invalidate();
    }

    public void setProgColor(@ColorRes int startColor, @ColorRes int firstColor) {
        this.mColorArray = new int[]{ContextCompat.getColor((Context)this.getContext(), (int)startColor), ContextCompat.getColor((Context)this.getContext(), (int)firstColor)};
        this.mProgPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mColorArray, null, Shader.TileMode.MIRROR));
        this.invalidate();
    }

    public void setProgColor(@ColorRes int[] colorArray) {
        if (colorArray == null || colorArray.length < 2) {
            return;
        }
        this.mColorArray = new int[colorArray.length];
        for (int index = 0; index < colorArray.length; ++index) {
            this.mColorArray[index] = ContextCompat.getColor((Context)this.getContext(), (int)colorArray[index]);
        }
        this.mProgPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mColorArray, null, Shader.TileMode.MIRROR));
        this.invalidate();
    }

    public void cancelAnimator() {
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            MLog.info((Object)TAG, (String)"cancelAnimator", (Object[])new Object[0]);
            this.mAnimator.cancel();
        }
    }

    @SuppressLint(value={"NewApi"})
    public void pauseAnimation() {
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            MLog.info((Object)TAG, (String)"pauseAnimation", (Object[])new Object[0]);
            this.mAnimator.pause();
        }
    }

    @SuppressLint(value={"NewApi"})
    public void resumeAnimation() {
        if (this.mAnimator != null && this.mAnimator.isPaused()) {
            MLog.info((Object)TAG, (String)"resumeAnimation", (Object[])new Object[0]);
            this.mAnimator.resume();
        }
    }

    public static interface CountDownListener {
        public void onComplete();
    }
}

