/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.startask;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Looper;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.startask.TaskAnimationManager;
import com.yy.mobile.ui.startask.TaskEffectController;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import java.lang.ref.WeakReference;

public class TaskStrongEffectView {
    private static final String TAG = "TaskStrongEffectView";
    private final int iconMoveY = 21;
    private final int endAnimator = 1;
    public int layoutBottom = 0;
    public int leftMargin = 0;
    private Context mContext;
    private View rootView;
    private RecycleImageView mEffectLayoutBgImg;
    private RecycleImageView mEffectCloseBtn;
    private RelativeLayout mIconContainerRl;
    private RelativeLayout mItemAnimContainer;
    private TextView mTxtTitle;
    private TextView mTxtMessage;
    private TextView mTxtGetReward;
    private RecycleImageView mIconRiv;
    private int bgLayoutDelayTime = 13000;
    private int iconDelayTime = 13400;
    private int iconDefaultSize = 45;
    private boolean isInChannel = true;
    private boolean isPlaying = false;
    private AnimatorSet alphaAnimatorSet;
    private AnimatorSet scaleAnimatorSet;
    private ObjectAnimator fadeOutAnimatorObj;
    private AnimatorSet translationAnimatorSet;
    private WeakReference<TaskEffectController.ITaskStrongEffectListener> effectListenerWeakRef;
    private WeakReference<TaskEffectController.ITaskViewClickedListener> taskViewClickedWeakRef;
    private WeakReference<TaskEffectController.ITaskControllerPlayState> playStateWeakReference;
    private int[] targetPos = new int[2];
    private Runnable fadeOutRunnable = new Runnable(){

        @Override
        public void run() {
            if (TaskStrongEffectView.this.mItemAnimContainer != null && TaskStrongEffectView.this.isPlaying) {
                TaskStrongEffectView.this.fadeOutAnimatorObj = TaskAnimationManager.getInstance().startAlphaAnimator((View)TaskStrongEffectView.this.mItemAnimContainer, null, 600, 1.0f, 0.0f);
            }
        }
    };
    private Runnable scaleRunnable = new Runnable(){

        @Override
        public void run() {
            if (TaskStrongEffectView.this.mIconRiv != null) {
                TaskStrongEffectView.this.scaleAnimatorSet = TaskAnimationManager.getInstance().startScaleAnimator((View)TaskStrongEffectView.this.mIconRiv, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animator2) {
                        if (TaskStrongEffectView.this.handler != null && TaskStrongEffectView.this.isPlaying) {
                            TaskStrongEffectView.this.handler.sendEmptyMessage(1);
                        }
                    }
                }, 400, 1.0f, 0.4f);
            }
        }
    };
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.myLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 1) {
                TaskStrongEffectView.this.translationAnimatorSet = TaskAnimationManager.getInstance().startTranslationAnimator((View)TaskStrongEffectView.this.mIconRiv, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animator2) {
                        TaskEffectController.ITaskStrongEffectListener listener2;
                        TaskStrongEffectView.this.isPlaying = false;
                        TaskStrongEffectView.this.mIconRiv.setVisibility(4);
                        TaskStrongEffectView.this.stopTaskAnimation();
                        TaskEffectController.ITaskStrongEffectListener iTaskStrongEffectListener = listener2 = TaskStrongEffectView.this.effectListenerWeakRef != null ? (TaskEffectController.ITaskStrongEffectListener)TaskStrongEffectView.this.effectListenerWeakRef.get() : null;
                        if (listener2 != null) {
                            listener2.animtionOnStop();
                        }
                    }
                }, 600, TaskStrongEffectView.this.targetPos[0], TaskStrongEffectView.this.targetPos[1]);
            }
        }
    };

    public TaskStrongEffectView(Context context) {
        this.mContext = context;
        this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_task_effect, null);
        this.mEffectLayoutBgImg = (RecycleImageView)this.rootView.findViewById(R.id.effect_layout_bg_img);
        this.mEffectCloseBtn = (RecycleImageView)this.rootView.findViewById(R.id.effect_close_btn);
        this.mEffectCloseBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TaskStrongEffectView.this.isInChannel) {
                    TaskStrongEffectView.this.clickMoreButtonPlayAnimation();
                } else {
                    TaskStrongEffectView.this.stopTaskAnimation();
                }
            }
        });
        this.mItemAnimContainer = (RelativeLayout)this.rootView.findViewById(R.id.item_anim_container);
        this.mTxtTitle = (TextView)this.rootView.findViewById(R.id.txt_title);
        this.mTxtMessage = (TextView)this.rootView.findViewById(R.id.txt_message);
        this.mTxtGetReward = (TextView)this.rootView.findViewById(R.id.txt_getReward);
        this.rootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TaskEffectController.ITaskControllerPlayState state;
                TaskEffectController.ITaskViewClickedListener listener2;
                TaskStrongEffectView.this.stopTaskAnimation();
                TaskEffectController.ITaskViewClickedListener iTaskViewClickedListener = listener2 = TaskStrongEffectView.this.taskViewClickedWeakRef != null ? (TaskEffectController.ITaskViewClickedListener)TaskStrongEffectView.this.taskViewClickedWeakRef.get() : null;
                if (listener2 != null) {
                    listener2.clicked();
                }
                TaskEffectController.ITaskControllerPlayState iTaskControllerPlayState = state = TaskStrongEffectView.this.playStateWeakReference != null ? (TaskEffectController.ITaskControllerPlayState)TaskStrongEffectView.this.playStateWeakReference.get() : null;
                if (state != null) {
                    state.playState(false);
                }
            }
        });
        this.mIconContainerRl = (RelativeLayout)this.rootView.findViewById(R.id.icon_container_rl);
        this.mIconRiv = new RecycleImageView(this.mContext);
        ImageLoader.loadImageBackgroundResource((int)R.drawable.task_qiangtips_icon_l, (View)this.mIconRiv, (ImageConfig)ImageConfig.defaultImageConfig());
        this.mItemAnimContainer.setAlpha(0.0f);
        this.mIconRiv.setAlpha(0);
        this.rootView.setVisibility(4);
    }

    public void setTaskLayoutInfo(int layoutBottom, int leftMargin) {
        if (this.layoutBottom != layoutBottom || this.leftMargin != leftMargin) {
            this.layoutBottom = layoutBottom;
            this.leftMargin = leftMargin;
            this.setIconLayoutParmas();
        }
    }

    private void setIconLayoutParmas() {
        RelativeLayout.LayoutParams iconParams = this.getIconLayoutParams();
        if (this.rootView.getParent() != null && ((ViewGroup)this.rootView.getParent()).indexOfChild((View)this.mIconRiv) == -1) {
            if (this.isInChannel && null != ((ViewGroup)this.rootView.getParent()).findViewById(R.id.trl_gift_panel)) {
                ((ViewGroup)this.rootView.getParent()).addView((View)this.mIconRiv, ((ViewGroup)this.rootView.getParent()).indexOfChild(((ViewGroup)this.rootView.getParent()).findViewById(R.id.trl_gift_panel)), (ViewGroup.LayoutParams)iconParams);
            } else {
                ((ViewGroup)this.rootView.getParent()).addView((View)this.mIconRiv, (ViewGroup.LayoutParams)iconParams);
            }
        } else {
            this.mIconRiv.setLayoutParams((ViewGroup.LayoutParams)iconParams);
        }
    }

    public View getTaskLayoutView() {
        return this.rootView;
    }

    public void setLayoutTxtInfo(String title, String message, String reward) {
        this.setTaskTitle(title);
        this.setTaskMessage(message);
        this.setRewardInfo(reward);
    }

    public void setTaskTitle(String str) {
        if (this.mTxtTitle != null) {
            this.mTxtTitle.setText((CharSequence)str);
        }
    }

    public void setTaskMessage(String msg) {
        if (this.mTxtMessage != null) {
            this.mTxtMessage.setText((CharSequence)msg);
        }
    }

    public void setRewardInfo(String info) {
        if (this.mTxtGetReward != null) {
            this.mTxtGetReward.setText((CharSequence)info);
        }
    }

    public void startTaskAnimation(int x, int y) {
        if (this.isPlaying) {
            MLog.info((Object)TAG, (String)"wwd \u52a8\u753b\u64ad\u653e\u8fc7\u7a0b\u4e2d", (Object[])new Object[0]);
            return;
        }
        if (!this.isInChannel) {
            int screenWidth = ResolutionUtils.getScreenWidth((Context)BasicConfig.getInstance().getAppContext());
            int targePosX = screenWidth * 4 / 5 + screenWidth / 10;
            int offsetX = (int)ResolutionUtils.convertDpToPixel((float)this.iconDefaultSize, (Context)BasicConfig.getInstance().getAppContext());
            int yTarget = (int)ResolutionUtils.convertDpToPixel((float)(this.layoutBottom + 21 - 6), (Context)BasicConfig.getInstance().getAppContext());
            this.targetPos[0] = targePosX - this.getLeftMargin() - offsetX / 2;
            this.targetPos[1] = yTarget;
        } else {
            this.targetPos[0] = x;
            this.targetPos[1] = y;
        }
        this.startTaskAnimation();
    }

    private void startTaskAnimation() {
        if (this.rootView != null && this.rootView.getVisibility() == 4) {
            this.rootView.setVisibility(0);
        }
        ObjectAnimator iconAlphaAnimtator = TaskAnimationManager.getInstance().alphaAnimator((View)this.mIconRiv, 0.0f, 1.0f);
        ObjectAnimator itemContainerAnimator = TaskAnimationManager.getInstance().alphaAnimator((View)this.mItemAnimContainer, 0.0f, 1.0f);
        this.alphaAnimatorSet = TaskAnimationManager.getInstance().startAnimatorSet((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator2) {
                TaskStrongEffectView.this.isPlaying = true;
                if (TaskStrongEffectView.this.mItemAnimContainer != null) {
                    TaskStrongEffectView.this.mItemAnimContainer.setVisibility(0);
                    TaskStrongEffectView.this.mItemAnimContainer.setAlpha(0.0f);
                }
                if (TaskStrongEffectView.this.mIconRiv != null) {
                    TaskStrongEffectView.this.mIconRiv.setVisibility(0);
                    TaskStrongEffectView.this.mIconRiv.setScaleX(1.0f);
                    TaskStrongEffectView.this.mIconRiv.setScaleY(1.0f);
                    TaskStrongEffectView.this.mIconRiv.setAlpha(0);
                }
            }

            public void onAnimationEnd(Animator animator2) {
                if (TaskStrongEffectView.this.handler != null && TaskStrongEffectView.this.isPlaying && !TaskStrongEffectView.this.isInChannel) {
                    TaskStrongEffectView.this.handler.removeCallbacks(TaskStrongEffectView.this.fadeOutRunnable);
                    TaskStrongEffectView.this.handler.postDelayed(TaskStrongEffectView.this.fadeOutRunnable, (long)TaskStrongEffectView.this.bgLayoutDelayTime);
                    TaskStrongEffectView.this.handler.removeCallbacks(TaskStrongEffectView.this.scaleRunnable);
                    TaskStrongEffectView.this.handler.postDelayed(TaskStrongEffectView.this.scaleRunnable, (long)TaskStrongEffectView.this.iconDelayTime);
                }
            }
        }, 600, iconAlphaAnimtator, itemContainerAnimator);
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onDestroy() {
        this.stopTaskAnimation();
    }

    public void stopTaskAnimation() {
        this.isPlaying = false;
        if (this.handler != null) {
            this.handler.removeCallbacks(this.fadeOutRunnable);
            this.handler.removeCallbacks(this.scaleRunnable);
            this.handler.removeMessages(1);
        }
        if (this.alphaAnimatorSet != null) {
            this.alphaAnimatorSet.removeAllListeners();
            this.alphaAnimatorSet.cancel();
            this.alphaAnimatorSet = null;
        }
        if (this.scaleAnimatorSet != null) {
            this.scaleAnimatorSet.removeAllListeners();
            this.scaleAnimatorSet.cancel();
            this.scaleAnimatorSet = null;
        }
        if (this.fadeOutAnimatorObj != null) {
            this.fadeOutAnimatorObj.removeAllListeners();
            this.fadeOutAnimatorObj.cancel();
            this.fadeOutAnimatorObj = null;
        }
        if (this.translationAnimatorSet != null) {
            this.translationAnimatorSet.removeAllListeners();
            this.translationAnimatorSet.cancel();
            this.translationAnimatorSet = null;
        }
        if (this.rootView != null) {
            this.rootView.setVisibility(4);
        }
        if (this.mIconRiv != null) {
            this.mIconRiv.setVisibility(4);
            this.mIconRiv.setTranslationX(0.0f);
            this.mIconRiv.setTranslationY(0.0f);
        }
    }

    private int getLeftMargin() {
        int offset = ResolutionUtils.getScreenWidth((Context)BasicConfig.getInstance().getAppContext()) - (int)ResolutionUtils.convertDpToPixel((float)320.0f, (Context)BasicConfig.getInstance().getAppContext());
        int leftMargin = offset / 2 + (int)ResolutionUtils.convertDpToPixel((float)this.iconDefaultSize, (Context)BasicConfig.getInstance().getAppContext()) / 2;
        return leftMargin;
    }

    public void setInChannel(boolean inChannel) {
        this.isInChannel = inChannel;
    }

    private RelativeLayout.LayoutParams getIconLayoutParams() {
        RelativeLayout.LayoutParams iconParams = new RelativeLayout.LayoutParams(-2, -2);
        iconParams.addRule(12);
        iconParams.bottomMargin = (int)ResolutionUtils.convertDpToPixel((float)(this.layoutBottom + 21), (Context)BasicConfig.getInstance().getAppContext());
        iconParams.leftMargin = this.leftMargin == 0 && !this.isInChannel ? this.getLeftMargin() : (int)ResolutionUtils.convertDpToPixel((float)this.leftMargin, (Context)BasicConfig.getInstance().getAppContext()) + (int)ResolutionUtils.convertDpToPixel((float)this.iconDefaultSize, (Context)BasicConfig.getInstance().getAppContext()) / 2;
        return iconParams;
    }

    public void setEffectListenerWeakRef(TaskEffectController.ITaskStrongEffectListener effectListener) {
        if (this.effectListenerWeakRef == null) {
            this.effectListenerWeakRef = new WeakReference<TaskEffectController.ITaskStrongEffectListener>(effectListener);
        }
    }

    public void setTaskViewClickedWeakRef(TaskEffectController.ITaskViewClickedListener listener2) {
        if (this.taskViewClickedWeakRef == null) {
            this.taskViewClickedWeakRef = new WeakReference<TaskEffectController.ITaskViewClickedListener>(listener2);
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void clickMoreButtonPlayAnimation() {
        this.playFadeOutAndScaleAnimation(0, 0);
    }

    private void playFadeOutAndScaleAnimation(int fadeOutTime, int scaleTime) {
        if (this.handler != null) {
            this.handler.removeCallbacks(this.fadeOutRunnable);
            this.handler.postDelayed(this.fadeOutRunnable, (long)fadeOutTime);
            this.handler.removeCallbacks(this.scaleRunnable);
            this.handler.postDelayed(this.scaleRunnable, (long)scaleTime);
        }
    }

    public void setPlayStateWeakReference(TaskEffectController.ITaskControllerPlayState playStateListener) {
        if (this.playStateWeakReference == null) {
            this.playStateWeakReference = new WeakReference<TaskEffectController.ITaskControllerPlayState>(playStateListener);
        }
    }
}

