/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.richtop.ui;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.live.module.noble.EntIdentityIconSet;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.channel.core.AbsChannelControllerCore;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.richtop.core.RichTopGiftInfo;
import com.yy.mobile.ui.richtop.core.RichTopInfo;
import com.yy.mobile.ui.startask.TaskCommon;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.noble.EntIdentity;
import com.yymobile.core.noble.INNobleCore;
import com.yymobile.core.noble.bean.NobleInfoBean;
import com.yymobile.core.truelove.TrueLoveInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RichTopListAdapter
extends BaseAdapter {
    private static final String TAG = "RichTopListAdapter";
    public static final int TYPE_TOP_INFO = 0;
    public static final int TYPE_GIFT_INFO_HEAD = 1;
    public static final int TYPE_GIFT_INFO = 2;
    public static final int TOP_EMPTY_COUNT = 3;
    protected Context mContext;
    private RichTopInfo mEmptyRichestInfo;
    protected List<RichTopInfo> mTopInfoList = new ArrayList<RichTopInfo>();
    protected List<RichTopGiftInfo> mGiftInfoList = new ArrayList<RichTopGiftInfo>();
    private List<Map<String, String>> mNobleInfolist = new ArrayList<Map<String, String>>();
    private boolean isShowReachTopTag = false;
    private int drawableWidth;

    public RichTopListAdapter(Context context, List<RichTopInfo> topInfoList, List<RichTopGiftInfo> giftInfoList, boolean showReachTag) {
        this.mContext = context;
        this.setTopInfoList(topInfoList);
        this.setGiftInfoList(giftInfoList);
        this.isShowReachTopTag = showReachTag;
        this.drawableWidth = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)this.mContext);
    }

    public RichTopListAdapter(Context context, boolean showReachTag) {
        this.mContext = context;
        this.isShowReachTopTag = showReachTag;
        this.drawableWidth = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)this.mContext);
    }

    public List<RichTopInfo> getTopInfoList() {
        return this.mTopInfoList;
    }

    public void setTopInfoList(List<RichTopInfo> topInfoList) {
        if (this.mTopInfoList == null) {
            this.mTopInfoList = new ArrayList<RichTopInfo>();
        }
        this.mTopInfoList.clear();
        if (topInfoList != null && !topInfoList.isEmpty()) {
            this.mTopInfoList.addAll(topInfoList);
        }
        this.notifyDataSetChanged();
    }

    public List<RichTopGiftInfo> getGiftInfoList() {
        return this.mGiftInfoList;
    }

    public void setGiftInfoList(List<RichTopGiftInfo> giftInfoList) {
        if (this.mGiftInfoList == null) {
            this.mGiftInfoList = new ArrayList<RichTopGiftInfo>();
        }
        this.mGiftInfoList.clear();
        if (giftInfoList != null && !giftInfoList.isEmpty()) {
            this.mGiftInfoList.addAll(giftInfoList);
        }
        this.notifyDataSetChanged();
    }

    public void setNobleInfo(List<Map<String, String>> nobleInfoList) {
        if (nobleInfoList == null || nobleInfoList.isEmpty()) {
            this.mNobleInfolist.clear();
        } else {
            this.mNobleInfolist = nobleInfoList;
        }
    }

    public int getCount() {
        if (this.mGiftInfoList.size() <= 0) {
            return this.getTopListSize();
        }
        return this.getTopListSize() + this.mGiftInfoList.size() + 1;
    }

    public Object getItem(int position) {
        int topSize = this.getTopListSize();
        if (position < this.mTopInfoList.size()) {
            return this.mTopInfoList.get(position);
        }
        if (position < topSize) {
            return this.getEmptyRichestInfo();
        }
        if (position == topSize) {
            return 1;
        }
        if (position - topSize - 1 < this.mGiftInfoList.size() && position - topSize - 1 >= 0) {
            return this.mGiftInfoList.get(position - topSize - 1);
        }
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public int getItemViewType(int position) {
        int topSize = this.getTopListSize();
        if (position < topSize) {
            return 0;
        }
        if (position == topSize) {
            return 1;
        }
        return 2;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        MLog.debug((Object)TAG, (String)("getView position = " + position + ", getItemViewType = " + this.getItemViewType(position)), (Object[])new Object[0]);
        switch (this.getItemViewType(position)) {
            case 0: {
                TopInfoHolder topInfoHolder;
                if (convertView == null || convertView.getTag() == null || !(convertView.getTag() instanceof TopInfoHolder)) {
                    topInfoHolder = new TopInfoHolder();
                    convertView = this.createTopInfoView(topInfoHolder, parent);
                } else {
                    topInfoHolder = (TopInfoHolder)convertView.getTag();
                }
                RichTopInfo info = (RichTopInfo)this.getItem(position);
                MLog.debug((Object)TAG, (String)("richtopinfo====" + info), (Object[])new Object[0]);
                if (info == null) break;
                if ("1".equals(info.nobleHide)) {
                    this.setMysteriousPerson(topInfoHolder, true, position);
                } else {
                    this.setMysteriousPerson(topInfoHolder, false, position);
                    this.loadFace(info.portraitUrl, info.portraitIndex, (RecycleImageView)topInfoHolder.portrait);
                    if (info.name != null) {
                        topInfoHolder.nickname.setText((CharSequence)info.name);
                    }
                    if (Build.VERSION.SDK_INT >= 17) {
                        topInfoHolder.nickname.setTextDirection(3);
                    }
                    if (this.isShowNobleInfo(info)) {
                        topInfoHolder.nickname.setTextColor(this.mContext.getResources().getColor(R.color.color_red));
                    } else {
                        topInfoHolder.nickname.setTextColor(this.mContext.getResources().getColor(R.color.color_black));
                    }
                    if (topInfoHolder.tvLevel != null) {
                        this.setOppoLevel(topInfoHolder.tvLevel, info.userLv);
                    }
                    if (info.level > 0) {
                        int res = this.getNobelIconRes(info.level);
                        BitmapDrawable bitmapDrawable = ImageLoader.getBitmapDrawableFromResource((int)res, (ImageConfig)ImageConfig.defaultImageConfig());
                        if (bitmapDrawable != null) {
                            bitmapDrawable.setBounds(0, 0, this.drawableWidth, this.drawableWidth);
                        }
                        topInfoHolder.nickname.setCompoundDrawables((Drawable)bitmapDrawable, null, null, null);
                    } else if (info.actNobleType > 0) {
                        int res = this.getNobelIconRes(info.level);
                        BitmapDrawable bitmapDrawable = ImageLoader.getBitmapDrawableFromResource((int)res, (ImageConfig)ImageConfig.defaultImageConfig());
                        if (bitmapDrawable != null) {
                            bitmapDrawable.setBounds(0, 0, this.drawableWidth, this.drawableWidth);
                        }
                        topInfoHolder.nickname.setCompoundDrawables((Drawable)bitmapDrawable, null, null, null);
                    } else if (info.level == 0) {
                        int res = TaskCommon.vulgarResIds(info.nobleV2Type, info.nobleV2Level);
                        BitmapDrawable bitmapDrawable = ImageLoader.getBitmapDrawableFromResource((int)res, (ImageConfig)ImageConfig.defaultImageConfig());
                        if (bitmapDrawable != null) {
                            bitmapDrawable.setBounds(0, 0, this.drawableWidth, this.drawableWidth);
                        }
                        topInfoHolder.nickname.setCompoundDrawables((Drawable)bitmapDrawable, null, null, null);
                    } else {
                        topInfoHolder.nickname.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
                    }
                    if (info.uid == LoginUtil.getUid() && this.isShowReachTopTag) {
                        topInfoHolder.reachRankTag.setVisibility(0);
                    } else {
                        topInfoHolder.reachRankTag.setVisibility(4);
                    }
                    if (topInfoHolder.sexImg != null) {
                        this.setOppoUserSex(topInfoHolder.sexImg, info.sex);
                    }
                }
                if (StringUtils.isEmpty((String)info.contribution).booleanValue()) {
                    info.contribution = "0";
                }
                topInfoHolder.contributionCount.setText((CharSequence)this.mContext.getString(this.setContributionCountRes(), new Object[]{info.contribution}));
                break;
            }
            case 2: {
                int res;
                BitmapDrawable bitmapDrawable;
                GiftInfoHolder giftInfoHolder;
                if (convertView == null) {
                    giftInfoHolder = new GiftInfoHolder();
                    convertView = this.createGiftInfoView(giftInfoHolder, parent);
                } else {
                    giftInfoHolder = (GiftInfoHolder)convertView.getTag();
                }
                RichTopGiftInfo giftInfo = (RichTopGiftInfo)this.getItem(position);
                if (giftInfo.name != null) {
                    giftInfoHolder.nickname.setText((CharSequence)giftInfo.name);
                }
                if ((bitmapDrawable = ImageLoader.getBitmapDrawableFromResource((int)(res = this.getMyNobelIconRes(giftInfo.uid)), (ImageConfig)ImageConfig.defaultImageConfig())) != null) {
                    bitmapDrawable.setBounds(0, 0, this.drawableWidth, this.drawableWidth);
                }
                giftInfoHolder.nickname.setCompoundDrawables((Drawable)bitmapDrawable, null, null, null);
                ImageLoader.loadImage((String)giftInfo.gitGiftUrl, (RecycleImageView)giftInfoHolder.giftIcon, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.lr_ic_default_gift);
                giftInfoHolder.giftNumber.setText((CharSequence)this.mContext.getString(R.string.channel_contribution_send_gift_number, new Object[]{giftInfo.gitGiftNum}));
                if (giftInfo.isFirstCharge) {
                    giftInfoHolder.contributionCount.setVisibility(8);
                    break;
                }
                giftInfoHolder.contributionCount.setVisibility(0);
                giftInfoHolder.contributionCount.setText((CharSequence)this.mContext.getString(this.setContributionCountRes(), new Object[]{giftInfo.contribution}));
                break;
            }
            case 1: {
                if (convertView != null) break;
                GiftInfoHeadHolder giftHeadHolder = new GiftInfoHeadHolder();
                convertView = this.createGiftInfoHeadView(giftHeadHolder, parent);
                break;
            }
        }
        return convertView;
    }

    protected void setOppoUserSex(ImageView iv, int sex) {
    }

    protected void setOppoLevel(TextView tv, int level) {
    }

    protected int setContributionCountRes() {
        return R.string.channel_contribution_counts;
    }

    protected int getTopListSize() {
        return this.mTopInfoList.size() < 3 ? 3 : this.mTopInfoList.size();
    }

    protected RichTopInfo getEmptyRichestInfo() {
        if (this.mEmptyRichestInfo == null) {
            this.mEmptyRichestInfo = new RichTopInfo();
            this.mEmptyRichestInfo.uid = -1L;
            this.mEmptyRichestInfo.name = this.mContext.getString(R.string.channel_contribution_list_top_empty);
        }
        return this.mEmptyRichestInfo;
    }

    public void setMysteriousPerson(TopInfoHolder topInfoHolder, boolean isMysterions, int position) {
        if (isMysterions) {
            topInfoHolder.portrait.setVisibility(8);
            topInfoHolder.mysteriousPersonIv.setVisibility(0);
            topInfoHolder.nickname.setVisibility(8);
            topInfoHolder.mysteriousPerson.setVisibility(0);
        } else {
            topInfoHolder.portrait.setVisibility(0);
            topInfoHolder.mysteriousPersonIv.setVisibility(8);
            topInfoHolder.nickname.setVisibility(0);
            topInfoHolder.mysteriousPerson.setVisibility(8);
        }
        if (position < 3) {
            topInfoHolder.rankIcon.setText((CharSequence)"");
            topInfoHolder.rankIcon.setBackgroundResource(this.getRankIconRes(position + 1));
        } else {
            topInfoHolder.portrait.setBorderWidth(0);
            topInfoHolder.rankIcon.setText((CharSequence)String.valueOf(position + 1));
            topInfoHolder.rankIcon.setBackgroundResource(0);
        }
    }

    protected View createTopRichInfoView(Context context, ViewGroup parent) {
        return LayoutInflater.from((Context)context).inflate(R.layout.layout_richtop_list_item, parent, false);
    }

    protected View createTopInfoView(TopInfoHolder topInfoHolder, ViewGroup parent) {
        View convertView = this.createTopRichInfoView(this.mContext, parent);
        topInfoHolder.rankIcon = (TextView)convertView.findViewById(R.id.iv_rank_icon);
        topInfoHolder.portrait = (CircleImageView)convertView.findViewById(R.id.iv_portrait);
        topInfoHolder.mysteriousPersonIv = (ImageView)convertView.findViewById(R.id.mysterious_person_iv);
        topInfoHolder.nickname = (TextView)convertView.findViewById(R.id.tv_nickname);
        topInfoHolder.mysteriousPerson = (TextView)convertView.findViewById(R.id.tv_mysterious_person);
        topInfoHolder.contributionCount = (TextView)convertView.findViewById(R.id.tv_contribution);
        topInfoHolder.reachRankTag = (RecycleImageView)convertView.findViewById(R.id.iv_reach_rank);
        convertView.setTag((Object)topInfoHolder);
        return convertView;
    }

    private View createGiftInfoView(GiftInfoHolder giftInfoHolder, ViewGroup parent) {
        View convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_richtop_list_gift_item, parent, false);
        giftInfoHolder.nickname = (TextView)convertView.findViewById(R.id.tv_nickname);
        giftInfoHolder.giftName = (TextView)convertView.findViewById(R.id.tv_gift_name);
        giftInfoHolder.giftIcon = (RecycleImageView)convertView.findViewById(R.id.iv_gift_icon);
        giftInfoHolder.giftNumber = (TextView)convertView.findViewById(R.id.tv_gift_number);
        giftInfoHolder.contributionCount = (TextView)convertView.findViewById(R.id.tv_gift_contribution);
        convertView.setTag((Object)giftInfoHolder);
        return convertView;
    }

    private View createGiftInfoHeadView(GiftInfoHeadHolder giftInfoHeadHolder, ViewGroup parent) {
        View convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_richtop_list_gift_head, parent, false);
        giftInfoHeadHolder.title = (TextView)convertView;
        convertView.setTag((Object)giftInfoHeadHolder);
        return convertView;
    }

    protected int getRankIconRes(int rank) {
        switch (rank) {
            case 1: {
                return R.drawable.icon_ranked_1;
            }
            case 2: {
                return R.drawable.icon_ranked_2;
            }
            case 3: {
                return R.drawable.icon_ranked_3;
            }
        }
        return 0;
    }

    private int getNobelIconRes(int level) {
        return EntIdentityIconSet.getIconResId(level);
    }

    private int getMyNobelIconRes(long uid) {
        if (!((INNobleCore)ICoreManagerBase.getCore(INNobleCore.class)).isNewNobleType()) {
            if (!EntIdentity.isNobleOverDue()) {
                if (EntIdentity.UserNobleInfo.level > 0) {
                    return EntIdentityIconSet.getIconResId(EntIdentity.UserNobleInfo.level);
                }
                if (EntIdentity.UserNobleInfo.actNobleType > 0) {
                    return EntIdentityIconSet.getIconResId(EntIdentity.UserNobleInfo.actNobleType);
                }
            }
        } else {
            NobleInfoBean bean = ((INNobleCore)ICoreManagerBase.getCore(INNobleCore.class)).getNobleInfoBean();
            if (bean != null && bean.type > 0) {
                return TaskCommon.vulgarResIds(bean.type, bean.level);
            }
        }
        return 0;
    }

    private boolean isShowNobleInfo(RichTopInfo info) {
        for (int m = 0; m < this.mNobleInfolist.size(); ++m) {
            Map<String, String> map = this.mNobleInfolist.get(m);
            if (map == null || map.size() == 0) continue;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("isShowNobleInfouid" + map.get("uid") + "hasHonourCap" + map.get("hasHonourCap")), (Object[])new Object[0]);
            }
            if (!String.valueOf(info.uid).equals(map.get("uid")) || !"1".equals(map.get("hasHonourCap"))) continue;
            return true;
        }
        return false;
    }

    private String isShowTrueLoveIcon(ArrayList<Map<String, String>> infos, RichTopInfo info) {
        for (Map<String, String> map : infos) {
            if (info.uid != StringUtils.safeParseLong((String)map.get("uid"))) continue;
            TrueLoveInfo.richTopTrueLoveList.put(info.uid, true);
            return map.get("level");
        }
        return null;
    }

    private void loadFace(String url, int index, RecycleImageView recycleImageView) {
        AbsChannelControllerCore absChannelControllerCore = (AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class);
        if (absChannelControllerCore == null || !absChannelControllerCore.isInterceptShowPortrait(url, (ImageView)recycleImageView)) {
            int blankBitmapResource = this.defaultFaceRes();
            int loadingBitmapResource = this.defaultFaceRes();
            if (index != 999 && index > 0) {
                String headUrl = BasicConfig.getInstance().getAppContext().getString(R.string.str_friend_head_index_url_format, new Object[]{index});
                ImageLoader.loadImage((String)headUrl, (RecycleImageView)recycleImageView, (ImageConfig)ImageConfig.defaultImageConfig(), (int)loadingBitmapResource, (int)blankBitmapResource);
                return;
            }
            ImageLoader.loadImage((RecycleImageView)recycleImageView, (String)url, (int)loadingBitmapResource);
        }
    }

    protected int defaultFaceRes() {
        return R.drawable.default_portrait;
    }

    private static class GiftInfoHeadHolder {
        public TextView title;

        private GiftInfoHeadHolder() {
        }
    }

    public class GiftInfoHolder {
        public TextView nickname;
        public TextView giftName;
        public RecycleImageView giftIcon;
        public TextView giftNumber;
        public TextView contributionCount;
    }

    public class TopInfoHolder {
        public TextView rankIcon;
        public CircleImageView portrait;
        public ImageView mysteriousPersonIv;
        public TextView nickname;
        public TextView contributionCount;
        public TextView mysteriousPerson;
        public RecycleImageView reachRankTag;
        public ImageView sexImg;
        public TextView tvLevel;
    }
}

