/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.richtop.ui;

import android.app.Dialog;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IRichTopClient_onHideRichTopFragment_EventArgs;
import com.gyf.immersionbar.NotchUtils;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.ui.richtop.core.IRichTopCore;
import com.yy.mobile.ui.richtop.endorsement.EndorsementComponent;
import com.yy.mobile.ui.richtop.ui.RichTopComponent;
import com.yy.mobile.ui.richtop.ui.RichTopFragment$$EventBinder;
import com.yy.mobile.ui.richtop.ui.RichTopGiftRecordComponent;
import com.yy.mobile.ui.richtop.ui.RichTopLiveFragment;
import com.yy.mobile.ui.richtop.ui.mulitfightpk.FightAllGuestContRankFragment;
import com.yy.mobile.ui.widget.PagerSlidingTabStrip;
import com.yy.mobile.ui.widget.pager.PagerSelectedAdapter;
import com.yy.mobile.ui.widget.pager.SelectedViewPager;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.mobilelive.Utils;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.List;

public class RichTopFragment
extends PopupComponent {
    private String TAG = "RichTopFragment";
    protected ImageView mBackNav = null;
    protected PagerSlidingTabStrip mTab = null;
    private SelectedViewPager mPageFragment = null;
    private List<String> mTabTitleList = new ArrayList<String>();
    private PagerAdapter mAdapter = null;
    private int mTabIndicatorHeight = 0;
    private boolean isLiving = false;
    private EventBinder mRichTopFragmentSniperEventBinder;

    public static RichTopFragment newInstance() {
        return new RichTopFragment();
    }

    public static RichTopFragment newInstance(String focusTitle) {
        RichTopFragment fragment = new RichTopFragment();
        Bundle bundle = new Bundle();
        bundle.putString("focusTitle", focusTitle);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getActivity().getResources().getConfiguration().orientation == 2) {
            this.setStyle(0, R.style.fullscreen_micgragment);
        } else {
            this.setStyle(0, R.style.translucent_micgragment);
        }
    }

    protected View createView(LayoutInflater inflater, ViewGroup container) {
        return inflater.inflate(R.layout.fragment_richtop, container, false);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = this.createView(inflater, container);
        this.mBackNav = (ImageView)view.findViewById(R.id.rich_back_nav);
        this.mTab = (PagerSlidingTabStrip)view.findViewById(R.id.rich_tab);
        this.mTab.setUnderlineColor(Spdt.color((int)R.color.main_btn_bg));
        this.mTabIndicatorHeight = this.mTab.getIndicatorHeight();
        this.mPageFragment = (SelectedViewPager)view.findViewById(R.id.rich_pager);
        this.mBackNav.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                RichTopFragment.this.hide();
            }
        });
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.isLiving = ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive();
        this.initPager();
        if (Utils.isFullScreen() && NotchUtils.hasNotchScreen((View)view) && !Build.BRAND.equals("HUAWEI")) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mPageFragment.getLayoutParams();
            lp.leftMargin += ScreenUtil.getStatusBarHeight();
            lp.rightMargin += ScreenUtil.getStatusBarHeight();
        }
        if (this.getDialog() != null && this.getDialog().getWindow() != null) {
            this.getDialog().getWindow().setSoftInputMode(32);
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        if (dialog.getWindow() != null) {
            dialog.getWindow().setWindowAnimations(R.style.DialogAnimationRightSlide300);
        }
        return dialog;
    }

    private void initPager() {
        String focusTitle;
        if (this.mTab == null) {
            return;
        }
        this.mTab.setTypeface(null, 0);
        this.mTab.setShouldExpand(true);
        this.mTab.setUseFadeEffect(true);
        this.mTab.setFadeEnabled(true);
        this.mTab.setZoomMax(0.15f);
        this.mTabTitleList.clear();
        this.mTab.setIndicatorHeight(this.mTabIndicatorHeight);
        boolean isMulitLive = false;
        if (this.isLiving && !this.isMultiLive() && !this.isMulitLiveTemplate()) {
            this.mTabTitleList.add("\u8d21\u732e\u699c");
            this.mTabTitleList.add("\u9001\u793c\u660e\u7ec6");
        } else if (((IRichTopCore)ICoreManagerBase.getCore(IRichTopCore.class)).isLiveRichTop()) {
            this.mTabTitleList.add("\u672c\u573a\u8d21\u732e\u699c");
            this.mTabTitleList.add("\u4e03\u5929\u8d21\u732e\u699c");
        } else if (this.isMulitLiveTemplate() || this.isMultiLive()) {
            this.mTabTitleList.add("\u8d21\u732e\u699c");
            this.mTabTitleList.add("\u5609\u5bbe\u699c");
            isMulitLive = true;
        } else {
            this.mTabTitleList.add("7\u5929\u8d21\u732e\u699c");
        }
        FragmentManager fm = this.getChildFragmentManager();
        this.mAdapter = new PagerAdapter(fm, this.mTabTitleList);
        this.mPageFragment.setAdapter((android.support.v4.view.PagerAdapter)this.mAdapter);
        this.mTab.setOnTabClickListener(new PagerSlidingTabStrip.OnTabClickListener(){

            public void onClick(int selectedPos, int prePos) {
                if (selectedPos < RichTopFragment.this.mAdapter.getCount() && TextUtils.equals((CharSequence)RichTopFragment.this.mAdapter.getPageTitle(selectedPos), (CharSequence)"\u5609\u5bbe\u699c")) {
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51331", "0002");
                }
            }
        });
        this.mTab.setViewPager((ViewPager)this.mPageFragment);
        int titleCnt = this.mAdapter.getCount();
        String string2 = focusTitle = this.getArguments() == null ? "" : this.getArguments().getString("focusTitle", "");
        if (!TextUtils.isEmpty((CharSequence)focusTitle)) {
            for (int i = 0; i < titleCnt; ++i) {
                if (!TextUtils.equals((CharSequence)this.mAdapter.getPageTitle(i), (CharSequence)focusTitle)) continue;
                this.jumpToIndex(i);
                break;
            }
        }
    }

    private boolean isMultiLive() {
        return false;
    }

    private boolean isMulitLiveTemplate() {
        return false;
    }

    private void jumpToIndex(int mFocusIndex) {
        if (mFocusIndex > 0 && mFocusIndex < this.mAdapter.getCount()) {
            try {
                this.mPageFragment.setCurrentItem(mFocusIndex);
            }
            catch (Throwable e) {
                MLog.error((Object)"", (String)"", (Object[])new Object[0]);
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onHideRichTopFragment(IRichTopClient_onHideRichTopFragment_EventArgs busEventArgs) {
        this.hide();
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mBackNav != null) {
            this.mBackNav.setOnClickListener(null);
        }
        this.mBackNav = null;
    }

    protected BaseLinkFragment createRichTopComponent(boolean isShowTitle) {
        return RichTopComponent.newInstance(isShowTitle);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mRichTopFragmentSniperEventBinder == null) {
            this.mRichTopFragmentSniperEventBinder = new RichTopFragment$$EventBinder();
        }
        this.mRichTopFragmentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mRichTopFragmentSniperEventBinder != null) {
            this.mRichTopFragmentSniperEventBinder.unBindEvent();
        }
    }

    public class PagerAdapter
    extends PagerSelectedAdapter {
        private static final int NAV_TAG_FIRST = 0;
        private static final int NAV_TAG_SECOND = 1;
        private SparseArray<Fragment> registeredFragments;
        private ArrayList<String> mTitleList;

        public PagerAdapter(FragmentManager fm, List<String> tabTitleList) {
            super(fm);
            this.registeredFragments = new SparseArray();
            this.mTitleList = new ArrayList();
            if (tabTitleList != null) {
                this.mTitleList.addAll(tabTitleList);
            }
        }

        public BaseLinkFragment getItem(int position) {
            if (RichTopFragment.this.isLiving && !RichTopFragment.this.isMultiLive() && !RichTopFragment.this.isMulitLiveTemplate()) {
                if (position == 0) {
                    return RichTopFragment.this.createRichTopComponent(true);
                }
                if (position == 1) {
                    return RichTopGiftRecordComponent.instance();
                }
                return EndorsementComponent.Companion.newInstance();
            }
            if (((IRichTopCore)ICoreManagerBase.getCore(IRichTopCore.class)).isLiveRichTop()) {
                if (position == 0) {
                    return RichTopLiveFragment.newInstance();
                }
                if (position == 1) {
                    return RichTopFragment.this.createRichTopComponent(true);
                }
                return EndorsementComponent.Companion.newInstance();
            }
            if (RichTopFragment.this.isMulitLiveTemplate() || RichTopFragment.this.isMultiLive()) {
                if (position == 0) {
                    return RichTopFragment.this.createRichTopComponent(true);
                }
                return FightAllGuestContRankFragment.newInstatnce();
            }
            if (position == 0) {
                return RichTopFragment.this.createRichTopComponent(false);
            }
            return EndorsementComponent.Companion.newInstance();
        }

        public int getCount() {
            return this.mTitleList.size();
        }

        public CharSequence getPageTitle(int position) {
            return this.mTitleList.get(position);
        }

        public Object instantiateItem(ViewGroup container, int position) {
            Fragment fragment = (Fragment)super.instantiateItem(container, position);
            this.registeredFragments.put(position, (Object)fragment);
            return fragment;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            this.registeredFragments.remove(position);
            super.destroyItem(container, position, object);
        }

        public Fragment getRegisteredFragment(int position) {
            return (Fragment)this.registeredFragments.get(position);
        }
    }
}

