/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.model.parser;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import com.example.configcenter.Publess;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.plugin.main.events.LiveGuestPlayTogetherStateClient_onMessageAdd_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.richtext.BaseRichTextFilter;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.richtext.NewChannelAirTicketFilter;
import com.yy.mobile.richtext.NewChannelTextManager;
import com.yy.mobile.richtext.RichTextManager;
import com.yy.mobile.richtext.VipEmoticonFilter;
import com.yy.mobile.richtext.XmlChannelMessage;
import com.yy.mobile.richtext.XmlFilter;
import com.yy.mobile.ui.publicchat.NickClickableSpan;
import com.yy.mobile.ui.publicchat.OnepieceXmlFilter;
import com.yy.mobile.ui.publicchat.handler.ParserUtil;
import com.yy.mobile.ui.publicchat.model.event.AirTicketClickEvent;
import com.yy.mobile.ui.publicchat.model.event.AppendChannelMessageEvent;
import com.yy.mobile.ui.publicchat.model.medal.LiveRoomLoadDrawableWrapper;
import com.yy.mobile.ui.publicchat.model.medal.PublicChatMedalParseManage;
import com.yy.mobile.ui.publicchat.model.parser.IParser;
import com.yy.mobile.ui.publicchat.model.parser.SafetyWarningConfig;
import com.yy.mobile.ui.publicchat.util.RichTextUtil;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.ChannelChatFilter;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.basechannel.IChannelLinkCoreEx;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.ChannelMsgRecvFilter;
import com.yymobile.core.channel.ChatMedalInfo;
import com.yymobile.core.channel.NoticeMessage;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.flower.FlowerChinneMessage;
import com.yymobile.core.gift.GiftChannelMessage;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.medal.MedalBaseEntry;
import com.yymobile.core.medal.MedalCenter;
import com.yymobile.core.medal.MedalNobleEntry;
import com.yymobile.core.medal.MedalTrueLoveEntry;
import com.yymobile.core.medal.PenetrateInfoEntry;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.noble.NobleLevelUpgradeChannelMessage;
import com.yymobile.core.noble.emotion.NobleEmotionFilter;
import com.yymobile.core.noble.emotion.NobleEmotionParser;
import com.yymobile.core.sensitivewords.ISensitiveWordsCore;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PublicChatBaseParser
implements EventCompat,
IParser {
    private static final String TAG = "PublicChatBaseModel";
    public static final String ASSISTANT_CHAT_NICK_COLOR = "#f9af12";
    public static final String GAME_TEMPLATE_CHAT_NICK_COLOR = "#999999";
    public static final String GAME_TEMPLATE_CHAT_GIFT_COLOR = "#f9ba17";
    public static final int GIFT_TEXT_COLOR = Color.parseColor((String)"#7bf0d6");
    public static final int TYPE_NEED_RECORD = 1;
    public static final int TYPE_NO_NEED_RECORD = 0;
    public static final int NORMAL_CHAT = 1;
    public static final int ASSISTANT_CHAT = 2;
    public static final int GAME_TEMPLATE_CHAT = 3;
    public static final int ENTERTAINMENT_PLUB_B_CHAT = 4;
    protected Context mContext;
    protected PublicChatMedalParseManage mMedalParseManage;
    private NewChannelTextManager newChannelTextManager = new NewChannelTextManager();
    protected List<RichTextManager.Feature> features = new CopyOnWriteArrayList<RichTextManager.Feature>();
    private ChannelMsgRecvFilter mChannelMsgRecvFilter = new ChannelMsgRecvFilter();
    public int mChatFilterType = 1;
    public int mHistoryType = 0;
    protected int mGiftMessageImageSize;
    public NewChannelAirTicketFilter.AirSpanClickListener airSpanClickListener = new NewChannelAirTicketFilter.AirSpanClickListener(){

        public void onSpanClick(long topSid, long subSid) {
            MLog.info((Object)PublicChatBaseParser.TAG, (String)("AirSpanClickListener onSpanClick : topSid=" + topSid + " ,subSid=" + subSid), (Object[])new Object[0]);
            if (subSid > 0L ? subSid == ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid : topSid == ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid && subSid == ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid) {
                return;
            }
            if (((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() && ((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).getCurrentTopMicId() == LoginUtil.getUid()) {
                SingleToastUtil.showToast((String)"\u4f60\u76ee\u524d\u6b63\u5728\u76f4\u64ad\u4e2d\uff0c\u4e0d\u80fd\u53bb\u522b\u7684\u76f4\u64ad\u95f4\u5f53\u89c2\u4f17\u54e6");
                return;
            }
            RxBus.getDefault().post((Object)new AirTicketClickEvent(topSid, subSid));
        }
    };

    public PublicChatBaseParser() {
        this.features.add(RichTextManager.Feature.CHANNELAIRTICKET);
        this.features.add(RichTextManager.Feature.EMOTICON);
        this.features.add(RichTextManager.Feature.GROUPTICKET);
        this.features.add(RichTextManager.Feature.NOBLEEMOTION);
        this.features.add(RichTextManager.Feature.NOBLEGIFEMOTION);
        this.mMedalParseManage = new PublicChatMedalParseManage(){

            @Override
            protected SpannableStringBuilder onPreCommonModeParse(SpannableStringBuilder spannable, ChannelMessage message, MedalBaseEntry entity) {
                return PublicChatBaseParser.this.doCommonModeParse(spannable, message, entity);
            }
        };
        this.mMedalParseManage.initModelType();
    }

    @Override
    public boolean parse(@NotNull ChannelMessage message) {
        String chatEmotionUri;
        String emotionStr;
        message.text = message.text.trim();
        if (XmlFilter.checkValid((String)message.text)) {
            message = this.doXmlParse(message);
        } else if (message instanceof PublicChatMessage || ChannelTicketFilter.isChannelTicketMessage((CharSequence)message.text)) {
            message.pureText = message.text;
        }
        if (message instanceof PublicChatMessage) {
            message.pureText = message.text = ParserUtil.fixXmlString(message.text);
        }
        if (!FP.empty((CharSequence)(emotionStr = NobleEmotionParser.getInstance().getNobleEmotionStr(message.text))) && !FP.empty((CharSequence)(chatEmotionUri = NobleEmotionParser.getInstance().getChatEmotionUri(emotionStr)))) {
            message.gifUri = chatEmotionUri;
            message.channelMessageType = ChannelMessage.ChannelMsgType.NOBLEEMOTION_MESSAGE_TYPE;
        }
        message.text = VipEmoticonFilter.replaceVipEmoticonWithGivenStr((String)message.text, (String)"[\u4f1a\u5458\u8868\u60c5]");
        if (LoginUtil.isLogined() && message.uid == LoginUtil.getUid() && ICoreManagerBase.getUserCore().getCacheLoginUserInfo() != null) {
            message.nickname = ICoreManagerBase.getUserCore().getCacheLoginUserInfo().nickName;
        }
        this.appendMsgByType(message);
        this.checkSensitiveWordAndNotice(message);
        return true;
    }

    protected ChannelMessage appendMsgByType(ChannelMessage message) {
        if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.CUSTOMS_MESSAGE_TYPE)) {
            return this.unionCustomMsgType(message);
        }
        SpannableStringBuilder spannable = null;
        if (message.medalEntryList.isEmpty()) {
            PenetrateInfoEntry entry = MedalCenter.getInstance().fourceToPenetrateInfoEntry(message);
            MedalCenter.getInstance().createMedalEntry(message, entry);
        }
        String body = message.text;
        message.text = message.getFormatNick() + this.getNickMessageSpacing() + message.text;
        int contentStart = message.medals.length() + message.nickname.length() + message.tail.length();
        if (message instanceof GiftChannelMessage) {
            this.parseLoadedGiftMessage(this.mContext, (GiftChannelMessage)message, message.nickname, contentStart);
        } else if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.TURNTABLE_MESSAGE_TYPE)) {
            spannable = this.getTurnAbleSpannable(message, contentStart);
        } else if (message instanceof NobleLevelUpgradeChannelMessage || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.TURE_LOVE_TYPE) || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SUBSCRIBE_MESSAGE_TYPE) || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SHARE_MESSAGE_TYPE) || message instanceof FlowerChinneMessage || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.NOBLEEMOTION_MESSAGE_TYPE)) {
            if (message instanceof FlowerChinneMessage) {
                spannable = this.onAppendFlowerChinneMessage(this.mContext, (FlowerChinneMessage)message);
                contentStart = 0;
            } else if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.NOBLEEMOTION_MESSAGE_TYPE)) {
                HashMap entryMap = (HashMap)message.medalEntryList.get(1);
                if (entryMap != null) {
                    MedalNobleEntry entry = (MedalNobleEntry)entryMap.get(1);
                    spannable = entry.getNobleLevel() > 0 || entry.getActNobleType() > 0 ? this.newChannelTextManager.getSpannableString(this.mContext, (CharSequence)message.text, this.features) : new SpannableStringBuilder((CharSequence)message.text);
                }
            } else {
                spannable = new SpannableStringBuilder((CharSequence)message.text);
            }
            if (spannable != null && contentStart < message.text.length() && message.text.length() <= spannable.length()) {
                spannable.setSpan((Object)new ForegroundColorSpan(this.getColorByChannelMessage(message)), contentStart, message.text.length(), 33);
            }
        } else if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.TURNCHAIR_MESSAGE_TYPE) || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.NOTICE_MESSAGE_TYPE)) {
            spannable = this.unionSpannable(message.channelMessageType, message);
        } else if (!TextUtils.isEmpty((CharSequence)body)) {
            spannable = this.newChannelTextManager.getSpannableString(this.mContext, (CharSequence)body, this.features);
            if (null != spannable) {
                RxBus.getDefault().post((Object)new LiveGuestPlayTogetherStateClient_onMessageAdd_EventArgs(spannable, message.uid));
            }
            spannable = new SpannableStringBuilder((CharSequence)message.getFormatNick()).append((CharSequence)this.getNickMessageSpacing()).append((CharSequence)spannable);
        }
        if (spannable != null) {
            message.spannable = this.parseMessageHeader(message, spannable);
        }
        return message;
    }

    protected String getNickMessageSpacing() {
        return " ";
    }

    protected ChannelMessage unionCustomMsgType(ChannelMessage message) {
        return message;
    }

    protected SpannableStringBuilder unionSpannable(ChannelMessage.ChannelMsgType msgType, ChannelMessage message) {
        return message.spannable;
    }

    private void checkSensitiveWordAndNotice(ChannelMessage message) {
        if (this.isContainSensitiveWord(message)) {
            ChannelMessage notice = this.createNoticeMessage();
            RxBus.getDefault().post((Object)new AppendChannelMessageEvent(notice));
        }
    }

    private boolean isContainSensitiveWord(ChannelMessage message) {
        if (message.uid != LoginUtil.getUid() && message instanceof PublicChatMessage) {
            return ((ISensitiveWordsCore)ICoreManagerBase.getCore(ISensitiveWordsCore.class)).containFinanceSensitiveWord(message.pureText);
        }
        return false;
    }

    private ChannelMessage createNoticeMessage() {
        NoticeMessage noticeMessage = new NoticeMessage();
        noticeMessage.channelMessageType = ChannelMessage.ChannelMsgType.NOTICE_MESSAGE_TYPE;
        noticeMessage.text = ((SafetyWarningConfig)Publess.of(SafetyWarningConfig.class).getData()).getContent();
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)noticeMessage.text);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#bae05d")), 0, noticeMessage.text.length(), 33);
        noticeMessage.spannable = spannable;
        return noticeMessage;
    }

    public int getChatFilterType() {
        return this.mChatFilterType;
    }

    public void initModel(Context context) {
        this.onEventBind();
        this.mContext = context;
        this.mGiftMessageImageSize = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)BasicConfig.getInstance().getAppContext());
        this.newChannelTextManager.init(this.airSpanClickListener);
        this.newChannelTextManager.addFilterFeature((BaseRichTextFilter)new NobleEmotionFilter());
    }

    public void deInitModel() {
        this.onEventUnBind();
        this.airSpanClickListener = null;
        this.newChannelTextManager.dispose();
        this.features.clear();
        this.mMedalParseManage = null;
        this.mContext = null;
    }

    private SpannableStringBuilder onAppendFlowerChinneMessage(Context context, FlowerChinneMessage msg) {
        if (context == null) {
            return null;
        }
        int res = R.drawable.icon_xiao_hua;
        HashMap trueloveMap = (HashMap)msg.medalEntryList.get(2);
        if (trueloveMap != null && trueloveMap.get(2) != null && trueloveMap.get(2) instanceof MedalTrueLoveEntry) {
            MedalTrueLoveEntry entry = (MedalTrueLoveEntry)trueloveMap.get(2);
            if (entry.isTrueLoveLv) {
                res = R.drawable.icon_xiao_hua_rose;
            }
        }
        SpannableStringBuilder sp = new SpannableStringBuilder((CharSequence)msg.text);
        Pattern p = Pattern.compile("REPLACE_IMGE_FLAG");
        Matcher m = p.matcher(msg.text);
        while (m.find()) {
            if (msg.nickname.contains("REPLACE_IMGE_FLAG")) continue;
            BitmapDrawable bd = ImageUtil.getBitmapDrawableFromResource((int)this.mGiftMessageImageSize, (int)this.mGiftMessageImageSize, (int)res);
            bd.setBounds(0, 0, this.mGiftMessageImageSize, this.mGiftMessageImageSize);
            if (m.start() >= m.end() || m.end() > sp.length()) continue;
            CustomImageSpan imageSpan = new CustomImageSpan((Drawable)bd, 2.0f);
            sp.setSpan((Object)imageSpan, m.start(), m.end(), 33);
        }
        return sp;
    }

    protected SpannableStringBuilder parseMessageHeader(ChannelMessage message, SpannableStringBuilder spannable) {
        MLog.info((Object)TAG, (String)("[zhk]parseMessageHeader " + spannable.toString()), (Object[])new Object[0]);
        spannable = this.parseMessageHeaderIcon(message, spannable);
        spannable = this.nicknameClick(message, spannable);
        MLog.info((Object)TAG, (String)("[zhk]parseMessageHeader " + spannable.toString()), (Object[])new Object[0]);
        return spannable;
    }

    public SpannableStringBuilder parseMessageHeaderIcon(ChannelMessage message, SpannableStringBuilder spannable) {
        if (message == null || spannable == null || this.mContext == null || this.mMedalParseManage == null) {
            return spannable;
        }
        return this.mMedalParseManage.parseSpannable(this.mContext, message, spannable);
    }

    protected SpannableStringBuilder doCommonModeParse(SpannableStringBuilder spannable, ChannelMessage message, MedalBaseEntry entity) {
        try {
            boolean isReplace;
            if (null != entity && !FP.empty((CharSequence)entity.getNote()) && (isReplace = ((IChannelLinkCoreEx)ICoreManagerBase.getChannelLinkCore()).getSubscribedMutiChannelSSidList().contains(message.sid))) {
                int endIdx;
                boolean isSafeRange;
                int startIdx = spannable.toString().indexOf(entity.getNote());
                boolean bl = isSafeRange = startIdx < (endIdx = startIdx + entity.getNote().length()) && endIdx <= spannable.length();
                if (isSafeRange && startIdx > -1) {
                    spannable.replace(startIdx, endIdx, (CharSequence)"");
                    startIdx = message.medals.indexOf(entity.getNote());
                    endIdx = startIdx + entity.getNote().length();
                    boolean bl2 = isSafeRange = startIdx < endIdx && endIdx <= message.medals.length();
                    if (isSafeRange && startIdx > -1) {
                        message.medals.replace(startIdx, endIdx, "");
                    }
                    message.text = message.text.replace(entity.getNote(), "");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.info((Object)TAG, (String)("doCommonModeParse error :" + e.getMessage()), (Object[])new Object[0]);
        }
        return spannable;
    }

    public SpannableStringBuilder nicknameClick(ChannelMessage message, SpannableStringBuilder spannable) {
        if (message == null || spannable == null || this.mContext == null) {
            return null;
        }
        if (message.nickname.length() > 0) {
            int nickSpanColor = this.getNickColor();
            if (this.isGameTypeOrETPlanBType()) {
                if (!(message instanceof GiftChannelMessage) && message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.COMMON_MESSAGE_TYPE)) {
                    nickSpanColor = Color.parseColor((String)GAME_TEMPLATE_CHAT_NICK_COLOR);
                }
            } else if (message instanceof GiftChannelMessage) {
                nickSpanColor = ((GiftChannelMessage)message).nickSpanColor;
            }
            int start2 = spannable.toString().indexOf(message.nickname);
            int end = start2 + message.nickname.length();
            MLog.info((Object)TAG, (String)("[zhk]nicknameClick " + start2 + " " + end), (Object[])new Object[0]);
            if (start2 >= 0 && end <= spannable.toString().length()) {
                spannable.setSpan((Object)new ForegroundColorSpan(nickSpanColor), start2, end, 33);
            } else {
                MLog.info((Object)TAG, (String)("Message sp value = " + spannable.toString()), (Object[])new Object[0]);
            }
            NickClickableSpan nickClickableSpan = new NickClickableSpan(true, message.uid, (String)message.tailMap.get("hdid"), nickSpanColor, this.isOtherChannelMessage(message.sid));
            if (start2 >= 0 && end <= spannable.toString().length()) {
                spannable.setSpan((Object)nickClickableSpan, start2, end, 33);
            }
        }
        return spannable;
    }

    public void parseLoadedGiftMessage(Context context, final GiftChannelMessage message, String nick, final int contentStart) {
        if (context == null) {
            MLog.info((Object)TAG, (String)"context = null", (Object[])new Object[0]);
            return;
        }
        final String giftIconUrl = GiftConfigParser.getInstance().getGiftIconPath(message.giftTypeId);
        MLog.info((Object)TAG, (String)("giftIconUrl = " + giftIconUrl), (Object[])new Object[0]);
        if (!FP.empty((CharSequence)giftIconUrl)) {
            BitmapDrawable drawable2 = ImageLoader.getBitmapFromCache((String)giftIconUrl, (ImageConfig)ImageConfig.smallImageConfig());
            final String name = nick;
            if (drawable2 != null) {
                this.parseGiftMessage(message, contentStart, name);
            } else {
                final Resources resources = context.getResources();
                this.parseGiftMessage(message, contentStart, name);
                ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)giftIconUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                        MLog.info((Object)PublicChatBaseParser.TAG, (String)("loadBitmap error = " + e.getMessage()), (Object[])new Object[0]);
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        if (bitmap != null) {
                            ImageLoader.addBitmapToCache((String)giftIconUrl, (BitmapDrawable)new BitmapDrawable(resources, bitmap), (ImageConfig)ImageConfig.smallImageConfig());
                            PublicChatBaseParser.this.parseGiftMessage(message, contentStart, name);
                        }
                    }
                });
            }
        } else {
            this.parseGiftMessage(message, contentStart, nick);
        }
    }

    protected void parseGiftMessage(GiftChannelMessage message, int contentStart1, String name) {
        int zu;
        int x;
        if (message == null || this.mContext == null) {
            MLog.info((Object)TAG, (String)("message = " + message + ", mContext = " + this.mContext), (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"parseGiftMessage", (Object[])new Object[0]);
        SpannableStringBuilder sp = message.getSpannableString(this.mContext, R.drawable.lr_ic_default_gift, R.drawable.xunzhang_default_bitmap, this.mGiftMessageImageSize, this.mGiftMessageImageSize);
        if (sp == null) {
            return;
        }
        if (message.type == GiftChannelMessage.GiftType.ComboGift && (x = message.text.lastIndexOf("X")) + 1 < (zu = message.text.lastIndexOf("\u7ec4")) && zu <= sp.length()) {
            sp.setSpan((Object)new AbsoluteSizeSpan(19, true), x + 1, zu, 33);
        }
        try {
            message.nickSpanColor = this.getNickColor();
            if (!FP.empty((Map)message.additional) && message.additional.containsKey("client_show_style_tag") && ((String)message.additional.get("client_show_style_tag")).equals("1")) {
                int contentStart = (TextUtils.isEmpty((CharSequence)message.medals) ? 0 : message.medals.length()) + (TextUtils.isEmpty((CharSequence)message.nickname) ? 0 : message.nickname.length()) + (TextUtils.isEmpty((CharSequence)message.tail) ? 0 : message.tail.length());
                int index = contentStart + 3;
                sp.setSpan((Object)new ForegroundColorSpan(this.getGiftColor()), contentStart, TextUtils.isEmpty((CharSequence)message.text) ? 0 : message.text.length(), 33);
                sp.setSpan((Object)new ForegroundColorSpan(this.isGameTypeOrETPlanBType() ? this.getGiftColor() : this.getNickColor()), index, index + (TextUtils.isEmpty((CharSequence)message.toName) ? 0 : message.toName.length()), 33);
            } else if (!FP.empty((Map)message.additional) && !FP.empty((CharSequence)((CharSequence)message.additional.get("gift_template_type")))) {
                String type2 = (String)message.additional.get("gift_template_type");
                String color2 = "#f1ad43";
                if ("7".equals(type2)) {
                    color2 = "#57cc6a";
                    message.nickSpanColor = -11023254;
                } else if ("6".equals(type2)) {
                    color2 = "#f1ad43";
                    message.nickSpanColor = -938685;
                }
                sp.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)color2)), 0, TextUtils.isEmpty((CharSequence)message.text) ? 0 : message.text.length(), 33);
            } else if (this.mChatFilterType == 1 || this.mChatFilterType == 3) {
                int endLength;
                int start2 = (TextUtils.isEmpty((CharSequence)message.medals) ? 0 : message.medals.length()) + (TextUtils.isEmpty((CharSequence)message.nickname) ? 0 : message.nickname.length());
                int n = endLength = TextUtils.isEmpty((CharSequence)message.text) ? 0 : message.text.length();
                if (start2 > endLength) {
                    start2 = endLength;
                }
                sp.setSpan((Object)new ForegroundColorSpan(this.getGiftColor()), start2, endLength, 33);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        message.spannable = this.parseMessageHeader((ChannelMessage)message, sp);
    }

    protected ChannelInfo getCurrentChannelInfo() {
        return ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
    }

    protected int getNickColor() {
        if (this.mChatFilterType == 2) {
            return Color.parseColor((String)ASSISTANT_CHAT_NICK_COLOR);
        }
        if (this.isGameTypeOrETPlanBType()) {
            return Color.parseColor((String)GAME_TEMPLATE_CHAT_GIFT_COLOR);
        }
        return Color.parseColor((String)"#6DEAFF");
    }

    protected int getGiftColor() {
        return Color.parseColor((String)(this.isGameTypeOrETPlanBType() ? GAME_TEMPLATE_CHAT_GIFT_COLOR : "#7bf0d6"));
    }

    protected boolean isNeedFilterMessage(ChannelMessage message) {
        return ChannelChatFilter.filter((ChannelMessage)message, (ChannelMsgRecvFilter)this.mChannelMsgRecvFilter);
    }

    protected int getColorByChannelMessage(ChannelMessage message) {
        if (message instanceof NobleLevelUpgradeChannelMessage || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.TURE_LOVE_TYPE)) {
            return Color.parseColor((String)"#7bf0d6");
        }
        if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SUBSCRIBE_MESSAGE_TYPE) || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SHARE_MESSAGE_TYPE) || message instanceof FlowerChinneMessage) {
            return this.getNickColor();
        }
        return 0;
    }

    private SpannableStringBuilder getTurnAbleSpannable(ChannelMessage message, int contentStart) {
        SpannableStringBuilder spannable = null;
        if (this.mContext != null) {
            int iconIdx;
            spannable = this.newChannelTextManager.getSpannableString(this.mContext, (CharSequence)message.text, this.features);
            if (contentStart < spannable.length()) {
                spannable.setSpan((Object)new ForegroundColorSpan(GIFT_TEXT_COLOR), contentStart, spannable.length(), 33);
            }
            if ((iconIdx = message.text.indexOf("[lft]")) > -1) {
                Drawable turntableIcon = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), R.drawable.turntable_icon);
                if (turntableIcon != null) {
                    turntableIcon.setBounds(0, 0, turntableIcon.getIntrinsicWidth(), turntableIcon.getIntrinsicHeight());
                }
                if ("[lft]".length() + iconIdx <= spannable.length()) {
                    spannable.setSpan((Object)new CustomImageSpan(turntableIcon, 2, 0.0f, ResolutionUtils.convertDpToPixel((float)6.0f, (Context)this.mContext)), iconIdx, iconIdx + "[lft]".length(), 33);
                }
            }
        }
        return spannable;
    }

    private ChannelMessage doXmlParse(ChannelMessage message) {
        String filterText;
        String tempXmlStr = message.text;
        XmlChannelMessage xmlChannelMessage = OnepieceXmlFilter.parseOnepieceChannelMessage(message.text);
        message.text = xmlChannelMessage.text;
        if (message instanceof PublicChatMessage || ChannelTicketFilter.isChannelTicketMessage((CharSequence)message.text)) {
            message.pureText = xmlChannelMessage.text;
        }
        if (!TextUtils.isEmpty((CharSequence)(filterText = RichTextUtil.filterEmotion(message.text)))) {
            message.text = filterText;
        }
        PenetrateInfoEntry entry = MedalCenter.getInstance().parserPenetrateInfoV4(xmlChannelMessage, tempXmlStr);
        MedalCenter.getInstance().createMedalEntry(message, entry);
        List commonMedals = xmlChannelMessage.commonMedals;
        if (commonMedals != null) {
            message.commonMedals = new ArrayList();
            for (Map map : commonMedals) {
                ChatMedalInfo info = new ChatMedalInfo(map);
                message.commonMedals.add(info);
            }
        }
        return message;
    }

    protected boolean isOtherChannelMessage(long sid) {
        return ((IChannelLinkCoreEx)ICoreManagerBase.getChannelLinkCore()).getSubscribedMutiChannelSSidList().contains(sid);
    }

    public void decorateNickNameBeforeParse(ChannelMessage message) {
        if (message != null && !FP.empty((CharSequence)message.nickname)) {
            if (this.getChatFilterType() == 2) {
                message.nickname = message.nickname + " :";
            } else if (this.isGameTypeOrETPlanBType() && !message.nickname.endsWith(":") && message instanceof PublicChatMessage && message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.COMMON_MESSAGE_TYPE)) {
                message.nickname = message.nickname + ":";
            }
        }
    }

    public boolean isGameTypeOrETPlanBType() {
        return this.mChatFilterType == 3 || this.mChatFilterType == 4;
    }

    public void onEventBind() {
    }

    public void onEventUnBind() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HistoryType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChatType {
    }
}

