/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.handler;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.publicchat.NickClickableSpan;
import com.yy.mobile.ui.publicchat.model.medal.LiveRoomLoadDrawableWrapper;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCoreEx;
import com.yymobile.core.cavalier.ITaskCore;
import com.yymobile.core.cavalier.TaskCoreProxy;
import com.yymobile.core.cavalier.TaskProtocol;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.config.PublicChatUtils;
import com.yymobile.core.medal.MedalBaseEntry;
import com.yymobile.core.medal.MedalTailEntry;
import java.util.HashMap;
import java.util.Map;

public final class ParserUtil {
    private static int mMedalIconSize = (int)ResolutionUtils.convertDpToPixel((float)16.0f, (Context)BasicConfig.getInstance().getAppContext());

    public static SpannableStringBuilder generateEnterSpannable(ChannelMessage info, String tail) {
        int idx;
        String text = " \u6765\u4e86";
        if (!tail.isEmpty()) {
            text = tail;
        }
        if (info == null) {
            return new SpannableStringBuilder((CharSequence)text);
        }
        int medalWallMedalId = 0;
        StringBuilder nickname = new StringBuilder(info.nickname);
        for (Map.Entry entryPriority : info.medalEntryList.entrySet()) {
            HashMap medalsMap = (HashMap)entryPriority.getValue();
            for (Map.Entry entry : medalsMap.entrySet()) {
                MedalBaseEntry entity = (MedalBaseEntry)entry.getValue();
                if (entity.getParserType() != 5) continue;
                nickname.append(entity.getNote());
                medalWallMedalId = ((MedalTailEntry)entity).getUserMedalWallMaxPriorityId();
            }
        }
        text = nickname.append(text).toString();
        String from = "";
        if (info.tailMap.containsKey("from")) {
            from = (String)info.tailMap.get("from");
        }
        if ("near_by_live".equals(from)) {
            text = "\u9644\u8fd1\u7684 " + text;
        }
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        int start2 = spannable.toString().indexOf(info.nickname);
        int end = start2 + info.nickname.length();
        if (start2 >= 0 && end <= spannable.toString().length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, info.uid, (String)info.tailMap.get("hdid"), ParserUtil.isOtherChannelMessage(info.sid)), start2, end, 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#6DEAFF")), 0, spannable.length(), 33);
        if (medalWallMedalId > 0 && (idx = spannable.toString().indexOf("[knight]")) > -1) {
            Drawable songDrawable = null;
            String url = ((ITaskCore)ICoreManagerBase.getCore(ITaskCore.class)).getMedalIdUrl(medalWallMedalId, TaskProtocol.MEDAL_TYPE.MOB_TAILLIGHT);
            if (!TextUtils.isEmpty((CharSequence)url)) {
                songDrawable = TaskCoreProxy.newInstance().getMedalDrawableByUrl(url);
            }
            int paddingLeft = PublicChatUtils.tailMarginLeft;
            int paddingRight = PublicChatUtils.tailMarginRight;
            if (songDrawable != null) {
                songDrawable.setBounds(0, 0, mMedalIconSize, mMedalIconSize);
            } else {
                paddingLeft = 0;
                paddingRight = 0;
                songDrawable = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), R.drawable.xunzhang_default_bitmap);
                if (songDrawable != null) {
                    songDrawable.setBounds(0, 0, 1, 1);
                }
            }
            spannable.setSpan((Object)new CustomImageSpan(songDrawable, 2, (float)paddingLeft, (float)paddingRight), idx, idx + "[knight]".length(), 33);
        }
        return spannable;
    }

    public static Drawable createBusinessIconDrawable(int resId, int widthDp, int heightDp) {
        if (0 == resId || widthDp == 0 || heightDp == 0) {
            return null;
        }
        Drawable businessDrawable = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), resId);
        if (businessDrawable != null && widthDp > 0 && heightDp > 0) {
            businessDrawable.setBounds(0, 0, (int)ResolutionUtils.convertDpToPixel((float)widthDp, (Context)BasicConfig.getInstance().getAppContext()), (int)ResolutionUtils.convertDpToPixel((float)heightDp, (Context)BasicConfig.getInstance().getAppContext()));
        }
        return businessDrawable;
    }

    public static boolean isOtherChannelMessage(long sid) {
        return ((IChannelLinkCoreEx)ICoreManagerBase.getChannelLinkCore()).getSubscribedMutiChannelSSidList().contains(sid);
    }

    public static boolean isShowIcon(ChannelMessage message) {
        return true;
    }

    public static String fixXmlString(String string2) {
        if (string2 == null || string2.length() == 0) {
            return string2;
        }
        try {
            string2 = string2.replaceAll("&lt;", "<");
            string2 = string2.replaceAll("&gt;", ">");
            string2 = string2.replaceAll("&apos;", "'");
            string2 = string2.replaceAll("&quot;", "\"");
        }
        catch (Throwable throwable) {
            MLog.error((Object)"XmlFilter", (String)("fixXmlString error!" + throwable), (Object[])new Object[0]);
        }
        return string2;
    }
}

