/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugins;

import android.app.Activity;
import android.os.Bundle;
import android.view.ViewGroup;
import com.yy.mobile.liveapi.plugins.IPluginRenderApi;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.plugins.BasePluginViewController;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.yyapi.PluginRenderApiImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BasePluginsComponent
extends Component {
    private static final String TAG = "BasePluginsComponent";
    protected static final int ON_PAUSE_ACTION = 0;
    protected static final int ON_RESUME_ACTION = 1;
    protected static final int ON_DESTROY_ACTION = 2;
    protected static final int ON_ORIENTATION_CHANGED_ACTION = 3;
    protected static final List<Class<? extends BasePluginViewController>> CONTROLLER_CLASSES = Arrays.asList(new Class[0]);
    protected boolean isHost;
    protected String pluginId;
    protected List<BasePluginViewController> mControllers = new ArrayList<BasePluginViewController>();

    protected void initController(ViewGroup containerView, Bundle savedInstanceState) {
        PluginRenderApiImpl impl = (PluginRenderApiImpl)CoreApiManager.getInstance().getApi(IPluginRenderApi.class);
        if (impl != null) {
            impl.init(this.hashCode());
            for (Class<? extends BasePluginViewController> clazz : CONTROLLER_CLASSES) {
                BasePluginViewController c = null;
                try {
                    c = clazz.getConstructor(Integer.TYPE).newInstance(1);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)"Create plugin view controller error", (Throwable)e, (Object[])new Object[0]);
                }
                if (c == null) continue;
                c.attach((Activity)this.getActivity());
                c.init((Activity)this.getActivity(), containerView, savedInstanceState);
                this.mControllers.add(c);
                impl.addPluginController(this.isHost, c);
            }
        }
    }

    protected void onControllerAction(int action2, boolean isLandscape) {
        PluginRenderApiImpl impl = (PluginRenderApiImpl)CoreApiManager.getInstance().getApi(IPluginRenderApi.class);
        if (impl == null) {
            MLog.error((Object)TAG, (String)"onControllerAction return, api is null", (Object[])new Object[0]);
            return;
        }
        BasePluginViewController controller = impl.getCurrentUsingController(this.isHost);
        if (controller != null) {
            switch (action2) {
                case 0: {
                    controller.onPause();
                    break;
                }
                case 1: {
                    controller.onResume();
                    break;
                }
                case 2: {
                    controller.onDestroy();
                    if (impl == null) break;
                    impl.clearPluginController(controller.getPluginId(), this.isHost);
                    break;
                }
                case 3: {
                    controller.orientationChanged(isLandscape);
                    break;
                }
            }
        }
    }

    public void onPause() {
        super.onPause();
        this.onControllerAction(0, false);
    }

    public void onResume() {
        super.onResume();
        this.onControllerAction(1, false);
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        this.onControllerAction(2, false);
        this.resetPluginRender();
    }

    private void resetPluginRender() {
        PluginRenderApiImpl impl = (PluginRenderApiImpl)CoreApiManager.getInstance().getApi(IPluginRenderApi.class);
        if (impl != null) {
            impl.reset(this.hashCode());
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        this.onControllerAction(3, isLandscape);
    }
}

