/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugins;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.android.small.Small;
import com.yy.mobile.plugin.PluginCenter;
import com.yy.mobile.plugin.PluginInfo;
import com.yy.mobile.plugin.Plugins;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.util.log.MLog;
import java.util.Map;
import javax.annotation.Nonnull;

public class BasePluginViewController
extends AbstractViewController {
    private static final String TAG = "BasketballController";
    Bundle bundle;
    private int mType = 0;
    private ViewGroup rootView;
    private PluginInfo mPlugin;
    private String mPluginId;
    private long mTaskId;

    public BasePluginViewController(int type2, String pluginId, long taskId) {
        this.mType = type2;
        this.mPlugin = Plugins.fromPluginId((String)pluginId);
        this.mPluginId = pluginId;
        this.mTaskId = taskId;
    }

    public void init(Activity context, ViewGroup viewGroup, Bundle savedInstanceState) {
        this.rootView = viewGroup;
        this.bundle = savedInstanceState;
    }

    @Nonnull
    private Map<String, String> getPluginCenterActionMap() {
        return this.mPlugin != null ? this.mPlugin.pluginCenterActionMap() : PluginCenter.defaultActionMap();
    }

    public void deliverViewGroupToPlugin() {
        MLog.info((Object)TAG, (String)"deliverViewGroupToPlugin", (Object[])new Object[0]);
        String action2 = this.getPluginCenterActionMap().get("ACTION_PLUGIN_VIEW");
        this.smallStart(action2, this.getActivity(), this.bundle, this.rootView, this.mType);
    }

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.bundle = savedInstanceState;
        return this.rootView;
    }

    protected void onPause() {
        super.onPause();
        String action2 = this.getPluginCenterActionMap().get("ACTION_PLUGIN_VIEW");
        this.smallOnPuse(action2, this.mType);
    }

    protected void onResume() {
        super.onResume();
        String action2 = this.getPluginCenterActionMap().get("ACTION_PLUGIN_VIEW");
        this.smallOnResume(action2, this.mType);
    }

    public void orientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        String action2 = this.getPluginCenterActionMap().get("ACTION_PLUGIN_VIEW");
        this.smallOnOrientationChanged(action2, isLandscape, this.mType);
    }

    protected void onDestroy() {
        super.onDestroy();
        String action2 = this.getPluginCenterActionMap().get("ACTION_PLUGIN_VIEW");
        this.smallOnDestroy(action2, this.mType);
    }

    private void smallStart(String action2, Activity activity, Bundle savedInstanceState, ViewGroup parentView, int type2) {
        if (activity != null) {
            Intent intent = new Intent(action2);
            intent.putExtra("command", "onShow");
            intent.putExtra("LIVE_STATE_KEY", type2);
            this.putBaseInfo(intent);
            Small.startAction((Intent)intent, (Activity)activity, (ViewGroup)parentView);
        }
    }

    private void smallOnDestroy(String action2, int type2) {
        Intent intent = new Intent(action2);
        intent.putExtra("command", "onDestroy");
        Bundle params = new Bundle();
        params.putInt("LIVE_STATE_KEY", type2);
        this.putBaseInfo(intent);
        Small.startAction((Intent)intent, null);
    }

    private void smallOnOrientationChanged(String action2, boolean isLandscape, int type2) {
        Intent intent = new Intent(action2);
        intent.putExtra("command", "onOrientationChanged");
        intent.putExtra("ON_ORIENTATION_CHANGED_KEY", isLandscape);
        intent.putExtra("LIVE_STATE_KEY", type2);
        this.putBaseInfo(intent);
        Small.startAction((Intent)intent, null);
    }

    private void smallOnResume(String action2, int type2) {
        Intent intent = new Intent(action2);
        intent.putExtra("command", "onResume");
        Bundle params = new Bundle();
        params.putInt("LIVE_STATE_KEY", type2);
        this.putBaseInfo(intent);
        Small.startAction((Intent)intent, null);
    }

    private void smallOnPuse(String action2, int type2) {
        Intent intent = new Intent(action2);
        intent.putExtra("command", "onPause");
        Bundle params = new Bundle();
        params.putInt("LIVE_STATE_KEY", type2);
        this.putBaseInfo(intent);
        Small.startAction((Intent)intent, null);
    }

    private Intent putBaseInfo(Intent intent) {
        intent.putExtra("pluginid", this.mPluginId);
        intent.putExtra("taskid", this.mTaskId);
        return intent;
    }

    public String getPluginId() {
        return this.mPluginId;
    }

    public long getTaskId() {
        return this.mTaskId;
    }
}

