/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.noble;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.streamlight.EntIdentityIconSet;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;

public class NobleShoutingView {
    private final int offsetX = (int)ResolutionUtils.convertDpToPixel((float)130.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int lifeRunTime = 5000;
    private FrameLayout mView;
    private View mFixedView;
    private RecycleImageView itemBgRiv;
    private RecycleImageView nobleTypeRiv;
    private TextView nobleUserNick;
    private TextView nameTxt;
    private ViewStub viewStub;
    private boolean viewStubIsInflate = false;
    private boolean isLifeRun = false;
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.myLooper());
    private Runnable viewStateRunnable = new Runnable(){

        @Override
        public void run() {
            NobleShoutingView.this.isLifeRun = false;
            NobleShoutingView.this.mView.setVisibility(4);
            if (NobleShoutingView.this.mCustomView != null) {
                NobleShoutingView.this.mView.removeView(NobleShoutingView.this.mCustomView);
                NobleShoutingView.this.mCustomView = null;
                NobleShoutingView.this.mCustomParams = null;
            }
        }
    };
    private View mCustomView;
    private ViewGroup.LayoutParams mCustomParams;
    private ViewGroup.LayoutParams mDefaultParams;

    public NobleShoutingView(Context context, View parent) {
        this.viewStub = new ViewStub(context);
        this.viewStub.setLayoutResource(R.layout.item_noble_shouting);
        ((ViewGroup)parent).addView((View)this.viewStub);
    }

    public View getRootView() {
        if (!this.viewStubIsInflate) {
            this.viewStubIsInflate = true;
            this.mView = (FrameLayout)this.viewStub.inflate();
            this.init();
        }
        return this.mView;
    }

    public void setRootViewLayoutParams(ViewGroup.LayoutParams params) {
        this.mDefaultParams = params;
        this.getRootView().setLayoutParams(params);
    }

    public void start() {
        if (this.mView == null) {
            return;
        }
        this.initViewParams();
        ObjectAnimator transAnimator = ObjectAnimator.ofFloat((Object)this.mView, (String)"translationX", (float[])new float[]{-this.offsetX, 0.0f});
        transAnimator.setDuration(250L);
        transAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator2) {
                NobleShoutingView.this.mView.setVisibility(0);
            }
        });
        transAnimator.start();
        this.isLifeRun = true;
        this.handler.removeCallbacks(this.viewStateRunnable);
        this.handler.postDelayed(this.viewStateRunnable, 5000L);
    }

    public void init() {
        this.mFixedView = this.mView.findViewById(R.id.rl_fixed);
        this.itemBgRiv = (RecycleImageView)this.mView.findViewById(R.id.item_bg_riv);
        this.nobleTypeRiv = (RecycleImageView)this.mView.findViewById(R.id.noble_type_riv);
        this.nobleUserNick = (TextView)this.mView.findViewById(R.id.noble_user_nick);
        this.nameTxt = (TextView)this.mView.findViewById(R.id.nameTxt);
        this.mView.setVisibility(4);
    }

    public void onDisponse() {
        this.handler.removeCallbacksAndMessages(null);
    }

    public void setNobleType(int type2) {
        int resid = EntIdentityIconSet.getIconResId((int)type2, (int)120);
        if (resid > 0) {
            ImageLoader.loadImageResource((int)resid, (RecycleImageView)this.nobleTypeRiv, (ImageConfig)ImageConfig.defaultImageConfig());
        }
    }

    public void setNobleNick(String nick) {
        this.nobleUserNick.setText((CharSequence)nick);
    }

    public void setMessage(String msg) {
        this.nameTxt.setText((CharSequence)msg);
    }

    public boolean isRun() {
        return this.isLifeRun;
    }

    public void setCustomView(View customView, ViewGroup.LayoutParams customParams) {
        this.mCustomView = customView;
        this.mCustomParams = customParams;
    }

    private void initViewParams() {
        if (this.mCustomView != null) {
            this.mFixedView.setVisibility(8);
            this.mView.addView(this.mCustomView);
        } else {
            this.mFixedView.setVisibility(0);
        }
        this.mView.setLayoutParams(this.mCustomParams != null ? this.mCustomParams : this.mDefaultParams);
    }
}

