/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive.danmumvp;

import android.os.Bundle;
import com.yy.live.helper.DialogFactory;
import com.yy.live.module.giftdanmu.ChannelAirFilter;
import com.yy.mobile.ui.basicgunview.BaseDanMuComponent;
import com.yy.mobile.ui.basicgunview.danmuopengl.gunpower.DanMuItemStub;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuClickListener;
import com.yy.mobile.ui.mobilelive.danmumvp.ReplayDanMuUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.live.LiveCore.JoinChannelIntent;
import com.yymobile.core.mobilelive.IMobileLiveReplayDanmuCore;
import java.util.List;

public class ReplayDanMuComponent
extends BaseDanMuComponent {
    private static final String TAG = "ReplayDanMuComponent";
    protected IDanmuClickListener liveDanmuClickListener = new IDanmuClickListener(){

        public void setOnClickListener(DanMuItemStub stub) {
            String content = stub.content;
            if (content == null) {
                return;
            }
            try {
                ChannelAirFilter.ChannelTicketInfo channelTicketInfo;
                List<ChannelAirFilter.ChannelTicketInfo> infos = ChannelAirFilter.parseChannelTicket(content);
                long topSid = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid;
                long subSid = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid;
                if (infos != null && infos.size() > 0 && (channelTicketInfo = infos.get(0)) != null && (channelTicketInfo.sid != topSid || channelTicketInfo.subSid != subSid)) {
                    DialogFactory dialogFactory = new DialogFactory(ReplayDanMuComponent.this.getContext());
                    dialogFactory.showOkCancelDialog("\u662f\u5426\u5207\u6362\u9891\u9053\uff1f", "\u786e\u5b9a", "\u53d6\u6d88", true, new DialogFactory.OkCancelDialogListener(){

                        @Override
                        public void onCancel() {
                        }

                        @Override
                        public void onOk() {
                            JoinChannelIntent.instance((long)channelTicketInfo.sid, (long)channelTicketInfo.subSid).src("90001").build().joinChannel(ReplayDanMuComponent.this.getContext());
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)ReplayDanMuComponent.TAG, (Throwable)throwable);
            }
        }
    };
    private IMobileLiveReplayDanmuCore mobileLiveReplayDanmuCore;

    public static ReplayDanMuComponent newInstance() {
        return new ReplayDanMuComponent();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MLog.info((Object)TAG, (String)"onCreate", (Object[])new Object[0]);
        this.mobileLiveReplayDanmuCore = (IMobileLiveReplayDanmuCore)ICoreManagerBase.getCore(IMobileLiveReplayDanmuCore.class);
    }

    @Override
    public void initView() {
        this.mobileLiveReplayDanmuCore.setContext(this.getContext());
        ReplayDanMuUtil.getInstance().setSurfaceView(this.isSurfaceView);
        ReplayDanMuUtil.getInstance().setDanmuView(this.tanmuView);
        if (this.shouldDanmuShow()) {
            this.mobileLiveReplayDanmuCore.addClient();
            this.mobileLiveReplayDanmuCore.onReceiveStatus(true);
            ReplayDanMuUtil.getInstance().open(true);
        } else {
            this.mobileLiveReplayDanmuCore.removeClient();
            this.mobileLiveReplayDanmuCore.onReceiveStatus(false);
            ReplayDanMuUtil.getInstance().open(false);
        }
        this.tanmuView.setOnClickListener(this.liveDanmuClickListener);
        this.tanmuView.queryDanmuOpenStatus(ReplayDanMuUtil.getInstance().getDanmuOpenStatus(1));
    }

    @Override
    protected void doBgShow(boolean show2) {
    }

    @Override
    protected void onLandscape() {
        if (this.mobileLiveReplayDanmuCore != null) {
            this.mobileLiveReplayDanmuCore.addClient();
            this.mobileLiveReplayDanmuCore.onReceiveStatus(true);
        }
        ReplayDanMuUtil.getInstance().open(true);
    }

    @Override
    protected void onPortrait() {
        if (this.mobileLiveReplayDanmuCore != null) {
            this.mobileLiveReplayDanmuCore.removeClient();
            this.mobileLiveReplayDanmuCore.onReceiveStatus(false);
        }
        ReplayDanMuUtil.getInstance().open(false);
    }

    @Override
    protected boolean doSuperJoinChannelSuccess() {
        return false;
    }

    @Override
    protected void initJoinChannelSuccess() {
    }

    @Override
    protected boolean isReplayDanmuConfig() {
        return true;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.shouldDanmuShow()) {
            if (this.mobileLiveReplayDanmuCore != null) {
                this.mobileLiveReplayDanmuCore.addClient();
                this.mobileLiveReplayDanmuCore.onReceiveStatus(true);
            }
            ReplayDanMuUtil.getInstance().open(true);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.mobileLiveReplayDanmuCore != null) {
            this.mobileLiveReplayDanmuCore.onReceiveStatus(false);
        }
        ReplayDanMuUtil.getInstance().open(false);
        ReplayDanMuUtil.getInstance().stopDanmu();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (this.mobileLiveReplayDanmuCore != null) {
            this.mobileLiveReplayDanmuCore.onReceiveStatus(false);
            this.mobileLiveReplayDanmuCore.removeClient();
        }
        ReplayDanMuUtil.getInstance().setSurfaceView(false);
        ReplayDanMuUtil.getInstance().open(false);
        ReplayDanMuUtil.getInstance().stopDanmu();
        ReplayDanMuUtil.getInstance().setDanmuView(null);
        if (this.mobileLiveReplayDanmuCore != null) {
            this.mobileLiveReplayDanmuCore.setContext(null);
        }
        ReplayDanMuUtil.getInstance().clear();
    }

    @Override
    public boolean isDanmuEnabled() {
        return ReplayDanMuUtil.getInstance().isDanmuEnabled();
    }
}

