/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.channel.core.AbsChannelControllerCore;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onDeleteMobileLiveReplayHistories_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onDeleteMobileLiveReplaySuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_replayReportFinish_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_replayReport_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveReplayClient_onReplayPlaying_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveReplayClient_onReplaySeekbarChanged_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveReplayClient_onReplayTimeChanged_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.ISongChooseClient_onHideReplayController_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.basicfunction.report.ReplayReportModule;
import com.yy.mobile.ui.mobilelive.ReplayControlFragment$$EventBinder;
import com.yy.mobile.ui.mobilelive.SpdtReplayFragmentStyle;
import com.yy.mobile.ui.mobilelive.replay.ReplayControlComponentBehavior;
import com.yy.mobile.ui.mobilelive.replay.ReplayProgramInfoPresenter;
import com.yy.mobile.ui.mobilelive.replay.ReplayVideoComponentProxy;
import com.yy.mobile.ui.programinfo.ProgramInfoFragment;
import com.yy.mobile.ui.utils.DurationUtils;
import com.yy.mobile.ui.utils.StringUtil;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.live.LiveCore.JoinChannelIntent;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.user.UserInfo;
import java.io.File;

public class ReplayControlFragment
extends Component
implements ReplayControlComponentBehavior {
    public static final String FRAGMENT_TAG = "com.yy.yyent.tag.ReplayControlFragment";
    public static final String TAG = "ReplayControlFragment";
    public String mProgamId;
    public String mLoadingBackgroundImgUrl;
    public String mReplayTitle;
    private View mRootView;
    private TextView mRestTime;
    private TextView mPlayTime;
    private SeekBar mSeekBar;
    private View mProgressLayout;
    private String mMobileLiveTitle;
    private long mUid;
    private long mOwnUid = 0L;
    private String mStoreReason;
    private View mBtnLeave;
    private MediaPlayer shootMP;
    private ProgramInfoFragment mProgramInfoFragment;
    private ReplayProgramInfoPresenter mReplayProgramInfoPresenter;
    private ReplayVideoComponentProxy mReplayVideoComponentProxy;
    private long tid;
    private long sid;
    private long startTime;
    private int mCurrentReplayIndex = 0;
    private ReplayReportModule mReportModel;
    private int mCurrentTime;
    private int mVideoDuration;
    private int mReportingPlayStatus;
    private int showProgressTime = 5000;
    private Runnable hideProgressTask;
    private boolean isFirstPlaying = true;
    private Boolean isMyRequest = false;
    private ReplayControlFragmentEvents mReplayControlFragmentEvents;
    private LinearLayout mLiveStatusLayout;
    private ImageView mIvAudioStream;
    private String onShareStyle = "00";
    private UserInfo userInfo;
    private String mShareTitle;
    private String mShareText;
    private String mImageUrl;
    public View anchorHeadInfoView;
    private EventBinder mReplayControlFragmentSniperEventBinder;

    public static ReplayControlFragment newInstance() {
        ReplayControlFragment fragment = new ReplayControlFragment();
        Bundle bundle = new Bundle();
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setVideoPlayComponentProxy(ReplayVideoComponentProxy playComponentProxy) {
        this.mReplayVideoComponentProxy = playComponentProxy;
    }

    @Override
    public void updateProgressShowStatus(Boolean show2) {
        if (this.mProgressLayout != null) {
            if (show2.booleanValue()) {
                this.mProgressLayout.setVisibility(0);
            } else {
                this.mProgressLayout.setVisibility(4);
            }
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof ReplayControlFragmentEvents) {
            this.mReplayControlFragmentEvents = (ReplayControlFragmentEvents)context;
        }
    }

    public void onDetach() {
        this.mReplayControlFragmentEvents = null;
        super.onDetach();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        MLog.info((Object)TAG, (String)"onCreateView", (Object[])new Object[0]);
        this.mRootView = inflater.inflate(this.getRootLayoutResId(), container, false);
        this.anchorHeadInfoView = this.mRootView.findViewById(R.id.fl_anchor_head_info);
        if (this.getActivity().getIntent().hasExtra("data_replay_uid")) {
            this.mUid = this.getActivity().getIntent().getLongExtra("data_replay_uid", 0L);
            MLog.info((Object)TAG, (String)("mUid=" + this.mUid), (Object[])new Object[0]);
            this.updateProgramInfo(this.mUid);
        }
        if (this.getActivity().getIntent().hasExtra("data_replay_title")) {
            this.mMobileLiveTitle = this.getActivity().getIntent().getStringExtra("data_replay_title");
            MLog.info((Object)TAG, (String)("mMobileLiveTitle=" + this.mMobileLiveTitle), (Object[])new Object[0]);
        }
        if (this.getActivity().getIntent().hasExtra("data_replay_id")) {
            this.mProgamId = this.getActivity().getIntent().getStringExtra("data_replay_id");
            MLog.info((Object)TAG, (String)("mProgamId= " + this.mProgamId), (Object[])new Object[0]);
            this.mReplayProgramInfoPresenter.setPid(this.mProgamId);
        }
        this.mRestTime = (TextView)this.mRootView.findViewById(R.id.rest_time);
        this.mPlayTime = (TextView)this.mRootView.findViewById(R.id.play_time);
        this.mSeekBar = (SeekBar)this.mRootView.findViewById(R.id.mediacontroller_progress);
        this.mSeekBar.setProgressDrawable(this.getResources().getDrawable(((SpdtReplayFragmentStyle)Spdt.of(SpdtReplayFragmentStyle.class)).getSeekBarBackground()));
        this.mBtnLeave = this.mRootView.findViewById(R.id.btn_leave);
        this.mProgressLayout = this.mRootView.findViewById(R.id.replay_progress_layout);
        this.mLiveStatusLayout = (LinearLayout)this.mRootView.findViewById(R.id.mLiveStatusLayout);
        int statusColor = Spdt.color((int)R.color.leave_channel_text);
        ((TextView)this.mRootView.findViewById(R.id.tv_live_status)).setTextColor(statusColor);
        this.mIvAudioStream = (ImageView)this.mRootView.findViewById(R.id.mIvAudioStream);
        this.mBtnLeave.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReplayControlFragment.this.getActivity().finish();
                if (ReplayControlFragment.this.mReplayControlFragmentEvents != null) {
                    ReplayControlFragment.this.mReplayControlFragmentEvents.onClickClose();
                }
            }
        });
        this.mSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                ReplayControlFragment.this.removeHideProgressTask();
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                int progress = seekBar.getProgress();
                if (progress == seekBar.getMax()) {
                    progress -= 2;
                }
                if (ReplayControlFragment.this.checkNetToast() && ReplayControlFragment.this.mReplayVideoComponentProxy != null) {
                    ReplayControlFragment.this.mReplayVideoComponentProxy.seekTo(progress);
                    ReplayControlFragment.this.mReplayVideoComponentProxy.resumePlayer(false);
                    RxBus.getDefault().post((Object)new IMobileLiveReplayClient_onReplaySeekbarChanged_EventArgs(progress));
                }
                MLog.info((Object)ReplayControlFragment.TAG, (String)"YYPlayer setTime  time=%d ", (Object[])new Object[]{progress});
                ReplayControlFragment.this.setHideProgressTask();
            }
        });
        ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).requestProfile(this.mUid);
        return this.mRootView;
    }

    protected int getRootLayoutResId() {
        return R.layout.fragment_mobilelive_replay;
    }

    @BusEvent
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs eventArgs) {
        final EntUserInfo info = eventArgs.getInfo();
        if (info == null || info.uid != this.mUid) {
            return;
        }
        MLog.info((Object)TAG, (String)("\u5f53\u524d\u76f4\u64ad\u72b6\u6001\uff1a" + info.isLiving), (Object[])new Object[0]);
        if (info.isLiving == 1) {
            if (this.mLiveStatusLayout != null && this.mIvAudioStream != null) {
                this.mLiveStatusLayout.setVisibility(0);
                AnimationDrawable drawable2 = (AnimationDrawable)this.mIvAudioStream.getDrawable();
                drawable2.start();
                this.mLiveStatusLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ReplayControlFragment.this.checkNetToast()) {
                            MLog.info((Object)ReplayControlFragment.TAG, (String)("onClick anchorInfo " + info), (Object[])new Object[0]);
                            long ssid = 0L;
                            long sid = 0L;
                            if (info.isLiving == 1 && info.topId > 0L) {
                                sid = info.topId;
                                ssid = info.subId;
                            } else if (info.roomIdLong > 0L) {
                                sid = info.roomIdLong;
                                ssid = info.roomIdLong;
                            } else if (StringUtils.safeParseLong((String)info.signChLong) > 0L) {
                                sid = StringUtils.safeParseLong((String)info.signChLong);
                                ssid = StringUtils.safeParseLong((String)info.signChLong);
                            }
                            if (sid > 0L && ssid > 0L && ReplayControlFragment.this.getActivity() != null) {
                                JoinChannelIntent.instance((long)sid, (long)ssid).build().joinChannel((Context)ReplayControlFragment.this.getActivity());
                                ReplayControlFragment.this.getActivity().finish();
                            }
                        }
                    }
                });
            }
        } else if (this.mLiveStatusLayout != null) {
            this.mLiveStatusLayout.setVisibility(8);
        }
    }

    public void onStop() {
        super.onStop();
        MLog.info((Object)TAG, (String)"onStop", (Object[])new Object[0]);
    }

    public void onDestroyView() {
        MLog.info((Object)TAG, (String)"onDestroyView", (Object[])new Object[0]);
        this.mProgramInfoFragment = null;
        super.onDestroyView();
        this.removeHideProgressTask();
        Object var2_1 = null;
        if (this.mReplayControlFragmentSniperEventBinder != null) {
            this.mReplayControlFragmentSniperEventBinder.unBindEvent();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        if (this.mReportModel != null) {
            this.mReportModel.destroy();
            this.mReportModel = null;
        }
    }

    public void shootSound() {
        AudioManager meng = (AudioManager)this.getContext().getSystemService("audio");
        int volume = meng.getStreamVolume(5);
        if (volume != 0) {
            if (this.shootMP == null) {
                this.shootMP = MediaPlayer.create((Context)this.getContext(), (Uri)Uri.parse((String)"file:///system/media/audio/ui/camera_click.ogg"));
            }
            if (this.shootMP != null) {
                this.shootMP.start();
            }
        }
    }

    private boolean hasNickName() {
        return this.userInfo != null && !FP.empty((CharSequence)this.userInfo.nickName);
    }

    private String getAnchorkName() {
        if (this.userInfo != null && !FP.empty((CharSequence)this.userInfo.reserve1)) {
            return this.userInfo.reserve1;
        }
        if (this.hasNickName()) {
            return this.userInfo.nickName;
        }
        return "";
    }

    private String getNickName() {
        if (this.userInfo != null && !FP.empty((CharSequence)this.userInfo.reserve1)) {
            return this.userInfo.reserve1;
        }
        if (this.hasNickName()) {
            if (this.userInfo.nickName.length() > 5) {
                return this.userInfo.nickName.substring(0, 5);
            }
            return this.userInfo.nickName;
        }
        return "";
    }

    @BusEvent(sync=true)
    public void replayReport(IMobileLiveClient_replayReport_EventArgs busEventArgs) {
        File dir = new File(BasicConfig.getInstance().getRootDir().getAbsolutePath() + "/saved");
        if (!dir.exists() && !dir.mkdirs()) {
            MLog.error((Object)TAG, (String)"replayReport mkdirs faild", (Object[])new Object[0]);
            this.toast("\u4e3e\u62a5\u5931\u8d25");
            return;
        }
        String path = dir.getAbsolutePath() + "/yy_live_" + System.currentTimeMillis() + ".png";
        if (this.mReplayVideoComponentProxy != null && this.mReplayVideoComponentProxy.takeSnapshot(path)) {
            if (this.mReportModel == null) {
                this.mReportModel = new ReplayReportModule((Activity)this.getActivity(), this.getActivity().getIntent().hasExtra("data_replay_title") ? this.getActivity().getIntent().getStringExtra("data_replay_title") : "", this.mCurrentTime, this.getActivity().getIntent().getLongExtra("data_replay_uid", 0L), this.getActivity().getIntent().getStringExtra("data_replay_id"));
            } else {
                this.mReportModel.setCurrentPlayTime(this.mCurrentTime);
            }
            this.mReportModel.showReport(path);
            this.mReportingPlayStatus = this.mReplayVideoComponentProxy.getPlayStatus();
            if (this.mReportingPlayStatus == 2) {
                this.mReplayVideoComponentProxy.pausePlayer(false);
            }
        } else {
            this.toast("\u4e3e\u62a5\u5931\u8d25");
        }
    }

    @BusEvent(sync=true)
    public void replayReportFinish(IMobileLiveClient_replayReportFinish_EventArgs busEventArgs) {
        if (this.mReportingPlayStatus == 2 && this.mReplayVideoComponentProxy != null) {
            this.mReplayVideoComponentProxy.resumePlayer(false);
        }
    }

    @BusEvent(sync=true)
    public void onReplayTimeChanged(IMobileLiveReplayClient_onReplayTimeChanged_EventArgs busEventArgs) {
        String progamId = busEventArgs.getPregomId();
        int progressfirst = busEventArgs.getCurTime();
        int progressseccond = busEventArgs.getParam();
        this.mSeekBar.setProgress(progressfirst);
        this.mSeekBar.setSecondaryProgress(progressseccond);
        this.mCurrentTime = progressfirst;
        this.mRestTime.setText((CharSequence)("-" + DurationUtils.intToDurationString((int)((this.mVideoDuration - progressfirst) / 1000))));
        this.mPlayTime.setText((CharSequence)DurationUtils.intToDurationString((int)(progressfirst / 1000)));
    }

    @BusEvent(sync=true)
    public void onReplayPlaying(IMobileLiveReplayClient_onReplayPlaying_EventArgs busEventArgs) {
        int length;
        this.mVideoDuration = length = busEventArgs.getLength();
        this.mSeekBar.setMax(this.mVideoDuration);
        if (this.isFirstPlaying) {
            this.isFirstPlaying = false;
            this.setHideProgressTask();
        }
        this.loadProgramInfoFragment();
    }

    private void loadProgramInfoFragment() {
        long tempUid;
        if (this.mReplayVideoComponentProxy != null && this.mReplayVideoComponentProxy.getReplayUrlInfo().trueUid > 0L && this.mUid != (tempUid = this.mReplayVideoComponentProxy.getReplayUrlInfo().trueUid) && tempUid > 0L) {
            this.mUid = tempUid;
            this.updateProgramInfo(this.mUid);
        }
        if (this.mReplayVideoComponentProxy != null && this.mReplayVideoComponentProxy.getReplayUrlInfo() != null && this.mReplayVideoComponentProxy.getReplayUrlInfo().mOwnerId > 0L) {
            this.mOwnUid = this.mReplayVideoComponentProxy.getReplayUrlInfo().mOwnerId;
        }
        if (this.mReplayVideoComponentProxy != null && this.mReplayVideoComponentProxy.getReplayUrlInfo() != null && !StringUtil.isNullOrEmpty((CharSequence)this.mReplayVideoComponentProxy.getReplayUrlInfo().storeReason)) {
            this.mStoreReason = this.mReplayVideoComponentProxy.getReplayUrlInfo().storeReason;
        }
    }

    private void updateProgramInfo(long uid) {
        if (this.mProgramInfoFragment == null) {
            Object result;
            AbsChannelControllerCore core = (AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class);
            if (core != null && (result = core.interceptNewProgramInfoFragmentInstance(this.mUid)) != null) {
                this.mProgramInfoFragment = (ProgramInfoFragment)result;
            }
            if (this.mProgramInfoFragment == null) {
                this.mProgramInfoFragment = ProgramInfoFragment.newInstance(uid);
            }
            this.mReplayProgramInfoPresenter = new ReplayProgramInfoPresenter(this.mProgramInfoFragment);
            this.mProgramInfoFragment.setProgramInfoPresenter(this.mReplayProgramInfoPresenter);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!ReplayControlFragment.this.isAdded()) {
                        return;
                    }
                    FragmentManager fm = ReplayControlFragment.this.getChildFragmentManager();
                    FragmentTransaction ft = fm.beginTransaction();
                    ft.replace(R.id.fl_anchor_head_info, (Fragment)ReplayControlFragment.this.mProgramInfoFragment);
                    ft.commitAllowingStateLoss();
                }
            });
        }
    }

    @Override
    public void changProgressLayoutVisibility() {
        if (this.mProgressLayout == null) {
            return;
        }
        if (this.mProgressLayout.getVisibility() == 0) {
            this.mProgressLayout.setVisibility(4);
            this.removeHideProgressTask();
        } else {
            this.mProgressLayout.setVisibility(0);
            this.setHideProgressTask();
        }
    }

    private void setHideProgressTask() {
        if (this.hideProgressTask == null) {
            this.hideProgressTask = new Runnable(){

                @Override
                public void run() {
                    if (ReplayControlFragment.this.mProgressLayout == null) {
                        return;
                    }
                    if (ReplayControlFragment.this.mProgressLayout.getVisibility() == 0) {
                        ReplayControlFragment.this.mProgressLayout.setVisibility(4);
                    }
                }
            };
        }
        this.getHandler().postDelayed(this.hideProgressTask, (long)this.showProgressTime);
    }

    private void removeHideProgressTask() {
        if (this.hideProgressTask != null) {
            this.getHandler().removeCallbacks(this.hideProgressTask);
        }
    }

    @BusEvent(sync=true)
    public void onHideReplayController(ISongChooseClient_onHideReplayController_EventArgs busEventArgs) {
        ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).requestProfile(this.mUid);
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        this.userInfo = info;
    }

    @BusEvent(sync=true)
    public void onDeleteMobileLiveReplayHistories(IMobileLiveClient_onDeleteMobileLiveReplayHistories_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        if (!this.isMyRequest.booleanValue()) {
            return;
        }
        this.isMyRequest = false;
        if (result == 0) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u5220\u9664\u6210\u529f", (int)0).show();
            if (this.mReplayVideoComponentProxy != null) {
                RxBus.getDefault().post((Object)new IMobileLiveClient_onDeleteMobileLiveReplaySuccess_EventArgs(this.mReplayVideoComponentProxy.getReplayUrlInfo().programId));
            }
            this.getActivity().finish();
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.replay_delete_failed_toast_text), (int)0).show();
        }
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mReplayControlFragmentSniperEventBinder == null) {
            this.mReplayControlFragmentSniperEventBinder = new ReplayControlFragment$$EventBinder();
        }
        this.mReplayControlFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    public static interface ReplayControlFragmentEvents {
        public void onClickClose();
    }
}

