/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IMobileLiveClient_onQueryLeaveReplayInfo_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.channel.core.AbsChannelControllerCore;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.imageloader.transform.YYBitmapTransformation;
import com.yy.mobile.imageloader.transform.YYBlurBitmapTransformation;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onGetReplayInfos_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BasePluginEntLiveActivity;
import com.yy.mobile.ui.LiveNavigationUtils;
import com.yy.mobile.ui.mobilelive.MobileLiveReplayLeaveActivity$$EventBinder;
import com.yy.mobile.ui.mobilelive.clipviewpager.ClipViewPager;
import com.yy.mobile.ui.mobilelive.clipviewpager.ScalePageTransformer;
import com.yy.mobile.ui.mobilelive.replay.LeaveReplayAdapter;
import com.yy.mobile.ui.mobilelive.replay.ReplayLeaveInfo;
import com.yy.mobile.ui.mobilelive.replay.ReplayProgramInfoPresenter;
import com.yy.mobile.ui.programinfo.ProgramInfoFragment;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yymobile.core.CoreError;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.mobilelive.LeaveReplayInfo;
import com.yymobile.core.mobilelive.MobileLiveConstant;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import java.util.Collection;

public class MobileLiveReplayLeaveActivity
extends BasePluginEntLiveActivity
implements View.OnClickListener {
    public static String MOBILE_LIVE_LEAVE_INFO_KEY = "mobile_live_leave_info_key";
    private static final String TAG = "MobileLiveReplayLeaveActivity";
    protected ReplayLeaveInfo mReplayLeaveInfo;
    private String mAnchor;
    private RecycleImageView recycleImageView;
    private RelativeLayout mReplayTypeLayout;
    private TextView mReplayLine;
    private TextView mLeaveReplayType;
    private ImageView mImgExit;
    private TextView mTvLeaveReplay;
    private ClipViewPager mViewPager;
    private LeaveReplayAdapter mPagerAdapter;
    protected ReplayProgramInfoPresenter mReplayProgramInfoPresenter;
    private EventBinder mMobileLiveReplayLeaveActivitySniperEventBinder;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!this.sdkInitStatus.get()) {
            return;
        }
        this.setContentView(R.layout.layout_mobile_replay_leave);
        this.mReplayLeaveInfo = (ReplayLeaveInfo)this.getIntent().getParcelableExtra(MOBILE_LIVE_LEAVE_INFO_KEY);
        this.initView();
        this.initReplayDada();
    }

    private void initView() {
        Object result;
        this.recycleImageView = (RecycleImageView)this.findViewById(R.id.mobile_live_leave_bg);
        this.mReplayTypeLayout = (RelativeLayout)this.findViewById(R.id.leave_replay_indicator);
        this.mReplayTypeLayout.setVisibility(4);
        this.mReplayLine = (TextView)this.findViewById(R.id.replay_Line);
        this.mLeaveReplayType = (TextView)this.findViewById(R.id.leave_replay_info);
        this.mImgExit = (ImageView)this.findViewById(R.id.btn_leave);
        this.mTvLeaveReplay = (TextView)this.findViewById(R.id.leave_replay);
        this.mViewPager = (ClipViewPager)this.findViewById(R.id.viewpager);
        this.mTvLeaveReplay.setOnClickListener((View.OnClickListener)this);
        this.mImgExit.setOnClickListener((View.OnClickListener)this);
        this.mViewPager.setPageTransformer(true, new ScalePageTransformer());
        this.findViewById(R.id.page_container).setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return MobileLiveReplayLeaveActivity.this.mViewPager.dispatchTouchEvent(event);
            }
        });
        this.mPagerAdapter = new LeaveReplayAdapter((Context)this, this.mViewPager);
        this.mViewPager.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageSelected(int arg0) {
                ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50402", "0004");
            }

            public void onPageScrolled(int position, float arg1, int arg2) {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)MobileLiveReplayLeaveActivity.this.mReplayLine.getLayoutParams();
                if (layoutParams != null && arg1 != 0.0f) {
                    layoutParams.leftMargin = (int)(((float)position + arg1) * (float)layoutParams.width);
                    MobileLiveReplayLeaveActivity.this.mReplayLine.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
            }

            public void onPageScrollStateChanged(int arg0) {
            }
        });
        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50402", "0008");
        ProgramInfoFragment mProgramInfoFragment = null;
        AbsChannelControllerCore core = (AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class);
        if (core != null && (result = core.interceptNewProgramInfoFragmentInstance(this.mReplayLeaveInfo.mAnchorUid)) != null) {
            mProgramInfoFragment = (ProgramInfoFragment)result;
        }
        if (mProgramInfoFragment == null) {
            mProgramInfoFragment = ProgramInfoFragment.newInstance(this.mReplayLeaveInfo.mAnchorUid);
        }
        this.mReplayProgramInfoPresenter = new ReplayProgramInfoPresenter(mProgramInfoFragment);
        this.mReplayProgramInfoPresenter.setIsFromLeaveReplay(true);
        this.mReplayProgramInfoPresenter.setPid(this.mReplayLeaveInfo.mProgamId);
        mProgramInfoFragment.setProgramInfoPresenter(this.mReplayProgramInfoPresenter);
        FragmentManager fm = this.getSupportFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        ft.replace(R.id.fl_anchor_head_info, (Fragment)mProgramInfoFragment);
        ft.commitAllowingStateLoss();
        if (this.mReplayLeaveInfo.mAnchorUid > 0L) {
            ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).requestDetailUserInfo(this.mReplayLeaveInfo.mAnchorUid, false);
        }
        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).queryLeaveReplayInfo(this.mReplayLeaveInfo.mProgamId, this.mReplayLeaveInfo.mAnchorUid, LoginUtil.getUid());
    }

    public void initReplayDada() {
        ImageLoader.Builder.obtain((RecycleImageView)this.recycleImageView, (String)this.mReplayLeaveInfo.mBgImgUrl, (int)R.drawable.mobile_live_leave_bg).setTransform(new YYBitmapTransformation[]{new YYBlurBitmapTransformation(20.0f)}).load();
        if (this.mReplayLeaveInfo.mProgamId != null) {
            ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).getReplayInfos(this.mReplayLeaveInfo.mProgamId);
        }
    }

    @BusEvent(sync=true)
    public void onGetReplayInfos(IMobileLiveClient_onGetReplayInfos_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        String playUrl = busEventArgs.getPlayUrl();
        String imgUrl = busEventArgs.getImgUrl();
        int isLiving = busEventArgs.getIsLiving();
        MLog.info((Object)TAG, (String)("onGetReplayInfos result=" + result + " playUrl=" + playUrl + " imgUrl=" + imgUrl + " isLiving=" + isLiving), (Object[])new Object[0]);
        if (!BlankUtil.isBlank((String)imgUrl)) {
            this.mReplayLeaveInfo.mBgImgUrl = imgUrl;
        }
        if (result == 0) {
            this.mReplayLeaveInfo.mPlayUrl = playUrl;
            this.mReplayLeaveInfo.mBgImgUrl = imgUrl;
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onQueryLeaveReplayInfo(IMobileLiveClient_onQueryLeaveReplayInfo_EventArgs busEventArgs) {
        int result = busEventArgs.mResult;
        long type2 = busEventArgs.mType;
        LeaveReplayInfo data = busEventArgs.mData;
        this.hideStatus();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("result = " + result + " data = " + data), (Object[])new Object[0]);
        }
        if (result == 0 && data != null) {
            if (!FP.empty((Collection)data.replayList)) {
                this.mReplayTypeLayout.setVisibility(0);
                if ((int)type2 == 1) {
                    this.mPagerAdapter.setReplayAnchorName(this.mAnchor);
                    this.mLeaveReplayType.setText((CharSequence)this.getResources().getString(R.string.leave_replay_list));
                } else {
                    this.mLeaveReplayType.setText((CharSequence)this.getResources().getString(R.string.leave_replay_recommand));
                }
                this.mViewPager.setOffscreenPageLimit(data.replayList.size());
                this.mPagerAdapter.setData(data.replayList);
                this.mPagerAdapter.setReplayType((int)type2);
                this.mViewPager.setCurrentItem(0);
                if (this.mViewPager.getChildAt(1) != null) {
                    this.mViewPager.getChildAt(1).setScaleX(0.86f);
                    this.mViewPager.getChildAt(1).setScaleY(0.86f);
                    this.mViewPager.getChildAt(1).setAlpha(0.5f);
                }
                if (data.replayList.size() > 1) {
                    RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mReplayLine.getLayoutParams();
                    layoutParams.width = this.getWindowManager().getDefaultDisplay().getWidth() / data.replayList.size();
                    this.mReplayLine.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    this.mReplayLine.setVisibility(0);
                } else {
                    this.mReplayLine.setVisibility(4);
                }
            }
        } else if (this.mPagerAdapter != null && this.mPagerAdapter.getCount() > 0) {
            this.checkNetToast();
        } else {
            if (this.isNetworkAvailable()) {
                ((RecycleImageView)this.findViewById(R.id.no_data_icon)).setImageResource(R.drawable.img_no_live_data);
                ((TextView)this.findViewById(R.id.no_data_text)).setText(R.string.no_list_data);
            } else {
                ((RecycleImageView)this.findViewById(R.id.no_data_icon)).setImageResource(R.drawable.icon_error);
                ((TextView)this.findViewById(R.id.no_data_text)).setText(R.string.click_screen_reload);
            }
            this.findViewById(R.id.no_data_text).setVisibility(0);
            this.findViewById(R.id.no_data_icon).setVisibility(0);
            this.findViewById(R.id.status_layout).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MobileLiveReplayLeaveActivity.this.findViewById(R.id.no_data_text).setVisibility(8);
                    MobileLiveReplayLeaveActivity.this.findViewById(R.id.no_data_icon).setVisibility(8);
                    MobileLiveReplayLeaveActivity.this.showLoading();
                    ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).queryLeaveReplayInfo(MobileLiveReplayLeaveActivity.this.mReplayLeaveInfo.mProgamId, MobileLiveReplayLeaveActivity.this.mReplayLeaveInfo.mAnchorUid, LoginUtil.getUid());
                }
            });
        }
    }

    @Override
    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                MobileLiveReplayLeaveActivity.this.showLoading();
                ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).queryLeaveReplayInfo(MobileLiveReplayLeaveActivity.this.mReplayLeaveInfo.mProgamId, MobileLiveReplayLeaveActivity.this.mReplayLeaveInfo.mAnchorUid, LoginUtil.getUid());
            }
        };
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        MLog.info((Object)TAG, (String)("onRequestDetailUserInfo info=" + (info == null ? " is null" : info.toString()) + "isLocalData=" + isLocalData + "error = " + error), (Object[])new Object[0]);
        if (error == null && info != null && userId > 0L && this.mReplayLeaveInfo != null && userId == this.mReplayLeaveInfo.mAnchorUid) {
            this.mAnchor = !FP.empty((CharSequence)info.reserve1) ? info.reserve1 : info.nickName;
        }
    }

    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.btn_leave) {
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1910", "0001");
            ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).setMobileLiveCachedVideoScreenshotNull();
            this.finish();
        } else if (viewId == R.id.leave_replay) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"zs -- ", (String)"MobileLiveLeaveActivity leaveReplay ", (Object[])new Object[0]);
            }
            this.finish();
            LiveNavigationUtils.toMobileLiveReplayWithType((Context)this, this.mReplayLeaveInfo.mProgamId, this.mReplayLeaveInfo.mAnchorUid, this.mReplayLeaveInfo.mPlayUrl, this.mReplayLeaveInfo.mBgImgUrl, FP.empty((CharSequence)this.mReplayLeaveInfo.mMobileLiveTitle) ? this.getIntent().getStringExtra(MobileLiveConstant.MOBILE_LIVE_REPLAY_TITLE) : this.mReplayLeaveInfo.mMobileLiveTitle, MobileLiveConstant.TO_MOBILE_LIVE_REPLAY_PATH_BY_LEAVE, this.mReplayLeaveInfo.mReplayTypeFrom);
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50402", "0005");
        }
    }

    protected boolean handleStatusBar() {
        return true;
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mMobileLiveReplayLeaveActivitySniperEventBinder == null) {
            this.mMobileLiveReplayLeaveActivitySniperEventBinder = new MobileLiveReplayLeaveActivity$$EventBinder();
        }
        this.mMobileLiveReplayLeaveActivitySniperEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mMobileLiveReplayLeaveActivitySniperEventBinder != null) {
            this.mMobileLiveReplayLeaveActivitySniperEventBinder.unBindEvent();
        }
    }
}

