/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.Scroller;
import com.yy.mobile.ui.gift.packages.PackageAdapter;
import com.yy.mobile.util.log.MLog;

public class ScrollLayout
extends ViewGroup {
    private static final String TAG = "ScrollLayout";
    private static final int TOUCH_STATE_REST = 0;
    private static final int TOUCH_STATE_SCROLLING = 1;
    private static final int SNAP_VELOCITY = 600;
    private Scroller mScroller;
    private VelocityTracker mVelocityTracker;
    private PackageAdapter mPackageAdapter;
    private int mCurScreen;
    private int mDefaultScreen = 0;
    private int mTouchState = 0;
    private int mTouchSlop;
    private float mLastMotionX;
    private float mLastMotionY;
    private int leftBorder;
    private int rightBorder;

    public ScrollLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScrollLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mScroller = new Scroller(context);
        this.mCurScreen = this.mDefaultScreen;
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childLeft = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            if (childView.getVisibility() == 8) continue;
            int childWidth = childView.getMeasuredWidth();
            childView.layout(childLeft, 0, childLeft + childWidth, childView.getMeasuredHeight());
            childLeft += childWidth;
        }
        if (childCount > 0) {
            this.leftBorder = this.getChildAt(0).getLeft();
            this.rightBorder = this.getChildAt(childCount - 1).getRight();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthMode != 0x40000000) {
            MLog.info((Object)TAG, (String)"ScrollLayout only canmCurScreen run at EXACTLY mode!", (Object[])new Object[0]);
        }
        if ((heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec)) != 0x40000000) {
            MLog.info((Object)TAG, (String)"ScrollLayout only can run at EXACTLY mode!", (Object[])new Object[0]);
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.getChildAt(i).measure(widthMeasureSpec, heightMeasureSpec);
        }
        this.scrollTo(this.mCurScreen * width, 0);
    }

    public void snapToDestination() {
        int screenWidth = this.getWidth();
        int destScreen = (this.getScrollX() + screenWidth / 2) / screenWidth;
        this.snapToScreen(destScreen);
    }

    public void snapToScreen(int whichScreen) {
        if (this.mPackageAdapter != null) {
            this.mPackageAdapter.onPageSelected(whichScreen);
        }
        whichScreen = Math.max(0, Math.min(whichScreen, this.getChildCount() - 1));
        if (this.getScrollX() != whichScreen * this.getWidth()) {
            int delta = whichScreen * this.getWidth() - this.getScrollX();
            this.mScroller.startScroll(this.getScrollX(), 0, delta, 0, Math.abs(delta));
            this.mCurScreen = whichScreen;
            this.invalidate();
        }
    }

    public void setToScreen(int whichScreen) {
        this.mCurScreen = whichScreen = Math.max(0, Math.min(whichScreen, this.getChildCount() - 1));
        this.scrollTo(whichScreen * this.getWidth(), 0);
    }

    public int getCurScreen() {
        return this.mCurScreen;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            this.postInvalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        int action2 = event.getAction();
        float x = event.getX();
        float y = event.getY();
        switch (action2) {
            case 0: {
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionX = x;
                break;
            }
            case 2: {
                int deltaX = (int)(this.mLastMotionX - x);
                this.mLastMotionX = x;
                if (this.getScrollX() + deltaX < this.leftBorder) {
                    this.scrollTo(this.leftBorder, 0);
                    return true;
                }
                if (this.getScrollX() + this.getWidth() + deltaX > this.rightBorder) {
                    this.scrollTo(this.rightBorder - this.getWidth(), 0);
                    return true;
                }
                this.scrollBy(deltaX, 0);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000);
                int velocityX = (int)velocityTracker.getXVelocity();
                if (velocityX > 600 && this.mCurScreen > 0) {
                    this.snapToScreen(this.mCurScreen - 1);
                } else if (velocityX < -600 && this.mCurScreen < this.getChildCount() - 1) {
                    this.snapToScreen(this.mCurScreen + 1);
                } else {
                    this.snapToDestination();
                }
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mTouchState = 0;
                break;
            }
            case 3: {
                this.mTouchState = 0;
                break;
            }
        }
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action2 = ev.getAction();
        if (action2 == 2 && this.mTouchState != 0) {
            return true;
        }
        float x = ev.getX();
        float y = ev.getY();
        switch (action2) {
            case 2: {
                int xDiff = (int)Math.abs(this.mLastMotionX - x);
                if (xDiff <= this.mTouchSlop) break;
                this.mTouchState = 1;
                break;
            }
            case 0: {
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                this.mTouchState = this.mScroller.isFinished() ? 0 : 1;
                break;
            }
            case 1: 
            case 3: {
                this.mTouchState = 0;
                break;
            }
        }
        return this.mTouchState != 0;
    }

    public PackageAdapter getAdapter() {
        return this.mPackageAdapter;
    }

    public void setAdapter(PackageAdapter adapter) {
        this.mPackageAdapter = adapter;
        this.mPackageAdapter.setContainer(this);
    }
}

