/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.gift.ArGiftLockInfo;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.gift.GiftConfigParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArGiftListAdapter
extends BaseAdapter {
    private static final String TAG = "ArGiftListAdapter";
    protected Context mContext;
    protected LayoutInflater mInflater;
    private int mCurrentAmount;
    private Map<Integer, ArGiftLockInfo> map = new HashMap<Integer, ArGiftLockInfo>();
    private List<ArAmountInfo> amountInfoList = new ArrayList<ArAmountInfo>();

    public ArGiftListAdapter(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.setLockLevel(1);
    }

    public int getCount() {
        return this.amountInfoList.size();
    }

    public Object getItem(int position) {
        if (position >= 0 && position < this.amountInfoList.size()) {
            return this.amountInfoList.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ArAmountItemViewHolder viewHolder;
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.ar_gift_amount_list_item, parent, false);
            viewHolder = new ArAmountItemViewHolder();
            viewHolder.amountTextView = (TextView)convertView.findViewById(R.id.tv_amount);
            viewHolder.lockImageView = (ImageView)convertView.findViewById(R.id.iv_lock);
            viewHolder.descriptionTextView = (TextView)convertView.findViewById(R.id.tv_description);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ArAmountItemViewHolder)convertView.getTag();
        }
        Object itemObject = this.getItem(position);
        if (itemObject != null) {
            ArAmountInfo amountInfo = (ArAmountInfo)itemObject;
            viewHolder.descriptionTextView.setText((CharSequence)amountInfo.description);
            if (amountInfo.amount == -1) {
                viewHolder.amountTextView.setVisibility(8);
                viewHolder.lockImageView.setVisibility(8);
                viewHolder.amountTextView.setText((CharSequence)"");
                viewHolder.descriptionTextView.setTextColor(this.mContext.getResources().getColor(R.color.color_gray));
                viewHolder.descriptionTextView.setGravity(17);
                viewHolder.descriptionTextView.setTextSize(0, (float)this.mContext.getResources().getDimensionPixelSize(R.dimen.long_text_tips_fnt));
            } else {
                if (amountInfo.isLock) {
                    viewHolder.amountTextView.setVisibility(4);
                    viewHolder.lockImageView.setVisibility(0);
                    viewHolder.amountTextView.setTextColor(this.mContext.getResources().getColor(R.color.common_color_24));
                    convertView.setBackgroundResource(R.color.color_bg_lock_gray);
                } else {
                    viewHolder.amountTextView.setVisibility(0);
                    viewHolder.lockImageView.setVisibility(8);
                    viewHolder.amountTextView.setText((CharSequence)String.valueOf(amountInfo.amount));
                    viewHolder.amountTextView.setTextColor(this.mContext.getResources().getColor(R.color.common_color_15));
                    convertView.setBackgroundResource(R.color.common_color_11);
                }
                viewHolder.descriptionTextView.setGravity(3);
                viewHolder.descriptionTextView.setTextSize(0, (float)this.mContext.getResources().getDimensionPixelSize(R.dimen.short_text_navigation_fnt));
            }
        }
        return convertView;
    }

    public void setArGiftInfo(int type2, int level, int levelGiftSetNum) {
        ArGiftLockInfo arGift = this.map.get(type2);
        if (arGift == null) {
            arGift = new ArGiftLockInfo(level, levelGiftSetNum);
            this.map.put(type2, arGift);
        } else {
            arGift.setLockLevel(level);
            arGift.setLevelGiftSetNum(levelGiftSetNum);
        }
        this.setLockLevel(level);
    }

    public boolean isCantArGiftAmount(int giftId) {
        List amountInfos = GiftConfigParser.getInstance().getGiftAmountList(giftId);
        return amountInfos == null || amountInfos.size() < 2;
    }

    public ArGiftLockInfo getArGiftInfo(int type2) {
        return this.map.get(type2);
    }

    public int getCurrentAmount() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"getCurrentAmount mCurrentAmount=%d", (Object[])new Object[]{this.mCurrentAmount});
        }
        if (this.mCurrentAmount <= 1) {
            this.mCurrentAmount = 1;
        }
        return this.mCurrentAmount;
    }

    public void setCurrentAmount(int amount) {
        this.mCurrentAmount = amount;
        this.notifyDataSetChanged();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"setCurrentAmount mCurrentAmount=%d", (Object[])new Object[]{this.mCurrentAmount});
        }
    }

    public int getAmount(int position) {
        ArAmountInfo amountInfo = (ArAmountInfo)this.getItem(position);
        if (amountInfo != null) {
            return amountInfo.amount;
        }
        return 0;
    }

    public int getAmountFromLevel(int level) {
        if (this.amountInfoList != null) {
            for (int t = 0; t < this.amountInfoList.size(); ++t) {
                ArAmountInfo amountInfo = this.amountInfoList.get(t);
                if (amountInfo.level != level) continue;
                return amountInfo.amount;
            }
        }
        return 0;
    }

    public boolean getLockState(int position) {
        ArAmountInfo amountInfo = (ArAmountInfo)this.getItem(position);
        if (amountInfo != null) {
            return amountInfo.isLock;
        }
        return false;
    }

    public void setLockLevel(int level) {
        if (FP.empty(this.amountInfoList)) {
            this.amountInfoList = new ArrayList<ArAmountInfo>();
            this.amountInfoList.add(new ArAmountInfo(-1, false, this.mContext.getString(R.string.str_ar_gift_level_introduce), 4));
            this.amountInfoList.add(new ArAmountInfo(100, true, this.mContext.getString(R.string.str_ar_gift_three_level), 3));
            this.amountInfoList.add(new ArAmountInfo(10, true, this.mContext.getString(R.string.str_ar_gift_two_level), 2));
            this.amountInfoList.add(new ArAmountInfo(1, false, this.mContext.getString(R.string.str_ar_gift_one_level), 1));
        } else {
            for (int t = 0; t < this.amountInfoList.size(); ++t) {
                ArAmountInfo arAmountInfo = this.amountInfoList.get(t);
                arAmountInfo.isLock = arAmountInfo.level > level;
            }
        }
        this.notifyDataSetChanged();
    }

    public static class ArAmountInfo {
        public int amount;
        public String description;
        public boolean isLock;
        public int level;

        ArAmountInfo(int amount, boolean isLock, String description, int level) {
            this.amount = amount;
            this.isLock = isLock;
            this.description = description;
            this.level = level;
        }

        public void setLock(boolean isLock) {
            this.isLock = isLock;
        }

        public String toString() {
            return "ArAmountInfo{amount=" + this.amount + ", description='" + this.description + '\'' + '}';
        }
    }

    public static class ArAmountItemViewHolder {
        public TextView amountTextView;
        public ImageView lockImageView;
        public TextView descriptionTextView;
    }
}

