/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.comfessionwall;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.AnimationDrawable;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.comfessionwall.ConfessionUtils;
import com.yy.mobile.ui.comfessionwall.ConfessionWallBroadcastView;
import com.yy.mobile.ui.comfessionwall.ConfessionWallDetailView;
import com.yy.mobile.ui.comfessionwall.ConfessionWallItemView;
import com.yy.mobile.ui.comfessionwall.WallDetailBean;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.ui.utils.dialog.OkDialog;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.comfessionwall.ConfessionWallBean;
import com.yymobile.core.live.LiveCore.JoinChannelIntent;
import com.yymobile.core.pluginsconfig.IPluginPropertyCore;
import com.yymobile.core.pluginsconfig.PluginPropertyKey;
import com.yymobile.core.statistic.IHiidoStatisticCore;

public class ConfessionWallViewManager
implements ConfessionWallDetailView.OnConfessionWallDetailViewClickListener,
ConfessionWallBroadcastView.OnBroadcastViewClickListener {
    private static final String mTAG = "ConfessionWallViewManager";
    private Context mContext;
    private ViewGroup mRootView;
    private RelativeLayout confessionInfoContainer;
    private RecycleImageView confessionContainerRightLight;
    private TextView timeCountDownTv;
    private RecycleImageView mClickStateTagRiv;
    private RecycleImageView topStrokeLightRiv;
    private RecycleImageView mCollisionView;
    private RecycleImageView bottomStrokeLightRiv;
    private RelativeLayout.LayoutParams clickStateTagRivLayoutParams;
    private RelativeLayout.LayoutParams lightLayoutParams;
    private ConfessionWallItemView confessionWallItemView;
    private RelativeLayout.LayoutParams confessionWallItemViewLayoutParams;
    private ImageView flashView;
    private ValueAnimator extrudeValueAnimator;
    private ValueAnimator detailExtrudeValueAnimator;
    private ObjectAnimator rotateAnimator;
    private AnimatorSet animatorMoveToRightSet;
    private AnimatorSet animatorSetRight;
    private AnimatorSet animatorFlashSet;
    private ValueAnimator vaShrink;
    private static final long TIME_DELAY = 5000L;
    private Handler mHandler = new SafeDispatchHandler(Looper.myLooper());
    private Runnable timeTask = new Runnable(){

        @Override
        public void run() {
            ConfessionWallViewManager.this.shrinkDetailAnimation();
        }
    };
    private ConfessionWallDetailView confessionWallDetailView;
    private RelativeLayout.LayoutParams wallContainerLayoutParams;
    private RelativeLayout.LayoutParams detailLayoutParams;
    private ConfessionWallBroadcastView confessionWallBroadcastView;
    private OnAnimationFinishedListener mOnAnimationFinishedListener;
    private boolean isExtrudeAnimatorRun = false;
    private boolean detailViewIsShow = false;
    private boolean isIniting = false;
    private ConfessionWallBean bean;
    private IChannelLinkCore channelLinkCore;
    private static final String CONFESSION_WALL_DECS_URL = "https://web.yy.com/expressingwall/index.html";
    private float confessionRightPositionX = 0.0f;
    private boolean outSizeConfessionVisibleLock = false;
    private final int confessionInfoContainerMinWidth = (int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)BasicConfig.getInstance().getAppContext());
    public static final int commonContainerHeight = (int)ResolutionUtils.convertDpToPixel((float)22.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int mViewHeight = (int)ResolutionUtils.convertDpToPixel((float)200.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int mLightMarginRight = (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int mConfessionWallContainerMaxWidth = (int)ResolutionUtils.convertDpToPixel((float)104.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int strokeLineWidth = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)BasicConfig.getInstance().getAppContext());

    public ConfessionWallViewManager(Context context) {
        this.mContext = context;
        this.mRootView = new RelativeLayout(context);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, this.mViewHeight);
        this.mRootView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.channelLinkCore = ICoreManagerBase.getChannelLinkCore();
    }

    public void loadData(ConfessionWallBean bean) {
        if (bean == null) {
            return;
        }
        if (this.isIniting) {
            return;
        }
        this.bean = bean;
        this.createConfessionWallInfoContainer();
        if (this.detailViewIsShow) {
            this.updateDetailInfo();
        }
    }

    public void updateCountDownTime(int sec, int type2) {
        if (type2 == 1) {
            if (this.confessionWallBroadcastView != null && this.confessionWallBroadcastView.getVisibility() == 0) {
                this.confessionWallBroadcastView.setCountDownTime(sec);
            }
            if (this.timeCountDownTv != null) {
                if (sec == 0) {
                    this.timeCountDownTv.setVisibility(8);
                    if (!this.detailViewIsShow) {
                        this.confessionWallAnimator(1.3f, 1.0f, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationStart(Animator animator2) {
                                ConfessionWallViewManager.this.isExtrudeAnimatorRun = true;
                            }

                            public void onAnimationEnd(Animator animator2) {
                                ConfessionWallViewManager.this.isExtrudeAnimatorRun = false;
                            }
                        });
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(sec);
                    sb.append("s");
                    this.timeCountDownTv.setText((CharSequence)sb.toString());
                }
            }
        }
    }

    public ViewGroup getRootView() {
        return this.mRootView;
    }

    private void createConfessionWallInfoContainer() {
        this.isIniting = true;
        if (this.mRootView == null || this.bean == null) {
            return;
        }
        if (this.confessionWallDetailView == null) {
            this.confessionWallDetailView = new ConfessionWallDetailView(this.mContext);
            this.mRootView.addView((View)this.confessionWallDetailView, (ViewGroup.LayoutParams)this.detailLayoutParams);
            this.confessionWallDetailView.setVisibility(8);
        }
        WallDetailBean wallDetailBean = this.createdWallDetailBean(this.bean);
        this.setDetailLayoutHeight(wallDetailBean.isCurrentInChannel);
        this.confessionWallDetailView.setListener(this);
        this.confessionWallDetailView.setData(wallDetailBean);
        if (this.confessionInfoContainer == null) {
            this.confessionInfoContainer = new RelativeLayout(this.mContext);
            this.confessionInfoContainer.setId(R.id.comfeesionwall_broadcast_container);
            this.confessionInfoContainer.setLayoutParams((ViewGroup.LayoutParams)this.wallContainerLayoutParams);
            this.confessionWallItemView = new ConfessionWallItemView(this.mContext);
            this.confessionWallItemViewLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            this.confessionWallItemViewLayoutParams.addRule(15);
            this.confessionWallItemViewLayoutParams.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.confessionInfoContainer.addView((View)this.confessionWallItemView, (ViewGroup.LayoutParams)this.confessionWallItemViewLayoutParams);
            this.timeCountDownTv = new TextView(this.mContext);
            RelativeLayout.LayoutParams timeCountDownTvLp = new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)31.0f, (Context)BasicConfig.getInstance().getAppContext()), -2);
            timeCountDownTvLp.addRule(15);
            timeCountDownTvLp.addRule(11);
            timeCountDownTvLp.rightMargin = (int)ResolutionUtils.convertDpToPixel((float)15.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.timeCountDownTv.setGravity(17);
            this.timeCountDownTv.setLayoutParams((ViewGroup.LayoutParams)timeCountDownTvLp);
            this.timeCountDownTv.setTextColor(-1);
            this.timeCountDownTv.setTypeface(Typeface.DEFAULT_BOLD);
            this.timeCountDownTv.setTextSize(9.0f);
            this.confessionInfoContainer.addView((View)this.timeCountDownTv);
            this.mClickStateTagRiv = new RecycleImageView(this.mContext);
            this.clickStateTagRivLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            this.clickStateTagRivLayoutParams.addRule(11);
            this.clickStateTagRivLayoutParams.addRule(15);
            this.clickStateTagRivLayoutParams.rightMargin = (int)ResolutionUtils.convertDpToPixel((float)7.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.mClickStateTagRiv.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_liveroom_confession_down));
            this.confessionInfoContainer.addView((View)this.mClickStateTagRiv, (ViewGroup.LayoutParams)this.clickStateTagRivLayoutParams);
            this.topStrokeLightRiv = new RecycleImageView(this.mContext);
            this.topStrokeLightRiv.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_liveroom_confession_line));
            RelativeLayout.LayoutParams topStrokeLightRivLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            topStrokeLightRivLayoutParams.width = this.strokeLineWidth;
            topStrokeLightRivLayoutParams.addRule(11);
            topStrokeLightRivLayoutParams.rightMargin = (int)ResolutionUtils.convertDpToPixel((float)17.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.confessionInfoContainer.addView((View)this.topStrokeLightRiv, (ViewGroup.LayoutParams)topStrokeLightRivLayoutParams);
            this.bottomStrokeLightRiv = new RecycleImageView(this.mContext);
            this.bottomStrokeLightRiv.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_liveroom_confession_line));
            RelativeLayout.LayoutParams bottomStrokeLightRivLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            bottomStrokeLightRivLayoutParams.width = this.strokeLineWidth;
            bottomStrokeLightRivLayoutParams.addRule(11);
            bottomStrokeLightRivLayoutParams.addRule(12);
            bottomStrokeLightRivLayoutParams.rightMargin = (int)ResolutionUtils.convertDpToPixel((float)40.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.confessionInfoContainer.addView((View)this.bottomStrokeLightRiv, (ViewGroup.LayoutParams)bottomStrokeLightRivLayoutParams);
            this.confessionContainerRightLight = new RecycleImageView(this.mContext);
            this.lightLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            this.lightLayoutParams.addRule(11);
            this.lightLayoutParams.rightMargin = this.mLightMarginRight;
            this.confessionContainerRightLight.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.bg_liveroom_confession_light));
            this.confessionInfoContainer.addView((View)this.confessionContainerRightLight, (ViewGroup.LayoutParams)this.lightLayoutParams);
            this.confessionInfoContainer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (ConfessionWallViewManager.this.isExtrudeAnimatorRun) {
                        return;
                    }
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)ConfessionWallViewManager.mTAG, (String)"confessionInfoContainer is click!", (Object[])new Object[0]);
                    }
                    if (!ConfessionWallViewManager.this.detailViewIsShow) {
                        ConfessionWallViewManager.this.mHandler.removeCallbacksAndMessages(null);
                        ConfessionWallViewManager.this.mHandler.postDelayed(ConfessionWallViewManager.this.timeTask, 5000L);
                        ConfessionWallViewManager.this.startExpandDetailAnimation();
                    } else {
                        ConfessionWallViewManager.this.mHandler.removeCallbacksAndMessages(null);
                        ConfessionWallViewManager.this.shrinkDetailAnimation();
                    }
                }
            });
            this.mRootView.addView((View)this.confessionInfoContainer);
        }
        this.wallContainerLayoutParams.width = this.bean.mLeftSec > 0 || this.detailViewIsShow ? this.mConfessionWallContainerMaxWidth : this.confessionInfoContainerMinWidth;
        int bgLevelId = ConfessionUtils.getBgLevelDrawableId(this.bean.mStyle);
        this.confessionInfoContainer.setBackgroundDrawable(this.mContext.getResources().getDrawable(bgLevelId));
        this.confessionWallItemView.init(this.bean.mFromUrl, this.bean.mToUrl, this.bean.mStyle);
        if (this.bean.mLeftSec <= 0) {
            this.timeCountDownTv.setVisibility(8);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(this.bean.mLeftSec);
            sb.append("s");
            this.timeCountDownTv.setText((CharSequence)sb.toString());
            this.timeCountDownTv.setVisibility(0);
        }
        this.setStrokeLightShowOrHide(this.bean.mStyle);
        this.setRightLightShowOrHide(this.bean.mStyle);
        this.isIniting = false;
    }

    private void setDetailLayoutHeight(boolean isCurrentInChannel) {
        if (this.bean.mTopCid == this.channelLinkCore.getCurrentTopMicId()) {
            this.detailLayoutParams.height = isCurrentInChannel ? ConfessionWallDetailView.InAnchorChannelViewHeight - (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)BasicConfig.getInstance().getAppContext()) : ConfessionWallDetailView.InAnchorChannelViewHeight;
            this.confessionWallDetailView.init(ConfessionWallDetailView.ViewType.InAnchorChannel, isCurrentInChannel);
        } else {
            this.detailLayoutParams.height = isCurrentInChannel ? ConfessionWallDetailView.OutAnchorChannelViewHeight - (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)BasicConfig.getInstance().getAppContext()) : ConfessionWallDetailView.OutAnchorChannelViewHeight;
            this.confessionWallDetailView.init(ConfessionWallDetailView.ViewType.OutAnchorChannel, isCurrentInChannel);
        }
    }

    private void shrinkDetailAnimation() {
        if (this.confessionWallDetailView != null) {
            this.confessionWallDetailExtrudeAnimator(1.0f, 0.0f, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animator2) {
                    ConfessionWallViewManager.this.isExtrudeAnimatorRun = true;
                }

                public void onAnimationEnd(Animator animator2) {
                    if (ConfessionWallViewManager.this.confessionWallDetailView != null) {
                        ConfessionWallViewManager.this.confessionWallDetailView.setVisibility(8);
                    }
                    ConfessionWallViewManager.this.detailViewIsShow = false;
                    ConfessionWallViewManager.this.startRotateAnimator(180, 0);
                    if (ConfessionWallViewManager.this.isNeedExtrude()) {
                        ConfessionWallViewManager.this.confessionWallAnimator(1.3f, 1.0f, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animator2) {
                                ConfessionWallViewManager.this.isExtrudeAnimatorRun = false;
                            }
                        });
                    } else {
                        ConfessionWallViewManager.this.isExtrudeAnimatorRun = false;
                    }
                }
            });
        }
    }

    private void startExpandDetailAnimation() {
        if (this.isNeedExtrude()) {
            this.confessionWallAnimator(1.0f, 1.3f, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animator2) {
                    ConfessionWallViewManager.this.isExtrudeAnimatorRun = true;
                    ConfessionWallViewManager.this.startRotateAnimator(0, 180);
                }

                public void onAnimationEnd(Animator animator2) {
                    ConfessionWallViewManager.this.startWallDetailExtrudeAnimator();
                }
            });
        } else {
            this.startRotateAnimator(0, 180);
            this.startWallDetailExtrudeAnimator();
        }
    }

    public void notifyBroadCastView(ConfessionWallBean bean, OnAnimationFinishedListener listener2) {
        this.bean = bean;
        this.mOnAnimationFinishedListener = listener2;
        WallDetailBean wallDetailBean = this.createdWallDetailBean(bean);
        if (this.confessionWallBroadcastView == null) {
            this.confessionWallBroadcastView = new ConfessionWallBroadcastView(this.mContext, this.wallContainerLayoutParams.topMargin);
            this.confessionWallBroadcastView.setListener(this);
            this.confessionWallBroadcastView.setData(wallDetailBean);
            this.mRootView.addView((View)this.confessionWallBroadcastView);
            this.confessionWallBroadcastView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    ConfessionWallViewManager.this.confessionWallBroadcastView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    ConfessionWallViewManager.this.moveToRightAnim();
                }
            });
        } else {
            this.confessionWallBroadcastView.setVisibility(0);
            this.confessionWallBroadcastView.setData(wallDetailBean);
            this.moveToRightAnim();
        }
    }

    private void moveToRightAnim() {
        if (this.animatorMoveToRightSet != null) {
            this.animatorMoveToRightSet.removeAllListeners();
            this.animatorMoveToRightSet.end();
        }
        this.animatorMoveToRightSet = new AnimatorSet();
        float moveDistanceX = this.mRootView.getWidth() - ConfessionWallBroadcastView.BroadCastViewWidth - DimenConverter.dip2px((Context)this.mContext, (float)10.0f);
        ObjectAnimator objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this.confessionWallBroadcastView), (String)"translationX", (float[])new float[]{0.0f, moveDistanceX});
        objectAnimator1.setDuration(300L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this.confessionWallBroadcastView), (String)"translationX", (float[])new float[]{moveDistanceX, moveDistanceX - (float)DimenConverter.dip2px((Context)this.mContext, (float)15.0f)});
        objectAnimator2.setDuration(200L);
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)((Object)this.confessionWallBroadcastView), (String)"translationX", (float[])new float[]{moveDistanceX - (float)DimenConverter.dip2px((Context)this.mContext, (float)15.0f), moveDistanceX});
        objectAnimator3.setDuration(200L);
        this.animatorMoveToRightSet.play((Animator)objectAnimator1);
        this.animatorMoveToRightSet.play((Animator)objectAnimator2).after((Animator)objectAnimator1);
        this.animatorMoveToRightSet.play((Animator)objectAnimator3).after((Animator)objectAnimator2);
        this.animatorMoveToRightSet.removeAllListeners();
        this.animatorMoveToRightSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                MLog.debug((Object)ConfessionWallViewManager.mTAG, (String)"animatorMoveToRightSet -- onAnimationEnd", (Object[])new Object[0]);
                ConfessionWallViewManager.this.playFlashAnimator();
            }
        });
        this.animatorMoveToRightSet.start();
        if (this.mCollisionView == null) {
            this.mCollisionView = new RecycleImageView(this.mContext);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(DimenConverter.dip2px((Context)this.mContext, (float)70.0f), DimenConverter.dip2px((Context)this.mContext, (float)70.0f));
            params.topMargin = (this.confessionInfoContainer.getTop() + this.confessionInfoContainer.getBottom()) / 2 - DimenConverter.dip2px((Context)this.mContext, (float)35.0f);
            params.addRule(0, R.id.comfeesionwall_broadcast_container);
            this.mCollisionView.setVisibility(8);
            this.mRootView.addView((View)this.mCollisionView, (ViewGroup.LayoutParams)params);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ConfessionWallViewManager.this.mCollisionView.setVisibility(0);
                ConfessionWallViewManager.this.mCollisionView.setBackgroundDrawable(null);
                ConfessionWallViewManager.this.mCollisionView.setBackgroundResource(R.drawable.confession_collision_animation);
                AnimationDrawable frameAnimation = (AnimationDrawable)ConfessionWallViewManager.this.mCollisionView.getBackground();
                frameAnimation.start();
            }
        }, (long)100L);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ConfessionWallViewManager.this.mCollisionView != null) {
                    ConfessionWallViewManager.this.mCollisionView.setVisibility(8);
                }
            }
        }, (long)500L);
        this.confessionRightPositionX = this.confessionInfoContainer.getX();
        if (this.animatorSetRight != null) {
            this.animatorSetRight.removeAllListeners();
            this.animatorSetRight.end();
        }
        this.animatorSetRight = new AnimatorSet();
        ObjectAnimator animRightTrans = ObjectAnimator.ofFloat((Object)this.confessionInfoContainer, (String)"translationX", (float[])new float[]{0.0f, this.wallContainerLayoutParams.width});
        animRightTrans.setDuration(400L);
        ObjectAnimator animRightAlpha = ObjectAnimator.ofFloat((Object)this.confessionInfoContainer, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        animRightTrans.setDuration(400L);
        this.animatorSetRight.setStartDelay(100L);
        this.animatorSetRight.play((Animator)animRightTrans).with((Animator)animRightAlpha);
        this.animatorSetRight.removeAllListeners();
        this.animatorSetRight.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                ConfessionWallViewManager.this.updateDetailInfo();
                if (ConfessionWallViewManager.this.confessionInfoContainer != null) {
                    ConfessionWallViewManager.this.confessionWallAnimator(1.0f, 1.3f, null);
                }
            }
        });
        this.animatorSetRight.start();
    }

    private void playFlashAnimator() {
        if (this.confessionWallBroadcastView != null) {
            if (this.flashView == null) {
                this.flashView = new ImageView(this.mContext);
                RelativeLayout.LayoutParams lpFlashView = new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)24.0f, (Context)BasicConfig.getInstance().getAppContext()), (int)ResolutionUtils.convertDpToPixel((float)19.0f, (Context)BasicConfig.getInstance().getAppContext()));
                lpFlashView.addRule(15);
                this.flashView.setLayoutParams((ViewGroup.LayoutParams)lpFlashView);
                this.flashView.setId(R.id.comfeesionwall_broadcast_flashview);
                this.confessionWallBroadcastView.addView((View)this.flashView);
            }
            if (this.flashView != null) {
                this.flashView.setVisibility(0);
                if (this.bean != null) {
                    this.flashView.setBackgroundResource(ConfessionUtils.getFlashAnimatorDrawableId(this.bean.mStyle));
                } else {
                    this.flashView.setBackgroundResource(R.drawable.confession_flash_1);
                }
            }
            if (this.animatorFlashSet != null) {
                this.animatorFlashSet.removeAllListeners();
                this.animatorFlashSet.end();
            }
            this.animatorFlashSet = new AnimatorSet();
            ObjectAnimator objectAnimator1 = this.createTranslationAnimator((View)this.flashView, 0);
            ObjectAnimator objectAnimator2 = this.createTranslationAnimator((View)this.flashView, 500);
            ObjectAnimator objectAnimator3 = this.createTranslationAnimator((View)this.flashView, 800);
            MLog.debug((Object)mTAG, (String)"playFlashAnimator -- addListener", (Object[])new Object[0]);
            objectAnimator3.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator2) {
                    MLog.debug((Object)ConfessionWallViewManager.mTAG, (String)"playFlashAnimator -- onAnimationEnd", (Object[])new Object[0]);
                    if (ConfessionWallViewManager.this.flashView != null) {
                        ConfessionWallViewManager.this.flashView.setVisibility(4);
                    }
                    ConfessionWallViewManager.this.startShrinkAnim();
                }
            });
            this.animatorFlashSet.play((Animator)objectAnimator1).with((Animator)this.getAlphaAnimator((View)this.flashView, 0));
            this.animatorFlashSet.play((Animator)objectAnimator2).with((Animator)this.getAlphaAnimator((View)this.flashView, 500)).after((Animator)objectAnimator1);
            this.animatorFlashSet.play((Animator)objectAnimator3).with((Animator)this.getAlphaAnimator((View)this.flashView, 800)).after((Animator)objectAnimator2);
            this.animatorFlashSet.start();
        }
    }

    private ObjectAnimator createTranslationAnimator(View view, int delay) {
        int transX = ConfessionWallBroadcastView.BroadCastViewWidth;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{transX, 0.0f});
        objectAnimator.setDuration(800L);
        objectAnimator.setStartDelay((long)delay);
        return objectAnimator;
    }

    private ObjectAnimator getAlphaAnimator(View view, int delay) {
        ObjectAnimator animatorAlpha = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        animatorAlpha.setDuration(800L);
        animatorAlpha.setStartDelay((long)delay);
        return animatorAlpha;
    }

    private void startShrinkAnim() {
        final int maxWidth = ConfessionWallBroadcastView.BroadCastViewWidth;
        final int viewX = (int)this.confessionWallBroadcastView.getX();
        if (this.vaShrink == null) {
            this.vaShrink = ValueAnimator.ofInt((int[])new int[]{0, maxWidth - this.mConfessionWallContainerMaxWidth});
        }
        this.vaShrink.setDuration(300L);
        this.vaShrink.removeAllUpdateListeners();
        this.vaShrink.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (ConfessionWallViewManager.this.confessionWallBroadcastView != null) {
                    int changeX = (Integer)animation.getAnimatedValue();
                    ((ConfessionWallViewManager)ConfessionWallViewManager.this).confessionWallBroadcastView.getLayoutParams().width = maxWidth - changeX;
                    ConfessionWallViewManager.this.confessionWallBroadcastView.setX(viewX + changeX);
                    ConfessionWallViewManager.this.confessionWallBroadcastView.requestLayout();
                }
            }
        });
        this.vaShrink.removeAllListeners();
        this.vaShrink.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (ConfessionWallViewManager.this.confessionWallBroadcastView != null) {
                    ConfessionWallViewManager.this.confessionWallBroadcastView.setVisibility(4);
                }
                ConfessionWallViewManager.this.resetConfessionWallView();
                ConfessionWallViewManager.this.resetConfessionWallBroadcastView();
                if (ConfessionWallViewManager.this.mOnAnimationFinishedListener != null) {
                    ConfessionWallViewManager.this.mOnAnimationFinishedListener.onAnimationFinished();
                }
            }
        });
        this.vaShrink.start();
    }

    public void resetConfessionWallBroadcastView() {
        if (this.confessionWallBroadcastView != null) {
            this.confessionWallBroadcastView.setX(0.0f);
            this.confessionWallBroadcastView.getLayoutParams().width = ConfessionWallBroadcastView.BroadCastViewWidth;
        }
    }

    public void resetConfessionWallView() {
        if (this.confessionInfoContainer != null) {
            this.confessionInfoContainer.setX((float)(this.mRootView.getMeasuredWidth() - this.confessionInfoContainer.getWidth() - (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)BasicConfig.getInstance().getAppContext())));
            this.confessionInfoContainer.setAlpha(1.0f);
        }
    }

    private boolean isNeedExtrude() {
        return this.timeCountDownTv == null || this.timeCountDownTv.getVisibility() == 8;
    }

    public void setWallContainerLayoutParams(RelativeLayout.LayoutParams baseLayoutParams) {
        this.wallContainerLayoutParams = baseLayoutParams;
    }

    public void setDetailLayoutParams(RelativeLayout.LayoutParams detailLayoutParams) {
        this.detailLayoutParams = detailLayoutParams;
    }

    public void setStrokeLightShowOrHide(int type2) {
        if (type2 == 3) {
            this.bottomStrokeLightRiv.setVisibility(0);
            this.topStrokeLightRiv.setVisibility(0);
        } else {
            this.bottomStrokeLightRiv.setVisibility(4);
            this.topStrokeLightRiv.setVisibility(4);
        }
    }

    public void setRightLightShowOrHide(int type2) {
        if (type2 == 1) {
            this.confessionContainerRightLight.setVisibility(4);
        } else {
            this.confessionContainerRightLight.setVisibility(0);
        }
    }

    public boolean isDetailViewIsShow() {
        return this.detailViewIsShow;
    }

    public boolean isLoadConfessionContainer() {
        return this.confessionInfoContainer != null;
    }

    public void onDispose() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.extrudeValueAnimator != null) {
            this.extrudeValueAnimator.removeAllListeners();
            this.extrudeValueAnimator.removeAllUpdateListeners();
            this.extrudeValueAnimator.end();
        }
        if (this.detailExtrudeValueAnimator != null) {
            this.detailExtrudeValueAnimator.removeAllListeners();
            this.detailExtrudeValueAnimator.removeAllUpdateListeners();
            this.detailExtrudeValueAnimator.end();
        }
        if (this.rotateAnimator != null) {
            this.rotateAnimator.removeAllListeners();
            this.rotateAnimator.end();
        }
        if (this.confessionWallBroadcastView != null) {
            this.confessionWallBroadcastView.onDisponse();
        }
        this.clearAllAnimation();
    }

    private void confessionWallAnimator(float from, float to, Animator.AnimatorListener animatorListener) {
        this.extrudeValueAnimator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        this.extrudeValueAnimator.removeAllUpdateListeners();
        this.extrudeValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float animatorValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ((ConfessionWallViewManager)ConfessionWallViewManager.this).wallContainerLayoutParams.width = (int)((float)ConfessionWallViewManager.this.confessionInfoContainerMinWidth * animatorValue);
                ConfessionWallViewManager.this.confessionInfoContainer.setLayoutParams((ViewGroup.LayoutParams)ConfessionWallViewManager.this.wallContainerLayoutParams);
            }
        });
        if (animatorListener != null) {
            this.extrudeValueAnimator.addListener(animatorListener);
        }
        this.extrudeValueAnimator.setDuration(100L);
        this.extrudeValueAnimator.start();
    }

    private void startWallDetailExtrudeAnimator() {
        if (this.confessionWallDetailView != null) {
            this.confessionWallDetailExtrudeAnimator(0.0f, 1.0f, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animator2) {
                    ConfessionWallViewManager.this.confessionWallDetailView.setVisibility(0);
                }

                public void onAnimationEnd(Animator animator2) {
                    ConfessionWallViewManager.this.isExtrudeAnimatorRun = false;
                    ConfessionWallViewManager.this.detailViewIsShow = true;
                }
            });
        }
    }

    private void confessionWallDetailExtrudeAnimator(float from, float to, Animator.AnimatorListener animatorListener) {
        if (this.detailExtrudeValueAnimator != null && (this.detailExtrudeValueAnimator.isRunning() || this.detailExtrudeValueAnimator.isStarted())) {
            this.detailExtrudeValueAnimator.removeAllListeners();
            this.detailExtrudeValueAnimator.end();
        }
        this.detailExtrudeValueAnimator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        this.detailExtrudeValueAnimator.removeAllUpdateListeners();
        this.detailExtrudeValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float animatorValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)ConfessionWallViewManager.this.confessionWallDetailView.getLayoutParams();
                layoutParams.height = (int)((float)ConfessionWallViewManager.this.confessionWallDetailView.getViewHeight() * animatorValue);
                ConfessionWallViewManager.this.confessionWallDetailView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
        this.detailExtrudeValueAnimator.removeAllListeners();
        this.detailExtrudeValueAnimator.addListener(animatorListener);
        this.detailExtrudeValueAnimator.setDuration(300L);
        this.detailExtrudeValueAnimator.start();
    }

    private void startRotateAnimator(int from, int to) {
        if (this.mClickStateTagRiv == null) {
            return;
        }
        if (this.rotateAnimator != null && (this.rotateAnimator.isRunning() || this.rotateAnimator.isStarted())) {
            this.rotateAnimator.removeAllListeners();
            this.rotateAnimator.end();
        }
        this.rotateAnimator = ObjectAnimator.ofFloat((Object)this.mClickStateTagRiv, (String)"rotation", (float[])new float[]{from, to});
        this.rotateAnimator.setDuration(100L);
        this.rotateAnimator.start();
    }

    private void updateDetailInfo() {
        if (this.confessionWallDetailView != null) {
            WallDetailBean wallDetailBean = this.createdWallDetailBean(this.bean);
            this.setDetailLayoutHeight(wallDetailBean.isCurrentInChannel);
            this.confessionWallDetailView.setData(wallDetailBean);
        }
        if (this.confessionInfoContainer != null) {
            int bgLevelId = ConfessionUtils.getBgLevelDrawableId(this.bean.mStyle);
            this.confessionInfoContainer.setBackgroundDrawable(this.mContext.getResources().getDrawable(bgLevelId));
            this.confessionWallItemView.update(this.bean.mFromUrl, this.bean.mToUrl, this.bean.mStyle);
            if (this.bean.mLeftSec <= 0) {
                this.timeCountDownTv.setVisibility(8);
            } else {
                this.timeCountDownTv.setVisibility(0);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.bean.mLeftSec);
            sb.append("s");
            this.timeCountDownTv.setText((CharSequence)sb.toString());
            this.setRightLightShowOrHide(this.bean.mStyle);
            this.setStrokeLightShowOrHide(this.bean.mStyle);
        }
    }

    private WallDetailBean createdWallDetailBean(ConfessionWallBean bean) {
        if (bean == null) {
            return null;
        }
        WallDetailBean wallDetailBean = new WallDetailBean();
        wallDetailBean.type = bean.mStyle;
        wallDetailBean.time = bean.mLeftSec;
        wallDetailBean.userNick = bean.mFromName;
        wallDetailBean.anchorNick = bean.mToName;
        wallDetailBean.giftId = bean.mGiftId;
        wallDetailBean.isCurrentInChannel = this.isInThisChannel(bean.mTopCid, bean.mSubCid);
        StringBuilder sb = new StringBuilder();
        sb.append(bean.mGiftNum).append("x").append(bean.mGroupNum);
        wallDetailBean.giftInfo = sb.toString();
        return wallDetailBean;
    }

    private boolean isInThisChannel(long topCid, long subCid) {
        boolean in;
        ChannelInfo info = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
        if (null == info) {
            return false;
        }
        boolean bl = in = topCid == info.topSid;
        if (subCid > 0L) {
            in = in && subCid == info.subSid;
        }
        return in;
    }

    @Override
    public void onClickCircusee(View v) {
        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51010", "0036");
        this.showGoChannelDialog();
    }

    private void showGoChannelDialog() {
        if (this.bean != null && (this.bean.mTopCid != 0L || this.bean.mSubCid != 0L)) {
            DialogLinkManager dialogLinkManager = new DialogLinkManager(this.mContext);
            if (this.isInThisChannel(this.bean.mTopCid, this.bean.mSubCid)) {
                dialogLinkManager.showDialog((BaseDialog)new OkDialog((CharSequence)"\u60a8\u5df2\u5728\u5f53\u524d\u76f4\u64ad\u95f4", true, true, null));
            } else {
                dialogLinkManager.showDialog((BaseDialog)new OkCancelDialog((CharSequence)"\u662f\u5426\u5207\u6362\u9891\u9053\uff1f", (CharSequence)"\u786e\u5b9a", (CharSequence)"\u53d6\u6d88", true, true, new OkCancelDialogListener(){

                    public void onCancel() {
                    }

                    public void onOk() {
                        ConfessionWallViewManager.this.toChannelWithChannelId(((ConfessionWallViewManager)ConfessionWallViewManager.this).bean.mTopCid, ((ConfessionWallViewManager)ConfessionWallViewManager.this).bean.mSubCid);
                    }
                }));
            }
        }
    }

    @Override
    public void onClickProblem(View v) {
        if (this.mContext != null) {
            ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)this.mContext, CONFESSION_WALL_DECS_URL);
        }
    }

    @Override
    public void onClickBroadCast(View v) {
        this.showGoChannelDialog();
    }

    private void toChannelWithChannelId(long sid, long ssid) {
        if (this.mContext != null) {
            boolean isUseSubSid = (Boolean)((IPluginPropertyCore)ICoreManagerBase.getCore(IPluginPropertyCore.class)).getCustomerConfig(PluginPropertyKey.ComboAllChannelNotifyToSubSid.getKey(), (Object)false);
            JoinChannelIntent.instance((long)sid, (long)(isUseSubSid ? ssid : 0L)).build().joinChannel(this.mContext);
        }
    }

    public void clearAllAnimation() {
        this.isExtrudeAnimatorRun = false;
        this.clearAnimator(this.extrudeValueAnimator);
        this.clearAnimator((ValueAnimator)this.rotateAnimator);
        this.clearAnimator(this.detailExtrudeValueAnimator);
        this.clearAnimator(this.vaShrink);
        this.clearAnimatorSet(this.animatorMoveToRightSet);
        this.clearAnimatorSet(this.animatorSetRight);
        this.clearAnimatorSet(this.animatorFlashSet);
    }

    private void clearAnimatorSet(AnimatorSet animatorSet) {
        if (animatorSet != null) {
            animatorSet.removeAllListeners();
            animatorSet.cancel();
        }
    }

    private void clearAnimator(ValueAnimator animator2) {
        if (animator2 != null) {
            animator2.removeAllUpdateListeners();
            animator2.removeAllListeners();
            animator2.cancel();
        }
    }

    public void hideConfessionRootView() {
        if (this.mRootView != null) {
            this.mRootView.setVisibility(8);
        }
    }

    public void showConfessionRootView() {
        if (this.mRootView != null && this.mRootView.getVisibility() == 8 && !this.outSizeConfessionVisibleLock) {
            this.mRootView.setVisibility(0);
        }
    }

    public void setOutSizeConfessionVisibleLock(boolean outSizeConfessionVisibleLock) {
        this.outSizeConfessionVisibleLock = outSizeConfessionVisibleLock;
    }

    public void setDetailViewIsShow(boolean detailViewIsShow) {
        this.detailViewIsShow = detailViewIsShow;
    }

    static interface OnAnimationFinishedListener {
        public void onAnimationFinished();
    }
}

