/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.chatemotion;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;
import android.widget.TextView;
import com.yy.mobile.liveapi.chatemotion.uicore.IChatEmotionCore;
import com.yy.mobile.richtext.AirTicketFilter;
import com.yy.mobile.richtext.RichTextManager;
import com.yymobile.core.ICoreManagerBase;
import java.util.ArrayList;
import java.util.List;

public class EmotionChatEditText
extends EditText {
    private Context mContext;
    private IChatEmotionCore chatEmotionCore;
    private List<RichTextManager.Feature> features = new ArrayList<RichTextManager.Feature>(){
        {
            this.add(RichTextManager.Feature.EMOTICON);
        }
    };
    private OnSendEnableListener listener;
    private TextWatcher textChangedListener;

    public EmotionChatEditText(Context context) {
        super(context);
        this.init(context);
    }

    public EmotionChatEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EmotionChatEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public EmotionChatEditText(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.chatEmotionCore = (IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class);
        this.mContext = context;
        this.addTextChangedListener(this.getTextChangedListener());
    }

    private TextWatcher getTextChangedListener() {
        if (null != this.textChangedListener) {
            return this.textChangedListener;
        }
        this.textChangedListener = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start2, int before, int count) {
            }

            public void afterTextChanged(Editable editable) {
                for (AirTicketFilter.AirTicketSpan span : (AirTicketFilter.AirTicketSpan[])editable.getSpans(0, editable.length(), AirTicketFilter.AirTicketSpan.class)) {
                    editable.removeSpan((Object)span);
                }
                if (EmotionChatEditText.this.chatEmotionCore.getRichTextFilterFeature() != null) {
                    RichTextManager.getInstance().getSpannableString(EmotionChatEditText.this.mContext, (CharSequence)editable, EmotionChatEditText.this.chatEmotionCore.getRichTextFilterFeature());
                } else {
                    RichTextManager.getInstance().getSpannableString(EmotionChatEditText.this.mContext, (CharSequence)editable, EmotionChatEditText.this.features);
                }
                String msg = editable.toString().trim();
                if (EmotionChatEditText.this.listener != null) {
                    if (TextUtils.isEmpty((CharSequence)msg)) {
                        EmotionChatEditText.this.listener.onSendEnable(false);
                    } else {
                        EmotionChatEditText.this.listener.onSendEnable(true);
                    }
                }
                if (EmotionChatEditText.this.chatEmotionCore != null) {
                    EmotionChatEditText.this.chatEmotionCore.setCurrentInputMsg(msg);
                    EmotionChatEditText.this.chatEmotionCore.setMsgSendState(-1);
                }
            }
        };
        return this.textChangedListener;
    }

    public void setListeneTextChange(boolean listene) {
        if (listene) {
            this.addTextChangedListener(this.getTextChangedListener());
        } else {
            this.removeTextChangedListener(this.getTextChangedListener());
        }
    }

    public void setText(CharSequence text, TextView.BufferType type2) {
        super.setText(text, type2);
        if (text != null) {
            this.setSelection(this.getText().length());
        }
    }

    public void setOnSendEnableListener(OnSendEnableListener listener2) {
        this.listener = listener2;
    }

    public static interface OnSendEnableListener {
        public void onSendEnable(boolean var1);
    }
}

