/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicvideomodel;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.liveapi.pk.PkChannelMessage;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.chatemotion.ChatLinkMovementMethod;
import com.yy.mobile.ui.publicchat.MergeChannelMessage;
import com.yy.mobile.ui.publicchat.NSEnterChannelMessage;
import com.yy.mobile.ui.publicchat.model.event.EnterMessageShowEvent;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.gift.GiftChannelMessage;
import com.yymobile.core.noble.NobleTalkChannelMessage;
import com.yymobile.liveapi.message.CustomChatMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;

public class ChatFragmentAdapter
extends BaseAdapter {
    private static final String TAG = "ChatFragmentAdapter";
    private final int offsetX = (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int originX = (int)ResolutionUtils.convertDpToPixel((float)4.0f, (Context)BasicConfig.getInstance().getAppContext());
    protected Context mContext;
    public List<ChannelMessage> chatData = new ArrayList<ChannelMessage>();
    private int mChatType = 1;
    private int mChatContentTextSize = 14;
    private int mChatContentLineSpace = 0;

    public ChatFragmentAdapter(Context context) {
        this(context, 1);
    }

    public ChatFragmentAdapter(Context context, int chatType) {
        this.mContext = context;
        this.mChatType = chatType;
    }

    public void setChatData(List<ChannelMessage> data) {
        if (data != null) {
            this.chatData = data;
            this.notifyDataSetChanged();
        }
    }

    public void addChatData(ConcurrentLinkedQueue<ChannelMessage> data) {
        if (data != null) {
            try {
                this.chatData.addAll(data);
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (Throwable)throwable);
            }
            this.notifyDataSetChanged();
        }
    }

    public void clearData() {
        if (this.chatData != null) {
            this.chatData.clear();
            this.notifyDataSetChanged();
        }
    }

    public int getCount() {
        if (null != this.chatData && this.chatData.size() > 0) {
            return this.chatData.size();
        }
        return 0;
    }

    public ChannelMessage getItem(int position) {
        if (null != this.chatData && this.chatData.size() > position && position >= 0) {
            return this.chatData.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View view, ViewGroup arg2) {
        ChannelMessage message;
        ViewHolder viewHolder;
        if (view == null) {
            viewHolder = new ViewHolder();
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            view = this.getCustomLayoutId() != -1 ? inflater.inflate(this.getCustomLayoutId(), null) : (this.mChatType == 2 ? inflater.inflate(R.layout.layout_guest_live_chat_assistant_item, null) : (this.mChatType == 3 || this.mChatType == 4 ? inflater.inflate(R.layout.lr_layout_guest_game_template_chat_item, null) : inflater.inflate(R.layout.mobile_live_basic_live_bottom_chatkeyboard_item, null)));
            viewHolder.tvMessage = (TextView)view.findViewById(R.id.tv_chat_content);
            view.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)view.getTag();
        }
        viewHolder.tvMessage.setTextSize(2, (float)this.mChatContentTextSize);
        viewHolder.tvMessage.setLineSpacing((float)this.mChatContentLineSpace, 1.0f);
        view.setBackgroundDrawable(null);
        if (this.chatData != null && this.chatData.size() > 0 && position < this.chatData.size() && (message = this.getItem(position)) != null) {
            if (message.spannable != null) {
                try {
                    MLog.info((Object)TAG, (String)("spannable = " + message.spannable), (Object[])new Object[0]);
                    viewHolder.tvMessage.setText((CharSequence)message.spannable);
                    this.setMessageBg(message, viewHolder.tvMessage);
                    if (message instanceof GiftChannelMessage) {
                        viewHolder.tvMessage.setTag((Object)String.valueOf(((GiftChannelMessage)message).giftTypeId));
                        message.spannableTarget = new WeakReference<TextView>(viewHolder.tvMessage);
                    } else if (message instanceof MergeChannelMessage) {
                        viewHolder.tvMessage.setTag((Object)((MergeChannelMessage)message).uniqueId);
                        message.spannableTarget = new WeakReference<TextView>(viewHolder.tvMessage);
                        if (position == this.getCount() - 1) {
                            RxBus.getDefault().post((Object)new EnterMessageShowEvent((MergeChannelMessage)message));
                        }
                    }
                }
                catch (Throwable e) {
                    if (!TextUtils.isEmpty((CharSequence)message.text)) {
                        viewHolder.tvMessage.setText((CharSequence)message.text);
                    }
                    MLog.error((Object)TAG, (String)"getView", (Throwable)e, (Object[])new Object[0]);
                }
            } else if (!TextUtils.isEmpty((CharSequence)message.text) && viewHolder.tvMessage != null) {
                viewHolder.tvMessage.setText((CharSequence)message.text);
            }
            viewHolder.tvMessage.setOnTouchListener(new View.OnTouchListener(){
                private long downTime = 0L;

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 0) {
                        this.downTime = System.currentTimeMillis();
                    } else if (event.getAction() == 1 && System.currentTimeMillis() - this.downTime > 500L) {
                        return true;
                    }
                    return false;
                }
            });
            this.setMovementMethod(viewHolder.tvMessage);
        }
        return view;
    }

    protected int getCustomLayoutId() {
        return -1;
    }

    private void setMovementMethod(TextView tvMessage) {
        try {
            tvMessage.setMovementMethod(ChatLinkMovementMethod.getInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setMessageBg(@NotNull ChannelMessage msg, @NotNull TextView tv) {
        boolean issetMsgBg = false;
        tv.setPadding(0, 0, 0, 0);
        if (Build.VERSION.SDK_INT >= 16) {
            tv.setBackground(null);
        } else {
            tv.setBackgroundDrawable(null);
        }
        if (msg instanceof PkChannelMessage) {
            tv.setBackgroundResource(R.drawable.public_chat_channelpk_message_bg);
        } else if (msg instanceof GiftChannelMessage || msg instanceof CustomChatMessage || msg instanceof PublicChatMessage || StringUtils.safeParseBoolean((String)((String)msg.tailMap.get("isSongPluginUp")))) {
            tv.setPadding((int)ResolutionUtils.convertDpToPixel((float)6.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)6.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)this.mContext));
            if (msg instanceof GiftChannelMessage) {
                GiftChannelMessage message = (GiftChannelMessage)msg;
                if (!FP.empty((Map)message.additional) && !FP.empty((CharSequence)((CharSequence)message.additional.get("gift_template_type")))) {
                    String type2 = (String)message.additional.get("gift_template_type");
                    int color2 = 441961578;
                    if ("6".equals(type2)) {
                        color2 = 452046147;
                    } else if ("7".equals(type2)) {
                        color2 = 441961578;
                    }
                    tv.setBackgroundColor(color2);
                }
            } else {
                tv.setBackgroundResource(R.drawable.public_chat_gift_message_bg);
            }
            issetMsgBg = true;
        } else if (msg instanceof NobleTalkChannelMessage || msg instanceof NSEnterChannelMessage) {
            tv.setPadding((int)ResolutionUtils.convertDpToPixel((float)6.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)6.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)this.mContext));
            tv.setBackgroundResource(R.drawable.lr_game_template_gift_text_bg);
            issetMsgBg = true;
        }
        RelativeLayout.LayoutParams orgLayoutParmas = (RelativeLayout.LayoutParams)tv.getLayoutParams();
        if (orgLayoutParmas == null) {
            MLog.error((Object)TAG, (String)"PublicChat orgLayoutParmas is null!", (Object[])new Object[0]);
        } else if (!issetMsgBg) {
            orgLayoutParmas.leftMargin = this.offsetX;
            tv.setLayoutParams((ViewGroup.LayoutParams)orgLayoutParmas);
        } else {
            orgLayoutParmas.leftMargin = this.originX;
            tv.setLayoutParams((ViewGroup.LayoutParams)orgLayoutParmas);
        }
    }

    public void onUpdateGiftDrawable(GiftChannelMessage msg) {
        WeakReference textViewWeakReference;
        TextView tv;
        MLog.info((Object)TAG, (String)("onUpdateGiftDrawable msg=" + msg), (Object[])new Object[0]);
        if (msg != null && msg.spannableTarget != null && (tv = (TextView)(textViewWeakReference = msg.spannableTarget).get()) != null) {
            Object tag = tv.getTag();
            if (String.valueOf(msg.giftTypeId).equals(tag)) {
                tv.setText((CharSequence)msg.spannable);
            }
        }
    }

    public void onUpdateMergeMessage(MergeChannelMessage msg) {
    }

    public void setPublicMessageMode(boolean isPlusMode) {
        if (isPlusMode) {
            this.mChatContentTextSize = 20;
            this.mChatContentLineSpace = (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)this.mContext);
        } else {
            this.mChatContentTextSize = 14;
            this.mChatContentLineSpace = 0;
        }
    }

    public void destory() {
        this.mContext = null;
    }

    private static class ViewHolder {
        TextView tvMessage;

        private ViewHolder() {
        }
    }
}

