/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.controller;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Log;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.BaseDanmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.DrawTask;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.IDanmakuViewController;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.IDrawTask;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.UpdateThread;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.AbsDisplayer;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDanmakus;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDisplayer;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.android.DanmakuContext;
import com.yy.mobile.ui.basicgunview.danmucanvas.renderer.IRenderer;
import com.yy.mobile.ui.basicgunview.danmucanvas.utils.DanmakuTimer;
import com.yy.mobile.ui.basicgunview.danmucanvas.utils.DeviceUtils;

public class DrawHandler
extends Handler {
    public static final int START = 1;
    public static final int UPDATE = 2;
    public static final int RESUME = 3;
    public static final int SEEK_POS = 4;
    public static final int PREPARE = 5;
    private static final int QUIT = 6;
    private static final int PAUSE = 7;
    private static final int SHOW_DANMAKUS = 8;
    private static final int HIDE_DANMAKUS = 9;
    private static final int NOTIFY_DISP_SIZE_CHANGED = 10;
    private static final int NOTIFY_RENDERING = 11;
    private static final int UPDATE_WHEN_PAUSED = 12;
    private static final int CLEAR_DANMAKUS_ON_SCREEN = 13;
    private static final long INDEFINITE_TIME = 10000000L;
    private static final int MAX_RECORD_SIZE = 500;
    private final IRenderer.RenderingState mRenderingState = new IRenderer.RenderingState();
    private final boolean mUpdateInNewThread;
    public IDrawTask drawTask;
    private DanmakuContext mContext;
    private long pausedPosition = 0L;
    private boolean quitFlag = true;
    private long mTimeBase;
    private boolean mReady;
    private Callback mCallback;
    private DanmakuTimer timer = new DanmakuTimer();
    private IDanmakuViewController mDanmakuView;
    private boolean mDanmakusVisible = true;
    private AbsDisplayer mDisp;
    private UpdateThread mThread;
    private long mCordonTime = 30L;
    private long mCordonTime2 = 60L;
    private long mFrameUpdateRate = 16L;
    private long mThresholdTime;
    private long mLastDeltaTime;
    private boolean mInSeekingAction;
    private long mDesireSeekingTime;
    private long mRemainingTime;
    private boolean mInSyncAction;
    private boolean mInWaitingState;
    private boolean mIdleSleep;

    public DrawHandler(Looper looper, IDanmakuViewController view, boolean danmakuVisibile) {
        super(looper);
        this.mUpdateInNewThread = Runtime.getRuntime().availableProcessors() > 3;
        this.mIdleSleep = !DeviceUtils.isProblemBoxDevice();
        this.bindView(view);
        if (danmakuVisibile) {
            this.showDanmakus(null);
        } else {
            this.hideDanmakus(false);
        }
        this.mDanmakusVisible = danmakuVisibile;
    }

    private void bindView(IDanmakuViewController view) {
        this.mDanmakuView = view;
    }

    public void setCallback(Callback cb) {
        this.mCallback = cb;
    }

    public void quit() {
        this.removeCallbacksAndMessages(null);
        this.sendEmptyMessage(6);
    }

    public boolean isStop() {
        return this.quitFlag;
    }

    public void handleMessage(Message msg) {
        int what = msg.what;
        switch (what) {
            case 5: {
                this.mTimeBase = SystemClock.uptimeMillis();
                if (!this.mDanmakuView.isViewReady()) {
                    this.sendEmptyMessageDelayed(5, 100L);
                    break;
                }
                this.prepare(new Runnable(){

                    @Override
                    public void run() {
                        DrawHandler.this.pausedPosition = 0L;
                        DrawHandler.this.mReady = true;
                        if (DrawHandler.this.mCallback != null) {
                            DrawHandler.this.mCallback.prepared();
                        }
                    }
                });
                break;
            }
            case 8: {
                this.mDanmakusVisible = true;
                Long start2 = (Long)msg.obj;
                boolean resume = false;
                if (this.drawTask != null) {
                    if (start2 == null) {
                        this.timer.update(this.getCurrentTime());
                    } else {
                        this.drawTask.seek(start2);
                        resume = true;
                    }
                }
                if (this.quitFlag && this.mDanmakuView != null) {
                    this.mDanmakuView.drawDanmakus();
                }
                this.notifyRendering();
                if (!resume) break;
            }
            case 1: {
                Long startTime = (Long)msg.obj;
                this.pausedPosition = startTime != null ? startTime : 0L;
            }
            case 4: {
                if (what == 4) {
                    this.quitFlag = true;
                    this.quitUpdateThread();
                    Long position = (Long)msg.obj;
                    long deltaMs = position - this.timer.currMillisecond;
                    this.mTimeBase -= deltaMs;
                    this.timer.update(position);
                    this.mContext.mGlobalFlagValues.updateMeasureFlag();
                    if (this.drawTask != null) {
                        this.drawTask.seek(position);
                    }
                    this.pausedPosition = position;
                }
            }
            case 3: {
                this.quitFlag = false;
                if (this.mReady) {
                    this.mRenderingState.reset();
                    this.mTimeBase = SystemClock.uptimeMillis() - this.pausedPosition;
                    this.timer.update(this.pausedPosition);
                    this.removeMessages(3);
                    this.sendEmptyMessage(2);
                    this.notifyRendering();
                    this.mInSeekingAction = false;
                    if (this.drawTask == null) break;
                    this.drawTask.onPlayStateChanged(1);
                    break;
                }
                this.sendEmptyMessageDelayed(3, 100L);
                break;
            }
            case 2: {
                if (this.mUpdateInNewThread) {
                    this.updateInNewThread();
                    break;
                }
                this.updateInCurrentThread();
                break;
            }
            case 10: {
                Boolean updateFlag = (Boolean)msg.obj;
                if (updateFlag == null || !updateFlag.booleanValue()) break;
                this.mContext.mGlobalFlagValues.updateMeasureFlag();
                this.mContext.mGlobalFlagValues.updateVisibleFlag();
                break;
            }
            case 9: {
                Boolean quitDrawTask;
                this.mDanmakusVisible = false;
                if (this.mDanmakuView != null) {
                    this.mDanmakuView.clear();
                }
                if (this.drawTask != null) {
                    this.drawTask.requestHide();
                }
                if (!(quitDrawTask = (Boolean)msg.obj).booleanValue()) break;
            }
            case 7: {
                this.removeMessages(2);
                if (this.drawTask != null) {
                    this.drawTask.onPlayStateChanged(2);
                }
            }
            case 6: {
                if (what == 6) {
                    this.removeCallbacksAndMessages(null);
                }
                this.quitFlag = true;
                this.syncTimerIfNeeded();
                this.pausedPosition = this.timer.currMillisecond;
                if (this.mThread != null) {
                    this.notifyRendering();
                    this.quitUpdateThread();
                }
                if (what != 6 || this.getLooper() == Looper.getMainLooper()) break;
                this.getLooper().quit();
                break;
            }
            case 11: {
                this.notifyRendering();
                break;
            }
            case 12: {
                if (!this.quitFlag || this.mDanmakuView == null) break;
                this.mDanmakuView.drawDanmakus();
                this.notifyRendering();
                break;
            }
            case 13: {
                if (this.drawTask == null) break;
                this.drawTask.clearDanmakusOnScreen(this.getCurrentTime());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quitUpdateThread() {
        if (this.mThread != null) {
            UpdateThread thread = this.mThread;
            this.mThread = null;
            IDrawTask iDrawTask = this.drawTask;
            synchronized (iDrawTask) {
                this.drawTask.notifyAll();
            }
            thread.quit();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Log.e((String)"DrawHandler", (String)"Empty Catch on quitUpdateThread", (Throwable)e);
            }
        }
    }

    private void updateInCurrentThread() {
        long dTime;
        if (this.quitFlag) {
            return;
        }
        long startMS = SystemClock.uptimeMillis();
        long d2 = this.syncTimer(startMS);
        if (d2 < 0L) {
            this.removeMessages(2);
            this.sendEmptyMessageDelayed(2, 60L - d2);
            return;
        }
        d2 = this.mDanmakuView.drawDanmakus();
        this.removeMessages(2);
        if (d2 > this.mCordonTime2) {
            this.timer.add(d2);
        }
        if (!this.mDanmakusVisible) {
            this.waitRendering(10000000L);
            return;
        }
        if (this.mRenderingState.nothingRendered && this.mIdleSleep && (dTime = this.mRenderingState.endTime - this.timer.currMillisecond) > 500L) {
            this.waitRendering(dTime - 10L);
            return;
        }
        if (d2 < this.mFrameUpdateRate) {
            this.sendEmptyMessageDelayed(2, this.mFrameUpdateRate - d2);
            return;
        }
        this.sendEmptyMessage(2);
    }

    private void updateInNewThread() {
        if (this.mThread != null) {
            return;
        }
        this.mThread = new UpdateThread("DFM Update"){

            @Override
            public void run() {
                long lastTime = SystemClock.uptimeMillis();
                long dTime = 0L;
                while (!this.isQuited() && !DrawHandler.this.quitFlag) {
                    long startMS = SystemClock.uptimeMillis();
                    dTime = SystemClock.uptimeMillis() - lastTime;
                    long diffTime = DrawHandler.this.mFrameUpdateRate - dTime;
                    if (diffTime > 1L) {
                        SystemClock.sleep((long)diffTime);
                        continue;
                    }
                    lastTime = startMS;
                    DrawHandler.this.mDanmakuView.drawDanmakus();
                    if (!DrawHandler.this.mDanmakusVisible) {
                        DrawHandler.this.waitRendering(10000000L);
                        continue;
                    }
                    if (!((DrawHandler)DrawHandler.this).mRenderingState.nothingRendered || !DrawHandler.this.mIdleSleep || (dTime = ((DrawHandler)DrawHandler.this).mRenderingState.endTime - ((DrawHandler)DrawHandler.this).timer.currMillisecond) <= 500L) continue;
                    DrawHandler.this.notifyRendering();
                    DrawHandler.this.waitRendering(dTime - 10L);
                }
            }
        };
        this.mThread.start();
    }

    private long syncTimer(long startMS) {
        if (this.mInSeekingAction || this.mInSyncAction) {
            return 0L;
        }
        this.mInSyncAction = true;
        long d2 = 0L;
        long time = startMS - this.mTimeBase;
        if (!this.mDanmakusVisible || this.mRenderingState.nothingRendered || this.mInWaitingState) {
            this.timer.update(time);
            this.mRemainingTime = 0L;
        } else {
            long gapTime = time - this.timer.currMillisecond;
            long averageTime = Math.max(this.mFrameUpdateRate, this.getAverageRenderingTime());
            if (gapTime > 2000L || this.mRenderingState.consumingTime > this.mCordonTime || averageTime > this.mCordonTime) {
                d2 = gapTime;
                gapTime = 0L;
            } else {
                d2 = averageTime + gapTime / this.mFrameUpdateRate;
                d2 = Math.max(this.mFrameUpdateRate, d2);
                long a = (d2 = Math.min(this.mCordonTime, d2)) - this.mLastDeltaTime;
                if (a > 3L && a < 8L && this.mLastDeltaTime >= this.mFrameUpdateRate && this.mLastDeltaTime <= this.mCordonTime) {
                    d2 = this.mLastDeltaTime;
                }
                gapTime -= d2;
                this.mLastDeltaTime = d2;
            }
            this.mRemainingTime = gapTime;
            this.timer.add(d2);
        }
        if (this.mCallback != null) {
            this.mCallback.updateTimer(this.timer);
        }
        this.mInSyncAction = false;
        return d2;
    }

    private void syncTimerIfNeeded() {
        if (this.mInWaitingState) {
            this.syncTimer(SystemClock.uptimeMillis());
        }
    }

    private void initRenderingConfigs() {
        long averageFrameConsumingTime = 16L;
        this.mCordonTime = Math.max(33L, (long)((float)averageFrameConsumingTime * 2.5f));
        this.mCordonTime2 = (long)((float)this.mCordonTime * 2.5f);
        this.mFrameUpdateRate = Math.max(33L, averageFrameConsumingTime / 15L * 15L);
        this.mThresholdTime = this.mFrameUpdateRate + 3L;
    }

    private void prepare(final Runnable runnable) {
        if (this.drawTask == null) {
            this.drawTask = this.createDrawTask(this.timer, this.mDanmakuView.getContext(), this.mDanmakuView.getWidth(), this.mDanmakuView.getHeight(), this.mDanmakuView.isHardwareAccelerated(), new IDrawTask.TaskListener(){

                @Override
                public void ready() {
                    DrawHandler.this.initRenderingConfigs();
                    runnable.run();
                }

                @Override
                public void onDanmakuAdd(BaseDanmaku danmaku) {
                    long delay = danmaku.time - ((DrawHandler)DrawHandler.this).timer.currMillisecond;
                    if (delay > 0L) {
                        DrawHandler.this.sendEmptyMessageDelayed(11, delay);
                    } else if (DrawHandler.this.mInWaitingState) {
                        DrawHandler.this.notifyRendering();
                    }
                }

                @Override
                public void onDanmakuShown(BaseDanmaku danmaku) {
                    if (DrawHandler.this.mCallback != null) {
                        DrawHandler.this.mCallback.danmakuShown(danmaku);
                    }
                }

                @Override
                public void checkAvaiableLine() {
                    if (DrawHandler.this.mCallback != null) {
                        DrawHandler.this.mCallback.checkAvaiableLine();
                    }
                }

                @Override
                public void onDanmakusDrawingFinished() {
                    if (DrawHandler.this.mCallback != null) {
                        DrawHandler.this.mCallback.drawingFinished();
                    }
                }

                @Override
                public void onDanmakuConfigChanged() {
                    DrawHandler.this.redrawIfNeeded();
                }
            });
        } else {
            runnable.run();
        }
    }

    public boolean isPrepared() {
        return this.mReady;
    }

    private IDrawTask createDrawTask(DanmakuTimer timer, Context context, int width, int height, boolean isHardwareAccelerated, IDrawTask.TaskListener taskListener) {
        this.mDisp = this.mContext.getDisplayer();
        this.mDisp.setSize(width, height);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mDisp.setDensities(displayMetrics.density, displayMetrics.densityDpi);
        this.mDisp.setHardwareAccelerated(isHardwareAccelerated);
        DrawTask task = new DrawTask(timer, this.mContext, taskListener);
        task.prepare();
        this.obtainMessage(10, false).sendToTarget();
        return task;
    }

    public void seekTo(Long ms) {
        this.mInSeekingAction = true;
        this.mDesireSeekingTime = ms;
        this.removeMessages(2);
        this.removeMessages(3);
        this.removeMessages(4);
        this.obtainMessage(4, ms).sendToTarget();
    }

    public void addDanmaku(BaseDanmaku item2) {
        if (this.drawTask != null) {
            item2.flags = this.mContext.mGlobalFlagValues;
            this.drawTask.addDanmaku(item2);
            this.obtainMessage(11).sendToTarget();
        }
    }

    public void invalidateDanmaku(BaseDanmaku item2, boolean remeasure) {
        if (this.drawTask != null && item2 != null) {
            this.drawTask.invalidateDanmaku(item2, remeasure);
        }
        this.redrawIfNeeded();
    }

    public void resume() {
        this.sendEmptyMessage(3);
    }

    public void prepare() {
        this.sendEmptyMessage(5);
    }

    public void pause() {
        this.syncTimerIfNeeded();
        this.sendEmptyMessage(7);
    }

    public void showDanmakus(Long position) {
        if (this.mDanmakusVisible) {
            return;
        }
        this.mDanmakusVisible = true;
        this.removeMessages(8);
        this.removeMessages(9);
        this.obtainMessage(8, position).sendToTarget();
    }

    public long hideDanmakus(boolean quitDrawTask) {
        if (!this.mDanmakusVisible) {
            return this.timer.currMillisecond;
        }
        this.mDanmakusVisible = false;
        this.removeMessages(8);
        this.removeMessages(9);
        this.obtainMessage(9, quitDrawTask).sendToTarget();
        return this.timer.currMillisecond;
    }

    public boolean getVisibility() {
        return this.mDanmakusVisible;
    }

    public void draw(Canvas canvas) {
        if (this.drawTask == null) {
            return;
        }
        this.mDisp.setExtraData(canvas);
        this.drawTask.draw(this.mDisp);
    }

    private void redrawIfNeeded() {
        if (this.quitFlag && this.mDanmakusVisible) {
            this.obtainMessage(12).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRendering() {
        if (!this.mInWaitingState) {
            return;
        }
        if (this.mUpdateInNewThread) {
            IDrawTask iDrawTask = this.drawTask;
            synchronized (iDrawTask) {
                this.drawTask.notifyAll();
            }
        } else {
            this.removeMessages(2);
            this.sendEmptyMessage(2);
        }
        this.mInWaitingState = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitRendering(long dTime) {
        this.mRenderingState.sysTime = SystemClock.uptimeMillis();
        this.mInWaitingState = true;
        if (this.mUpdateInNewThread) {
            if (this.mThread == null) {
                return;
            }
            try {
                IDrawTask iDrawTask = this.drawTask;
                synchronized (iDrawTask) {
                    if (dTime == 10000000L) {
                        this.drawTask.wait();
                    } else {
                        this.drawTask.wait(dTime);
                    }
                    this.sendEmptyMessage(11);
                }
            }
            catch (InterruptedException e) {
                Log.e((String)"DrawHandler", (String)"Empty Catch on waitRendering", (Throwable)e);
            }
        } else if (dTime == 10000000L) {
            this.removeMessages(11);
            this.removeMessages(2);
        } else {
            this.removeMessages(11);
            this.removeMessages(2);
            this.sendEmptyMessageDelayed(11, dTime);
        }
    }

    private synchronized long getAverageRenderingTime() {
        return 0L;
    }

    private synchronized void recordRenderingTime() {
    }

    public IDisplayer getDisplayer() {
        return this.mDisp;
    }

    public void notifyDispSizeChanged(int width, int height) {
        if (this.mDisp == null) {
            return;
        }
        if (this.mDisp.getWidth() != width || this.mDisp.getHeight() != height) {
            this.mDisp.setSize(width, height);
            this.obtainMessage(10, true).sendToTarget();
        }
    }

    public void removeAllDanmakus(boolean isClearDanmakusOnScreen) {
        if (this.drawTask != null) {
            this.drawTask.removeAllDanmakus(isClearDanmakusOnScreen);
        }
    }

    public void removeAllLiveDanmakus() {
        if (this.drawTask != null) {
            this.drawTask.removeAllLiveDanmakus();
        }
    }

    public IDanmakus getCurrentVisibleDanmakus() {
        if (this.drawTask != null) {
            return this.drawTask.getVisibleDanmakusOnTime(this.getCurrentTime());
        }
        return null;
    }

    public long getCurrentTime() {
        if (!this.mReady) {
            return 0L;
        }
        if (this.mInSeekingAction) {
            return this.mDesireSeekingTime;
        }
        if (this.quitFlag || !this.mInWaitingState) {
            return this.timer.currMillisecond - this.mRemainingTime;
        }
        return SystemClock.uptimeMillis() - this.mTimeBase;
    }

    public void clearDanmakusOnScreen() {
        this.obtainMessage(13).sendToTarget();
    }

    public DanmakuContext getConfig() {
        return this.mContext;
    }

    public void setConfig(DanmakuContext config) {
        this.mContext = config;
    }

    public static interface Callback {
        public void prepared();

        public void updateTimer(DanmakuTimer var1);

        public void danmakuShown(BaseDanmaku var1);

        public void drawingFinished();

        public void checkAvaiableLine();
    }
}

