/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicfunction;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AudienceVideoQualityManager;
import com.yy.mobile.sdkwrapper.flowmanagement.api.line.StreamLineBrokenListener;
import com.yy.mobile.sdkwrapper.flowmanagement.api.line.StreamLineManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videoquality.IAudienceVideoQualityChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.basicfunction.StreamLineAdapter;
import com.yy.mobile.ui.meidabasicvideoview.uicore.IMediaVideoBasicCore;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelState;
import java.util.List;
import java.util.Map;

public class StreamLineCodeRatePopupComponent
extends BasePopupComponent
implements IAudienceVideoQualityChangeListener,
StreamLineBrokenListener {
    private static final String TAG = "StreamLineCodeRatePopup";
    private RecyclerView mRecycleView;
    private StreamLineAdapter mAdapter;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        AudienceVideoQualityManager.getInstance().addVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
        StreamLineManager.getInstance().addLineBrokenListener((StreamLineBrokenListener)this);
    }

    public void onDestroy() {
        super.onDestroy();
        AudienceVideoQualityManager.getInstance().removeVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
        StreamLineManager.getInstance().removeLineBrokenListener((StreamLineBrokenListener)this);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setStyle(0, 16973833);
        View root = inflater.inflate(R.layout.layout_streamline_dialog, container, false);
        this.mRecycleView = (RecyclerView)root.findViewById(R.id.lines_recycleview);
        this.mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity(), 1, false));
        this.initAdapter();
        this.mRecycleView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        return root;
    }

    public void onResume() {
        this.setWindowSize();
        super.onResume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(FragmentManager manager, String tag) {
        try {
            super.show(manager, tag);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
        }
        finally {
            AudienceVideoQualityManager.getInstance().removeVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
            StreamLineManager.getInstance().removeLineBrokenListener((StreamLineBrokenListener)this);
        }
    }

    private void setWindowSize() {
        int height;
        int width;
        boolean isLandscape = this.getResources().getConfiguration().orientation == 2;
        Dialog dialog = this.getDialog();
        WindowManager.LayoutParams lWindowParams = new WindowManager.LayoutParams();
        lWindowParams.copyFrom(this.getDialog().getWindow().getAttributes());
        if (isLandscape) {
            width = (int)ResolutionUtils.convertDpToPixel((float)340.0f, (Context)this.getContext());
            height = -1;
            lWindowParams.width = (int)ResolutionUtils.convertDpToPixel((float)340.0f, (Context)this.getContext());
            lWindowParams.height = -1;
        } else {
            width = -1;
            height = (int)ResolutionUtils.convertDpToPixel((float)230.0f, (Context)this.getContext());
            lWindowParams.width = -1;
            lWindowParams.height = (int)ResolutionUtils.convertDpToPixel((float)230.0f, (Context)this.getContext());
        }
        dialog.getWindow().setLayout(width, height);
    }

    private void initAdapter() {
        this.mAdapter = new StreamLineAdapter();
        this.initData(false);
        this.mAdapter.setOnItemClickListener(new StreamLineAdapter.OnItemClickListener(){

            @Override
            public void onClick(int lineNum, AudienceVideoQuality quality) {
                MLog.info((Object)StreamLineCodeRatePopupComponent.TAG, (String)"onclick switch line and quality:%s, %s", (Object[])new Object[]{lineNum, quality});
                StreamLineCodeRatePopupComponent.this.showMediaVideoLoading();
                AudienceVideoQualityManager.getInstance().switchVideoQuality(quality, lineNum);
                StreamLineCodeRatePopupComponent.this.mAdapter.setCurrentStream(lineNum, quality);
                StreamLineCodeRatePopupComponent.this.mAdapter.notifyDataSetChanged();
                StreamLineCodeRatePopupComponent.this.dismissAllowingStateLoss();
            }
        });
    }

    private void showMediaVideoLoading() {
        if (!((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).getVideoStopFlag() && ICoreManagerBase.getChannelLinkCore().getChannelState() != ChannelState.No_Channel) {
            MLog.info((Object)TAG, (String)"showMediaVideoLoading", (Object[])new Object[0]);
            ((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).showLineChangeVideoLoading(true);
        }
    }

    private void initData(boolean notifyChanged) {
        if (this.mAdapter != null) {
            Map linesQualities = AudienceVideoQualityManager.getInstance().getFullQualityVideoLines();
            MLog.info((Object)TAG, (String)"Adapter full linesQualities:%s", (Object[])new Object[]{linesQualities});
            this.mAdapter.setData(linesQualities);
            int curLine = AudienceVideoQualityManager.getInstance().getCurrentVideoLine();
            AudienceVideoQuality curQuality = AudienceVideoQualityManager.getInstance().getSelectedVideoQuality();
            MLog.info((Object)TAG, (String)"current line and quality: %s, %s", (Object[])new Object[]{curLine, curQuality});
            this.mAdapter.setCurrentStream(curLine, curQuality);
            if (notifyChanged) {
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        boolean isLandscape = this.getResources().getConfiguration().orientation == 2;
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawableResource(R.color.basic_func_global_bg);
        dialog.getWindow().addFlags(1024);
        dialog.getWindow().clearFlags(2);
        if (isLandscape) {
            dialog.getWindow().setWindowAnimations(R.style.DialogAnimationRightSlide);
            dialog.getWindow().setGravity(5);
        } else {
            dialog.getWindow().setWindowAnimations(R.style.DialogAnimation);
            dialog.getWindow().setGravity(80);
        }
        return dialog;
    }

    public void onUpdateAvaliableVideoQualities(List<AudienceVideoQuality> videoQualities) {
        this.initData(true);
    }

    public void onUpdateStreamLineInfo(Map<Integer, List<AudienceVideoQuality>> lineQuality) {
        this.initData(true);
    }

    public void onUpdateCurStreamLine(Integer curLine, AudienceVideoQuality curVideoQuality) {
        this.initData(true);
    }

    public void onCurrentLineBroken(int brokenLine) {
        this.initData(true);
    }
}

