/*
 * Decompiled with CFR 0.152.
 */
package com.yy.social.ui;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IPublicChatBroadcastClient_appendRevenueMessage_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.plugin.main.events.ICavalierClient_onComsueTaskMarquee_EventArgs;
import com.yy.mobile.plugin.main.events.IPublicChatBroadcastClient_onShowRevenueMarque_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.marquee.MarqueeController;
import com.yy.mobile.ui.publicchat.PublicChatRevenueController;
import com.yy.mobile.ui.startask.TaskChannelMessage;
import com.yy.mobile.util.log.MLog;
import com.yy.social.ui.MarqueeComponent$$EventBinder;
import java.util.Map;

public class MarqueeComponent
extends Component {
    private View mRootView;
    private MarqueeController mMarqueeController;
    private EventBinder mMarqueeComponentSniperEventBinder;

    public static MarqueeComponent newInstance() {
        MarqueeComponent component = new MarqueeComponent();
        return component;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.fragment_marquee_view, container, false);
        RelativeLayout parentView = (RelativeLayout)this.mRootView.findViewById(R.id.marquee_component);
        this.mMarqueeController = new MarqueeController(this.getContext(), (ViewGroup)parentView, MarqueeController.LiveRoomType.ILIVE);
        MLog.info((Object)"MarqueeComponent", (String)"MarqueeComponent onCreateView", (Object[])new Object[0]);
        return this.mRootView;
    }

    @BusEvent(sync=true)
    public void onComsueTaskMarquee(ICavalierClient_onComsueTaskMarquee_EventArgs busEventArgs) {
        long uid = busEventArgs.getUid();
        int level = busEventArgs.getLevel();
        String name = busEventArgs.getName();
        int nobleLevel = busEventArgs.getNobleLevel();
        MLog.info((Object)"MarqueeComponent", (String)("onComsueTaskMarquee uid:" + uid + ", level:" + level + ", name:" + name + ", nobleLevel:" + nobleLevel), (Object[])new Object[0]);
        if (this.mMarqueeController != null) {
            String text = this.setMessageFormat(name, nobleLevel, level);
            SpannableString spannableString = new SpannableString((CharSequence)text);
            int len = name.length();
            spannableString.setSpan((Object)new StyleSpan(0), 0, 2, 33);
            int tag = 2;
            spannableString.setSpan((Object)new StyleSpan(1), tag, tag + len, 33);
            spannableString.setSpan((Object)new StyleSpan(0), tag + len, text.length(), 33);
            if (level != 0 || nobleLevel <= 0) {
                this.mMarqueeController.setStyle(level, spannableString);
            }
        }
    }

    private String setMessageFormat(String name, int nobleLevel, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u6b22\u8fce ");
        if (nobleLevel > 0 && level > 0) {
            sb.append("[noblelv]");
        }
        sb.append(name);
        sb.append(" \u8fdb\u5165\u76f4\u64ad\u95f4");
        return sb.toString();
    }

    @BusEvent(sync=true)
    public void onShowRevenueMarque(IPublicChatBroadcastClient_onShowRevenueMarque_EventArgs busEventArgs) {
        boolean isShow = busEventArgs.getIsShow();
        if (this.mMarqueeController != null && !isShow) {
            this.mMarqueeController.hideView();
        }
    }

    private void setBroadCastMessage(long uid, String name, int level, Map<String, String> extendInfo, int nobleLevel, TaskChannelMessage.MessageType type) {
        TaskChannelMessage message = new TaskChannelMessage();
        message.uid = uid;
        message.nickname = name;
        if (type == TaskChannelMessage.MessageType.Normal) {
            message.time = 4000;
        }
        message.level = level;
        message.extendInfo = extendInfo;
        PluginBus.INSTANCE.get().post((Object)new IPublicChatBroadcastClient_appendRevenueMessage_EventArgs(message, PublicChatRevenueController.Priority.COMSUME_TASK));
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.mMarqueeController != null) {
            this.mMarqueeController.onOrientationChanges(isLandscape);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.mMarqueeController != null) {
            this.mMarqueeController.onResume();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mMarqueeController != null) {
            this.mMarqueeController.onPause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mMarqueeController != null) {
            this.mMarqueeController.onDestroy();
        }
    }

    protected boolean isLandScape() {
        if (this.getActivity() != null) {
            return this.getActivity().getResources().getConfiguration().orientation == 2;
        }
        return false;
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mMarqueeComponentSniperEventBinder == null) {
            this.mMarqueeComponentSniperEventBinder = new MarqueeComponent$$EventBinder();
        }
        this.mMarqueeComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mMarqueeComponentSniperEventBinder != null) {
            this.mMarqueeComponentSniperEventBinder.unBindEvent();
        }
    }
}

