/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.ylink;

import android.annotation.TargetApi;
import android.app.Activity;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IBasicFunctionClient_onSetScreenBrightness_EventArgs;
import com.yy.mobile.ui.basicfunction.BrightnessUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import java.lang.ref.WeakReference;

public class BrightnessObserver
extends ContentObserver {
    private static final Uri BRIGHTNESS_MODE_URI = Settings.System.getUriFor((String)"screen_brightness_mode");
    private static final Uri BRIGHTNESS_URI = Settings.System.getUriFor((String)"screen_brightness");
    private static final Uri BRIGHTNESS_ADJ_URI = Settings.System.getUriFor((String)"screen_auto_brightness_adj");
    private WeakReference<Activity> mActivity;

    public BrightnessObserver(Activity mActivity) {
        super((Handler)new SafeDispatchHandler(Looper.getMainLooper()));
        this.mActivity = new WeakReference<Activity>(mActivity);
    }

    public void onChange(boolean selfChange) {
        this.onChange(selfChange, null);
    }

    public void onChange(boolean selfChange, Uri uri) {
        super.onChange(selfChange);
        if (selfChange) {
            return;
        }
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null) {
            return;
        }
        if (!this.checkActivityValid(activity)) {
            return;
        }
        MLog.info((Object)"BrightnessObserver", (String)"[ouyangyj] BrightnessObserver onChange", (Object[])new Object[0]);
        if (BRIGHTNESS_MODE_URI.equals((Object)uri)) {
            MLog.info((Object)"BrightnessObserver", (String)"[ouyangyj] brightness mode changed", (Object[])new Object[0]);
        } else if (BRIGHTNESS_URI.equals((Object)uri) && !BrightnessUtils.isAutoBrightness(activity)) {
            MLog.info((Object)"BrightnessObserver", (String)"[ouyangyj] brightness mode is not auto mode, value changed", (Object[])new Object[0]);
        } else if (BRIGHTNESS_ADJ_URI.equals((Object)uri) && BrightnessUtils.isAutoBrightness(activity)) {
            MLog.info((Object)"BrightnessObserver", (String)"[ouyangyj] brightness mode is auto mode, value changed", (Object[])new Object[0]);
        } else {
            MLog.info((Object)"BrightnessObserver", (String)"[ouyangyj] brightness update, other", (Object[])new Object[0]);
        }
        if (this.checkActivityValid(activity)) {
            int curBrightness = BrightnessUtils.getScreenBrightness(activity);
            RxBus.getDefault().post((Object)new IBasicFunctionClient_onSetScreenBrightness_EventArgs(curBrightness));
        }
    }

    @TargetApi(value=17)
    public boolean checkActivityValid(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (activity.isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !activity.isDestroyed();
    }

    public void onDestry() {
        this.mActivity.clear();
        this.mActivity = null;
    }
}

