/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.channelmedaivideoinfo;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.os.Looper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelProgress_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onRequestJoinChannelExist_EventArgs;
import com.yy.mobile.plugin.main.events.IMediaClient_addChannelMediaAnchorInfoExt_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onAnchorStopLiveBroad_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AudienceVideoQualityManager;
import com.yy.mobile.sdkwrapper.flowmanagement.api.videoinfo.VideoDebugInfoManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videoquality.IAudienceVideoQualityChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoDebugInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.videoinfo.VideoDebugInfoListener;
import com.yy.mobile.sdkwrapper.yylive.media.event.AnchorBroadcastDataEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.MediaLinkInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.NoVideoInfoEventArgs;
import com.yy.mobile.ui.basicchanneltemplate.Temp;
import com.yy.mobile.ui.channeltimestatistics.ChannelTimeStatisticsUtil;
import com.yy.mobile.ui.screencapture.CaptureConstant;
import com.yy.mobile.ui.screencapture.ui.AbsFloatingView;
import com.yy.mobile.ui.widget.channelmedaivideoinfo.ChannelMediaVideoInfoView$$EventBinder;
import com.yy.mobile.ui.widget.channelmedaivideoinfo.ChannelMediaVideoInfoView$EventObject$$EventBinder;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.LiveRxBus;
import com.yymobile.core.channel.ChannelInfo;
import com.yyproto.utils.FP;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ChannelMediaVideoInfoView
extends AbsFloatingView
implements EventCompat,
VideoDebugInfoListener,
IAudienceVideoQualityChangeListener {
    private static final byte[] lock = new byte[0];
    private View mRootView;
    public View mScrollView;
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper());
    private static SoftReference<ChannelMediaVideoInfoView> instance;
    public int mMediaAudioState = 1;
    protected TextView channelAndMedia;
    protected TextView myUid;
    protected TextView channelInfo;
    protected TextView channelTpl;
    protected TextView audioState;
    protected TextView noVideoInfoView;
    protected TextView slipTime;
    protected TextView joinchannelTime;
    protected TextView leaveChannelTime;
    protected TextView arriveAndfirstFrametime;
    protected TextView totalTime;
    protected TextView auchorInfo;
    protected TextView anchorInfoExt;
    protected TextView gameMinBuffer;
    protected TextView mTvVideoInfo;
    protected TextView mTvStreamName;
    protected TextView lineQuality;
    protected TextView mTvAnchorEndBroadcast;
    private float textSize = 9.0f;
    private String textBackColor = "#e6D6D0D2";
    private Context appContext = this.getContext();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private Object object = new EventObject();
    private EventBinder mChannelMediaVideoInfoViewSniperEventBinder;

    private ChannelMediaVideoInfoView(Context context) {
        super(context);
    }

    public void onEventBind() {
        if (this.mChannelMediaVideoInfoViewSniperEventBinder == null) {
            this.mChannelMediaVideoInfoViewSniperEventBinder = new ChannelMediaVideoInfoView$$EventBinder();
        }
        this.mChannelMediaVideoInfoViewSniperEventBinder.bindEvent((Object)this);
        MLog.info((Object)"ChannelMediaVideoInfoView", (String)"onEventBind", (Object[])new Object[0]);
    }

    public void onEventUnBind() {
        if (this.mChannelMediaVideoInfoViewSniperEventBinder != null) {
            this.mChannelMediaVideoInfoViewSniperEventBinder.unBindEvent();
        }
        MLog.info((Object)"ChannelMediaVideoInfoView", (String)"onEventBind", (Object[])new Object[0]);
    }

    @Override
    public void attach() {
        MLog.info((Object)"ChannelMediaVideoInfoView", (String)"attach ", (Object[])new Object[0]);
        super.attach();
    }

    @Override
    public void detach() {
        MLog.info((Object)"ChannelMediaVideoInfoView", (String)"detach ", (Object[])new Object[0]);
        this.removeObserver();
        this.onDestroy();
        this.disposables.clear();
        super.detach();
    }

    @Override
    public View inflate(Context context) {
        this.mRootView = LayoutInflater.from((Context)context).inflate(R.layout.test_media_video_floating, null);
        this.setDragTriggerView(this.mRootView.findViewById(R.id.hide_text));
        this.mScrollView = this.mRootView.findViewById(R.id.scroll_view);
        this.mRootView.findViewById(R.id.hide_text).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChannelMediaVideoInfoView.this.mScrollView != null) {
                    ChannelMediaVideoInfoView.this.mScrollView.setVisibility(ChannelMediaVideoInfoView.this.mScrollView.getVisibility() == 0 ? 8 : 0);
                }
            }
        });
        this.initTestView();
        return this.mRootView;
    }

    private void initTestView() {
        MLog.info((Object)"ChannelMediaVideoInfoView", (String)"initTestView ", (Object[])new Object[0]);
        LinearLayout linearLayout = (LinearLayout)this.mRootView.findViewById(R.id.layout_container);
        this.channelAndMedia = this.initTextView((ViewGroup)linearLayout);
        this.myUid = this.initTextView((ViewGroup)linearLayout);
        this.mTvStreamName = this.initTextView((ViewGroup)linearLayout);
        this.mTvVideoInfo = this.initTextView((ViewGroup)linearLayout);
        this.mTvAnchorEndBroadcast = this.initTextView((ViewGroup)linearLayout);
        this.lineQuality = this.initTextView((ViewGroup)linearLayout);
        this.channelInfo = this.initTextView((ViewGroup)linearLayout);
        this.channelTpl = this.initTextView((ViewGroup)linearLayout);
        this.audioState = this.initTextView((ViewGroup)linearLayout);
        this.noVideoInfoView = this.initTextView((ViewGroup)linearLayout);
        this.slipTime = this.initTextView((ViewGroup)linearLayout);
        this.leaveChannelTime = this.initTextView((ViewGroup)linearLayout);
        this.joinchannelTime = this.initTextView((ViewGroup)linearLayout);
        this.arriveAndfirstFrametime = this.initTextView((ViewGroup)linearLayout);
        this.totalTime = this.initTextView((ViewGroup)linearLayout);
        this.auchorInfo = this.initTextView((ViewGroup)linearLayout);
        this.anchorInfoExt = this.initTextView((ViewGroup)linearLayout);
        this.gameMinBuffer = this.initTextView((ViewGroup)linearLayout);
    }

    private TextView initTextView(ViewGroup viewGroup) {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
        TextView tv = new TextView(this.appContext);
        tv.setPadding((int)ResolutionUtils.convertDpToPixel((float)4.0f, (Context)this.appContext), 0, 0, 0);
        tv.setTextSize(this.textSize);
        tv.setBackgroundColor(Color.parseColor((String)this.textBackColor));
        tv.setTextColor(-16777216);
        tv.setLayoutParams((ViewGroup.LayoutParams)lp);
        tv.setVisibility(8);
        tv.setLineSpacing(1.0f, 1.5f);
        viewGroup.addView((View)tv);
        return tv;
    }

    @Override
    public WindowManager.LayoutParams configParams() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.type = 2002;
        params.format = 1;
        params.flags = 40;
        params.gravity = 51;
        params.x = 0;
        int max = Math.max(CaptureConstant.SCREEN_WIDTH, CaptureConstant.SCREEN_HEIGHT);
        params.y = max / 2 - CaptureConstant.FLOAT_BAR_HEIGHT / 2;
        params.height = -2;
        params.width = -2;
        return params;
    }

    @BusEvent(sync=true)
    public void onJoinChannelProgress(IChannelLinkClient_onJoinChannelProgress_EventArgs busEventArgs) {
        if (ChannelMediaVideoInfoView.shouldShow()) {
            this.setTextViewString(this.channelAndMedia, "channelState:" + ICoreManagerBase.getChannelLinkCore().getChannelState());
            this.setTextViewString(this.noVideoInfoView, "");
        } else {
            this.onEventUnBind();
        }
    }

    @BusEvent
    public void onAnchorStopBroadcast(IMobileLiveClient_onAnchorStopLiveBroad_EventArgs event) {
        this.setTextViewString(this.mTvAnchorEndBroadcast, "\u4e3b\u64ad\u505c\u64ad\uff1a" + new SimpleDateFormat("yyyyy-mm-dd hh:mm:ss", Locale.CHINA).format(new Date()));
    }

    public void onVideoDebugInfoUpdate(List<VideoDebugInfo> list2) {
        if (FP.size(list2) > 0) {
            VideoDebugInfo debugInfo = list2.get(0);
            this.setTextViewString(this.mTvStreamName, "\u6d41\u540d\u79f0: " + debugInfo.videoStreamList);
            StringBuilder sb = new StringBuilder();
            sb.append("                  \u5927\u698220\u79d2\u5237\u65b0\u4e00\u6b21").append("\n");
            sb.append("\u7f16\u7801\u5206\u8fa8\u7387: ").append(debugInfo.encodeVideoResolution).append("\n");
            sb.append("\u89e3\u7801\u5206\u8fa8\u7387: ").append(debugInfo.decodeVideoResolution).append("\n");
            sb.append("\u4e3b\u64ad\u7aef\u7f16\u7801\u7801\u7387: ").append(debugInfo.encodeBitRate).append("\n");
            sb.append("\u89c2\u4f17\u7aef\u7801\u7387\u8303\u56f4\uff1a").append(debugInfo.audienceCodeRateRange).append("\n");
            sb.append("\u7801\u7387\u5217\u8868: ").append(debugInfo.bitRateList).append("\n");
            sb.append("\u89c2\u4f17\u7aef\u9009\u62e9\u7801\u7387: ").append(debugInfo.selectedBitRate).append("\n");
            sb.append("\u89c2\u4f17\u7aef\u89e3\u7801\u7801\u7387: ").append(debugInfo.decodeBitRate).append("\n");
            sb.append("\u89c2\u4f17\u7aef\u89e3\u7801\u5e27\u7387: ").append(debugInfo.decodeFrameRate).append("\n");
            sb.append("\u89c2\u4f17\u7aef\u89e3\u7801\u7c7b\u578b: ").append(debugInfo.decodeType).append("\n");
            sb.append("\u4e3b\u64ad\u7aef\u7f16\u7801\u7c7b\u578b: ").append(debugInfo.encodeType).append("\n");
            sb.append("rtt: ").append(debugInfo.rttInMs).append("\n");
            sb.append("\u591a\u4eba\u8fde\u9ea6\u4fe1\u606f\uff1a").append(debugInfo.multiVideoInfo).append("\n");
            sb.append("\u64ad\u653e\u72b6\u6001: ").append(debugInfo.playStatusInfo).append("\n");
            this.setTextViewString(this.mTvVideoInfo, sb.toString());
        }
    }

    public void onUpdateAvaliableVideoQualities(List<AudienceVideoQuality> videoQualities) {
        this.updateLineQualityInfo();
    }

    public void onUpdateStreamLineInfo(Map<Integer, List<AudienceVideoQuality>> map) {
        this.updateLineQualityInfo();
    }

    public void onUpdateCurStreamLine(Integer integer, AudienceVideoQuality videoQuality) {
        this.updateLineQualityInfo();
    }

    private void updateLineQualityInfo() {
        int curLine = AudienceVideoQualityManager.getInstance().getCurrentVideoLine();
        AudienceVideoQuality curQuality = AudienceVideoQualityManager.getInstance().getSelectedVideoQuality();
        String qu = curQuality.getName();
        String s = "\u5f53\u524d\u7ebf\u8def: " + curLine + " \u6e05\u6670\u5ea6: " + qu;
        this.setTextViewString(this.lineQuality, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChannelMediaVideoInfoView getInstance() {
        if (instance != null && instance.get() != null) return instance.get();
        byte[] byArray = lock;
        synchronized (lock) {
            if (instance != null && instance.get() != null) return instance.get();
            ChannelMediaVideoInfoView channelMediaVideoInfoView = new ChannelMediaVideoInfoView(BasicConfig.getInstance().getAppContext());
            instance = new SoftReference<ChannelMediaVideoInfoView>(channelMediaVideoInfoView);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance.get();
        }
    }

    public void removeFromStage() {
        MLog.info((Object)"ChannelMediaVideoInfoView", (String)"removeFromStage ~~~", (Object[])new Object[0]);
        this.detach();
    }

    @TargetApi(value=11)
    public void addToStage() {
        MLog.info((Object)"ChannelMediaVideoInfoView", (String)"addToStage ~~~", (Object[])new Object[0]);
        try {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                this.addToStageInit();
            } else {
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ChannelMediaVideoInfoView.this.addToStageInit();
                    }
                }, 2000L);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)"ChannelMediaVideoInfoView", (String)("addToStage error = " + throwable), (Object[])new Object[0]);
        }
    }

    public void addToStageInit() {
        if (ChannelMediaVideoInfoView.shouldShow()) {
            this.onEventBind();
            this.addObserver();
            this.attach();
            this.setChannelInfo();
            this.setMediaText();
            this.registerMediaVideoEvent();
        }
    }

    private void addObserver() {
        this.removeObserver();
        ICoreManagerBase.addClient((Object)this.object);
        VideoDebugInfoManager.getInstance().addVideoDebugInfoUpdateListener((VideoDebugInfoListener)this);
        AudienceVideoQualityManager.getInstance().addVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
    }

    private void removeObserver() {
        ICoreManagerBase.removeClient((Object)this.object);
        VideoDebugInfoManager.getInstance().removeVideoDebugInfoUpdateListener((VideoDebugInfoListener)this);
        AudienceVideoQualityManager.getInstance().removeVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
    }

    private void onDestroy() {
        this.handler.removeCallbacksAndMessages(null);
    }

    private void registerMediaVideoEvent() {
        this.registerAnchorBroadcastDataEvent();
        this.registerNoVideoInfoEvent();
    }

    private void registerNoVideoInfoEvent() {
        this.disposables.add(LiveRxBus.getInstance().register(NoVideoInfoEventArgs.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<NoVideoInfoEventArgs>(){

            public void accept(@NonNull NoVideoInfoEventArgs noVideoInfoEventArgs) throws Exception {
                ChannelMediaVideoInfoView.this.setTextViewString(ChannelMediaVideoInfoView.this.noVideoInfoView, "noVideoInfo:" + noVideoInfoEventArgs.reason);
            }
        }, RxUtils.errorConsumer((String)"ChannelMediaVideoInfoView", (String)"NoVideoInfoEventArgs error")));
    }

    @BusEvent
    public void registerChannelMediaAudioStateEvent(MediaLinkInfoEventArgs channelAudioStateInfo) {
        MLog.info((Object)"ChannelMediaVideoInfoView", (String)("[MediaCore Response] => [onChannelAudioStateNotify] channelAudioStateInfo.state = " + channelAudioStateInfo.state), (Object[])new Object[0]);
        this.mMediaAudioState = channelAudioStateInfo.state;
        this.getMediaAudioState(this.mMediaAudioState);
    }

    private void registerAnchorBroadcastDataEvent() {
        this.disposables.add(LiveRxBus.getInstance().register(AnchorBroadcastDataEventArgs.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<AnchorBroadcastDataEventArgs>(){

            public void accept(@NonNull AnchorBroadcastDataEventArgs anchorBroadcastData) throws Exception {
                if (anchorBroadcastData != null) {
                    ChannelMediaVideoInfoView.this.setTextViewString(ChannelMediaVideoInfoView.this.auchorInfo, "auchorInfo:uid:" + anchorBroadcastData.uid + " \nuserGroupId:" + anchorBroadcastData.userGroupId + " \nstreamId:" + anchorBroadcastData.streamId + " \nintDatas:" + anchorBroadcastData.intDatas + " \nstrDatas:" + anchorBroadcastData.strDatas);
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelMediaVideoInfoView", (String)"AnchorBroadcastDataEventArgs error")));
    }

    public void setTextViewString(final TextView view, final String textString) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            if (view != null) {
                if (!TextUtils.isEmpty((CharSequence)textString)) {
                    view.setVisibility(0);
                    view.setText((CharSequence)textString);
                } else {
                    view.setVisibility(8);
                }
            }
        } else {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (view != null) {
                        if (!TextUtils.isEmpty((CharSequence)textString)) {
                            view.setVisibility(0);
                            view.setText((CharSequence)textString);
                        } else {
                            view.setVisibility(8);
                        }
                    }
                }
            });
        }
    }

    private void getMediaAudioState(int state) {
        switch (state) {
            case 1: {
                this.setTextViewString(this.audioState, "audioState:NoAudio");
                break;
            }
            case 2: {
                this.setTextViewString(this.audioState, "audioState:RecvAudio");
                break;
            }
            case 3: {
                this.setTextViewString(this.audioState, "audioState:RecvNoAudio");
                break;
            }
        }
    }

    public void setChannelInfo() {
        ChannelInfo currentChannelInfo = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
        this.setTextViewString(this.channelAndMedia, "channelState:" + ICoreManagerBase.getChannelLinkCore().getChannelState());
        long userId = LoginUtil.getUid();
        if (userId == 0L) {
            userId = LoginUtil.getAnoymousUid();
        }
        this.setTextViewString(this.myUid, "myUid:" + userId);
        this.setTextViewString(this.channelInfo, "channelInfo:" + currentChannelInfo.topASid + "/" + currentChannelInfo.topSid + "/" + currentChannelInfo.subSid);
        this.setTextViewString(this.channelTpl, "channelTpl:" + ICoreManagerBase.getChannelLinkCore().getTemplateId() + "/" + (Temp.getCurrentBussinessId() == null ? "null" : Temp.getCurrentBussinessId()));
        this.getMediaAudioState(this.mMediaAudioState);
        this.setChannelTime();
    }

    public static boolean shouldShow() {
        return BasicConfig.getInstance().isDebuggable() && CommonPref.instance().getBoolean("PRE_SETTING_JUMP_TO_CHANNELVIEW", false);
    }

    private void setChannelTime() {
        this.setTextViewString(this.slipTime, "slipTime :" + ChannelTimeStatisticsUtil.instance().getSlipTimeOver());
        this.setTextViewString(this.leaveChannelTime, "leaveChannelTime :" + ChannelTimeStatisticsUtil.instance().getLeaveChannelTimeOver());
        this.setTextViewString(this.joinchannelTime, "joinchannelTime :" + ChannelTimeStatisticsUtil.instance().getJoinChannelTimeOver());
        this.setTextViewString(this.arriveAndfirstFrametime, "arriveTime/firstFrametime :" + ChannelTimeStatisticsUtil.instance().getArriveMediaTimeOver() + "/" + ChannelTimeStatisticsUtil.instance().getFirstFrameOver());
        this.setTextViewString(this.totalTime, "totalTime :" + ChannelTimeStatisticsUtil.instance().getAllTimeOver());
        this.setTextViewString(this.gameMinBuffer, "minBuffer :" + ChannelTimeStatisticsUtil.instance().getGameMinBuffer());
    }

    private void setMediaText() {
        this.setTextViewString(this.channelAndMedia, "channelState:" + ICoreManagerBase.getChannelLinkCore().getChannelState());
    }

    class EventObject
    implements EventCompat {
        private EventBinder mChannelMediaVideoInfoView$EventObjectSniperEventBinder;

        EventObject() {
        }

        public void onEventBind() {
            if (this.mChannelMediaVideoInfoView$EventObjectSniperEventBinder == null) {
                this.mChannelMediaVideoInfoView$EventObjectSniperEventBinder = new ChannelMediaVideoInfoView$EventObject$$EventBinder();
            }
            this.mChannelMediaVideoInfoView$EventObjectSniperEventBinder.bindEvent((Object)this);
            MLog.info((Object)"ChannelMediaVideoInfoView", (String)"EventObject onEventBind", (Object[])new Object[0]);
        }

        public void onEventUnBind() {
            if (this.mChannelMediaVideoInfoView$EventObjectSniperEventBinder != null) {
                this.mChannelMediaVideoInfoView$EventObjectSniperEventBinder.unBindEvent();
            }
            MLog.info((Object)"ChannelMediaVideoInfoView", (String)"EventObject onEventUnBind", (Object[])new Object[0]);
        }

        @BusEvent(sync=true)
        public void onRequestJoinChannelExist(IChannelLinkClient_onRequestJoinChannelExist_EventArgs busEventArgs) {
            ChannelInfo channelInfo = busEventArgs.getChannelInfo();
            CoreError error = busEventArgs.getError();
            ChannelMediaVideoInfoView.this.setChannelInfo();
        }

        @BusEvent(sync=true)
        public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
            ChannelInfo channelInfo = busEventArgs.getInfo();
            ChannelMediaVideoInfoView.this.setChannelInfo();
        }

        @BusEvent(sync=true)
        public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
            ChannelInfo channelInfo = busEventArgs.getInfo();
            ChannelMediaVideoInfoView.this.mMediaAudioState = 1;
            ChannelMediaVideoInfoView.this.setTextViewString(ChannelMediaVideoInfoView.this.audioState, "audioState:NoAudio");
            ChannelMediaVideoInfoView.this.setTextViewString(ChannelMediaVideoInfoView.this.channelAndMedia, "channelState:" + ICoreManagerBase.getChannelLinkCore().getChannelState());
            ChannelMediaVideoInfoView.this.setTextViewString(ChannelMediaVideoInfoView.this.noVideoInfoView, "");
            ChannelMediaVideoInfoView.this.setTextViewString(ChannelMediaVideoInfoView.this.auchorInfo, "");
            ChannelMediaVideoInfoView.this.setTextViewString(ChannelMediaVideoInfoView.this.anchorInfoExt, "");
        }

        @BusEvent(sync=true)
        public void addChannelMediaAnchorInfoExt(IMediaClient_addChannelMediaAnchorInfoExt_EventArgs busEventArgs) {
            String info = busEventArgs.getInfo();
            boolean superAddition = busEventArgs.getSuperAddition();
            if (superAddition) {
                ChannelMediaVideoInfoView.this.setTextViewString(ChannelMediaVideoInfoView.this.anchorInfoExt, "anchorInfoExt:" + (ChannelMediaVideoInfoView.this.anchorInfoExt.getText() == null ? "" : ChannelMediaVideoInfoView.this.anchorInfoExt.getText()) + info);
            } else {
                ChannelMediaVideoInfoView.this.setTextViewString(ChannelMediaVideoInfoView.this.anchorInfoExt, "anchorInfoExt:" + info);
            }
        }
    }
}

