/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.yy.mobile.memoryrecycle.views.YYImageView;
import com.yy.mobile.memoryrecycle.views.YYLinearLayout;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.CollectionsHelper;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class LoadingView
extends YYLinearLayout {
    public int mRefreshIntervalMillis;
    public List<YYImageView> mImageChildList;
    public List<Float> mAlphaPercentList;
    public int mImageChildCount;
    private int mLoopTimes;
    private Runnable mRefreshTask = new Runnable(){

        @Override
        public void run() {
            LoadingView.this.updateChildViewsDrawable();
            LoadingView.this.removeCallbacks(this);
            LoadingView.this.postDelayed(this, LoadingView.this.mRefreshIntervalMillis);
        }
    };

    public LoadingView(Context context) {
        this(context, null);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    public void updateChildViewsDrawable() {
        YYImageView child;
        int i;
        ++this.mLoopTimes;
        if (this.mLoopTimes == this.mImageChildCount) {
            this.mLoopTimes = 0;
        }
        int childIndex = 0;
        for (i = this.mLoopTimes; i < this.mImageChildCount; ++i) {
            child = this.mImageChildList.get(childIndex);
            this.setChildDrawable(child, this.mAlphaPercentList.get(i).floatValue());
            ++childIndex;
        }
        for (i = 0; i < this.mLoopTimes; ++i) {
            child = this.mImageChildList.get(childIndex);
            this.setChildDrawable(child, this.mAlphaPercentList.get(i).floatValue());
            ++childIndex;
        }
    }

    public void setChildDrawable(YYImageView child, float alphaPercent) {
        int alpha = (int)(alphaPercent * 255.0f);
        Drawable drawable2 = child.getDrawable();
        if (drawable2 != null) {
            drawable2.setAlpha(alpha);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.LoadingView);
        this.mRefreshIntervalMillis = ta.getInt(R.styleable.LoadingView_refresh_speed, 300);
        ta.recycle();
        this.mImageChildCount = 0;
    }

    public void setAlphaPercentList(List<Float> alphaPercentList) {
        this.mAlphaPercentList = new ArrayList<Float>(alphaPercentList);
        MLog.info((Object)"LoadingView", (String)"setAlphaPercentList mAlphaPercentList.size():%d, mImageChildCount:%d", (Object[])new Object[]{this.mAlphaPercentList.size(), this.mImageChildCount});
        if (this.mAlphaPercentList.size() != this.mImageChildCount) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                if (LoadingView.this.mAlphaPercentList != null) {
                    for (int i = 0; i < LoadingView.this.mImageChildCount; ++i) {
                        YYImageView imageView = LoadingView.this.mImageChildList.get(i);
                        LoadingView.this.setChildDrawable(imageView, LoadingView.this.mAlphaPercentList.get(i).floatValue());
                    }
                }
            }
        });
    }

    public void startLoading() {
        if (CollectionsHelper.isNullOrEmpty(this.mAlphaPercentList) || CollectionsHelper.isNullOrEmpty(this.mImageChildList) || this.mAlphaPercentList.size() != this.mImageChildCount) {
            return;
        }
        MLog.info((Object)"LoadingView", (String)"startLoading", (Object[])new Object[0]);
        this.postDelayed(this.mRefreshTask, this.mRefreshIntervalMillis);
    }

    public void stopLoading() {
        MLog.info((Object)"LoadingView", (String)"stopLoading", (Object[])new Object[0]);
        this.removeCallbacks(this.mRefreshTask);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initChildList();
    }

    private void initChildList() {
        int childCount = this.getChildCount();
        MLog.info((Object)"LoadingView", (String)"initChildList\uff0c childCount:%d", (Object[])new Object[]{childCount});
        this.mImageChildList = new ArrayList<YYImageView>(childCount);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof YYImageView)) continue;
            this.mImageChildList.add((YYImageView)child);
        }
        this.mImageChildCount = this.mImageChildList.size();
    }

    protected void onDetachedFromWindow() {
        this.stopLoading();
        super.onDetachedFromWindow();
    }
}

