/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.plugin.pluginunionlive.R;
import java.util.ArrayList;
import java.util.List;

public class GuideViewPager
extends ViewPager {
    private int mPageResId1;
    private int mPageResId2;
    private int mPageResId3;
    private int mPageResId4;
    private int mAckViewId;
    private Context mContext;
    public List<View> mPageList;
    public AckClickListener mAckClickListener;

    public GuideViewPager(Context context) {
        this(context, null);
    }

    public GuideViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public void setAckClickListener(AckClickListener ackClickListener) {
        this.mAckClickListener = ackClickListener;
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        this.mPageList = new ArrayList<View>(4);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.GuideViewPager);
        this.mPageResId1 = ta.getResourceId(R.styleable.GuideViewPager_gvp_page1, 0);
        this.mPageResId2 = ta.getResourceId(R.styleable.GuideViewPager_gvp_page2, 0);
        this.mPageResId3 = ta.getResourceId(R.styleable.GuideViewPager_gvp_page3, 0);
        this.mPageResId4 = ta.getResourceId(R.styleable.GuideViewPager_gvp_page4, 0);
        this.mAckViewId = ta.getResourceId(R.styleable.GuideViewPager_gvp_ack_view_id, 0);
        ta.recycle();
        this.setPageList();
        this.setAckClickEvent();
        this.setAdapter(new GuidePagerAdapter());
    }

    protected void onDetachedFromWindow() {
        this.mPageList.clear();
        super.onDetachedFromWindow();
    }

    private void setAckClickEvent() {
        if (this.mPageList.isEmpty()) {
            return;
        }
        View lastPage = this.mPageList.get(this.mPageList.size() - 1);
        View ackView = lastPage.findViewById(this.mAckViewId);
        if (ackView != null) {
            ackView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (GuideViewPager.this.mAckClickListener != null) {
                        GuideViewPager.this.mAckClickListener.onClickAck();
                    }
                }
            });
        }
    }

    private void setPageList() {
        View view;
        if (this.mPageResId1 != 0) {
            view = LayoutInflater.from((Context)this.mContext).inflate(this.mPageResId1, null);
            this.mPageList.add(view);
        }
        if (this.mPageResId2 != 0) {
            view = LayoutInflater.from((Context)this.mContext).inflate(this.mPageResId2, null);
            this.mPageList.add(view);
        }
        if (this.mPageResId3 != 0) {
            view = LayoutInflater.from((Context)this.mContext).inflate(this.mPageResId3, null);
            this.mPageList.add(view);
        }
        if (this.mPageResId4 != 0) {
            view = LayoutInflater.from((Context)this.mContext).inflate(this.mPageResId4, null);
            this.mPageList.add(view);
        }
    }

    private class GuidePagerAdapter
    extends PagerAdapter {
        private GuidePagerAdapter() {
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View view = GuideViewPager.this.mPageList.get(position);
            container.addView(view, position);
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView(GuideViewPager.this.mPageList.get(position));
        }

        public int getCount() {
            return GuideViewPager.this.mPageList.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }
    }

    public static interface AckClickListener {
        public void onClickAck();
    }
}

